/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeywordPlanCampaignName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_KEYWORD_PLAN_CAMPAIGN_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/keywordPlanCampaigns/{keyword_plan_campaign_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String keywordPlanCampaignId;

    @Deprecated
    protected KeywordPlanCampaignName() {
        this.customerId = null;
        this.keywordPlanCampaignId = null;
    }

    private KeywordPlanCampaignName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.keywordPlanCampaignId = (String)Preconditions.checkNotNull((Object)builder.getKeywordPlanCampaignId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getKeywordPlanCampaignId() {
        return this.keywordPlanCampaignId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KeywordPlanCampaignName of(String customerId, String keywordPlanCampaignId) {
        return KeywordPlanCampaignName.newBuilder().setCustomerId(customerId).setKeywordPlanCampaignId(keywordPlanCampaignId).build();
    }

    public static String format(String customerId, String keywordPlanCampaignId) {
        return KeywordPlanCampaignName.newBuilder().setCustomerId(customerId).setKeywordPlanCampaignId(keywordPlanCampaignId).build().toString();
    }

    public static KeywordPlanCampaignName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_KEYWORD_PLAN_CAMPAIGN_ID.validatedMatch(formattedString, "KeywordPlanCampaignName.parse: formattedString not in valid format");
        return KeywordPlanCampaignName.of((String)matchMap.get("customer_id"), (String)matchMap.get("keyword_plan_campaign_id"));
    }

    public static List<KeywordPlanCampaignName> parseList(List<String> formattedStrings) {
        ArrayList<KeywordPlanCampaignName> list = new ArrayList<KeywordPlanCampaignName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeywordPlanCampaignName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeywordPlanCampaignName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeywordPlanCampaignName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_KEYWORD_PLAN_CAMPAIGN_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeywordPlanCampaignName keywordPlanCampaignName = this;
            synchronized (keywordPlanCampaignName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.keywordPlanCampaignId != null) {
                        fieldMapBuilder.put((Object)"keyword_plan_campaign_id", (Object)this.keywordPlanCampaignId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_KEYWORD_PLAN_CAMPAIGN_ID.instantiate(new String[]{"customer_id", this.customerId, "keyword_plan_campaign_id", this.keywordPlanCampaignId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            KeywordPlanCampaignName that = (KeywordPlanCampaignName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.keywordPlanCampaignId, that.keywordPlanCampaignId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.keywordPlanCampaignId);
    }

    public static class Builder {
        private String customerId;
        private String keywordPlanCampaignId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getKeywordPlanCampaignId() {
            return this.keywordPlanCampaignId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setKeywordPlanCampaignId(String keywordPlanCampaignId) {
            this.keywordPlanCampaignId = keywordPlanCampaignId;
            return this;
        }

        private Builder(KeywordPlanCampaignName keywordPlanCampaignName) {
            this.customerId = keywordPlanCampaignName.customerId;
            this.keywordPlanCampaignId = keywordPlanCampaignName.keywordPlanCampaignId;
        }

        public KeywordPlanCampaignName build() {
            return new KeywordPlanCampaignName(this);
        }
    }
}

