/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeywordPlanName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_KEYWORD_PLAN_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/keywordPlans/{keyword_plan_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String keywordPlanId;

    @Deprecated
    protected KeywordPlanName() {
        this.customerId = null;
        this.keywordPlanId = null;
    }

    private KeywordPlanName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.keywordPlanId = (String)Preconditions.checkNotNull((Object)builder.getKeywordPlanId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getKeywordPlanId() {
        return this.keywordPlanId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KeywordPlanName of(String customerId, String keywordPlanId) {
        return KeywordPlanName.newBuilder().setCustomerId(customerId).setKeywordPlanId(keywordPlanId).build();
    }

    public static String format(String customerId, String keywordPlanId) {
        return KeywordPlanName.newBuilder().setCustomerId(customerId).setKeywordPlanId(keywordPlanId).build().toString();
    }

    public static KeywordPlanName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_KEYWORD_PLAN_ID.validatedMatch(formattedString, "KeywordPlanName.parse: formattedString not in valid format");
        return KeywordPlanName.of((String)matchMap.get("customer_id"), (String)matchMap.get("keyword_plan_id"));
    }

    public static List<KeywordPlanName> parseList(List<String> formattedStrings) {
        ArrayList<KeywordPlanName> list = new ArrayList<KeywordPlanName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeywordPlanName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeywordPlanName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeywordPlanName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_KEYWORD_PLAN_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeywordPlanName keywordPlanName = this;
            synchronized (keywordPlanName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.keywordPlanId != null) {
                        fieldMapBuilder.put((Object)"keyword_plan_id", (Object)this.keywordPlanId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_KEYWORD_PLAN_ID.instantiate(new String[]{"customer_id", this.customerId, "keyword_plan_id", this.keywordPlanId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            KeywordPlanName that = (KeywordPlanName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.keywordPlanId, that.keywordPlanId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.keywordPlanId);
    }

    public static class Builder {
        private String customerId;
        private String keywordPlanId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getKeywordPlanId() {
            return this.keywordPlanId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setKeywordPlanId(String keywordPlanId) {
            this.keywordPlanId = keywordPlanId;
            return this;
        }

        private Builder(KeywordPlanName keywordPlanName) {
            this.customerId = keywordPlanName.customerId;
            this.keywordPlanId = keywordPlanName.keywordPlanId;
        }

        public KeywordPlanName build() {
            return new KeywordPlanName(this);
        }
    }
}

