/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LandingPageViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_UNEXPANDED_FINAL_URL_FINGERPRINT = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/landingPageViews/{unexpanded_final_url_fingerprint}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String unexpandedFinalUrlFingerprint;

    @Deprecated
    protected LandingPageViewName() {
        this.customerId = null;
        this.unexpandedFinalUrlFingerprint = null;
    }

    private LandingPageViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.unexpandedFinalUrlFingerprint = (String)Preconditions.checkNotNull((Object)builder.getUnexpandedFinalUrlFingerprint());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getUnexpandedFinalUrlFingerprint() {
        return this.unexpandedFinalUrlFingerprint;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LandingPageViewName of(String customerId, String unexpandedFinalUrlFingerprint) {
        return LandingPageViewName.newBuilder().setCustomerId(customerId).setUnexpandedFinalUrlFingerprint(unexpandedFinalUrlFingerprint).build();
    }

    public static String format(String customerId, String unexpandedFinalUrlFingerprint) {
        return LandingPageViewName.newBuilder().setCustomerId(customerId).setUnexpandedFinalUrlFingerprint(unexpandedFinalUrlFingerprint).build().toString();
    }

    public static LandingPageViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_UNEXPANDED_FINAL_URL_FINGERPRINT.validatedMatch(formattedString, "LandingPageViewName.parse: formattedString not in valid format");
        return LandingPageViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("unexpanded_final_url_fingerprint"));
    }

    public static List<LandingPageViewName> parseList(List<String> formattedStrings) {
        ArrayList<LandingPageViewName> list = new ArrayList<LandingPageViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LandingPageViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LandingPageViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LandingPageViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_UNEXPANDED_FINAL_URL_FINGERPRINT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LandingPageViewName landingPageViewName = this;
            synchronized (landingPageViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.unexpandedFinalUrlFingerprint != null) {
                        fieldMapBuilder.put((Object)"unexpanded_final_url_fingerprint", (Object)this.unexpandedFinalUrlFingerprint);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_UNEXPANDED_FINAL_URL_FINGERPRINT.instantiate(new String[]{"customer_id", this.customerId, "unexpanded_final_url_fingerprint", this.unexpandedFinalUrlFingerprint});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            LandingPageViewName that = (LandingPageViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.unexpandedFinalUrlFingerprint, that.unexpandedFinalUrlFingerprint);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.unexpandedFinalUrlFingerprint);
    }

    public static class Builder {
        private String customerId;
        private String unexpandedFinalUrlFingerprint;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getUnexpandedFinalUrlFingerprint() {
            return this.unexpandedFinalUrlFingerprint;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setUnexpandedFinalUrlFingerprint(String unexpandedFinalUrlFingerprint) {
            this.unexpandedFinalUrlFingerprint = unexpandedFinalUrlFingerprint;
            return this;
        }

        private Builder(LandingPageViewName landingPageViewName) {
            this.customerId = landingPageViewName.customerId;
            this.unexpandedFinalUrlFingerprint = landingPageViewName.unexpandedFinalUrlFingerprint;
        }

        public LandingPageViewName build() {
            return new LandingPageViewName(this);
        }
    }
}

