/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MobileDeviceConstantName
implements ResourceName {
    private static final PathTemplate CRITERION_ID = PathTemplate.createWithoutUrlEncoding((String)"mobileDeviceConstants/{criterion_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String criterionId;

    @Deprecated
    protected MobileDeviceConstantName() {
        this.criterionId = null;
    }

    private MobileDeviceConstantName(Builder builder) {
        this.criterionId = (String)Preconditions.checkNotNull((Object)builder.getCriterionId());
    }

    public String getCriterionId() {
        return this.criterionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MobileDeviceConstantName of(String criterionId) {
        return MobileDeviceConstantName.newBuilder().setCriterionId(criterionId).build();
    }

    public static String format(String criterionId) {
        return MobileDeviceConstantName.newBuilder().setCriterionId(criterionId).build().toString();
    }

    public static MobileDeviceConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CRITERION_ID.validatedMatch(formattedString, "MobileDeviceConstantName.parse: formattedString not in valid format");
        return MobileDeviceConstantName.of((String)matchMap.get("criterion_id"));
    }

    public static List<MobileDeviceConstantName> parseList(List<String> formattedStrings) {
        ArrayList<MobileDeviceConstantName> list = new ArrayList<MobileDeviceConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MobileDeviceConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MobileDeviceConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MobileDeviceConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CRITERION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MobileDeviceConstantName mobileDeviceConstantName = this;
            synchronized (mobileDeviceConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.criterionId != null) {
                        fieldMapBuilder.put((Object)"criterion_id", (Object)this.criterionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CRITERION_ID.instantiate(new String[]{"criterion_id", this.criterionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MobileDeviceConstantName that = (MobileDeviceConstantName)o;
            return Objects.equals(this.criterionId, that.criterionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.criterionId);
    }

    public static class Builder {
        private String criterionId;

        protected Builder() {
        }

        public String getCriterionId() {
            return this.criterionId;
        }

        public Builder setCriterionId(String criterionId) {
            this.criterionId = criterionId;
            return this;
        }

        private Builder(MobileDeviceConstantName mobileDeviceConstantName) {
            this.criterionId = mobileDeviceConstantName.criterionId;
        }

        public MobileDeviceConstantName build() {
            return new MobileDeviceConstantName(this);
        }
    }
}

