/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TravelActivityPerformanceViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/travelActivityPerformanceViews");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;

    @Deprecated
    protected TravelActivityPerformanceViewName() {
        this.customerId = null;
    }

    private TravelActivityPerformanceViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TravelActivityPerformanceViewName of(String customerId) {
        return TravelActivityPerformanceViewName.newBuilder().setCustomerId(customerId).build();
    }

    public static String format(String customerId) {
        return TravelActivityPerformanceViewName.newBuilder().setCustomerId(customerId).build().toString();
    }

    public static TravelActivityPerformanceViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID.validatedMatch(formattedString, "TravelActivityPerformanceViewName.parse: formattedString not in valid format");
        return TravelActivityPerformanceViewName.of((String)matchMap.get("customer_id"));
    }

    public static List<TravelActivityPerformanceViewName> parseList(List<String> formattedStrings) {
        ArrayList<TravelActivityPerformanceViewName> list = new ArrayList<TravelActivityPerformanceViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TravelActivityPerformanceViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TravelActivityPerformanceViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TravelActivityPerformanceViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TravelActivityPerformanceViewName travelActivityPerformanceViewName = this;
            synchronized (travelActivityPerformanceViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID.instantiate(new String[]{"customer_id", this.customerId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            TravelActivityPerformanceViewName that = (TravelActivityPerformanceViewName)o;
            return Objects.equals(this.customerId, that.customerId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.customerId);
    }

    public static class Builder {
        private String customerId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        private Builder(TravelActivityPerformanceViewName travelActivityPerformanceViewName) {
            this.customerId = travelActivityPerformanceViewName.customerId;
        }

        public TravelActivityPerformanceViewName build() {
            return new TravelActivityPerformanceViewName(this);
        }
    }
}

