/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.services;

import com.google.ads.googleads.v13.resources.AccountLink;
import com.google.ads.googleads.v13.services.AccountLinkOperation;
import com.google.ads.googleads.v13.services.AccountLinkServiceSettings;
import com.google.ads.googleads.v13.services.CreateAccountLinkRequest;
import com.google.ads.googleads.v13.services.CreateAccountLinkResponse;
import com.google.ads.googleads.v13.services.MutateAccountLinkRequest;
import com.google.ads.googleads.v13.services.MutateAccountLinkResponse;
import com.google.ads.googleads.v13.services.stub.AccountLinkServiceStub;
import com.google.ads.googleads.v13.services.stub.AccountLinkServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class AccountLinkServiceClient
implements BackgroundResource {
    private final AccountLinkServiceSettings settings;
    private final AccountLinkServiceStub stub;

    public static final AccountLinkServiceClient create() throws IOException {
        return AccountLinkServiceClient.create(AccountLinkServiceSettings.newBuilder().build());
    }

    public static final AccountLinkServiceClient create(AccountLinkServiceSettings settings) throws IOException {
        return new AccountLinkServiceClient(settings);
    }

    public static final AccountLinkServiceClient create(AccountLinkServiceStub stub) {
        return new AccountLinkServiceClient(stub);
    }

    protected AccountLinkServiceClient(AccountLinkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AccountLinkServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AccountLinkServiceClient(AccountLinkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AccountLinkServiceSettings getSettings() {
        return this.settings;
    }

    public AccountLinkServiceStub getStub() {
        return this.stub;
    }

    public final CreateAccountLinkResponse createAccountLink(String customerId, AccountLink accountLink) {
        CreateAccountLinkRequest request = CreateAccountLinkRequest.newBuilder().setCustomerId(customerId).setAccountLink(accountLink).build();
        return this.createAccountLink(request);
    }

    public final CreateAccountLinkResponse createAccountLink(CreateAccountLinkRequest request) {
        return (CreateAccountLinkResponse)this.createAccountLinkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAccountLinkRequest, CreateAccountLinkResponse> createAccountLinkCallable() {
        return this.stub.createAccountLinkCallable();
    }

    public final MutateAccountLinkResponse mutateAccountLink(String customerId, AccountLinkOperation operation) {
        MutateAccountLinkRequest request = MutateAccountLinkRequest.newBuilder().setCustomerId(customerId).setOperation(operation).build();
        return this.mutateAccountLink(request);
    }

    public final MutateAccountLinkResponse mutateAccountLink(MutateAccountLinkRequest request) {
        return (MutateAccountLinkResponse)this.mutateAccountLinkCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAccountLinkRequest, MutateAccountLinkResponse> mutateAccountLinkCallable() {
        return this.stub.mutateAccountLinkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

