/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.services;

import com.google.ads.googleads.v13.services.AdParameterOperation;
import com.google.ads.googleads.v13.services.AdParameterServiceSettings;
import com.google.ads.googleads.v13.services.MutateAdParametersRequest;
import com.google.ads.googleads.v13.services.MutateAdParametersResponse;
import com.google.ads.googleads.v13.services.stub.AdParameterServiceStub;
import com.google.ads.googleads.v13.services.stub.AdParameterServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdParameterServiceClient
implements BackgroundResource {
    private final AdParameterServiceSettings settings;
    private final AdParameterServiceStub stub;

    public static final AdParameterServiceClient create() throws IOException {
        return AdParameterServiceClient.create(AdParameterServiceSettings.newBuilder().build());
    }

    public static final AdParameterServiceClient create(AdParameterServiceSettings settings) throws IOException {
        return new AdParameterServiceClient(settings);
    }

    public static final AdParameterServiceClient create(AdParameterServiceStub stub) {
        return new AdParameterServiceClient(stub);
    }

    protected AdParameterServiceClient(AdParameterServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdParameterServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdParameterServiceClient(AdParameterServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdParameterServiceSettings getSettings() {
        return this.settings;
    }

    public AdParameterServiceStub getStub() {
        return this.stub;
    }

    public final MutateAdParametersResponse mutateAdParameters(String customerId, List<AdParameterOperation> operations) {
        MutateAdParametersRequest request = MutateAdParametersRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdParameters(request);
    }

    public final MutateAdParametersResponse mutateAdParameters(MutateAdParametersRequest request) {
        return (MutateAdParametersResponse)this.mutateAdParametersCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdParametersRequest, MutateAdParametersResponse> mutateAdParametersCallable() {
        return this.stub.mutateAdParametersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

