/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.services;

import com.google.ads.googleads.v13.services.AssetSetOperation;
import com.google.ads.googleads.v13.services.AssetSetServiceSettings;
import com.google.ads.googleads.v13.services.MutateAssetSetsRequest;
import com.google.ads.googleads.v13.services.MutateAssetSetsResponse;
import com.google.ads.googleads.v13.services.stub.AssetSetServiceStub;
import com.google.ads.googleads.v13.services.stub.AssetSetServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AssetSetServiceClient
implements BackgroundResource {
    private final AssetSetServiceSettings settings;
    private final AssetSetServiceStub stub;

    public static final AssetSetServiceClient create() throws IOException {
        return AssetSetServiceClient.create(AssetSetServiceSettings.newBuilder().build());
    }

    public static final AssetSetServiceClient create(AssetSetServiceSettings settings) throws IOException {
        return new AssetSetServiceClient(settings);
    }

    public static final AssetSetServiceClient create(AssetSetServiceStub stub) {
        return new AssetSetServiceClient(stub);
    }

    protected AssetSetServiceClient(AssetSetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AssetSetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AssetSetServiceClient(AssetSetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AssetSetServiceSettings getSettings() {
        return this.settings;
    }

    public AssetSetServiceStub getStub() {
        return this.stub;
    }

    public final MutateAssetSetsResponse mutateAssetSets(String customerId, List<AssetSetOperation> operations) {
        MutateAssetSetsRequest request = MutateAssetSetsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAssetSets(request);
    }

    public final MutateAssetSetsResponse mutateAssetSets(MutateAssetSetsRequest request) {
        return (MutateAssetSetsResponse)this.mutateAssetSetsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAssetSetsRequest, MutateAssetSetsResponse> mutateAssetSetsCallable() {
        return this.stub.mutateAssetSetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

