/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.services;

import com.google.ads.googleads.v13.resources.OfflineUserDataJob;
import com.google.ads.googleads.v13.resources.OfflineUserDataJobMetadata;
import com.google.ads.googleads.v13.resources.OfflineUserDataJobName;
import com.google.ads.googleads.v13.services.AddOfflineUserDataJobOperationsRequest;
import com.google.ads.googleads.v13.services.AddOfflineUserDataJobOperationsResponse;
import com.google.ads.googleads.v13.services.CreateOfflineUserDataJobRequest;
import com.google.ads.googleads.v13.services.CreateOfflineUserDataJobResponse;
import com.google.ads.googleads.v13.services.OfflineUserDataJobOperation;
import com.google.ads.googleads.v13.services.OfflineUserDataJobServiceSettings;
import com.google.ads.googleads.v13.services.RunOfflineUserDataJobRequest;
import com.google.ads.googleads.v13.services.stub.OfflineUserDataJobServiceStub;
import com.google.ads.googleads.v13.services.stub.OfflineUserDataJobServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class OfflineUserDataJobServiceClient
implements BackgroundResource {
    private final OfflineUserDataJobServiceSettings settings;
    private final OfflineUserDataJobServiceStub stub;
    private final OperationsClient operationsClient;

    public static final OfflineUserDataJobServiceClient create() throws IOException {
        return OfflineUserDataJobServiceClient.create(OfflineUserDataJobServiceSettings.newBuilder().build());
    }

    public static final OfflineUserDataJobServiceClient create(OfflineUserDataJobServiceSettings settings) throws IOException {
        return new OfflineUserDataJobServiceClient(settings);
    }

    public static final OfflineUserDataJobServiceClient create(OfflineUserDataJobServiceStub stub) {
        return new OfflineUserDataJobServiceClient(stub);
    }

    protected OfflineUserDataJobServiceClient(OfflineUserDataJobServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((OfflineUserDataJobServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected OfflineUserDataJobServiceClient(OfflineUserDataJobServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final OfflineUserDataJobServiceSettings getSettings() {
        return this.settings;
    }

    public OfflineUserDataJobServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final CreateOfflineUserDataJobResponse createOfflineUserDataJob(String customerId, OfflineUserDataJob job) {
        CreateOfflineUserDataJobRequest request = CreateOfflineUserDataJobRequest.newBuilder().setCustomerId(customerId).setJob(job).build();
        return this.createOfflineUserDataJob(request);
    }

    public final CreateOfflineUserDataJobResponse createOfflineUserDataJob(CreateOfflineUserDataJobRequest request) {
        return (CreateOfflineUserDataJobResponse)this.createOfflineUserDataJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateOfflineUserDataJobRequest, CreateOfflineUserDataJobResponse> createOfflineUserDataJobCallable() {
        return this.stub.createOfflineUserDataJobCallable();
    }

    public final AddOfflineUserDataJobOperationsResponse addOfflineUserDataJobOperations(OfflineUserDataJobName resourceName, List<OfflineUserDataJobOperation> operations) {
        AddOfflineUserDataJobOperationsRequest request = AddOfflineUserDataJobOperationsRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).addAllOperations(operations).build();
        return this.addOfflineUserDataJobOperations(request);
    }

    public final AddOfflineUserDataJobOperationsResponse addOfflineUserDataJobOperations(String resourceName, List<OfflineUserDataJobOperation> operations) {
        AddOfflineUserDataJobOperationsRequest request = AddOfflineUserDataJobOperationsRequest.newBuilder().setResourceName(resourceName).addAllOperations(operations).build();
        return this.addOfflineUserDataJobOperations(request);
    }

    public final AddOfflineUserDataJobOperationsResponse addOfflineUserDataJobOperations(AddOfflineUserDataJobOperationsRequest request) {
        return (AddOfflineUserDataJobOperationsResponse)this.addOfflineUserDataJobOperationsCallable().call((Object)request);
    }

    public final UnaryCallable<AddOfflineUserDataJobOperationsRequest, AddOfflineUserDataJobOperationsResponse> addOfflineUserDataJobOperationsCallable() {
        return this.stub.addOfflineUserDataJobOperationsCallable();
    }

    public final OperationFuture<Empty, OfflineUserDataJobMetadata> runOfflineUserDataJobAsync(OfflineUserDataJobName resourceName) {
        RunOfflineUserDataJobRequest request = RunOfflineUserDataJobRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.runOfflineUserDataJobAsync(request);
    }

    public final OperationFuture<Empty, OfflineUserDataJobMetadata> runOfflineUserDataJobAsync(String resourceName) {
        RunOfflineUserDataJobRequest request = RunOfflineUserDataJobRequest.newBuilder().setResourceName(resourceName).build();
        return this.runOfflineUserDataJobAsync(request);
    }

    public final OperationFuture<Empty, OfflineUserDataJobMetadata> runOfflineUserDataJobAsync(RunOfflineUserDataJobRequest request) {
        return this.runOfflineUserDataJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RunOfflineUserDataJobRequest, Empty, OfflineUserDataJobMetadata> runOfflineUserDataJobOperationCallable() {
        return this.stub.runOfflineUserDataJobOperationCallable();
    }

    public final UnaryCallable<RunOfflineUserDataJobRequest, Operation> runOfflineUserDataJobCallable() {
        return this.stub.runOfflineUserDataJobCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

