/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.services;

import com.google.ads.googleads.v13.services.CampaignDuration;
import com.google.ads.googleads.v13.services.GenerateReachForecastRequest;
import com.google.ads.googleads.v13.services.GenerateReachForecastResponse;
import com.google.ads.googleads.v13.services.ListPlannableLocationsRequest;
import com.google.ads.googleads.v13.services.ListPlannableLocationsResponse;
import com.google.ads.googleads.v13.services.ListPlannableProductsRequest;
import com.google.ads.googleads.v13.services.ListPlannableProductsResponse;
import com.google.ads.googleads.v13.services.PlannedProduct;
import com.google.ads.googleads.v13.services.ReachPlanServiceSettings;
import com.google.ads.googleads.v13.services.stub.ReachPlanServiceStub;
import com.google.ads.googleads.v13.services.stub.ReachPlanServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ReachPlanServiceClient
implements BackgroundResource {
    private final ReachPlanServiceSettings settings;
    private final ReachPlanServiceStub stub;

    public static final ReachPlanServiceClient create() throws IOException {
        return ReachPlanServiceClient.create(ReachPlanServiceSettings.newBuilder().build());
    }

    public static final ReachPlanServiceClient create(ReachPlanServiceSettings settings) throws IOException {
        return new ReachPlanServiceClient(settings);
    }

    public static final ReachPlanServiceClient create(ReachPlanServiceStub stub) {
        return new ReachPlanServiceClient(stub);
    }

    protected ReachPlanServiceClient(ReachPlanServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ReachPlanServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ReachPlanServiceClient(ReachPlanServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ReachPlanServiceSettings getSettings() {
        return this.settings;
    }

    public ReachPlanServiceStub getStub() {
        return this.stub;
    }

    public final ListPlannableLocationsResponse listPlannableLocations(ListPlannableLocationsRequest request) {
        return (ListPlannableLocationsResponse)this.listPlannableLocationsCallable().call((Object)request);
    }

    public final UnaryCallable<ListPlannableLocationsRequest, ListPlannableLocationsResponse> listPlannableLocationsCallable() {
        return this.stub.listPlannableLocationsCallable();
    }

    public final ListPlannableProductsResponse listPlannableProducts(String plannableLocationId) {
        ListPlannableProductsRequest request = ListPlannableProductsRequest.newBuilder().setPlannableLocationId(plannableLocationId).build();
        return this.listPlannableProducts(request);
    }

    public final ListPlannableProductsResponse listPlannableProducts(ListPlannableProductsRequest request) {
        return (ListPlannableProductsResponse)this.listPlannableProductsCallable().call((Object)request);
    }

    public final UnaryCallable<ListPlannableProductsRequest, ListPlannableProductsResponse> listPlannableProductsCallable() {
        return this.stub.listPlannableProductsCallable();
    }

    public final GenerateReachForecastResponse generateReachForecast(String customerId, CampaignDuration campaignDuration, List<PlannedProduct> plannedProducts) {
        GenerateReachForecastRequest request = GenerateReachForecastRequest.newBuilder().setCustomerId(customerId).setCampaignDuration(campaignDuration).addAllPlannedProducts(plannedProducts).build();
        return this.generateReachForecast(request);
    }

    public final GenerateReachForecastResponse generateReachForecast(GenerateReachForecastRequest request) {
        return (GenerateReachForecastResponse)this.generateReachForecastCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateReachForecastRequest, GenerateReachForecastResponse> generateReachForecastCallable() {
        return this.stub.generateReachForecastCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

