/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.services.stub;

import com.google.ads.googleads.v13.services.MutateAssetsRequest;
import com.google.ads.googleads.v13.services.MutateAssetsResponse;
import com.google.ads.googleads.v13.services.stub.AssetServiceStub;
import com.google.ads.googleads.v13.services.stub.AssetServiceStubSettings;
import com.google.ads.googleads.v13.services.stub.GrpcAssetServiceCallableFactory;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAssetServiceStub
extends AssetServiceStub {
    private static final MethodDescriptor<MutateAssetsRequest, MutateAssetsResponse> mutateAssetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v13.services.AssetService/MutateAssets").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateAssetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateAssetsResponse.getDefaultInstance())).build();
    private final UnaryCallable<MutateAssetsRequest, MutateAssetsResponse> mutateAssetsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAssetServiceStub create(AssetServiceStubSettings settings) throws IOException {
        return new GrpcAssetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAssetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAssetServiceStub(AssetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAssetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAssetServiceStub(AssetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAssetServiceStub(AssetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcAssetServiceCallableFactory());
    }

    protected GrpcAssetServiceStub(AssetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings mutateAssetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateAssetsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
            return params.build();
        }).build();
        this.mutateAssetsCallable = callableFactory.createUnaryCallable(mutateAssetsTransportSettings, settings.mutateAssetsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<MutateAssetsRequest, MutateAssetsResponse> mutateAssetsCallable() {
        return this.mutateAssetsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

