/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.services.stub;

import com.google.ads.googleads.v13.services.GenerateForecastCurveRequest;
import com.google.ads.googleads.v13.services.GenerateForecastCurveResponse;
import com.google.ads.googleads.v13.services.GenerateForecastMetricsRequest;
import com.google.ads.googleads.v13.services.GenerateForecastMetricsResponse;
import com.google.ads.googleads.v13.services.GenerateForecastTimeSeriesRequest;
import com.google.ads.googleads.v13.services.GenerateForecastTimeSeriesResponse;
import com.google.ads.googleads.v13.services.GenerateHistoricalMetricsRequest;
import com.google.ads.googleads.v13.services.GenerateHistoricalMetricsResponse;
import com.google.ads.googleads.v13.services.MutateKeywordPlansRequest;
import com.google.ads.googleads.v13.services.MutateKeywordPlansResponse;
import com.google.ads.googleads.v13.services.stub.GrpcKeywordPlanServiceCallableFactory;
import com.google.ads.googleads.v13.services.stub.KeywordPlanServiceStub;
import com.google.ads.googleads.v13.services.stub.KeywordPlanServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcKeywordPlanServiceStub
extends KeywordPlanServiceStub {
    private static final MethodDescriptor<MutateKeywordPlansRequest, MutateKeywordPlansResponse> mutateKeywordPlansMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v13.services.KeywordPlanService/MutateKeywordPlans").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateKeywordPlansRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateKeywordPlansResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateForecastCurveRequest, GenerateForecastCurveResponse> generateForecastCurveMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v13.services.KeywordPlanService/GenerateForecastCurve").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateForecastCurveRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateForecastCurveResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateForecastTimeSeriesRequest, GenerateForecastTimeSeriesResponse> generateForecastTimeSeriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v13.services.KeywordPlanService/GenerateForecastTimeSeries").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateForecastTimeSeriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateForecastTimeSeriesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateForecastMetricsRequest, GenerateForecastMetricsResponse> generateForecastMetricsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v13.services.KeywordPlanService/GenerateForecastMetrics").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateForecastMetricsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateForecastMetricsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateHistoricalMetricsRequest, GenerateHistoricalMetricsResponse> generateHistoricalMetricsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v13.services.KeywordPlanService/GenerateHistoricalMetrics").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateHistoricalMetricsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateHistoricalMetricsResponse.getDefaultInstance())).build();
    private final UnaryCallable<MutateKeywordPlansRequest, MutateKeywordPlansResponse> mutateKeywordPlansCallable;
    private final UnaryCallable<GenerateForecastCurveRequest, GenerateForecastCurveResponse> generateForecastCurveCallable;
    private final UnaryCallable<GenerateForecastTimeSeriesRequest, GenerateForecastTimeSeriesResponse> generateForecastTimeSeriesCallable;
    private final UnaryCallable<GenerateForecastMetricsRequest, GenerateForecastMetricsResponse> generateForecastMetricsCallable;
    private final UnaryCallable<GenerateHistoricalMetricsRequest, GenerateHistoricalMetricsResponse> generateHistoricalMetricsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcKeywordPlanServiceStub create(KeywordPlanServiceStubSettings settings) throws IOException {
        return new GrpcKeywordPlanServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcKeywordPlanServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcKeywordPlanServiceStub(KeywordPlanServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcKeywordPlanServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcKeywordPlanServiceStub(KeywordPlanServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcKeywordPlanServiceStub(KeywordPlanServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcKeywordPlanServiceCallableFactory());
    }

    protected GrpcKeywordPlanServiceStub(KeywordPlanServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings mutateKeywordPlansTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateKeywordPlansMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"customer_id", (Object)String.valueOf(request.getCustomerId()));
            return params.build();
        }).build();
        GrpcCallSettings generateForecastCurveTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateForecastCurveMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"keyword_plan", (Object)String.valueOf(request.getKeywordPlan()));
            return params.build();
        }).build();
        GrpcCallSettings generateForecastTimeSeriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateForecastTimeSeriesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"keyword_plan", (Object)String.valueOf(request.getKeywordPlan()));
            return params.build();
        }).build();
        GrpcCallSettings generateForecastMetricsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateForecastMetricsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"keyword_plan", (Object)String.valueOf(request.getKeywordPlan()));
            return params.build();
        }).build();
        GrpcCallSettings generateHistoricalMetricsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateHistoricalMetricsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"keyword_plan", (Object)String.valueOf(request.getKeywordPlan()));
            return params.build();
        }).build();
        this.mutateKeywordPlansCallable = callableFactory.createUnaryCallable(mutateKeywordPlansTransportSettings, settings.mutateKeywordPlansSettings(), clientContext);
        this.generateForecastCurveCallable = callableFactory.createUnaryCallable(generateForecastCurveTransportSettings, settings.generateForecastCurveSettings(), clientContext);
        this.generateForecastTimeSeriesCallable = callableFactory.createUnaryCallable(generateForecastTimeSeriesTransportSettings, settings.generateForecastTimeSeriesSettings(), clientContext);
        this.generateForecastMetricsCallable = callableFactory.createUnaryCallable(generateForecastMetricsTransportSettings, settings.generateForecastMetricsSettings(), clientContext);
        this.generateHistoricalMetricsCallable = callableFactory.createUnaryCallable(generateHistoricalMetricsTransportSettings, settings.generateHistoricalMetricsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<MutateKeywordPlansRequest, MutateKeywordPlansResponse> mutateKeywordPlansCallable() {
        return this.mutateKeywordPlansCallable;
    }

    @Override
    public UnaryCallable<GenerateForecastCurveRequest, GenerateForecastCurveResponse> generateForecastCurveCallable() {
        return this.generateForecastCurveCallable;
    }

    @Override
    public UnaryCallable<GenerateForecastTimeSeriesRequest, GenerateForecastTimeSeriesResponse> generateForecastTimeSeriesCallable() {
        return this.generateForecastTimeSeriesCallable;
    }

    @Override
    public UnaryCallable<GenerateForecastMetricsRequest, GenerateForecastMetricsResponse> generateForecastMetricsCallable() {
        return this.generateForecastMetricsCallable;
    }

    @Override
    public UnaryCallable<GenerateHistoricalMetricsRequest, GenerateHistoricalMetricsResponse> generateHistoricalMetricsCallable() {
        return this.generateHistoricalMetricsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

