// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v14/resources/account_link.proto

package com.google.ads.googleads.v14.resources;

/**
 * <pre>
 * Represents the data sharing connection between a Google Ads account and
 * another account
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v14.resources.AccountLink}
 */
public final class AccountLink extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v14.resources.AccountLink)
    AccountLinkOrBuilder {
private static final long serialVersionUID = 0L;
  // Use AccountLink.newBuilder() to construct.
  private AccountLink(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private AccountLink() {
    resourceName_ = "";
    status_ = 0;
    type_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new AccountLink();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v14.resources.AccountLinkProto.internal_static_google_ads_googleads_v14_resources_AccountLink_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v14.resources.AccountLinkProto.internal_static_google_ads_googleads_v14_resources_AccountLink_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v14.resources.AccountLink.class, com.google.ads.googleads.v14.resources.AccountLink.Builder.class);
  }

  private int bitField0_;
  private int linkedAccountCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object linkedAccount_;
  public enum LinkedAccountCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    THIRD_PARTY_APP_ANALYTICS(5),
    DATA_PARTNER(6),
    GOOGLE_ADS(7),
    HOTEL_CENTER(9),
    ADVERTISING_PARTNER(10),
    LINKEDACCOUNT_NOT_SET(0);
    private final int value;
    private LinkedAccountCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LinkedAccountCase valueOf(int value) {
      return forNumber(value);
    }

    public static LinkedAccountCase forNumber(int value) {
      switch (value) {
        case 5: return THIRD_PARTY_APP_ANALYTICS;
        case 6: return DATA_PARTNER;
        case 7: return GOOGLE_ADS;
        case 9: return HOTEL_CENTER;
        case 10: return ADVERTISING_PARTNER;
        case 0: return LINKEDACCOUNT_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public LinkedAccountCase
  getLinkedAccountCase() {
    return LinkedAccountCase.forNumber(
        linkedAccountCase_);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Immutable. Resource name of the account link.
   * AccountLink resource names have the form:
   * `customers/{customer_id}/accountLinks/{account_link_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. Resource name of the account link.
   * AccountLink resource names have the form:
   * `customers/{customer_id}/accountLinks/{account_link_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACCOUNT_LINK_ID_FIELD_NUMBER = 8;
  private long accountLinkId_ = 0L;
  /**
   * <pre>
   * Output only. The ID of the link.
   * This field is read only.
   * </pre>
   *
   * <code>optional int64 account_link_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the accountLinkId field is set.
   */
  @java.lang.Override
  public boolean hasAccountLinkId() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Output only. The ID of the link.
   * This field is read only.
   * </pre>
   *
   * <code>optional int64 account_link_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The accountLinkId.
   */
  @java.lang.Override
  public long getAccountLinkId() {
    return accountLinkId_;
  }

  public static final int STATUS_FIELD_NUMBER = 3;
  private int status_ = 0;
  /**
   * <pre>
   * The status of the link.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus status = 3;</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * The status of the link.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus status = 3;</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus getStatus() {
    com.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus result = com.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus.forNumber(status_);
    return result == null ? com.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus.UNRECOGNIZED : result;
  }

  public static final int TYPE_FIELD_NUMBER = 4;
  private int type_ = 0;
  /**
   * <pre>
   * Output only. The type of the linked account.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Output only. The type of the linked account.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The type.
   */
  @java.lang.Override public com.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType getType() {
    com.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType result = com.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType.forNumber(type_);
    return result == null ? com.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType.UNRECOGNIZED : result;
  }

  public static final int THIRD_PARTY_APP_ANALYTICS_FIELD_NUMBER = 5;
  /**
   * <pre>
   * Immutable. A third party app analytics link.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier third_party_app_analytics = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return Whether the thirdPartyAppAnalytics field is set.
   */
  @java.lang.Override
  public boolean hasThirdPartyAppAnalytics() {
    return linkedAccountCase_ == 5;
  }
  /**
   * <pre>
   * Immutable. A third party app analytics link.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier third_party_app_analytics = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The thirdPartyAppAnalytics.
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier getThirdPartyAppAnalytics() {
    if (linkedAccountCase_ == 5) {
       return (com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier) linkedAccount_;
    }
    return com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.getDefaultInstance();
  }
  /**
   * <pre>
   * Immutable. A third party app analytics link.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier third_party_app_analytics = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifierOrBuilder getThirdPartyAppAnalyticsOrBuilder() {
    if (linkedAccountCase_ == 5) {
       return (com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier) linkedAccount_;
    }
    return com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.getDefaultInstance();
  }

  public static final int DATA_PARTNER_FIELD_NUMBER = 6;
  /**
   * <pre>
   * Output only. Data partner link.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier data_partner = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the dataPartner field is set.
   */
  @java.lang.Override
  public boolean hasDataPartner() {
    return linkedAccountCase_ == 6;
  }
  /**
   * <pre>
   * Output only. Data partner link.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier data_partner = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The dataPartner.
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier getDataPartner() {
    if (linkedAccountCase_ == 6) {
       return (com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier) linkedAccount_;
    }
    return com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Data partner link.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier data_partner = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifierOrBuilder getDataPartnerOrBuilder() {
    if (linkedAccountCase_ == 6) {
       return (com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier) linkedAccount_;
    }
    return com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.getDefaultInstance();
  }

  public static final int GOOGLE_ADS_FIELD_NUMBER = 7;
  /**
   * <pre>
   * Output only. Google Ads link.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier google_ads = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the googleAds field is set.
   */
  @java.lang.Override
  public boolean hasGoogleAds() {
    return linkedAccountCase_ == 7;
  }
  /**
   * <pre>
   * Output only. Google Ads link.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier google_ads = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The googleAds.
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier getGoogleAds() {
    if (linkedAccountCase_ == 7) {
       return (com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier) linkedAccount_;
    }
    return com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Google Ads link.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier google_ads = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifierOrBuilder getGoogleAdsOrBuilder() {
    if (linkedAccountCase_ == 7) {
       return (com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier) linkedAccount_;
    }
    return com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.getDefaultInstance();
  }

  public static final int HOTEL_CENTER_FIELD_NUMBER = 9;
  /**
   * <pre>
   * Output only. Hotel link
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier hotel_center = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the hotelCenter field is set.
   */
  @java.lang.Override
  public boolean hasHotelCenter() {
    return linkedAccountCase_ == 9;
  }
  /**
   * <pre>
   * Output only. Hotel link
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier hotel_center = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The hotelCenter.
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier getHotelCenter() {
    if (linkedAccountCase_ == 9) {
       return (com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier) linkedAccount_;
    }
    return com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Hotel link
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier hotel_center = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifierOrBuilder getHotelCenterOrBuilder() {
    if (linkedAccountCase_ == 9) {
       return (com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier) linkedAccount_;
    }
    return com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.getDefaultInstance();
  }

  public static final int ADVERTISING_PARTNER_FIELD_NUMBER = 10;
  /**
   * <pre>
   * Output only. Advertising Partner link
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier advertising_partner = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the advertisingPartner field is set.
   */
  @java.lang.Override
  public boolean hasAdvertisingPartner() {
    return linkedAccountCase_ == 10;
  }
  /**
   * <pre>
   * Output only. Advertising Partner link
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier advertising_partner = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The advertisingPartner.
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier getAdvertisingPartner() {
    if (linkedAccountCase_ == 10) {
       return (com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier) linkedAccount_;
    }
    return com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Advertising Partner link
   * </pre>
   *
   * <code>.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier advertising_partner = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifierOrBuilder getAdvertisingPartnerOrBuilder() {
    if (linkedAccountCase_ == 10) {
       return (com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier) linkedAccount_;
    }
    return com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (status_ != com.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(3, status_);
    }
    if (type_ != com.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType.UNSPECIFIED.getNumber()) {
      output.writeEnum(4, type_);
    }
    if (linkedAccountCase_ == 5) {
      output.writeMessage(5, (com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier) linkedAccount_);
    }
    if (linkedAccountCase_ == 6) {
      output.writeMessage(6, (com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier) linkedAccount_);
    }
    if (linkedAccountCase_ == 7) {
      output.writeMessage(7, (com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier) linkedAccount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(8, accountLinkId_);
    }
    if (linkedAccountCase_ == 9) {
      output.writeMessage(9, (com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier) linkedAccount_);
    }
    if (linkedAccountCase_ == 10) {
      output.writeMessage(10, (com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier) linkedAccount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (status_ != com.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, status_);
    }
    if (type_ != com.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, type_);
    }
    if (linkedAccountCase_ == 5) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, (com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier) linkedAccount_);
    }
    if (linkedAccountCase_ == 6) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, (com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier) linkedAccount_);
    }
    if (linkedAccountCase_ == 7) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, (com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier) linkedAccount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(8, accountLinkId_);
    }
    if (linkedAccountCase_ == 9) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(9, (com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier) linkedAccount_);
    }
    if (linkedAccountCase_ == 10) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, (com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier) linkedAccount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v14.resources.AccountLink)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v14.resources.AccountLink other = (com.google.ads.googleads.v14.resources.AccountLink) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (hasAccountLinkId() != other.hasAccountLinkId()) return false;
    if (hasAccountLinkId()) {
      if (getAccountLinkId()
          != other.getAccountLinkId()) return false;
    }
    if (status_ != other.status_) return false;
    if (type_ != other.type_) return false;
    if (!getLinkedAccountCase().equals(other.getLinkedAccountCase())) return false;
    switch (linkedAccountCase_) {
      case 5:
        if (!getThirdPartyAppAnalytics()
            .equals(other.getThirdPartyAppAnalytics())) return false;
        break;
      case 6:
        if (!getDataPartner()
            .equals(other.getDataPartner())) return false;
        break;
      case 7:
        if (!getGoogleAds()
            .equals(other.getGoogleAds())) return false;
        break;
      case 9:
        if (!getHotelCenter()
            .equals(other.getHotelCenter())) return false;
        break;
      case 10:
        if (!getAdvertisingPartner()
            .equals(other.getAdvertisingPartner())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    if (hasAccountLinkId()) {
      hash = (37 * hash) + ACCOUNT_LINK_ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getAccountLinkId());
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    switch (linkedAccountCase_) {
      case 5:
        hash = (37 * hash) + THIRD_PARTY_APP_ANALYTICS_FIELD_NUMBER;
        hash = (53 * hash) + getThirdPartyAppAnalytics().hashCode();
        break;
      case 6:
        hash = (37 * hash) + DATA_PARTNER_FIELD_NUMBER;
        hash = (53 * hash) + getDataPartner().hashCode();
        break;
      case 7:
        hash = (37 * hash) + GOOGLE_ADS_FIELD_NUMBER;
        hash = (53 * hash) + getGoogleAds().hashCode();
        break;
      case 9:
        hash = (37 * hash) + HOTEL_CENTER_FIELD_NUMBER;
        hash = (53 * hash) + getHotelCenter().hashCode();
        break;
      case 10:
        hash = (37 * hash) + ADVERTISING_PARTNER_FIELD_NUMBER;
        hash = (53 * hash) + getAdvertisingPartner().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v14.resources.AccountLink parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v14.resources.AccountLink parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v14.resources.AccountLink parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v14.resources.AccountLink parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v14.resources.AccountLink parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v14.resources.AccountLink parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v14.resources.AccountLink parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v14.resources.AccountLink parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v14.resources.AccountLink parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v14.resources.AccountLink parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v14.resources.AccountLink parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v14.resources.AccountLink parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v14.resources.AccountLink prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents the data sharing connection between a Google Ads account and
   * another account
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v14.resources.AccountLink}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v14.resources.AccountLink)
      com.google.ads.googleads.v14.resources.AccountLinkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v14.resources.AccountLinkProto.internal_static_google_ads_googleads_v14_resources_AccountLink_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v14.resources.AccountLinkProto.internal_static_google_ads_googleads_v14_resources_AccountLink_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v14.resources.AccountLink.class, com.google.ads.googleads.v14.resources.AccountLink.Builder.class);
    }

    // Construct using com.google.ads.googleads.v14.resources.AccountLink.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      accountLinkId_ = 0L;
      status_ = 0;
      type_ = 0;
      if (thirdPartyAppAnalyticsBuilder_ != null) {
        thirdPartyAppAnalyticsBuilder_.clear();
      }
      if (dataPartnerBuilder_ != null) {
        dataPartnerBuilder_.clear();
      }
      if (googleAdsBuilder_ != null) {
        googleAdsBuilder_.clear();
      }
      if (hotelCenterBuilder_ != null) {
        hotelCenterBuilder_.clear();
      }
      if (advertisingPartnerBuilder_ != null) {
        advertisingPartnerBuilder_.clear();
      }
      linkedAccountCase_ = 0;
      linkedAccount_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v14.resources.AccountLinkProto.internal_static_google_ads_googleads_v14_resources_AccountLink_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v14.resources.AccountLink getDefaultInstanceForType() {
      return com.google.ads.googleads.v14.resources.AccountLink.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v14.resources.AccountLink build() {
      com.google.ads.googleads.v14.resources.AccountLink result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v14.resources.AccountLink buildPartial() {
      com.google.ads.googleads.v14.resources.AccountLink result = new com.google.ads.googleads.v14.resources.AccountLink(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ads.googleads.v14.resources.AccountLink result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.accountLinkId_ = accountLinkId_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.status_ = status_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.type_ = type_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.ads.googleads.v14.resources.AccountLink result) {
      result.linkedAccountCase_ = linkedAccountCase_;
      result.linkedAccount_ = this.linkedAccount_;
      if (linkedAccountCase_ == 5 &&
          thirdPartyAppAnalyticsBuilder_ != null) {
        result.linkedAccount_ = thirdPartyAppAnalyticsBuilder_.build();
      }
      if (linkedAccountCase_ == 6 &&
          dataPartnerBuilder_ != null) {
        result.linkedAccount_ = dataPartnerBuilder_.build();
      }
      if (linkedAccountCase_ == 7 &&
          googleAdsBuilder_ != null) {
        result.linkedAccount_ = googleAdsBuilder_.build();
      }
      if (linkedAccountCase_ == 9 &&
          hotelCenterBuilder_ != null) {
        result.linkedAccount_ = hotelCenterBuilder_.build();
      }
      if (linkedAccountCase_ == 10 &&
          advertisingPartnerBuilder_ != null) {
        result.linkedAccount_ = advertisingPartnerBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v14.resources.AccountLink) {
        return mergeFrom((com.google.ads.googleads.v14.resources.AccountLink)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v14.resources.AccountLink other) {
      if (other == com.google.ads.googleads.v14.resources.AccountLink.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasAccountLinkId()) {
        setAccountLinkId(other.getAccountLinkId());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      switch (other.getLinkedAccountCase()) {
        case THIRD_PARTY_APP_ANALYTICS: {
          mergeThirdPartyAppAnalytics(other.getThirdPartyAppAnalytics());
          break;
        }
        case DATA_PARTNER: {
          mergeDataPartner(other.getDataPartner());
          break;
        }
        case GOOGLE_ADS: {
          mergeGoogleAds(other.getGoogleAds());
          break;
        }
        case HOTEL_CENTER: {
          mergeHotelCenter(other.getHotelCenter());
          break;
        }
        case ADVERTISING_PARTNER: {
          mergeAdvertisingPartner(other.getAdvertisingPartner());
          break;
        }
        case LINKEDACCOUNT_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 24: {
              status_ = input.readEnum();
              bitField0_ |= 0x00000004;
              break;
            } // case 24
            case 32: {
              type_ = input.readEnum();
              bitField0_ |= 0x00000008;
              break;
            } // case 32
            case 42: {
              input.readMessage(
                  getThirdPartyAppAnalyticsFieldBuilder().getBuilder(),
                  extensionRegistry);
              linkedAccountCase_ = 5;
              break;
            } // case 42
            case 50: {
              input.readMessage(
                  getDataPartnerFieldBuilder().getBuilder(),
                  extensionRegistry);
              linkedAccountCase_ = 6;
              break;
            } // case 50
            case 58: {
              input.readMessage(
                  getGoogleAdsFieldBuilder().getBuilder(),
                  extensionRegistry);
              linkedAccountCase_ = 7;
              break;
            } // case 58
            case 64: {
              accountLinkId_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 64
            case 74: {
              input.readMessage(
                  getHotelCenterFieldBuilder().getBuilder(),
                  extensionRegistry);
              linkedAccountCase_ = 9;
              break;
            } // case 74
            case 82: {
              input.readMessage(
                  getAdvertisingPartnerFieldBuilder().getBuilder(),
                  extensionRegistry);
              linkedAccountCase_ = 10;
              break;
            } // case 82
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int linkedAccountCase_ = 0;
    private java.lang.Object linkedAccount_;
    public LinkedAccountCase
        getLinkedAccountCase() {
      return LinkedAccountCase.forNumber(
          linkedAccountCase_);
    }

    public Builder clearLinkedAccount() {
      linkedAccountCase_ = 0;
      linkedAccount_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Immutable. Resource name of the account link.
     * AccountLink resource names have the form:
     * `customers/{customer_id}/accountLinks/{account_link_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. Resource name of the account link.
     * AccountLink resource names have the form:
     * `customers/{customer_id}/accountLinks/{account_link_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. Resource name of the account link.
     * AccountLink resource names have the form:
     * `customers/{customer_id}/accountLinks/{account_link_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. Resource name of the account link.
     * AccountLink resource names have the form:
     * `customers/{customer_id}/accountLinks/{account_link_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. Resource name of the account link.
     * AccountLink resource names have the form:
     * `customers/{customer_id}/accountLinks/{account_link_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long accountLinkId_ ;
    /**
     * <pre>
     * Output only. The ID of the link.
     * This field is read only.
     * </pre>
     *
     * <code>optional int64 account_link_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the accountLinkId field is set.
     */
    @java.lang.Override
    public boolean hasAccountLinkId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Output only. The ID of the link.
     * This field is read only.
     * </pre>
     *
     * <code>optional int64 account_link_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The accountLinkId.
     */
    @java.lang.Override
    public long getAccountLinkId() {
      return accountLinkId_;
    }
    /**
     * <pre>
     * Output only. The ID of the link.
     * This field is read only.
     * </pre>
     *
     * <code>optional int64 account_link_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The accountLinkId to set.
     * @return This builder for chaining.
     */
    public Builder setAccountLinkId(long value) {

      accountLinkId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The ID of the link.
     * This field is read only.
     * </pre>
     *
     * <code>optional int64 account_link_id = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearAccountLinkId() {
      bitField0_ = (bitField0_ & ~0x00000002);
      accountLinkId_ = 0L;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * The status of the link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus status = 3;</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * The status of the link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus status = 3;</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The status of the link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus status = 3;</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus getStatus() {
      com.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus result = com.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus.forNumber(status_);
      return result == null ? com.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The status of the link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus status = 3;</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The status of the link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.AccountLinkStatusEnum.AccountLinkStatus status = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000004);
      status_ = 0;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Output only. The type of the linked account.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Output only. The type of the linked account.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The type of the linked account.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The type.
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType getType() {
      com.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType result = com.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType.forNumber(type_);
      return result == null ? com.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The type of the linked account.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The type of the linked account.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.LinkedAccountTypeEnum.LinkedAccountType type = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier, com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifierOrBuilder> thirdPartyAppAnalyticsBuilder_;
    /**
     * <pre>
     * Immutable. A third party app analytics link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier third_party_app_analytics = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return Whether the thirdPartyAppAnalytics field is set.
     */
    @java.lang.Override
    public boolean hasThirdPartyAppAnalytics() {
      return linkedAccountCase_ == 5;
    }
    /**
     * <pre>
     * Immutable. A third party app analytics link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier third_party_app_analytics = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The thirdPartyAppAnalytics.
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier getThirdPartyAppAnalytics() {
      if (thirdPartyAppAnalyticsBuilder_ == null) {
        if (linkedAccountCase_ == 5) {
          return (com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier) linkedAccount_;
        }
        return com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.getDefaultInstance();
      } else {
        if (linkedAccountCase_ == 5) {
          return thirdPartyAppAnalyticsBuilder_.getMessage();
        }
        return com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. A third party app analytics link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier third_party_app_analytics = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setThirdPartyAppAnalytics(com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier value) {
      if (thirdPartyAppAnalyticsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedAccount_ = value;
        onChanged();
      } else {
        thirdPartyAppAnalyticsBuilder_.setMessage(value);
      }
      linkedAccountCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Immutable. A third party app analytics link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier third_party_app_analytics = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setThirdPartyAppAnalytics(
        com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.Builder builderForValue) {
      if (thirdPartyAppAnalyticsBuilder_ == null) {
        linkedAccount_ = builderForValue.build();
        onChanged();
      } else {
        thirdPartyAppAnalyticsBuilder_.setMessage(builderForValue.build());
      }
      linkedAccountCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Immutable. A third party app analytics link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier third_party_app_analytics = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder mergeThirdPartyAppAnalytics(com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier value) {
      if (thirdPartyAppAnalyticsBuilder_ == null) {
        if (linkedAccountCase_ == 5 &&
            linkedAccount_ != com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.getDefaultInstance()) {
          linkedAccount_ = com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.newBuilder((com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier) linkedAccount_)
              .mergeFrom(value).buildPartial();
        } else {
          linkedAccount_ = value;
        }
        onChanged();
      } else {
        if (linkedAccountCase_ == 5) {
          thirdPartyAppAnalyticsBuilder_.mergeFrom(value);
        } else {
          thirdPartyAppAnalyticsBuilder_.setMessage(value);
        }
      }
      linkedAccountCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Immutable. A third party app analytics link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier third_party_app_analytics = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder clearThirdPartyAppAnalytics() {
      if (thirdPartyAppAnalyticsBuilder_ == null) {
        if (linkedAccountCase_ == 5) {
          linkedAccountCase_ = 0;
          linkedAccount_ = null;
          onChanged();
        }
      } else {
        if (linkedAccountCase_ == 5) {
          linkedAccountCase_ = 0;
          linkedAccount_ = null;
        }
        thirdPartyAppAnalyticsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Immutable. A third party app analytics link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier third_party_app_analytics = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.Builder getThirdPartyAppAnalyticsBuilder() {
      return getThirdPartyAppAnalyticsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Immutable. A third party app analytics link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier third_party_app_analytics = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifierOrBuilder getThirdPartyAppAnalyticsOrBuilder() {
      if ((linkedAccountCase_ == 5) && (thirdPartyAppAnalyticsBuilder_ != null)) {
        return thirdPartyAppAnalyticsBuilder_.getMessageOrBuilder();
      } else {
        if (linkedAccountCase_ == 5) {
          return (com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier) linkedAccount_;
        }
        return com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Immutable. A third party app analytics link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier third_party_app_analytics = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier, com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifierOrBuilder> 
        getThirdPartyAppAnalyticsFieldBuilder() {
      if (thirdPartyAppAnalyticsBuilder_ == null) {
        if (!(linkedAccountCase_ == 5)) {
          linkedAccount_ = com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.getDefaultInstance();
        }
        thirdPartyAppAnalyticsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier, com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifierOrBuilder>(
                (com.google.ads.googleads.v14.resources.ThirdPartyAppAnalyticsLinkIdentifier) linkedAccount_,
                getParentForChildren(),
                isClean());
        linkedAccount_ = null;
      }
      linkedAccountCase_ = 5;
      onChanged();
      return thirdPartyAppAnalyticsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier, com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifierOrBuilder> dataPartnerBuilder_;
    /**
     * <pre>
     * Output only. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier data_partner = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the dataPartner field is set.
     */
    @java.lang.Override
    public boolean hasDataPartner() {
      return linkedAccountCase_ == 6;
    }
    /**
     * <pre>
     * Output only. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier data_partner = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The dataPartner.
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier getDataPartner() {
      if (dataPartnerBuilder_ == null) {
        if (linkedAccountCase_ == 6) {
          return (com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier) linkedAccount_;
        }
        return com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.getDefaultInstance();
      } else {
        if (linkedAccountCase_ == 6) {
          return dataPartnerBuilder_.getMessage();
        }
        return com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier data_partner = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setDataPartner(com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier value) {
      if (dataPartnerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedAccount_ = value;
        onChanged();
      } else {
        dataPartnerBuilder_.setMessage(value);
      }
      linkedAccountCase_ = 6;
      return this;
    }
    /**
     * <pre>
     * Output only. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier data_partner = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setDataPartner(
        com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.Builder builderForValue) {
      if (dataPartnerBuilder_ == null) {
        linkedAccount_ = builderForValue.build();
        onChanged();
      } else {
        dataPartnerBuilder_.setMessage(builderForValue.build());
      }
      linkedAccountCase_ = 6;
      return this;
    }
    /**
     * <pre>
     * Output only. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier data_partner = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeDataPartner(com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier value) {
      if (dataPartnerBuilder_ == null) {
        if (linkedAccountCase_ == 6 &&
            linkedAccount_ != com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.getDefaultInstance()) {
          linkedAccount_ = com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.newBuilder((com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier) linkedAccount_)
              .mergeFrom(value).buildPartial();
        } else {
          linkedAccount_ = value;
        }
        onChanged();
      } else {
        if (linkedAccountCase_ == 6) {
          dataPartnerBuilder_.mergeFrom(value);
        } else {
          dataPartnerBuilder_.setMessage(value);
        }
      }
      linkedAccountCase_ = 6;
      return this;
    }
    /**
     * <pre>
     * Output only. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier data_partner = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearDataPartner() {
      if (dataPartnerBuilder_ == null) {
        if (linkedAccountCase_ == 6) {
          linkedAccountCase_ = 0;
          linkedAccount_ = null;
          onChanged();
        }
      } else {
        if (linkedAccountCase_ == 6) {
          linkedAccountCase_ = 0;
          linkedAccount_ = null;
        }
        dataPartnerBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier data_partner = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.Builder getDataPartnerBuilder() {
      return getDataPartnerFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier data_partner = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifierOrBuilder getDataPartnerOrBuilder() {
      if ((linkedAccountCase_ == 6) && (dataPartnerBuilder_ != null)) {
        return dataPartnerBuilder_.getMessageOrBuilder();
      } else {
        if (linkedAccountCase_ == 6) {
          return (com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier) linkedAccount_;
        }
        return com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Data partner link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier data_partner = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier, com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifierOrBuilder> 
        getDataPartnerFieldBuilder() {
      if (dataPartnerBuilder_ == null) {
        if (!(linkedAccountCase_ == 6)) {
          linkedAccount_ = com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.getDefaultInstance();
        }
        dataPartnerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier, com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifierOrBuilder>(
                (com.google.ads.googleads.v14.resources.DataPartnerLinkIdentifier) linkedAccount_,
                getParentForChildren(),
                isClean());
        linkedAccount_ = null;
      }
      linkedAccountCase_ = 6;
      onChanged();
      return dataPartnerBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier, com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifierOrBuilder> googleAdsBuilder_;
    /**
     * <pre>
     * Output only. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier google_ads = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the googleAds field is set.
     */
    @java.lang.Override
    public boolean hasGoogleAds() {
      return linkedAccountCase_ == 7;
    }
    /**
     * <pre>
     * Output only. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier google_ads = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The googleAds.
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier getGoogleAds() {
      if (googleAdsBuilder_ == null) {
        if (linkedAccountCase_ == 7) {
          return (com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier) linkedAccount_;
        }
        return com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.getDefaultInstance();
      } else {
        if (linkedAccountCase_ == 7) {
          return googleAdsBuilder_.getMessage();
        }
        return com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier google_ads = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setGoogleAds(com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier value) {
      if (googleAdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedAccount_ = value;
        onChanged();
      } else {
        googleAdsBuilder_.setMessage(value);
      }
      linkedAccountCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Output only. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier google_ads = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setGoogleAds(
        com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.Builder builderForValue) {
      if (googleAdsBuilder_ == null) {
        linkedAccount_ = builderForValue.build();
        onChanged();
      } else {
        googleAdsBuilder_.setMessage(builderForValue.build());
      }
      linkedAccountCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Output only. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier google_ads = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeGoogleAds(com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier value) {
      if (googleAdsBuilder_ == null) {
        if (linkedAccountCase_ == 7 &&
            linkedAccount_ != com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.getDefaultInstance()) {
          linkedAccount_ = com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.newBuilder((com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier) linkedAccount_)
              .mergeFrom(value).buildPartial();
        } else {
          linkedAccount_ = value;
        }
        onChanged();
      } else {
        if (linkedAccountCase_ == 7) {
          googleAdsBuilder_.mergeFrom(value);
        } else {
          googleAdsBuilder_.setMessage(value);
        }
      }
      linkedAccountCase_ = 7;
      return this;
    }
    /**
     * <pre>
     * Output only. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier google_ads = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearGoogleAds() {
      if (googleAdsBuilder_ == null) {
        if (linkedAccountCase_ == 7) {
          linkedAccountCase_ = 0;
          linkedAccount_ = null;
          onChanged();
        }
      } else {
        if (linkedAccountCase_ == 7) {
          linkedAccountCase_ = 0;
          linkedAccount_ = null;
        }
        googleAdsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier google_ads = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.Builder getGoogleAdsBuilder() {
      return getGoogleAdsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier google_ads = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifierOrBuilder getGoogleAdsOrBuilder() {
      if ((linkedAccountCase_ == 7) && (googleAdsBuilder_ != null)) {
        return googleAdsBuilder_.getMessageOrBuilder();
      } else {
        if (linkedAccountCase_ == 7) {
          return (com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier) linkedAccount_;
        }
        return com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Google Ads link.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier google_ads = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier, com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifierOrBuilder> 
        getGoogleAdsFieldBuilder() {
      if (googleAdsBuilder_ == null) {
        if (!(linkedAccountCase_ == 7)) {
          linkedAccount_ = com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.getDefaultInstance();
        }
        googleAdsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier, com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifierOrBuilder>(
                (com.google.ads.googleads.v14.resources.GoogleAdsLinkIdentifier) linkedAccount_,
                getParentForChildren(),
                isClean());
        linkedAccount_ = null;
      }
      linkedAccountCase_ = 7;
      onChanged();
      return googleAdsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier, com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifierOrBuilder> hotelCenterBuilder_;
    /**
     * <pre>
     * Output only. Hotel link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier hotel_center = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the hotelCenter field is set.
     */
    @java.lang.Override
    public boolean hasHotelCenter() {
      return linkedAccountCase_ == 9;
    }
    /**
     * <pre>
     * Output only. Hotel link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier hotel_center = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The hotelCenter.
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier getHotelCenter() {
      if (hotelCenterBuilder_ == null) {
        if (linkedAccountCase_ == 9) {
          return (com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier) linkedAccount_;
        }
        return com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.getDefaultInstance();
      } else {
        if (linkedAccountCase_ == 9) {
          return hotelCenterBuilder_.getMessage();
        }
        return com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Hotel link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier hotel_center = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setHotelCenter(com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier value) {
      if (hotelCenterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedAccount_ = value;
        onChanged();
      } else {
        hotelCenterBuilder_.setMessage(value);
      }
      linkedAccountCase_ = 9;
      return this;
    }
    /**
     * <pre>
     * Output only. Hotel link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier hotel_center = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setHotelCenter(
        com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.Builder builderForValue) {
      if (hotelCenterBuilder_ == null) {
        linkedAccount_ = builderForValue.build();
        onChanged();
      } else {
        hotelCenterBuilder_.setMessage(builderForValue.build());
      }
      linkedAccountCase_ = 9;
      return this;
    }
    /**
     * <pre>
     * Output only. Hotel link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier hotel_center = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeHotelCenter(com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier value) {
      if (hotelCenterBuilder_ == null) {
        if (linkedAccountCase_ == 9 &&
            linkedAccount_ != com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.getDefaultInstance()) {
          linkedAccount_ = com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.newBuilder((com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier) linkedAccount_)
              .mergeFrom(value).buildPartial();
        } else {
          linkedAccount_ = value;
        }
        onChanged();
      } else {
        if (linkedAccountCase_ == 9) {
          hotelCenterBuilder_.mergeFrom(value);
        } else {
          hotelCenterBuilder_.setMessage(value);
        }
      }
      linkedAccountCase_ = 9;
      return this;
    }
    /**
     * <pre>
     * Output only. Hotel link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier hotel_center = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearHotelCenter() {
      if (hotelCenterBuilder_ == null) {
        if (linkedAccountCase_ == 9) {
          linkedAccountCase_ = 0;
          linkedAccount_ = null;
          onChanged();
        }
      } else {
        if (linkedAccountCase_ == 9) {
          linkedAccountCase_ = 0;
          linkedAccount_ = null;
        }
        hotelCenterBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Hotel link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier hotel_center = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.Builder getHotelCenterBuilder() {
      return getHotelCenterFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Hotel link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier hotel_center = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifierOrBuilder getHotelCenterOrBuilder() {
      if ((linkedAccountCase_ == 9) && (hotelCenterBuilder_ != null)) {
        return hotelCenterBuilder_.getMessageOrBuilder();
      } else {
        if (linkedAccountCase_ == 9) {
          return (com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier) linkedAccount_;
        }
        return com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Hotel link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier hotel_center = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier, com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifierOrBuilder> 
        getHotelCenterFieldBuilder() {
      if (hotelCenterBuilder_ == null) {
        if (!(linkedAccountCase_ == 9)) {
          linkedAccount_ = com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.getDefaultInstance();
        }
        hotelCenterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier, com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifierOrBuilder>(
                (com.google.ads.googleads.v14.resources.HotelCenterLinkIdentifier) linkedAccount_,
                getParentForChildren(),
                isClean());
        linkedAccount_ = null;
      }
      linkedAccountCase_ = 9;
      onChanged();
      return hotelCenterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier, com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifierOrBuilder> advertisingPartnerBuilder_;
    /**
     * <pre>
     * Output only. Advertising Partner link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier advertising_partner = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the advertisingPartner field is set.
     */
    @java.lang.Override
    public boolean hasAdvertisingPartner() {
      return linkedAccountCase_ == 10;
    }
    /**
     * <pre>
     * Output only. Advertising Partner link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier advertising_partner = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The advertisingPartner.
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier getAdvertisingPartner() {
      if (advertisingPartnerBuilder_ == null) {
        if (linkedAccountCase_ == 10) {
          return (com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier) linkedAccount_;
        }
        return com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.getDefaultInstance();
      } else {
        if (linkedAccountCase_ == 10) {
          return advertisingPartnerBuilder_.getMessage();
        }
        return com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Advertising Partner link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier advertising_partner = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setAdvertisingPartner(com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier value) {
      if (advertisingPartnerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        linkedAccount_ = value;
        onChanged();
      } else {
        advertisingPartnerBuilder_.setMessage(value);
      }
      linkedAccountCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Output only. Advertising Partner link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier advertising_partner = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setAdvertisingPartner(
        com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.Builder builderForValue) {
      if (advertisingPartnerBuilder_ == null) {
        linkedAccount_ = builderForValue.build();
        onChanged();
      } else {
        advertisingPartnerBuilder_.setMessage(builderForValue.build());
      }
      linkedAccountCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Output only. Advertising Partner link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier advertising_partner = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeAdvertisingPartner(com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier value) {
      if (advertisingPartnerBuilder_ == null) {
        if (linkedAccountCase_ == 10 &&
            linkedAccount_ != com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.getDefaultInstance()) {
          linkedAccount_ = com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.newBuilder((com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier) linkedAccount_)
              .mergeFrom(value).buildPartial();
        } else {
          linkedAccount_ = value;
        }
        onChanged();
      } else {
        if (linkedAccountCase_ == 10) {
          advertisingPartnerBuilder_.mergeFrom(value);
        } else {
          advertisingPartnerBuilder_.setMessage(value);
        }
      }
      linkedAccountCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Output only. Advertising Partner link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier advertising_partner = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearAdvertisingPartner() {
      if (advertisingPartnerBuilder_ == null) {
        if (linkedAccountCase_ == 10) {
          linkedAccountCase_ = 0;
          linkedAccount_ = null;
          onChanged();
        }
      } else {
        if (linkedAccountCase_ == 10) {
          linkedAccountCase_ = 0;
          linkedAccount_ = null;
        }
        advertisingPartnerBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Advertising Partner link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier advertising_partner = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.Builder getAdvertisingPartnerBuilder() {
      return getAdvertisingPartnerFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Advertising Partner link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier advertising_partner = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifierOrBuilder getAdvertisingPartnerOrBuilder() {
      if ((linkedAccountCase_ == 10) && (advertisingPartnerBuilder_ != null)) {
        return advertisingPartnerBuilder_.getMessageOrBuilder();
      } else {
        if (linkedAccountCase_ == 10) {
          return (com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier) linkedAccount_;
        }
        return com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Advertising Partner link
     * </pre>
     *
     * <code>.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier advertising_partner = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier, com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifierOrBuilder> 
        getAdvertisingPartnerFieldBuilder() {
      if (advertisingPartnerBuilder_ == null) {
        if (!(linkedAccountCase_ == 10)) {
          linkedAccount_ = com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.getDefaultInstance();
        }
        advertisingPartnerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier, com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier.Builder, com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifierOrBuilder>(
                (com.google.ads.googleads.v14.resources.AdvertisingPartnerLinkIdentifier) linkedAccount_,
                getParentForChildren(),
                isClean());
        linkedAccount_ = null;
      }
      linkedAccountCase_ = 10;
      onChanged();
      return advertisingPartnerBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v14.resources.AccountLink)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v14.resources.AccountLink)
  private static final com.google.ads.googleads.v14.resources.AccountLink DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v14.resources.AccountLink();
  }

  public static com.google.ads.googleads.v14.resources.AccountLink getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AccountLink>
      PARSER = new com.google.protobuf.AbstractParser<AccountLink>() {
    @java.lang.Override
    public AccountLink parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<AccountLink> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AccountLink> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v14.resources.AccountLink getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

