/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupLabelName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_LABEL_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroupLabels/{ad_group_id}~{label_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String labelId;

    @Deprecated
    protected AdGroupLabelName() {
        this.customerId = null;
        this.adGroupId = null;
        this.labelId = null;
    }

    private AdGroupLabelName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.labelId = (String)Preconditions.checkNotNull((Object)builder.getLabelId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getLabelId() {
        return this.labelId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupLabelName of(String customerId, String adGroupId, String labelId) {
        return AdGroupLabelName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setLabelId(labelId).build();
    }

    public static String format(String customerId, String adGroupId, String labelId) {
        return AdGroupLabelName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setLabelId(labelId).build().toString();
    }

    public static AdGroupLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_LABEL_ID.validatedMatch(formattedString, "AdGroupLabelName.parse: formattedString not in valid format");
        return AdGroupLabelName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("label_id"));
    }

    public static List<AdGroupLabelName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupLabelName> list = new ArrayList<AdGroupLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_LABEL_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupLabelName adGroupLabelName = this;
            synchronized (adGroupLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.labelId != null) {
                        fieldMapBuilder.put((Object)"label_id", (Object)this.labelId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_LABEL_ID.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "label_id", this.labelId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AdGroupLabelName that = (AdGroupLabelName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.labelId, that.labelId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.labelId);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String labelId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getLabelId() {
            return this.labelId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setLabelId(String labelId) {
            this.labelId = labelId;
            return this;
        }

        private Builder(AdGroupLabelName adGroupLabelName) {
            this.customerId = adGroupLabelName.customerId;
            this.adGroupId = adGroupLabelName.adGroupId;
            this.labelId = adGroupLabelName.labelId;
        }

        public AdGroupLabelName build() {
            return new AdGroupLabelName(this);
        }
    }
}

