/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BiddingStrategyName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_BIDDING_STRATEGY_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/biddingStrategies/{bidding_strategy_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String biddingStrategyId;

    @Deprecated
    protected BiddingStrategyName() {
        this.customerId = null;
        this.biddingStrategyId = null;
    }

    private BiddingStrategyName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.biddingStrategyId = (String)Preconditions.checkNotNull((Object)builder.getBiddingStrategyId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getBiddingStrategyId() {
        return this.biddingStrategyId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BiddingStrategyName of(String customerId, String biddingStrategyId) {
        return BiddingStrategyName.newBuilder().setCustomerId(customerId).setBiddingStrategyId(biddingStrategyId).build();
    }

    public static String format(String customerId, String biddingStrategyId) {
        return BiddingStrategyName.newBuilder().setCustomerId(customerId).setBiddingStrategyId(biddingStrategyId).build().toString();
    }

    public static BiddingStrategyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_BIDDING_STRATEGY_ID.validatedMatch(formattedString, "BiddingStrategyName.parse: formattedString not in valid format");
        return BiddingStrategyName.of((String)matchMap.get("customer_id"), (String)matchMap.get("bidding_strategy_id"));
    }

    public static List<BiddingStrategyName> parseList(List<String> formattedStrings) {
        ArrayList<BiddingStrategyName> list = new ArrayList<BiddingStrategyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BiddingStrategyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BiddingStrategyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BiddingStrategyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_BIDDING_STRATEGY_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BiddingStrategyName biddingStrategyName = this;
            synchronized (biddingStrategyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.biddingStrategyId != null) {
                        fieldMapBuilder.put((Object)"bidding_strategy_id", (Object)this.biddingStrategyId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_BIDDING_STRATEGY_ID.instantiate(new String[]{"customer_id", this.customerId, "bidding_strategy_id", this.biddingStrategyId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            BiddingStrategyName that = (BiddingStrategyName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.biddingStrategyId, that.biddingStrategyId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.biddingStrategyId);
    }

    public static class Builder {
        private String customerId;
        private String biddingStrategyId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getBiddingStrategyId() {
            return this.biddingStrategyId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setBiddingStrategyId(String biddingStrategyId) {
            this.biddingStrategyId = biddingStrategyId;
            return this;
        }

        private Builder(BiddingStrategyName biddingStrategyName) {
            this.customerId = biddingStrategyName.customerId;
            this.biddingStrategyId = biddingStrategyName.biddingStrategyId;
        }

        public BiddingStrategyName build() {
            return new BiddingStrategyName(this);
        }
    }
}

