/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignGroupName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_GROUP_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignGroups/{campaign_group_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignGroupId;

    @Deprecated
    protected CampaignGroupName() {
        this.customerId = null;
        this.campaignGroupId = null;
    }

    private CampaignGroupName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignGroupId = (String)Preconditions.checkNotNull((Object)builder.getCampaignGroupId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignGroupId() {
        return this.campaignGroupId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignGroupName of(String customerId, String campaignGroupId) {
        return CampaignGroupName.newBuilder().setCustomerId(customerId).setCampaignGroupId(campaignGroupId).build();
    }

    public static String format(String customerId, String campaignGroupId) {
        return CampaignGroupName.newBuilder().setCustomerId(customerId).setCampaignGroupId(campaignGroupId).build().toString();
    }

    public static CampaignGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_GROUP_ID.validatedMatch(formattedString, "CampaignGroupName.parse: formattedString not in valid format");
        return CampaignGroupName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_group_id"));
    }

    public static List<CampaignGroupName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignGroupName> list = new ArrayList<CampaignGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_GROUP_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignGroupName campaignGroupName = this;
            synchronized (campaignGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignGroupId != null) {
                        fieldMapBuilder.put((Object)"campaign_group_id", (Object)this.campaignGroupId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_GROUP_ID.instantiate(new String[]{"customer_id", this.customerId, "campaign_group_id", this.campaignGroupId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CampaignGroupName that = (CampaignGroupName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignGroupId, that.campaignGroupId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.campaignGroupId);
    }

    public static class Builder {
        private String customerId;
        private String campaignGroupId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignGroupId() {
            return this.campaignGroupId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignGroupId(String campaignGroupId) {
            this.campaignGroupId = campaignGroupId;
            return this;
        }

        private Builder(CampaignGroupName campaignGroupName) {
            this.customerId = campaignGroupName.customerId;
            this.campaignGroupId = campaignGroupName.campaignGroupId;
        }

        public CampaignGroupName build() {
            return new CampaignGroupName(this);
        }
    }
}

