/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DomainCategoryName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_BASE64_CATEGORY_LANGUAGE_CODE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/domainCategories/{campaign_id}~{base64_category}~{language_code}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String base64Category;
    private final String languageCode;

    @Deprecated
    protected DomainCategoryName() {
        this.customerId = null;
        this.campaignId = null;
        this.base64Category = null;
        this.languageCode = null;
    }

    private DomainCategoryName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.base64Category = (String)Preconditions.checkNotNull((Object)builder.getBase64Category());
        this.languageCode = (String)Preconditions.checkNotNull((Object)builder.getLanguageCode());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getBase64Category() {
        return this.base64Category;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DomainCategoryName of(String customerId, String campaignId, String base64Category, String languageCode) {
        return DomainCategoryName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setBase64Category(base64Category).setLanguageCode(languageCode).build();
    }

    public static String format(String customerId, String campaignId, String base64Category, String languageCode) {
        return DomainCategoryName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setBase64Category(base64Category).setLanguageCode(languageCode).build().toString();
    }

    public static DomainCategoryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_BASE64_CATEGORY_LANGUAGE_CODE.validatedMatch(formattedString, "DomainCategoryName.parse: formattedString not in valid format");
        return DomainCategoryName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("base64_category"), (String)matchMap.get("language_code"));
    }

    public static List<DomainCategoryName> parseList(List<String> formattedStrings) {
        ArrayList<DomainCategoryName> list = new ArrayList<DomainCategoryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DomainCategoryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DomainCategoryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DomainCategoryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_BASE64_CATEGORY_LANGUAGE_CODE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DomainCategoryName domainCategoryName = this;
            synchronized (domainCategoryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.base64Category != null) {
                        fieldMapBuilder.put((Object)"base64_category", (Object)this.base64Category);
                    }
                    if (this.languageCode != null) {
                        fieldMapBuilder.put((Object)"language_code", (Object)this.languageCode);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_BASE64_CATEGORY_LANGUAGE_CODE.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "base64_category", this.base64Category, "language_code", this.languageCode});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DomainCategoryName that = (DomainCategoryName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.base64Category, that.base64Category) && Objects.equals(this.languageCode, that.languageCode);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        h ^= Objects.hashCode(this.base64Category);
        h *= 1000003;
        return h ^= Objects.hashCode(this.languageCode);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String base64Category;
        private String languageCode;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getBase64Category() {
            return this.base64Category;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setBase64Category(String base64Category) {
            this.base64Category = base64Category;
            return this;
        }

        public Builder setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        private Builder(DomainCategoryName domainCategoryName) {
            this.customerId = domainCategoryName.customerId;
            this.campaignId = domainCategoryName.campaignId;
            this.base64Category = domainCategoryName.base64Category;
            this.languageCode = domainCategoryName.languageCode;
        }

        public DomainCategoryName build() {
            return new DomainCategoryName(this);
        }
    }
}

