/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PerStoreViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_PLACE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/perStoreViews/{place_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String placeId;

    @Deprecated
    protected PerStoreViewName() {
        this.customerId = null;
        this.placeId = null;
    }

    private PerStoreViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.placeId = (String)Preconditions.checkNotNull((Object)builder.getPlaceId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PerStoreViewName of(String customerId, String placeId) {
        return PerStoreViewName.newBuilder().setCustomerId(customerId).setPlaceId(placeId).build();
    }

    public static String format(String customerId, String placeId) {
        return PerStoreViewName.newBuilder().setCustomerId(customerId).setPlaceId(placeId).build().toString();
    }

    public static PerStoreViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_PLACE_ID.validatedMatch(formattedString, "PerStoreViewName.parse: formattedString not in valid format");
        return PerStoreViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("place_id"));
    }

    public static List<PerStoreViewName> parseList(List<String> formattedStrings) {
        ArrayList<PerStoreViewName> list = new ArrayList<PerStoreViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PerStoreViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PerStoreViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PerStoreViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_PLACE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PerStoreViewName perStoreViewName = this;
            synchronized (perStoreViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.placeId != null) {
                        fieldMapBuilder.put((Object)"place_id", (Object)this.placeId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_PLACE_ID.instantiate(new String[]{"customer_id", this.customerId, "place_id", this.placeId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PerStoreViewName that = (PerStoreViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.placeId, that.placeId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.placeId);
    }

    public static class Builder {
        private String customerId;
        private String placeId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getPlaceId() {
            return this.placeId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setPlaceId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        private Builder(PerStoreViewName perStoreViewName) {
            this.customerId = perStoreViewName.customerId;
            this.placeId = perStoreViewName.placeId;
        }

        public PerStoreViewName build() {
            return new PerStoreViewName(this);
        }
    }
}

