/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RemarketingActionName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_REMARKETING_ACTION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/remarketingActions/{remarketing_action_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String remarketingActionId;

    @Deprecated
    protected RemarketingActionName() {
        this.customerId = null;
        this.remarketingActionId = null;
    }

    private RemarketingActionName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.remarketingActionId = (String)Preconditions.checkNotNull((Object)builder.getRemarketingActionId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getRemarketingActionId() {
        return this.remarketingActionId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RemarketingActionName of(String customerId, String remarketingActionId) {
        return RemarketingActionName.newBuilder().setCustomerId(customerId).setRemarketingActionId(remarketingActionId).build();
    }

    public static String format(String customerId, String remarketingActionId) {
        return RemarketingActionName.newBuilder().setCustomerId(customerId).setRemarketingActionId(remarketingActionId).build().toString();
    }

    public static RemarketingActionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_REMARKETING_ACTION_ID.validatedMatch(formattedString, "RemarketingActionName.parse: formattedString not in valid format");
        return RemarketingActionName.of((String)matchMap.get("customer_id"), (String)matchMap.get("remarketing_action_id"));
    }

    public static List<RemarketingActionName> parseList(List<String> formattedStrings) {
        ArrayList<RemarketingActionName> list = new ArrayList<RemarketingActionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RemarketingActionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RemarketingActionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RemarketingActionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_REMARKETING_ACTION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RemarketingActionName remarketingActionName = this;
            synchronized (remarketingActionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.remarketingActionId != null) {
                        fieldMapBuilder.put((Object)"remarketing_action_id", (Object)this.remarketingActionId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_REMARKETING_ACTION_ID.instantiate(new String[]{"customer_id", this.customerId, "remarketing_action_id", this.remarketingActionId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RemarketingActionName that = (RemarketingActionName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.remarketingActionId, that.remarketingActionId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.remarketingActionId);
    }

    public static class Builder {
        private String customerId;
        private String remarketingActionId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getRemarketingActionId() {
            return this.remarketingActionId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setRemarketingActionId(String remarketingActionId) {
            this.remarketingActionId = remarketingActionId;
            return this;
        }

        private Builder(RemarketingActionName remarketingActionName) {
            this.customerId = remarketingActionName.customerId;
            this.remarketingActionId = remarketingActionName.remarketingActionId;
        }

        public RemarketingActionName build() {
            return new RemarketingActionName(this);
        }
    }
}

