/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TopicConstantName
implements ResourceName {
    private static final PathTemplate TOPIC_ID = PathTemplate.createWithoutUrlEncoding((String)"topicConstants/{topic_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String topicId;

    @Deprecated
    protected TopicConstantName() {
        this.topicId = null;
    }

    private TopicConstantName(Builder builder) {
        this.topicId = (String)Preconditions.checkNotNull((Object)builder.getTopicId());
    }

    public String getTopicId() {
        return this.topicId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TopicConstantName of(String topicId) {
        return TopicConstantName.newBuilder().setTopicId(topicId).build();
    }

    public static String format(String topicId) {
        return TopicConstantName.newBuilder().setTopicId(topicId).build().toString();
    }

    public static TopicConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = TOPIC_ID.validatedMatch(formattedString, "TopicConstantName.parse: formattedString not in valid format");
        return TopicConstantName.of((String)matchMap.get("topic_id"));
    }

    public static List<TopicConstantName> parseList(List<String> formattedStrings) {
        ArrayList<TopicConstantName> list = new ArrayList<TopicConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TopicConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TopicConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TopicConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return TOPIC_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TopicConstantName topicConstantName = this;
            synchronized (topicConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.topicId != null) {
                        fieldMapBuilder.put((Object)"topic_id", (Object)this.topicId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return TOPIC_ID.instantiate(new String[]{"topic_id", this.topicId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            TopicConstantName that = (TopicConstantName)o;
            return Objects.equals(this.topicId, that.topicId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.topicId);
    }

    public static class Builder {
        private String topicId;

        protected Builder() {
        }

        public String getTopicId() {
            return this.topicId;
        }

        public Builder setTopicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        private Builder(TopicConstantName topicConstantName) {
            this.topicId = topicConstantName.topicId;
        }

        public TopicConstantName build() {
            return new TopicConstantName(this);
        }
    }
}

