/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.services.stub;

import com.google.ads.googleads.v14.services.GenerateAudienceCompositionInsightsRequest;
import com.google.ads.googleads.v14.services.GenerateAudienceCompositionInsightsResponse;
import com.google.ads.googleads.v14.services.GenerateInsightsFinderReportRequest;
import com.google.ads.googleads.v14.services.GenerateInsightsFinderReportResponse;
import com.google.ads.googleads.v14.services.ListAudienceInsightsAttributesRequest;
import com.google.ads.googleads.v14.services.ListAudienceInsightsAttributesResponse;
import com.google.ads.googleads.v14.services.ListInsightsEligibleDatesRequest;
import com.google.ads.googleads.v14.services.ListInsightsEligibleDatesResponse;
import com.google.ads.googleads.v14.services.stub.AudienceInsightsServiceStub;
import com.google.ads.googleads.v14.services.stub.GrpcAudienceInsightsServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AudienceInsightsServiceStubSettings
extends StubSettings<AudienceInsightsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final UnaryCallSettings<GenerateInsightsFinderReportRequest, GenerateInsightsFinderReportResponse> generateInsightsFinderReportSettings;
    private final UnaryCallSettings<ListAudienceInsightsAttributesRequest, ListAudienceInsightsAttributesResponse> listAudienceInsightsAttributesSettings;
    private final UnaryCallSettings<ListInsightsEligibleDatesRequest, ListInsightsEligibleDatesResponse> listInsightsEligibleDatesSettings;
    private final UnaryCallSettings<GenerateAudienceCompositionInsightsRequest, GenerateAudienceCompositionInsightsResponse> generateAudienceCompositionInsightsSettings;

    public UnaryCallSettings<GenerateInsightsFinderReportRequest, GenerateInsightsFinderReportResponse> generateInsightsFinderReportSettings() {
        return this.generateInsightsFinderReportSettings;
    }

    public UnaryCallSettings<ListAudienceInsightsAttributesRequest, ListAudienceInsightsAttributesResponse> listAudienceInsightsAttributesSettings() {
        return this.listAudienceInsightsAttributesSettings;
    }

    public UnaryCallSettings<ListInsightsEligibleDatesRequest, ListInsightsEligibleDatesResponse> listInsightsEligibleDatesSettings() {
        return this.listInsightsEligibleDatesSettings;
    }

    public UnaryCallSettings<GenerateAudienceCompositionInsightsRequest, GenerateAudienceCompositionInsightsResponse> generateAudienceCompositionInsightsSettings() {
        return this.generateAudienceCompositionInsightsSettings;
    }

    public AudienceInsightsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAudienceInsightsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "googleads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AudienceInsightsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AudienceInsightsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AudienceInsightsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.generateInsightsFinderReportSettings = settingsBuilder.generateInsightsFinderReportSettings().build();
        this.listAudienceInsightsAttributesSettings = settingsBuilder.listAudienceInsightsAttributesSettings().build();
        this.listInsightsEligibleDatesSettings = settingsBuilder.listInsightsEligibleDatesSettings().build();
        this.generateAudienceCompositionInsightsSettings = settingsBuilder.generateAudienceCompositionInsightsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AudienceInsightsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GenerateInsightsFinderReportRequest, GenerateInsightsFinderReportResponse> generateInsightsFinderReportSettings;
        private final UnaryCallSettings.Builder<ListAudienceInsightsAttributesRequest, ListAudienceInsightsAttributesResponse> listAudienceInsightsAttributesSettings;
        private final UnaryCallSettings.Builder<ListInsightsEligibleDatesRequest, ListInsightsEligibleDatesResponse> listInsightsEligibleDatesSettings;
        private final UnaryCallSettings.Builder<GenerateAudienceCompositionInsightsRequest, GenerateAudienceCompositionInsightsResponse> generateAudienceCompositionInsightsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.generateInsightsFinderReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAudienceInsightsAttributesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInsightsEligibleDatesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateAudienceCompositionInsightsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.generateInsightsFinderReportSettings, this.listAudienceInsightsAttributesSettings, this.listInsightsEligibleDatesSettings, this.generateAudienceCompositionInsightsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AudienceInsightsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.generateInsightsFinderReportSettings = settings.generateInsightsFinderReportSettings.toBuilder();
            this.listAudienceInsightsAttributesSettings = settings.listAudienceInsightsAttributesSettings.toBuilder();
            this.listInsightsEligibleDatesSettings = settings.listInsightsEligibleDatesSettings.toBuilder();
            this.generateAudienceCompositionInsightsSettings = settings.generateAudienceCompositionInsightsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.generateInsightsFinderReportSettings, this.listAudienceInsightsAttributesSettings, this.listInsightsEligibleDatesSettings, this.generateAudienceCompositionInsightsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AudienceInsightsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AudienceInsightsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AudienceInsightsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AudienceInsightsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AudienceInsightsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.generateInsightsFinderReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAudienceInsightsAttributesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listInsightsEligibleDatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateAudienceCompositionInsightsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GenerateInsightsFinderReportRequest, GenerateInsightsFinderReportResponse> generateInsightsFinderReportSettings() {
            return this.generateInsightsFinderReportSettings;
        }

        public UnaryCallSettings.Builder<ListAudienceInsightsAttributesRequest, ListAudienceInsightsAttributesResponse> listAudienceInsightsAttributesSettings() {
            return this.listAudienceInsightsAttributesSettings;
        }

        public UnaryCallSettings.Builder<ListInsightsEligibleDatesRequest, ListInsightsEligibleDatesResponse> listInsightsEligibleDatesSettings() {
            return this.listInsightsEligibleDatesSettings;
        }

        public UnaryCallSettings.Builder<GenerateAudienceCompositionInsightsRequest, GenerateAudienceCompositionInsightsResponse> generateAudienceCompositionInsightsSettings() {
            return this.generateAudienceCompositionInsightsSettings;
        }

        public AudienceInsightsServiceStubSettings build() throws IOException {
            return new AudienceInsightsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)14400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)14400000L)).setTotalTimeout(Duration.ofMillis((long)14400000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

