/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomAudienceName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CUSTOM_AUDIENCE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customAudiences/{custom_audience_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String customAudienceId;

    @Deprecated
    protected CustomAudienceName() {
        this.customerId = null;
        this.customAudienceId = null;
    }

    private CustomAudienceName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.customAudienceId = (String)Preconditions.checkNotNull((Object)builder.getCustomAudienceId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCustomAudienceId() {
        return this.customAudienceId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomAudienceName of(String customerId, String customAudienceId) {
        return CustomAudienceName.newBuilder().setCustomerId(customerId).setCustomAudienceId(customAudienceId).build();
    }

    public static String format(String customerId, String customAudienceId) {
        return CustomAudienceName.newBuilder().setCustomerId(customerId).setCustomAudienceId(customAudienceId).build().toString();
    }

    public static CustomAudienceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CUSTOM_AUDIENCE_ID.validatedMatch(formattedString, "CustomAudienceName.parse: formattedString not in valid format");
        return CustomAudienceName.of((String)matchMap.get("customer_id"), (String)matchMap.get("custom_audience_id"));
    }

    public static List<CustomAudienceName> parseList(List<String> formattedStrings) {
        ArrayList<CustomAudienceName> list = new ArrayList<CustomAudienceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomAudienceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomAudienceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomAudienceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CUSTOM_AUDIENCE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomAudienceName customAudienceName = this;
            synchronized (customAudienceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.customAudienceId != null) {
                        fieldMapBuilder.put((Object)"custom_audience_id", (Object)this.customAudienceId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CUSTOM_AUDIENCE_ID.instantiate(new String[]{"customer_id", this.customerId, "custom_audience_id", this.customAudienceId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomAudienceName that = (CustomAudienceName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.customAudienceId, that.customAudienceId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customAudienceId);
    }

    public static class Builder {
        private String customerId;
        private String customAudienceId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCustomAudienceId() {
            return this.customAudienceId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCustomAudienceId(String customAudienceId) {
            this.customAudienceId = customAudienceId;
            return this;
        }

        private Builder(CustomAudienceName customAudienceName) {
            this.customerId = customAudienceName.customerId;
            this.customAudienceId = customAudienceName.customAudienceId;
        }

        public CustomAudienceName build() {
            return new CustomAudienceName(this);
        }
    }
}

