/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomInterestName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CUSTOM_INTEREST_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customInterests/{custom_interest_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String customInterestId;

    @Deprecated
    protected CustomInterestName() {
        this.customerId = null;
        this.customInterestId = null;
    }

    private CustomInterestName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.customInterestId = (String)Preconditions.checkNotNull((Object)builder.getCustomInterestId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCustomInterestId() {
        return this.customInterestId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomInterestName of(String customerId, String customInterestId) {
        return CustomInterestName.newBuilder().setCustomerId(customerId).setCustomInterestId(customInterestId).build();
    }

    public static String format(String customerId, String customInterestId) {
        return CustomInterestName.newBuilder().setCustomerId(customerId).setCustomInterestId(customInterestId).build().toString();
    }

    public static CustomInterestName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CUSTOM_INTEREST_ID.validatedMatch(formattedString, "CustomInterestName.parse: formattedString not in valid format");
        return CustomInterestName.of((String)matchMap.get("customer_id"), (String)matchMap.get("custom_interest_id"));
    }

    public static List<CustomInterestName> parseList(List<String> formattedStrings) {
        ArrayList<CustomInterestName> list = new ArrayList<CustomInterestName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomInterestName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomInterestName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomInterestName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CUSTOM_INTEREST_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomInterestName customInterestName = this;
            synchronized (customInterestName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.customInterestId != null) {
                        fieldMapBuilder.put((Object)"custom_interest_id", (Object)this.customInterestId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CUSTOM_INTEREST_ID.instantiate(new String[]{"customer_id", this.customerId, "custom_interest_id", this.customInterestId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomInterestName that = (CustomInterestName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.customInterestId, that.customInterestId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customInterestId);
    }

    public static class Builder {
        private String customerId;
        private String customInterestId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCustomInterestId() {
            return this.customInterestId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCustomInterestId(String customInterestId) {
            this.customInterestId = customInterestId;
            return this;
        }

        private Builder(CustomInterestName customInterestName) {
            this.customerId = customInterestName.customerId;
            this.customInterestId = customInterestName.customInterestId;
        }

        public CustomInterestName build() {
            return new CustomInterestName(this);
        }
    }
}

