/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GoogleAdsFieldName
implements ResourceName {
    private static final PathTemplate GOOGLE_ADS_FIELD = PathTemplate.createWithoutUrlEncoding((String)"googleAdsFields/{google_ads_field}");
    private volatile Map<String, String> fieldValuesMap;
    private final String googleAdsField;

    @Deprecated
    protected GoogleAdsFieldName() {
        this.googleAdsField = null;
    }

    private GoogleAdsFieldName(Builder builder) {
        this.googleAdsField = (String)Preconditions.checkNotNull((Object)builder.getGoogleAdsField());
    }

    public String getGoogleAdsField() {
        return this.googleAdsField;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GoogleAdsFieldName of(String googleAdsField) {
        return GoogleAdsFieldName.newBuilder().setGoogleAdsField(googleAdsField).build();
    }

    public static String format(String googleAdsField) {
        return GoogleAdsFieldName.newBuilder().setGoogleAdsField(googleAdsField).build().toString();
    }

    public static GoogleAdsFieldName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = GOOGLE_ADS_FIELD.validatedMatch(formattedString, "GoogleAdsFieldName.parse: formattedString not in valid format");
        return GoogleAdsFieldName.of((String)matchMap.get("google_ads_field"));
    }

    public static List<GoogleAdsFieldName> parseList(List<String> formattedStrings) {
        ArrayList<GoogleAdsFieldName> list = new ArrayList<GoogleAdsFieldName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GoogleAdsFieldName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GoogleAdsFieldName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GoogleAdsFieldName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return GOOGLE_ADS_FIELD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GoogleAdsFieldName googleAdsFieldName = this;
            synchronized (googleAdsFieldName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.googleAdsField != null) {
                        fieldMapBuilder.put((Object)"google_ads_field", (Object)this.googleAdsField);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return GOOGLE_ADS_FIELD.instantiate(new String[]{"google_ads_field", this.googleAdsField});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            GoogleAdsFieldName that = (GoogleAdsFieldName)o;
            return Objects.equals(this.googleAdsField, that.googleAdsField);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.googleAdsField);
    }

    public static class Builder {
        private String googleAdsField;

        protected Builder() {
        }

        public String getGoogleAdsField() {
            return this.googleAdsField;
        }

        public Builder setGoogleAdsField(String googleAdsField) {
            this.googleAdsField = googleAdsField;
            return this;
        }

        private Builder(GoogleAdsFieldName googleAdsFieldName) {
            this.googleAdsField = googleAdsFieldName.googleAdsField;
        }

        public GoogleAdsFieldName build() {
            return new GoogleAdsFieldName(this);
        }
    }
}

