/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.services;

import com.google.ads.googleads.v14.services.CustomerFeedOperation;
import com.google.ads.googleads.v14.services.CustomerFeedServiceSettings;
import com.google.ads.googleads.v14.services.MutateCustomerFeedsRequest;
import com.google.ads.googleads.v14.services.MutateCustomerFeedsResponse;
import com.google.ads.googleads.v14.services.stub.CustomerFeedServiceStub;
import com.google.ads.googleads.v14.services.stub.CustomerFeedServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomerFeedServiceClient
implements BackgroundResource {
    private final CustomerFeedServiceSettings settings;
    private final CustomerFeedServiceStub stub;

    public static final CustomerFeedServiceClient create() throws IOException {
        return CustomerFeedServiceClient.create(CustomerFeedServiceSettings.newBuilder().build());
    }

    public static final CustomerFeedServiceClient create(CustomerFeedServiceSettings settings) throws IOException {
        return new CustomerFeedServiceClient(settings);
    }

    public static final CustomerFeedServiceClient create(CustomerFeedServiceStub stub) {
        return new CustomerFeedServiceClient(stub);
    }

    protected CustomerFeedServiceClient(CustomerFeedServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerFeedServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomerFeedServiceClient(CustomerFeedServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerFeedServiceSettings getSettings() {
        return this.settings;
    }

    public CustomerFeedServiceStub getStub() {
        return this.stub;
    }

    public final MutateCustomerFeedsResponse mutateCustomerFeeds(String customerId, List<CustomerFeedOperation> operations) {
        MutateCustomerFeedsRequest request = MutateCustomerFeedsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomerFeeds(request);
    }

    public final MutateCustomerFeedsResponse mutateCustomerFeeds(MutateCustomerFeedsRequest request) {
        return (MutateCustomerFeedsResponse)this.mutateCustomerFeedsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerFeedsRequest, MutateCustomerFeedsResponse> mutateCustomerFeedsCallable() {
        return this.stub.mutateCustomerFeedsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

