/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.services;

import com.google.ads.googleads.v14.services.CustomerLabelOperation;
import com.google.ads.googleads.v14.services.CustomerLabelServiceSettings;
import com.google.ads.googleads.v14.services.MutateCustomerLabelsRequest;
import com.google.ads.googleads.v14.services.MutateCustomerLabelsResponse;
import com.google.ads.googleads.v14.services.stub.CustomerLabelServiceStub;
import com.google.ads.googleads.v14.services.stub.CustomerLabelServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomerLabelServiceClient
implements BackgroundResource {
    private final CustomerLabelServiceSettings settings;
    private final CustomerLabelServiceStub stub;

    public static final CustomerLabelServiceClient create() throws IOException {
        return CustomerLabelServiceClient.create(CustomerLabelServiceSettings.newBuilder().build());
    }

    public static final CustomerLabelServiceClient create(CustomerLabelServiceSettings settings) throws IOException {
        return new CustomerLabelServiceClient(settings);
    }

    public static final CustomerLabelServiceClient create(CustomerLabelServiceStub stub) {
        return new CustomerLabelServiceClient(stub);
    }

    protected CustomerLabelServiceClient(CustomerLabelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerLabelServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomerLabelServiceClient(CustomerLabelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerLabelServiceSettings getSettings() {
        return this.settings;
    }

    public CustomerLabelServiceStub getStub() {
        return this.stub;
    }

    public final MutateCustomerLabelsResponse mutateCustomerLabels(String customerId, List<CustomerLabelOperation> operations) {
        MutateCustomerLabelsRequest request = MutateCustomerLabelsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomerLabels(request);
    }

    public final MutateCustomerLabelsResponse mutateCustomerLabels(MutateCustomerLabelsRequest request) {
        return (MutateCustomerLabelsResponse)this.mutateCustomerLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerLabelsRequest, MutateCustomerLabelsResponse> mutateCustomerLabelsCallable() {
        return this.stub.mutateCustomerLabelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

