/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.services;

import com.google.ads.googleads.v14.services.ExperimentArmOperation;
import com.google.ads.googleads.v14.services.ExperimentArmServiceSettings;
import com.google.ads.googleads.v14.services.MutateExperimentArmsRequest;
import com.google.ads.googleads.v14.services.MutateExperimentArmsResponse;
import com.google.ads.googleads.v14.services.stub.ExperimentArmServiceStub;
import com.google.ads.googleads.v14.services.stub.ExperimentArmServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ExperimentArmServiceClient
implements BackgroundResource {
    private final ExperimentArmServiceSettings settings;
    private final ExperimentArmServiceStub stub;

    public static final ExperimentArmServiceClient create() throws IOException {
        return ExperimentArmServiceClient.create(ExperimentArmServiceSettings.newBuilder().build());
    }

    public static final ExperimentArmServiceClient create(ExperimentArmServiceSettings settings) throws IOException {
        return new ExperimentArmServiceClient(settings);
    }

    public static final ExperimentArmServiceClient create(ExperimentArmServiceStub stub) {
        return new ExperimentArmServiceClient(stub);
    }

    protected ExperimentArmServiceClient(ExperimentArmServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ExperimentArmServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ExperimentArmServiceClient(ExperimentArmServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ExperimentArmServiceSettings getSettings() {
        return this.settings;
    }

    public ExperimentArmServiceStub getStub() {
        return this.stub;
    }

    public final MutateExperimentArmsResponse mutateExperimentArms(String customerId, List<ExperimentArmOperation> operations) {
        MutateExperimentArmsRequest request = MutateExperimentArmsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateExperimentArms(request);
    }

    public final MutateExperimentArmsResponse mutateExperimentArms(MutateExperimentArmsRequest request) {
        return (MutateExperimentArmsResponse)this.mutateExperimentArmsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateExperimentArmsRequest, MutateExperimentArmsResponse> mutateExperimentArmsCallable() {
        return this.stub.mutateExperimentArmsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

