/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.services;

import com.google.ads.googleads.v14.enums.CallToActionTypeEnum;
import com.google.ads.googleads.v14.enums.HotelAssetSuggestionStatusEnum;
import com.google.ads.googleads.v14.services.HotelAssetSuggestionOrBuilder;
import com.google.ads.googleads.v14.services.HotelImageAsset;
import com.google.ads.googleads.v14.services.HotelImageAssetOrBuilder;
import com.google.ads.googleads.v14.services.HotelTextAsset;
import com.google.ads.googleads.v14.services.HotelTextAssetOrBuilder;
import com.google.ads.googleads.v14.services.TravelAssetSuggestionServiceProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class HotelAssetSuggestion
extends GeneratedMessageV3
implements HotelAssetSuggestionOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int PLACE_ID_FIELD_NUMBER = 1;
    private volatile Object placeId_ = "";
    public static final int FINAL_URL_FIELD_NUMBER = 2;
    private volatile Object finalUrl_ = "";
    public static final int HOTEL_NAME_FIELD_NUMBER = 3;
    private volatile Object hotelName_ = "";
    public static final int CALL_TO_ACTION_FIELD_NUMBER = 4;
    private int callToAction_ = 0;
    public static final int TEXT_ASSETS_FIELD_NUMBER = 5;
    private List<HotelTextAsset> textAssets_;
    public static final int IMAGE_ASSETS_FIELD_NUMBER = 6;
    private List<HotelImageAsset> imageAssets_;
    public static final int STATUS_FIELD_NUMBER = 7;
    private int status_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final HotelAssetSuggestion DEFAULT_INSTANCE = new HotelAssetSuggestion();
    private static final Parser<HotelAssetSuggestion> PARSER = new AbstractParser<HotelAssetSuggestion>(){

        public HotelAssetSuggestion parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = HotelAssetSuggestion.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private HotelAssetSuggestion(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private HotelAssetSuggestion() {
        this.placeId_ = "";
        this.finalUrl_ = "";
        this.hotelName_ = "";
        this.callToAction_ = 0;
        this.textAssets_ = Collections.emptyList();
        this.imageAssets_ = Collections.emptyList();
        this.status_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new HotelAssetSuggestion();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return TravelAssetSuggestionServiceProto.internal_static_google_ads_googleads_v14_services_HotelAssetSuggestion_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return TravelAssetSuggestionServiceProto.internal_static_google_ads_googleads_v14_services_HotelAssetSuggestion_fieldAccessorTable.ensureFieldAccessorsInitialized(HotelAssetSuggestion.class, Builder.class);
    }

    @Override
    public String getPlaceId() {
        Object ref = this.placeId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.placeId_ = s;
        return s;
    }

    @Override
    public ByteString getPlaceIdBytes() {
        Object ref = this.placeId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.placeId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getFinalUrl() {
        Object ref = this.finalUrl_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.finalUrl_ = s;
        return s;
    }

    @Override
    public ByteString getFinalUrlBytes() {
        Object ref = this.finalUrl_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.finalUrl_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getHotelName() {
        Object ref = this.hotelName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.hotelName_ = s;
        return s;
    }

    @Override
    public ByteString getHotelNameBytes() {
        Object ref = this.hotelName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.hotelName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getCallToActionValue() {
        return this.callToAction_;
    }

    @Override
    public CallToActionTypeEnum.CallToActionType getCallToAction() {
        CallToActionTypeEnum.CallToActionType result = CallToActionTypeEnum.CallToActionType.forNumber(this.callToAction_);
        return result == null ? CallToActionTypeEnum.CallToActionType.UNRECOGNIZED : result;
    }

    @Override
    public List<HotelTextAsset> getTextAssetsList() {
        return this.textAssets_;
    }

    @Override
    public List<? extends HotelTextAssetOrBuilder> getTextAssetsOrBuilderList() {
        return this.textAssets_;
    }

    @Override
    public int getTextAssetsCount() {
        return this.textAssets_.size();
    }

    @Override
    public HotelTextAsset getTextAssets(int index) {
        return this.textAssets_.get(index);
    }

    @Override
    public HotelTextAssetOrBuilder getTextAssetsOrBuilder(int index) {
        return this.textAssets_.get(index);
    }

    @Override
    public List<HotelImageAsset> getImageAssetsList() {
        return this.imageAssets_;
    }

    @Override
    public List<? extends HotelImageAssetOrBuilder> getImageAssetsOrBuilderList() {
        return this.imageAssets_;
    }

    @Override
    public int getImageAssetsCount() {
        return this.imageAssets_.size();
    }

    @Override
    public HotelImageAsset getImageAssets(int index) {
        return this.imageAssets_.get(index);
    }

    @Override
    public HotelImageAssetOrBuilder getImageAssetsOrBuilder(int index) {
        return this.imageAssets_.get(index);
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus getStatus() {
        HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus result = HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus.forNumber(this.status_);
        return result == null ? HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.placeId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.placeId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.finalUrl_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.finalUrl_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.hotelName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.hotelName_);
        }
        if (this.callToAction_ != CallToActionTypeEnum.CallToActionType.UNSPECIFIED.getNumber()) {
            output.writeEnum(4, this.callToAction_);
        }
        for (i = 0; i < this.textAssets_.size(); ++i) {
            output.writeMessage(5, (MessageLite)this.textAssets_.get(i));
        }
        for (i = 0; i < this.imageAssets_.size(); ++i) {
            output.writeMessage(6, (MessageLite)this.imageAssets_.get(i));
        }
        if (this.status_ != HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(7, this.status_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.placeId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.placeId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.finalUrl_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.finalUrl_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.hotelName_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.hotelName_);
        }
        if (this.callToAction_ != CallToActionTypeEnum.CallToActionType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.callToAction_);
        }
        for (i = 0; i < this.textAssets_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((MessageLite)this.textAssets_.get(i)));
        }
        for (i = 0; i < this.imageAssets_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((MessageLite)this.imageAssets_.get(i)));
        }
        if (this.status_ != HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)7, (int)this.status_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HotelAssetSuggestion)) {
            return super.equals(obj);
        }
        HotelAssetSuggestion other = (HotelAssetSuggestion)obj;
        if (!this.getPlaceId().equals(other.getPlaceId())) {
            return false;
        }
        if (!this.getFinalUrl().equals(other.getFinalUrl())) {
            return false;
        }
        if (!this.getHotelName().equals(other.getHotelName())) {
            return false;
        }
        if (this.callToAction_ != other.callToAction_) {
            return false;
        }
        if (!this.getTextAssetsList().equals(other.getTextAssetsList())) {
            return false;
        }
        if (!this.getImageAssetsList().equals(other.getImageAssetsList())) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + HotelAssetSuggestion.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getPlaceId().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getFinalUrl().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getHotelName().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.callToAction_;
        if (this.getTextAssetsCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getTextAssetsList().hashCode();
        }
        if (this.getImageAssetsCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getImageAssetsList().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + this.status_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static HotelAssetSuggestion parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (HotelAssetSuggestion)PARSER.parseFrom(data);
    }

    public static HotelAssetSuggestion parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (HotelAssetSuggestion)PARSER.parseFrom(data, extensionRegistry);
    }

    public static HotelAssetSuggestion parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (HotelAssetSuggestion)PARSER.parseFrom(data);
    }

    public static HotelAssetSuggestion parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (HotelAssetSuggestion)PARSER.parseFrom(data, extensionRegistry);
    }

    public static HotelAssetSuggestion parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (HotelAssetSuggestion)PARSER.parseFrom(data);
    }

    public static HotelAssetSuggestion parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (HotelAssetSuggestion)PARSER.parseFrom(data, extensionRegistry);
    }

    public static HotelAssetSuggestion parseFrom(InputStream input) throws IOException {
        return (HotelAssetSuggestion)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static HotelAssetSuggestion parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (HotelAssetSuggestion)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static HotelAssetSuggestion parseDelimitedFrom(InputStream input) throws IOException {
        return (HotelAssetSuggestion)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static HotelAssetSuggestion parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (HotelAssetSuggestion)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static HotelAssetSuggestion parseFrom(CodedInputStream input) throws IOException {
        return (HotelAssetSuggestion)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static HotelAssetSuggestion parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (HotelAssetSuggestion)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return HotelAssetSuggestion.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HotelAssetSuggestion prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static HotelAssetSuggestion getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<HotelAssetSuggestion> parser() {
        return PARSER;
    }

    public Parser<HotelAssetSuggestion> getParserForType() {
        return PARSER;
    }

    public HotelAssetSuggestion getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements HotelAssetSuggestionOrBuilder {
        private int bitField0_;
        private Object placeId_ = "";
        private Object finalUrl_ = "";
        private Object hotelName_ = "";
        private int callToAction_ = 0;
        private List<HotelTextAsset> textAssets_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<HotelTextAsset, HotelTextAsset.Builder, HotelTextAssetOrBuilder> textAssetsBuilder_;
        private List<HotelImageAsset> imageAssets_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<HotelImageAsset, HotelImageAsset.Builder, HotelImageAssetOrBuilder> imageAssetsBuilder_;
        private int status_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return TravelAssetSuggestionServiceProto.internal_static_google_ads_googleads_v14_services_HotelAssetSuggestion_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return TravelAssetSuggestionServiceProto.internal_static_google_ads_googleads_v14_services_HotelAssetSuggestion_fieldAccessorTable.ensureFieldAccessorsInitialized(HotelAssetSuggestion.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.placeId_ = "";
            this.finalUrl_ = "";
            this.hotelName_ = "";
            this.callToAction_ = 0;
            if (this.textAssetsBuilder_ == null) {
                this.textAssets_ = Collections.emptyList();
            } else {
                this.textAssets_ = null;
                this.textAssetsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFEF;
            if (this.imageAssetsBuilder_ == null) {
                this.imageAssets_ = Collections.emptyList();
            } else {
                this.imageAssets_ = null;
                this.imageAssetsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFDF;
            this.status_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return TravelAssetSuggestionServiceProto.internal_static_google_ads_googleads_v14_services_HotelAssetSuggestion_descriptor;
        }

        public HotelAssetSuggestion getDefaultInstanceForType() {
            return HotelAssetSuggestion.getDefaultInstance();
        }

        public HotelAssetSuggestion build() {
            HotelAssetSuggestion result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public HotelAssetSuggestion buildPartial() {
            HotelAssetSuggestion result = new HotelAssetSuggestion(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(HotelAssetSuggestion result) {
            if (this.textAssetsBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0) {
                    this.textAssets_ = Collections.unmodifiableList(this.textAssets_);
                    this.bitField0_ &= 0xFFFFFFEF;
                }
                result.textAssets_ = this.textAssets_;
            } else {
                result.textAssets_ = this.textAssetsBuilder_.build();
            }
            if (this.imageAssetsBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0) {
                    this.imageAssets_ = Collections.unmodifiableList(this.imageAssets_);
                    this.bitField0_ &= 0xFFFFFFDF;
                }
                result.imageAssets_ = this.imageAssets_;
            } else {
                result.imageAssets_ = this.imageAssetsBuilder_.build();
            }
        }

        private void buildPartial0(HotelAssetSuggestion result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.placeId_ = this.placeId_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.finalUrl_ = this.finalUrl_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.hotelName_ = this.hotelName_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.callToAction_ = this.callToAction_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.status_ = this.status_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof HotelAssetSuggestion) {
                return this.mergeFrom((HotelAssetSuggestion)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(HotelAssetSuggestion other) {
            if (other == HotelAssetSuggestion.getDefaultInstance()) {
                return this;
            }
            if (!other.getPlaceId().isEmpty()) {
                this.placeId_ = other.placeId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getFinalUrl().isEmpty()) {
                this.finalUrl_ = other.finalUrl_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.getHotelName().isEmpty()) {
                this.hotelName_ = other.hotelName_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (other.callToAction_ != 0) {
                this.setCallToActionValue(other.getCallToActionValue());
            }
            if (this.textAssetsBuilder_ == null) {
                if (!other.textAssets_.isEmpty()) {
                    if (this.textAssets_.isEmpty()) {
                        this.textAssets_ = other.textAssets_;
                        this.bitField0_ &= 0xFFFFFFEF;
                    } else {
                        this.ensureTextAssetsIsMutable();
                        this.textAssets_.addAll(other.textAssets_);
                    }
                    this.onChanged();
                }
            } else if (!other.textAssets_.isEmpty()) {
                if (this.textAssetsBuilder_.isEmpty()) {
                    this.textAssetsBuilder_.dispose();
                    this.textAssetsBuilder_ = null;
                    this.textAssets_ = other.textAssets_;
                    this.bitField0_ &= 0xFFFFFFEF;
                    this.textAssetsBuilder_ = alwaysUseFieldBuilders ? this.getTextAssetsFieldBuilder() : null;
                } else {
                    this.textAssetsBuilder_.addAllMessages((Iterable)other.textAssets_);
                }
            }
            if (this.imageAssetsBuilder_ == null) {
                if (!other.imageAssets_.isEmpty()) {
                    if (this.imageAssets_.isEmpty()) {
                        this.imageAssets_ = other.imageAssets_;
                        this.bitField0_ &= 0xFFFFFFDF;
                    } else {
                        this.ensureImageAssetsIsMutable();
                        this.imageAssets_.addAll(other.imageAssets_);
                    }
                    this.onChanged();
                }
            } else if (!other.imageAssets_.isEmpty()) {
                if (this.imageAssetsBuilder_.isEmpty()) {
                    this.imageAssetsBuilder_.dispose();
                    this.imageAssetsBuilder_ = null;
                    this.imageAssets_ = other.imageAssets_;
                    this.bitField0_ &= 0xFFFFFFDF;
                    this.imageAssetsBuilder_ = alwaysUseFieldBuilders ? this.getImageAssetsFieldBuilder() : null;
                } else {
                    this.imageAssetsBuilder_.addAllMessages((Iterable)other.imageAssets_);
                }
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block15: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block15;
                        }
                        case 10: {
                            this.placeId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block15;
                        }
                        case 18: {
                            this.finalUrl_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block15;
                        }
                        case 26: {
                            this.hotelName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block15;
                        }
                        case 32: {
                            this.callToAction_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block15;
                        }
                        case 42: {
                            GeneratedMessageV3 m = (HotelTextAsset)input.readMessage(HotelTextAsset.parser(), extensionRegistry);
                            if (this.textAssetsBuilder_ == null) {
                                this.ensureTextAssetsIsMutable();
                                this.textAssets_.add((HotelTextAsset)m);
                                continue block15;
                            }
                            this.textAssetsBuilder_.addMessage((AbstractMessage)m);
                            continue block15;
                        }
                        case 50: {
                            GeneratedMessageV3 m = (HotelImageAsset)input.readMessage(HotelImageAsset.parser(), extensionRegistry);
                            if (this.imageAssetsBuilder_ == null) {
                                this.ensureImageAssetsIsMutable();
                                this.imageAssets_.add((HotelImageAsset)m);
                                continue block15;
                            }
                            this.imageAssetsBuilder_.addMessage((AbstractMessage)m);
                            continue block15;
                        }
                        case 56: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 0x40;
                            continue block15;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getPlaceId() {
            Object ref = this.placeId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.placeId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPlaceIdBytes() {
            Object ref = this.placeId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.placeId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPlaceId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.placeId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearPlaceId() {
            this.placeId_ = HotelAssetSuggestion.getDefaultInstance().getPlaceId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setPlaceIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HotelAssetSuggestion.checkByteStringIsUtf8((ByteString)value);
            this.placeId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getFinalUrl() {
            Object ref = this.finalUrl_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.finalUrl_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFinalUrlBytes() {
            Object ref = this.finalUrl_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.finalUrl_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFinalUrl(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.finalUrl_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearFinalUrl() {
            this.finalUrl_ = HotelAssetSuggestion.getDefaultInstance().getFinalUrl();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setFinalUrlBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HotelAssetSuggestion.checkByteStringIsUtf8((ByteString)value);
            this.finalUrl_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getHotelName() {
            Object ref = this.hotelName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.hotelName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getHotelNameBytes() {
            Object ref = this.hotelName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.hotelName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setHotelName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.hotelName_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearHotelName() {
            this.hotelName_ = HotelAssetSuggestion.getDefaultInstance().getHotelName();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setHotelNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HotelAssetSuggestion.checkByteStringIsUtf8((ByteString)value);
            this.hotelName_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public int getCallToActionValue() {
            return this.callToAction_;
        }

        public Builder setCallToActionValue(int value) {
            this.callToAction_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public CallToActionTypeEnum.CallToActionType getCallToAction() {
            CallToActionTypeEnum.CallToActionType result = CallToActionTypeEnum.CallToActionType.forNumber(this.callToAction_);
            return result == null ? CallToActionTypeEnum.CallToActionType.UNRECOGNIZED : result;
        }

        public Builder setCallToAction(CallToActionTypeEnum.CallToActionType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.callToAction_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearCallToAction() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.callToAction_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureTextAssetsIsMutable() {
            if ((this.bitField0_ & 0x10) == 0) {
                this.textAssets_ = new ArrayList<HotelTextAsset>(this.textAssets_);
                this.bitField0_ |= 0x10;
            }
        }

        @Override
        public List<HotelTextAsset> getTextAssetsList() {
            if (this.textAssetsBuilder_ == null) {
                return Collections.unmodifiableList(this.textAssets_);
            }
            return this.textAssetsBuilder_.getMessageList();
        }

        @Override
        public int getTextAssetsCount() {
            if (this.textAssetsBuilder_ == null) {
                return this.textAssets_.size();
            }
            return this.textAssetsBuilder_.getCount();
        }

        @Override
        public HotelTextAsset getTextAssets(int index) {
            if (this.textAssetsBuilder_ == null) {
                return this.textAssets_.get(index);
            }
            return (HotelTextAsset)this.textAssetsBuilder_.getMessage(index);
        }

        public Builder setTextAssets(int index, HotelTextAsset value) {
            if (this.textAssetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTextAssetsIsMutable();
                this.textAssets_.set(index, value);
                this.onChanged();
            } else {
                this.textAssetsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setTextAssets(int index, HotelTextAsset.Builder builderForValue) {
            if (this.textAssetsBuilder_ == null) {
                this.ensureTextAssetsIsMutable();
                this.textAssets_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.textAssetsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addTextAssets(HotelTextAsset value) {
            if (this.textAssetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTextAssetsIsMutable();
                this.textAssets_.add(value);
                this.onChanged();
            } else {
                this.textAssetsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addTextAssets(int index, HotelTextAsset value) {
            if (this.textAssetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureTextAssetsIsMutable();
                this.textAssets_.add(index, value);
                this.onChanged();
            } else {
                this.textAssetsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addTextAssets(HotelTextAsset.Builder builderForValue) {
            if (this.textAssetsBuilder_ == null) {
                this.ensureTextAssetsIsMutable();
                this.textAssets_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.textAssetsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addTextAssets(int index, HotelTextAsset.Builder builderForValue) {
            if (this.textAssetsBuilder_ == null) {
                this.ensureTextAssetsIsMutable();
                this.textAssets_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.textAssetsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllTextAssets(Iterable<? extends HotelTextAsset> values) {
            if (this.textAssetsBuilder_ == null) {
                this.ensureTextAssetsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.textAssets_);
                this.onChanged();
            } else {
                this.textAssetsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearTextAssets() {
            if (this.textAssetsBuilder_ == null) {
                this.textAssets_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
            } else {
                this.textAssetsBuilder_.clear();
            }
            return this;
        }

        public Builder removeTextAssets(int index) {
            if (this.textAssetsBuilder_ == null) {
                this.ensureTextAssetsIsMutable();
                this.textAssets_.remove(index);
                this.onChanged();
            } else {
                this.textAssetsBuilder_.remove(index);
            }
            return this;
        }

        public HotelTextAsset.Builder getTextAssetsBuilder(int index) {
            return (HotelTextAsset.Builder)this.getTextAssetsFieldBuilder().getBuilder(index);
        }

        @Override
        public HotelTextAssetOrBuilder getTextAssetsOrBuilder(int index) {
            if (this.textAssetsBuilder_ == null) {
                return this.textAssets_.get(index);
            }
            return (HotelTextAssetOrBuilder)this.textAssetsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends HotelTextAssetOrBuilder> getTextAssetsOrBuilderList() {
            if (this.textAssetsBuilder_ != null) {
                return this.textAssetsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.textAssets_);
        }

        public HotelTextAsset.Builder addTextAssetsBuilder() {
            return (HotelTextAsset.Builder)this.getTextAssetsFieldBuilder().addBuilder((AbstractMessage)HotelTextAsset.getDefaultInstance());
        }

        public HotelTextAsset.Builder addTextAssetsBuilder(int index) {
            return (HotelTextAsset.Builder)this.getTextAssetsFieldBuilder().addBuilder(index, (AbstractMessage)HotelTextAsset.getDefaultInstance());
        }

        public List<HotelTextAsset.Builder> getTextAssetsBuilderList() {
            return this.getTextAssetsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<HotelTextAsset, HotelTextAsset.Builder, HotelTextAssetOrBuilder> getTextAssetsFieldBuilder() {
            if (this.textAssetsBuilder_ == null) {
                this.textAssetsBuilder_ = new RepeatedFieldBuilderV3(this.textAssets_, (this.bitField0_ & 0x10) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.textAssets_ = null;
            }
            return this.textAssetsBuilder_;
        }

        private void ensureImageAssetsIsMutable() {
            if ((this.bitField0_ & 0x20) == 0) {
                this.imageAssets_ = new ArrayList<HotelImageAsset>(this.imageAssets_);
                this.bitField0_ |= 0x20;
            }
        }

        @Override
        public List<HotelImageAsset> getImageAssetsList() {
            if (this.imageAssetsBuilder_ == null) {
                return Collections.unmodifiableList(this.imageAssets_);
            }
            return this.imageAssetsBuilder_.getMessageList();
        }

        @Override
        public int getImageAssetsCount() {
            if (this.imageAssetsBuilder_ == null) {
                return this.imageAssets_.size();
            }
            return this.imageAssetsBuilder_.getCount();
        }

        @Override
        public HotelImageAsset getImageAssets(int index) {
            if (this.imageAssetsBuilder_ == null) {
                return this.imageAssets_.get(index);
            }
            return (HotelImageAsset)this.imageAssetsBuilder_.getMessage(index);
        }

        public Builder setImageAssets(int index, HotelImageAsset value) {
            if (this.imageAssetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureImageAssetsIsMutable();
                this.imageAssets_.set(index, value);
                this.onChanged();
            } else {
                this.imageAssetsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setImageAssets(int index, HotelImageAsset.Builder builderForValue) {
            if (this.imageAssetsBuilder_ == null) {
                this.ensureImageAssetsIsMutable();
                this.imageAssets_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.imageAssetsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addImageAssets(HotelImageAsset value) {
            if (this.imageAssetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureImageAssetsIsMutable();
                this.imageAssets_.add(value);
                this.onChanged();
            } else {
                this.imageAssetsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addImageAssets(int index, HotelImageAsset value) {
            if (this.imageAssetsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureImageAssetsIsMutable();
                this.imageAssets_.add(index, value);
                this.onChanged();
            } else {
                this.imageAssetsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addImageAssets(HotelImageAsset.Builder builderForValue) {
            if (this.imageAssetsBuilder_ == null) {
                this.ensureImageAssetsIsMutable();
                this.imageAssets_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.imageAssetsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addImageAssets(int index, HotelImageAsset.Builder builderForValue) {
            if (this.imageAssetsBuilder_ == null) {
                this.ensureImageAssetsIsMutable();
                this.imageAssets_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.imageAssetsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllImageAssets(Iterable<? extends HotelImageAsset> values) {
            if (this.imageAssetsBuilder_ == null) {
                this.ensureImageAssetsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.imageAssets_);
                this.onChanged();
            } else {
                this.imageAssetsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearImageAssets() {
            if (this.imageAssetsBuilder_ == null) {
                this.imageAssets_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFDF;
                this.onChanged();
            } else {
                this.imageAssetsBuilder_.clear();
            }
            return this;
        }

        public Builder removeImageAssets(int index) {
            if (this.imageAssetsBuilder_ == null) {
                this.ensureImageAssetsIsMutable();
                this.imageAssets_.remove(index);
                this.onChanged();
            } else {
                this.imageAssetsBuilder_.remove(index);
            }
            return this;
        }

        public HotelImageAsset.Builder getImageAssetsBuilder(int index) {
            return (HotelImageAsset.Builder)this.getImageAssetsFieldBuilder().getBuilder(index);
        }

        @Override
        public HotelImageAssetOrBuilder getImageAssetsOrBuilder(int index) {
            if (this.imageAssetsBuilder_ == null) {
                return this.imageAssets_.get(index);
            }
            return (HotelImageAssetOrBuilder)this.imageAssetsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends HotelImageAssetOrBuilder> getImageAssetsOrBuilderList() {
            if (this.imageAssetsBuilder_ != null) {
                return this.imageAssetsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.imageAssets_);
        }

        public HotelImageAsset.Builder addImageAssetsBuilder() {
            return (HotelImageAsset.Builder)this.getImageAssetsFieldBuilder().addBuilder((AbstractMessage)HotelImageAsset.getDefaultInstance());
        }

        public HotelImageAsset.Builder addImageAssetsBuilder(int index) {
            return (HotelImageAsset.Builder)this.getImageAssetsFieldBuilder().addBuilder(index, (AbstractMessage)HotelImageAsset.getDefaultInstance());
        }

        public List<HotelImageAsset.Builder> getImageAssetsBuilderList() {
            return this.getImageAssetsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<HotelImageAsset, HotelImageAsset.Builder, HotelImageAssetOrBuilder> getImageAssetsFieldBuilder() {
            if (this.imageAssetsBuilder_ == null) {
                this.imageAssetsBuilder_ = new RepeatedFieldBuilderV3(this.imageAssets_, (this.bitField0_ & 0x20) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.imageAssets_ = null;
            }
            return this.imageAssetsBuilder_;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus getStatus() {
            HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus result = HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus.forNumber(this.status_);
            return result == null ? HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(HotelAssetSuggestionStatusEnum.HotelAssetSuggestionStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x40;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

