// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v14/common/matching_function.proto

// Protobuf Java Version: 3.25.2
package com.google.ads.googleads.v14.common;

/**
 * <pre>
 * Matching function associated with a
 * CustomerFeed, CampaignFeed, or AdGroupFeed. The matching function is used
 * to filter the set of feed items selected.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v14.common.MatchingFunction}
 */
public final class MatchingFunction extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v14.common.MatchingFunction)
    MatchingFunctionOrBuilder {
private static final long serialVersionUID = 0L;
  // Use MatchingFunction.newBuilder() to construct.
  private MatchingFunction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private MatchingFunction() {
    functionString_ = "";
    operator_ = 0;
    leftOperands_ = java.util.Collections.emptyList();
    rightOperands_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new MatchingFunction();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v14.common.MatchingFunctionProto.internal_static_google_ads_googleads_v14_common_MatchingFunction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v14.common.MatchingFunctionProto.internal_static_google_ads_googleads_v14_common_MatchingFunction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v14.common.MatchingFunction.class, com.google.ads.googleads.v14.common.MatchingFunction.Builder.class);
  }

  private int bitField0_;
  public static final int FUNCTION_STRING_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private volatile java.lang.Object functionString_ = "";
  /**
   * <pre>
   * String representation of the Function.
   *
   * Examples:
   *
   * 1. IDENTITY(true) or IDENTITY(false). All or no feed items served.
   * 2. EQUALS(CONTEXT.DEVICE,"Mobile")
   * 3. IN(FEED_ITEM_ID,{1000001,1000002,1000003})
   * 4. CONTAINS_ANY(FeedAttribute[12345678,0],{"Mars cruise","Venus cruise"})
   * 5. AND(IN(FEED_ITEM_ID,{10001,10002}),EQUALS(CONTEXT.DEVICE,"Mobile"))
   *
   * For more details, visit
   * https://developers.google.com/google-ads/api/docs/extensions/feeds/matching-functions
   *
   * Note that because multiple strings may represent the same underlying
   * function (whitespace and single versus double quotation marks, for
   * example), the value returned may not be identical to the string sent in a
   * mutate request.
   * </pre>
   *
   * <code>optional string function_string = 5;</code>
   * @return Whether the functionString field is set.
   */
  @java.lang.Override
  public boolean hasFunctionString() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * String representation of the Function.
   *
   * Examples:
   *
   * 1. IDENTITY(true) or IDENTITY(false). All or no feed items served.
   * 2. EQUALS(CONTEXT.DEVICE,"Mobile")
   * 3. IN(FEED_ITEM_ID,{1000001,1000002,1000003})
   * 4. CONTAINS_ANY(FeedAttribute[12345678,0],{"Mars cruise","Venus cruise"})
   * 5. AND(IN(FEED_ITEM_ID,{10001,10002}),EQUALS(CONTEXT.DEVICE,"Mobile"))
   *
   * For more details, visit
   * https://developers.google.com/google-ads/api/docs/extensions/feeds/matching-functions
   *
   * Note that because multiple strings may represent the same underlying
   * function (whitespace and single versus double quotation marks, for
   * example), the value returned may not be identical to the string sent in a
   * mutate request.
   * </pre>
   *
   * <code>optional string function_string = 5;</code>
   * @return The functionString.
   */
  @java.lang.Override
  public java.lang.String getFunctionString() {
    java.lang.Object ref = functionString_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      functionString_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * String representation of the Function.
   *
   * Examples:
   *
   * 1. IDENTITY(true) or IDENTITY(false). All or no feed items served.
   * 2. EQUALS(CONTEXT.DEVICE,"Mobile")
   * 3. IN(FEED_ITEM_ID,{1000001,1000002,1000003})
   * 4. CONTAINS_ANY(FeedAttribute[12345678,0],{"Mars cruise","Venus cruise"})
   * 5. AND(IN(FEED_ITEM_ID,{10001,10002}),EQUALS(CONTEXT.DEVICE,"Mobile"))
   *
   * For more details, visit
   * https://developers.google.com/google-ads/api/docs/extensions/feeds/matching-functions
   *
   * Note that because multiple strings may represent the same underlying
   * function (whitespace and single versus double quotation marks, for
   * example), the value returned may not be identical to the string sent in a
   * mutate request.
   * </pre>
   *
   * <code>optional string function_string = 5;</code>
   * @return The bytes for functionString.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getFunctionStringBytes() {
    java.lang.Object ref = functionString_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      functionString_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPERATOR_FIELD_NUMBER = 4;
  private int operator_ = 0;
  /**
   * <pre>
   * Operator for a function.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator operator = 4;</code>
   * @return The enum numeric value on the wire for operator.
   */
  @java.lang.Override public int getOperatorValue() {
    return operator_;
  }
  /**
   * <pre>
   * Operator for a function.
   * </pre>
   *
   * <code>.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator operator = 4;</code>
   * @return The operator.
   */
  @java.lang.Override public com.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator getOperator() {
    com.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator result = com.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator.forNumber(operator_);
    return result == null ? com.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator.UNRECOGNIZED : result;
  }

  public static final int LEFT_OPERANDS_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ads.googleads.v14.common.Operand> leftOperands_;
  /**
   * <pre>
   * The operands on the left hand side of the equation. This is also the
   * operand to be used for single operand expressions such as NOT.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v14.common.Operand> getLeftOperandsList() {
    return leftOperands_;
  }
  /**
   * <pre>
   * The operands on the left hand side of the equation. This is also the
   * operand to be used for single operand expressions such as NOT.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v14.common.OperandOrBuilder> 
      getLeftOperandsOrBuilderList() {
    return leftOperands_;
  }
  /**
   * <pre>
   * The operands on the left hand side of the equation. This is also the
   * operand to be used for single operand expressions such as NOT.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
   */
  @java.lang.Override
  public int getLeftOperandsCount() {
    return leftOperands_.size();
  }
  /**
   * <pre>
   * The operands on the left hand side of the equation. This is also the
   * operand to be used for single operand expressions such as NOT.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.common.Operand getLeftOperands(int index) {
    return leftOperands_.get(index);
  }
  /**
   * <pre>
   * The operands on the left hand side of the equation. This is also the
   * operand to be used for single operand expressions such as NOT.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.common.OperandOrBuilder getLeftOperandsOrBuilder(
      int index) {
    return leftOperands_.get(index);
  }

  public static final int RIGHT_OPERANDS_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private java.util.List<com.google.ads.googleads.v14.common.Operand> rightOperands_;
  /**
   * <pre>
   * The operands on the right hand side of the equation.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v14.common.Operand> getRightOperandsList() {
    return rightOperands_;
  }
  /**
   * <pre>
   * The operands on the right hand side of the equation.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v14.common.OperandOrBuilder> 
      getRightOperandsOrBuilderList() {
    return rightOperands_;
  }
  /**
   * <pre>
   * The operands on the right hand side of the equation.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
   */
  @java.lang.Override
  public int getRightOperandsCount() {
    return rightOperands_.size();
  }
  /**
   * <pre>
   * The operands on the right hand side of the equation.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.common.Operand getRightOperands(int index) {
    return rightOperands_.get(index);
  }
  /**
   * <pre>
   * The operands on the right hand side of the equation.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v14.common.OperandOrBuilder getRightOperandsOrBuilder(
      int index) {
    return rightOperands_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    for (int i = 0; i < leftOperands_.size(); i++) {
      output.writeMessage(2, leftOperands_.get(i));
    }
    for (int i = 0; i < rightOperands_.size(); i++) {
      output.writeMessage(3, rightOperands_.get(i));
    }
    if (operator_ != com.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator.UNSPECIFIED.getNumber()) {
      output.writeEnum(4, operator_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, functionString_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < leftOperands_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, leftOperands_.get(i));
    }
    for (int i = 0; i < rightOperands_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, rightOperands_.get(i));
    }
    if (operator_ != com.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, operator_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, functionString_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v14.common.MatchingFunction)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v14.common.MatchingFunction other = (com.google.ads.googleads.v14.common.MatchingFunction) obj;

    if (hasFunctionString() != other.hasFunctionString()) return false;
    if (hasFunctionString()) {
      if (!getFunctionString()
          .equals(other.getFunctionString())) return false;
    }
    if (operator_ != other.operator_) return false;
    if (!getLeftOperandsList()
        .equals(other.getLeftOperandsList())) return false;
    if (!getRightOperandsList()
        .equals(other.getRightOperandsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasFunctionString()) {
      hash = (37 * hash) + FUNCTION_STRING_FIELD_NUMBER;
      hash = (53 * hash) + getFunctionString().hashCode();
    }
    hash = (37 * hash) + OPERATOR_FIELD_NUMBER;
    hash = (53 * hash) + operator_;
    if (getLeftOperandsCount() > 0) {
      hash = (37 * hash) + LEFT_OPERANDS_FIELD_NUMBER;
      hash = (53 * hash) + getLeftOperandsList().hashCode();
    }
    if (getRightOperandsCount() > 0) {
      hash = (37 * hash) + RIGHT_OPERANDS_FIELD_NUMBER;
      hash = (53 * hash) + getRightOperandsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v14.common.MatchingFunction parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v14.common.MatchingFunction parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v14.common.MatchingFunction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v14.common.MatchingFunction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v14.common.MatchingFunction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v14.common.MatchingFunction parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v14.common.MatchingFunction parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v14.common.MatchingFunction parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v14.common.MatchingFunction parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v14.common.MatchingFunction parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v14.common.MatchingFunction parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v14.common.MatchingFunction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v14.common.MatchingFunction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Matching function associated with a
   * CustomerFeed, CampaignFeed, or AdGroupFeed. The matching function is used
   * to filter the set of feed items selected.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v14.common.MatchingFunction}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v14.common.MatchingFunction)
      com.google.ads.googleads.v14.common.MatchingFunctionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v14.common.MatchingFunctionProto.internal_static_google_ads_googleads_v14_common_MatchingFunction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v14.common.MatchingFunctionProto.internal_static_google_ads_googleads_v14_common_MatchingFunction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v14.common.MatchingFunction.class, com.google.ads.googleads.v14.common.MatchingFunction.Builder.class);
    }

    // Construct using com.google.ads.googleads.v14.common.MatchingFunction.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      functionString_ = "";
      operator_ = 0;
      if (leftOperandsBuilder_ == null) {
        leftOperands_ = java.util.Collections.emptyList();
      } else {
        leftOperands_ = null;
        leftOperandsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (rightOperandsBuilder_ == null) {
        rightOperands_ = java.util.Collections.emptyList();
      } else {
        rightOperands_ = null;
        rightOperandsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v14.common.MatchingFunctionProto.internal_static_google_ads_googleads_v14_common_MatchingFunction_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v14.common.MatchingFunction getDefaultInstanceForType() {
      return com.google.ads.googleads.v14.common.MatchingFunction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v14.common.MatchingFunction build() {
      com.google.ads.googleads.v14.common.MatchingFunction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v14.common.MatchingFunction buildPartial() {
      com.google.ads.googleads.v14.common.MatchingFunction result = new com.google.ads.googleads.v14.common.MatchingFunction(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.ads.googleads.v14.common.MatchingFunction result) {
      if (leftOperandsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          leftOperands_ = java.util.Collections.unmodifiableList(leftOperands_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.leftOperands_ = leftOperands_;
      } else {
        result.leftOperands_ = leftOperandsBuilder_.build();
      }
      if (rightOperandsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          rightOperands_ = java.util.Collections.unmodifiableList(rightOperands_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.rightOperands_ = rightOperands_;
      } else {
        result.rightOperands_ = rightOperandsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.ads.googleads.v14.common.MatchingFunction result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.functionString_ = functionString_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.operator_ = operator_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v14.common.MatchingFunction) {
        return mergeFrom((com.google.ads.googleads.v14.common.MatchingFunction)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v14.common.MatchingFunction other) {
      if (other == com.google.ads.googleads.v14.common.MatchingFunction.getDefaultInstance()) return this;
      if (other.hasFunctionString()) {
        functionString_ = other.functionString_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.operator_ != 0) {
        setOperatorValue(other.getOperatorValue());
      }
      if (leftOperandsBuilder_ == null) {
        if (!other.leftOperands_.isEmpty()) {
          if (leftOperands_.isEmpty()) {
            leftOperands_ = other.leftOperands_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureLeftOperandsIsMutable();
            leftOperands_.addAll(other.leftOperands_);
          }
          onChanged();
        }
      } else {
        if (!other.leftOperands_.isEmpty()) {
          if (leftOperandsBuilder_.isEmpty()) {
            leftOperandsBuilder_.dispose();
            leftOperandsBuilder_ = null;
            leftOperands_ = other.leftOperands_;
            bitField0_ = (bitField0_ & ~0x00000004);
            leftOperandsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getLeftOperandsFieldBuilder() : null;
          } else {
            leftOperandsBuilder_.addAllMessages(other.leftOperands_);
          }
        }
      }
      if (rightOperandsBuilder_ == null) {
        if (!other.rightOperands_.isEmpty()) {
          if (rightOperands_.isEmpty()) {
            rightOperands_ = other.rightOperands_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureRightOperandsIsMutable();
            rightOperands_.addAll(other.rightOperands_);
          }
          onChanged();
        }
      } else {
        if (!other.rightOperands_.isEmpty()) {
          if (rightOperandsBuilder_.isEmpty()) {
            rightOperandsBuilder_.dispose();
            rightOperandsBuilder_ = null;
            rightOperands_ = other.rightOperands_;
            bitField0_ = (bitField0_ & ~0x00000008);
            rightOperandsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getRightOperandsFieldBuilder() : null;
          } else {
            rightOperandsBuilder_.addAllMessages(other.rightOperands_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18: {
              com.google.ads.googleads.v14.common.Operand m =
                  input.readMessage(
                      com.google.ads.googleads.v14.common.Operand.parser(),
                      extensionRegistry);
              if (leftOperandsBuilder_ == null) {
                ensureLeftOperandsIsMutable();
                leftOperands_.add(m);
              } else {
                leftOperandsBuilder_.addMessage(m);
              }
              break;
            } // case 18
            case 26: {
              com.google.ads.googleads.v14.common.Operand m =
                  input.readMessage(
                      com.google.ads.googleads.v14.common.Operand.parser(),
                      extensionRegistry);
              if (rightOperandsBuilder_ == null) {
                ensureRightOperandsIsMutable();
                rightOperands_.add(m);
              } else {
                rightOperandsBuilder_.addMessage(m);
              }
              break;
            } // case 26
            case 32: {
              operator_ = input.readEnum();
              bitField0_ |= 0x00000002;
              break;
            } // case 32
            case 42: {
              functionString_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 42
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object functionString_ = "";
    /**
     * <pre>
     * String representation of the Function.
     *
     * Examples:
     *
     * 1. IDENTITY(true) or IDENTITY(false). All or no feed items served.
     * 2. EQUALS(CONTEXT.DEVICE,"Mobile")
     * 3. IN(FEED_ITEM_ID,{1000001,1000002,1000003})
     * 4. CONTAINS_ANY(FeedAttribute[12345678,0],{"Mars cruise","Venus cruise"})
     * 5. AND(IN(FEED_ITEM_ID,{10001,10002}),EQUALS(CONTEXT.DEVICE,"Mobile"))
     *
     * For more details, visit
     * https://developers.google.com/google-ads/api/docs/extensions/feeds/matching-functions
     *
     * Note that because multiple strings may represent the same underlying
     * function (whitespace and single versus double quotation marks, for
     * example), the value returned may not be identical to the string sent in a
     * mutate request.
     * </pre>
     *
     * <code>optional string function_string = 5;</code>
     * @return Whether the functionString field is set.
     */
    public boolean hasFunctionString() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * String representation of the Function.
     *
     * Examples:
     *
     * 1. IDENTITY(true) or IDENTITY(false). All or no feed items served.
     * 2. EQUALS(CONTEXT.DEVICE,"Mobile")
     * 3. IN(FEED_ITEM_ID,{1000001,1000002,1000003})
     * 4. CONTAINS_ANY(FeedAttribute[12345678,0],{"Mars cruise","Venus cruise"})
     * 5. AND(IN(FEED_ITEM_ID,{10001,10002}),EQUALS(CONTEXT.DEVICE,"Mobile"))
     *
     * For more details, visit
     * https://developers.google.com/google-ads/api/docs/extensions/feeds/matching-functions
     *
     * Note that because multiple strings may represent the same underlying
     * function (whitespace and single versus double quotation marks, for
     * example), the value returned may not be identical to the string sent in a
     * mutate request.
     * </pre>
     *
     * <code>optional string function_string = 5;</code>
     * @return The functionString.
     */
    public java.lang.String getFunctionString() {
      java.lang.Object ref = functionString_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        functionString_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * String representation of the Function.
     *
     * Examples:
     *
     * 1. IDENTITY(true) or IDENTITY(false). All or no feed items served.
     * 2. EQUALS(CONTEXT.DEVICE,"Mobile")
     * 3. IN(FEED_ITEM_ID,{1000001,1000002,1000003})
     * 4. CONTAINS_ANY(FeedAttribute[12345678,0],{"Mars cruise","Venus cruise"})
     * 5. AND(IN(FEED_ITEM_ID,{10001,10002}),EQUALS(CONTEXT.DEVICE,"Mobile"))
     *
     * For more details, visit
     * https://developers.google.com/google-ads/api/docs/extensions/feeds/matching-functions
     *
     * Note that because multiple strings may represent the same underlying
     * function (whitespace and single versus double quotation marks, for
     * example), the value returned may not be identical to the string sent in a
     * mutate request.
     * </pre>
     *
     * <code>optional string function_string = 5;</code>
     * @return The bytes for functionString.
     */
    public com.google.protobuf.ByteString
        getFunctionStringBytes() {
      java.lang.Object ref = functionString_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        functionString_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * String representation of the Function.
     *
     * Examples:
     *
     * 1. IDENTITY(true) or IDENTITY(false). All or no feed items served.
     * 2. EQUALS(CONTEXT.DEVICE,"Mobile")
     * 3. IN(FEED_ITEM_ID,{1000001,1000002,1000003})
     * 4. CONTAINS_ANY(FeedAttribute[12345678,0],{"Mars cruise","Venus cruise"})
     * 5. AND(IN(FEED_ITEM_ID,{10001,10002}),EQUALS(CONTEXT.DEVICE,"Mobile"))
     *
     * For more details, visit
     * https://developers.google.com/google-ads/api/docs/extensions/feeds/matching-functions
     *
     * Note that because multiple strings may represent the same underlying
     * function (whitespace and single versus double quotation marks, for
     * example), the value returned may not be identical to the string sent in a
     * mutate request.
     * </pre>
     *
     * <code>optional string function_string = 5;</code>
     * @param value The functionString to set.
     * @return This builder for chaining.
     */
    public Builder setFunctionString(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      functionString_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * String representation of the Function.
     *
     * Examples:
     *
     * 1. IDENTITY(true) or IDENTITY(false). All or no feed items served.
     * 2. EQUALS(CONTEXT.DEVICE,"Mobile")
     * 3. IN(FEED_ITEM_ID,{1000001,1000002,1000003})
     * 4. CONTAINS_ANY(FeedAttribute[12345678,0],{"Mars cruise","Venus cruise"})
     * 5. AND(IN(FEED_ITEM_ID,{10001,10002}),EQUALS(CONTEXT.DEVICE,"Mobile"))
     *
     * For more details, visit
     * https://developers.google.com/google-ads/api/docs/extensions/feeds/matching-functions
     *
     * Note that because multiple strings may represent the same underlying
     * function (whitespace and single versus double quotation marks, for
     * example), the value returned may not be identical to the string sent in a
     * mutate request.
     * </pre>
     *
     * <code>optional string function_string = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearFunctionString() {
      functionString_ = getDefaultInstance().getFunctionString();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * String representation of the Function.
     *
     * Examples:
     *
     * 1. IDENTITY(true) or IDENTITY(false). All or no feed items served.
     * 2. EQUALS(CONTEXT.DEVICE,"Mobile")
     * 3. IN(FEED_ITEM_ID,{1000001,1000002,1000003})
     * 4. CONTAINS_ANY(FeedAttribute[12345678,0],{"Mars cruise","Venus cruise"})
     * 5. AND(IN(FEED_ITEM_ID,{10001,10002}),EQUALS(CONTEXT.DEVICE,"Mobile"))
     *
     * For more details, visit
     * https://developers.google.com/google-ads/api/docs/extensions/feeds/matching-functions
     *
     * Note that because multiple strings may represent the same underlying
     * function (whitespace and single versus double quotation marks, for
     * example), the value returned may not be identical to the string sent in a
     * mutate request.
     * </pre>
     *
     * <code>optional string function_string = 5;</code>
     * @param value The bytes for functionString to set.
     * @return This builder for chaining.
     */
    public Builder setFunctionStringBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      functionString_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int operator_ = 0;
    /**
     * <pre>
     * Operator for a function.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator operator = 4;</code>
     * @return The enum numeric value on the wire for operator.
     */
    @java.lang.Override public int getOperatorValue() {
      return operator_;
    }
    /**
     * <pre>
     * Operator for a function.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator operator = 4;</code>
     * @param value The enum numeric value on the wire for operator to set.
     * @return This builder for chaining.
     */
    public Builder setOperatorValue(int value) {
      operator_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Operator for a function.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator operator = 4;</code>
     * @return The operator.
     */
    @java.lang.Override
    public com.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator getOperator() {
      com.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator result = com.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator.forNumber(operator_);
      return result == null ? com.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Operator for a function.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator operator = 4;</code>
     * @param value The operator to set.
     * @return This builder for chaining.
     */
    public Builder setOperator(com.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      operator_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Operator for a function.
     * </pre>
     *
     * <code>.google.ads.googleads.v14.enums.MatchingFunctionOperatorEnum.MatchingFunctionOperator operator = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearOperator() {
      bitField0_ = (bitField0_ & ~0x00000002);
      operator_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.ads.googleads.v14.common.Operand> leftOperands_ =
      java.util.Collections.emptyList();
    private void ensureLeftOperandsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        leftOperands_ = new java.util.ArrayList<com.google.ads.googleads.v14.common.Operand>(leftOperands_);
        bitField0_ |= 0x00000004;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v14.common.Operand, com.google.ads.googleads.v14.common.Operand.Builder, com.google.ads.googleads.v14.common.OperandOrBuilder> leftOperandsBuilder_;

    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public java.util.List<com.google.ads.googleads.v14.common.Operand> getLeftOperandsList() {
      if (leftOperandsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(leftOperands_);
      } else {
        return leftOperandsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public int getLeftOperandsCount() {
      if (leftOperandsBuilder_ == null) {
        return leftOperands_.size();
      } else {
        return leftOperandsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public com.google.ads.googleads.v14.common.Operand getLeftOperands(int index) {
      if (leftOperandsBuilder_ == null) {
        return leftOperands_.get(index);
      } else {
        return leftOperandsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public Builder setLeftOperands(
        int index, com.google.ads.googleads.v14.common.Operand value) {
      if (leftOperandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLeftOperandsIsMutable();
        leftOperands_.set(index, value);
        onChanged();
      } else {
        leftOperandsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public Builder setLeftOperands(
        int index, com.google.ads.googleads.v14.common.Operand.Builder builderForValue) {
      if (leftOperandsBuilder_ == null) {
        ensureLeftOperandsIsMutable();
        leftOperands_.set(index, builderForValue.build());
        onChanged();
      } else {
        leftOperandsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public Builder addLeftOperands(com.google.ads.googleads.v14.common.Operand value) {
      if (leftOperandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLeftOperandsIsMutable();
        leftOperands_.add(value);
        onChanged();
      } else {
        leftOperandsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public Builder addLeftOperands(
        int index, com.google.ads.googleads.v14.common.Operand value) {
      if (leftOperandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLeftOperandsIsMutable();
        leftOperands_.add(index, value);
        onChanged();
      } else {
        leftOperandsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public Builder addLeftOperands(
        com.google.ads.googleads.v14.common.Operand.Builder builderForValue) {
      if (leftOperandsBuilder_ == null) {
        ensureLeftOperandsIsMutable();
        leftOperands_.add(builderForValue.build());
        onChanged();
      } else {
        leftOperandsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public Builder addLeftOperands(
        int index, com.google.ads.googleads.v14.common.Operand.Builder builderForValue) {
      if (leftOperandsBuilder_ == null) {
        ensureLeftOperandsIsMutable();
        leftOperands_.add(index, builderForValue.build());
        onChanged();
      } else {
        leftOperandsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public Builder addAllLeftOperands(
        java.lang.Iterable<? extends com.google.ads.googleads.v14.common.Operand> values) {
      if (leftOperandsBuilder_ == null) {
        ensureLeftOperandsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, leftOperands_);
        onChanged();
      } else {
        leftOperandsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public Builder clearLeftOperands() {
      if (leftOperandsBuilder_ == null) {
        leftOperands_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        leftOperandsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public Builder removeLeftOperands(int index) {
      if (leftOperandsBuilder_ == null) {
        ensureLeftOperandsIsMutable();
        leftOperands_.remove(index);
        onChanged();
      } else {
        leftOperandsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public com.google.ads.googleads.v14.common.Operand.Builder getLeftOperandsBuilder(
        int index) {
      return getLeftOperandsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public com.google.ads.googleads.v14.common.OperandOrBuilder getLeftOperandsOrBuilder(
        int index) {
      if (leftOperandsBuilder_ == null) {
        return leftOperands_.get(index);  } else {
        return leftOperandsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v14.common.OperandOrBuilder> 
         getLeftOperandsOrBuilderList() {
      if (leftOperandsBuilder_ != null) {
        return leftOperandsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(leftOperands_);
      }
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public com.google.ads.googleads.v14.common.Operand.Builder addLeftOperandsBuilder() {
      return getLeftOperandsFieldBuilder().addBuilder(
          com.google.ads.googleads.v14.common.Operand.getDefaultInstance());
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public com.google.ads.googleads.v14.common.Operand.Builder addLeftOperandsBuilder(
        int index) {
      return getLeftOperandsFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v14.common.Operand.getDefaultInstance());
    }
    /**
     * <pre>
     * The operands on the left hand side of the equation. This is also the
     * operand to be used for single operand expressions such as NOT.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand left_operands = 2;</code>
     */
    public java.util.List<com.google.ads.googleads.v14.common.Operand.Builder> 
         getLeftOperandsBuilderList() {
      return getLeftOperandsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v14.common.Operand, com.google.ads.googleads.v14.common.Operand.Builder, com.google.ads.googleads.v14.common.OperandOrBuilder> 
        getLeftOperandsFieldBuilder() {
      if (leftOperandsBuilder_ == null) {
        leftOperandsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v14.common.Operand, com.google.ads.googleads.v14.common.Operand.Builder, com.google.ads.googleads.v14.common.OperandOrBuilder>(
                leftOperands_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        leftOperands_ = null;
      }
      return leftOperandsBuilder_;
    }

    private java.util.List<com.google.ads.googleads.v14.common.Operand> rightOperands_ =
      java.util.Collections.emptyList();
    private void ensureRightOperandsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        rightOperands_ = new java.util.ArrayList<com.google.ads.googleads.v14.common.Operand>(rightOperands_);
        bitField0_ |= 0x00000008;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v14.common.Operand, com.google.ads.googleads.v14.common.Operand.Builder, com.google.ads.googleads.v14.common.OperandOrBuilder> rightOperandsBuilder_;

    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public java.util.List<com.google.ads.googleads.v14.common.Operand> getRightOperandsList() {
      if (rightOperandsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rightOperands_);
      } else {
        return rightOperandsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public int getRightOperandsCount() {
      if (rightOperandsBuilder_ == null) {
        return rightOperands_.size();
      } else {
        return rightOperandsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public com.google.ads.googleads.v14.common.Operand getRightOperands(int index) {
      if (rightOperandsBuilder_ == null) {
        return rightOperands_.get(index);
      } else {
        return rightOperandsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public Builder setRightOperands(
        int index, com.google.ads.googleads.v14.common.Operand value) {
      if (rightOperandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRightOperandsIsMutable();
        rightOperands_.set(index, value);
        onChanged();
      } else {
        rightOperandsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public Builder setRightOperands(
        int index, com.google.ads.googleads.v14.common.Operand.Builder builderForValue) {
      if (rightOperandsBuilder_ == null) {
        ensureRightOperandsIsMutable();
        rightOperands_.set(index, builderForValue.build());
        onChanged();
      } else {
        rightOperandsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public Builder addRightOperands(com.google.ads.googleads.v14.common.Operand value) {
      if (rightOperandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRightOperandsIsMutable();
        rightOperands_.add(value);
        onChanged();
      } else {
        rightOperandsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public Builder addRightOperands(
        int index, com.google.ads.googleads.v14.common.Operand value) {
      if (rightOperandsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRightOperandsIsMutable();
        rightOperands_.add(index, value);
        onChanged();
      } else {
        rightOperandsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public Builder addRightOperands(
        com.google.ads.googleads.v14.common.Operand.Builder builderForValue) {
      if (rightOperandsBuilder_ == null) {
        ensureRightOperandsIsMutable();
        rightOperands_.add(builderForValue.build());
        onChanged();
      } else {
        rightOperandsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public Builder addRightOperands(
        int index, com.google.ads.googleads.v14.common.Operand.Builder builderForValue) {
      if (rightOperandsBuilder_ == null) {
        ensureRightOperandsIsMutable();
        rightOperands_.add(index, builderForValue.build());
        onChanged();
      } else {
        rightOperandsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public Builder addAllRightOperands(
        java.lang.Iterable<? extends com.google.ads.googleads.v14.common.Operand> values) {
      if (rightOperandsBuilder_ == null) {
        ensureRightOperandsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, rightOperands_);
        onChanged();
      } else {
        rightOperandsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public Builder clearRightOperands() {
      if (rightOperandsBuilder_ == null) {
        rightOperands_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        rightOperandsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public Builder removeRightOperands(int index) {
      if (rightOperandsBuilder_ == null) {
        ensureRightOperandsIsMutable();
        rightOperands_.remove(index);
        onChanged();
      } else {
        rightOperandsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public com.google.ads.googleads.v14.common.Operand.Builder getRightOperandsBuilder(
        int index) {
      return getRightOperandsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public com.google.ads.googleads.v14.common.OperandOrBuilder getRightOperandsOrBuilder(
        int index) {
      if (rightOperandsBuilder_ == null) {
        return rightOperands_.get(index);  } else {
        return rightOperandsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v14.common.OperandOrBuilder> 
         getRightOperandsOrBuilderList() {
      if (rightOperandsBuilder_ != null) {
        return rightOperandsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rightOperands_);
      }
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public com.google.ads.googleads.v14.common.Operand.Builder addRightOperandsBuilder() {
      return getRightOperandsFieldBuilder().addBuilder(
          com.google.ads.googleads.v14.common.Operand.getDefaultInstance());
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public com.google.ads.googleads.v14.common.Operand.Builder addRightOperandsBuilder(
        int index) {
      return getRightOperandsFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v14.common.Operand.getDefaultInstance());
    }
    /**
     * <pre>
     * The operands on the right hand side of the equation.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v14.common.Operand right_operands = 3;</code>
     */
    public java.util.List<com.google.ads.googleads.v14.common.Operand.Builder> 
         getRightOperandsBuilderList() {
      return getRightOperandsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v14.common.Operand, com.google.ads.googleads.v14.common.Operand.Builder, com.google.ads.googleads.v14.common.OperandOrBuilder> 
        getRightOperandsFieldBuilder() {
      if (rightOperandsBuilder_ == null) {
        rightOperandsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v14.common.Operand, com.google.ads.googleads.v14.common.Operand.Builder, com.google.ads.googleads.v14.common.OperandOrBuilder>(
                rightOperands_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        rightOperands_ = null;
      }
      return rightOperandsBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v14.common.MatchingFunction)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v14.common.MatchingFunction)
  private static final com.google.ads.googleads.v14.common.MatchingFunction DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v14.common.MatchingFunction();
  }

  public static com.google.ads.googleads.v14.common.MatchingFunction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MatchingFunction>
      PARSER = new com.google.protobuf.AbstractParser<MatchingFunction>() {
    @java.lang.Override
    public MatchingFunction parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<MatchingFunction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MatchingFunction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v14.common.MatchingFunction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

