/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.ads.googleads.v14.common.CustomParameter;
import com.google.ads.googleads.v14.common.CustomParameterOrBuilder;
import com.google.ads.googleads.v14.common.TargetingSetting;
import com.google.ads.googleads.v14.common.TargetingSettingOrBuilder;
import com.google.ads.googleads.v14.enums.AdGroupAdRotationModeEnum;
import com.google.ads.googleads.v14.enums.AdGroupStatusEnum;
import com.google.ads.googleads.v14.enums.AdGroupTypeEnum;
import com.google.ads.googleads.v14.enums.AssetFieldTypeEnum;
import com.google.ads.googleads.v14.enums.AssetSetTypeEnum;
import com.google.ads.googleads.v14.enums.BiddingSourceEnum;
import com.google.ads.googleads.v14.enums.TargetingDimensionEnum;
import com.google.ads.googleads.v14.resources.AdGroupOrBuilder;
import com.google.ads.googleads.v14.resources.AdGroupProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class AdGroup
extends GeneratedMessageV3
implements AdGroupOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int ID_FIELD_NUMBER = 34;
    private long id_ = 0L;
    public static final int NAME_FIELD_NUMBER = 35;
    private volatile Object name_ = "";
    public static final int STATUS_FIELD_NUMBER = 5;
    private int status_ = 0;
    public static final int TYPE_FIELD_NUMBER = 12;
    private int type_ = 0;
    public static final int AD_ROTATION_MODE_FIELD_NUMBER = 22;
    private int adRotationMode_ = 0;
    public static final int BASE_AD_GROUP_FIELD_NUMBER = 36;
    private volatile Object baseAdGroup_ = "";
    public static final int TRACKING_URL_TEMPLATE_FIELD_NUMBER = 37;
    private volatile Object trackingUrlTemplate_ = "";
    public static final int URL_CUSTOM_PARAMETERS_FIELD_NUMBER = 6;
    private List<CustomParameter> urlCustomParameters_;
    public static final int CAMPAIGN_FIELD_NUMBER = 38;
    private volatile Object campaign_ = "";
    public static final int CPC_BID_MICROS_FIELD_NUMBER = 39;
    private long cpcBidMicros_ = 0L;
    public static final int EFFECTIVE_CPC_BID_MICROS_FIELD_NUMBER = 57;
    private long effectiveCpcBidMicros_ = 0L;
    public static final int CPM_BID_MICROS_FIELD_NUMBER = 40;
    private long cpmBidMicros_ = 0L;
    public static final int TARGET_CPA_MICROS_FIELD_NUMBER = 41;
    private long targetCpaMicros_ = 0L;
    public static final int CPV_BID_MICROS_FIELD_NUMBER = 42;
    private long cpvBidMicros_ = 0L;
    public static final int TARGET_CPM_MICROS_FIELD_NUMBER = 43;
    private long targetCpmMicros_ = 0L;
    public static final int TARGET_ROAS_FIELD_NUMBER = 44;
    private double targetRoas_ = 0.0;
    public static final int PERCENT_CPC_BID_MICROS_FIELD_NUMBER = 45;
    private long percentCpcBidMicros_ = 0L;
    public static final int OPTIMIZED_TARGETING_ENABLED_FIELD_NUMBER = 59;
    private boolean optimizedTargetingEnabled_ = false;
    public static final int DISPLAY_CUSTOM_BID_DIMENSION_FIELD_NUMBER = 23;
    private int displayCustomBidDimension_ = 0;
    public static final int FINAL_URL_SUFFIX_FIELD_NUMBER = 46;
    private volatile Object finalUrlSuffix_ = "";
    public static final int TARGETING_SETTING_FIELD_NUMBER = 25;
    private TargetingSetting targetingSetting_;
    public static final int AUDIENCE_SETTING_FIELD_NUMBER = 56;
    private AudienceSetting audienceSetting_;
    public static final int EFFECTIVE_TARGET_CPA_MICROS_FIELD_NUMBER = 47;
    private long effectiveTargetCpaMicros_ = 0L;
    public static final int EFFECTIVE_TARGET_CPA_SOURCE_FIELD_NUMBER = 29;
    private int effectiveTargetCpaSource_ = 0;
    public static final int EFFECTIVE_TARGET_ROAS_FIELD_NUMBER = 48;
    private double effectiveTargetRoas_ = 0.0;
    public static final int EFFECTIVE_TARGET_ROAS_SOURCE_FIELD_NUMBER = 32;
    private int effectiveTargetRoasSource_ = 0;
    public static final int LABELS_FIELD_NUMBER = 49;
    private LazyStringArrayList labels_ = LazyStringArrayList.emptyList();
    public static final int EXCLUDED_PARENT_ASSET_FIELD_TYPES_FIELD_NUMBER = 54;
    private List<Integer> excludedParentAssetFieldTypes_;
    private static final Internal.ListAdapter.Converter<Integer, AssetFieldTypeEnum.AssetFieldType> excludedParentAssetFieldTypes_converter_ = new Internal.ListAdapter.Converter<Integer, AssetFieldTypeEnum.AssetFieldType>(){

        public AssetFieldTypeEnum.AssetFieldType convert(Integer from) {
            AssetFieldTypeEnum.AssetFieldType result = AssetFieldTypeEnum.AssetFieldType.forNumber(from);
            return result == null ? AssetFieldTypeEnum.AssetFieldType.UNRECOGNIZED : result;
        }
    };
    private int excludedParentAssetFieldTypesMemoizedSerializedSize;
    public static final int EXCLUDED_PARENT_ASSET_SET_TYPES_FIELD_NUMBER = 58;
    private List<Integer> excludedParentAssetSetTypes_;
    private static final Internal.ListAdapter.Converter<Integer, AssetSetTypeEnum.AssetSetType> excludedParentAssetSetTypes_converter_ = new Internal.ListAdapter.Converter<Integer, AssetSetTypeEnum.AssetSetType>(){

        public AssetSetTypeEnum.AssetSetType convert(Integer from) {
            AssetSetTypeEnum.AssetSetType result = AssetSetTypeEnum.AssetSetType.forNumber(from);
            return result == null ? AssetSetTypeEnum.AssetSetType.UNRECOGNIZED : result;
        }
    };
    private int excludedParentAssetSetTypesMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final AdGroup DEFAULT_INSTANCE = new AdGroup();
    private static final Parser<AdGroup> PARSER = new AbstractParser<AdGroup>(){

        public AdGroup parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = AdGroup.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private AdGroup(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private AdGroup() {
        this.resourceName_ = "";
        this.name_ = "";
        this.status_ = 0;
        this.type_ = 0;
        this.adRotationMode_ = 0;
        this.baseAdGroup_ = "";
        this.trackingUrlTemplate_ = "";
        this.urlCustomParameters_ = Collections.emptyList();
        this.campaign_ = "";
        this.displayCustomBidDimension_ = 0;
        this.finalUrlSuffix_ = "";
        this.effectiveTargetCpaSource_ = 0;
        this.effectiveTargetRoasSource_ = 0;
        this.labels_ = LazyStringArrayList.emptyList();
        this.excludedParentAssetFieldTypes_ = Collections.emptyList();
        this.excludedParentAssetSetTypes_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new AdGroup();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AdGroupProto.internal_static_google_ads_googleads_v14_resources_AdGroup_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AdGroupProto.internal_static_google_ads_googleads_v14_resources_AdGroup_fieldAccessorTable.ensureFieldAccessorsInitialized(AdGroup.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasId() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public long getId() {
        return this.id_;
    }

    @Override
    public boolean hasName() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public AdGroupStatusEnum.AdGroupStatus getStatus() {
        AdGroupStatusEnum.AdGroupStatus result = AdGroupStatusEnum.AdGroupStatus.forNumber(this.status_);
        return result == null ? AdGroupStatusEnum.AdGroupStatus.UNRECOGNIZED : result;
    }

    @Override
    public int getTypeValue() {
        return this.type_;
    }

    @Override
    public AdGroupTypeEnum.AdGroupType getType() {
        AdGroupTypeEnum.AdGroupType result = AdGroupTypeEnum.AdGroupType.forNumber(this.type_);
        return result == null ? AdGroupTypeEnum.AdGroupType.UNRECOGNIZED : result;
    }

    @Override
    public int getAdRotationModeValue() {
        return this.adRotationMode_;
    }

    @Override
    public AdGroupAdRotationModeEnum.AdGroupAdRotationMode getAdRotationMode() {
        AdGroupAdRotationModeEnum.AdGroupAdRotationMode result = AdGroupAdRotationModeEnum.AdGroupAdRotationMode.forNumber(this.adRotationMode_);
        return result == null ? AdGroupAdRotationModeEnum.AdGroupAdRotationMode.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasBaseAdGroup() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public String getBaseAdGroup() {
        Object ref = this.baseAdGroup_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.baseAdGroup_ = s;
        return s;
    }

    @Override
    public ByteString getBaseAdGroupBytes() {
        Object ref = this.baseAdGroup_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.baseAdGroup_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasTrackingUrlTemplate() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public String getTrackingUrlTemplate() {
        Object ref = this.trackingUrlTemplate_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.trackingUrlTemplate_ = s;
        return s;
    }

    @Override
    public ByteString getTrackingUrlTemplateBytes() {
        Object ref = this.trackingUrlTemplate_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.trackingUrlTemplate_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<CustomParameter> getUrlCustomParametersList() {
        return this.urlCustomParameters_;
    }

    @Override
    public List<? extends CustomParameterOrBuilder> getUrlCustomParametersOrBuilderList() {
        return this.urlCustomParameters_;
    }

    @Override
    public int getUrlCustomParametersCount() {
        return this.urlCustomParameters_.size();
    }

    @Override
    public CustomParameter getUrlCustomParameters(int index) {
        return this.urlCustomParameters_.get(index);
    }

    @Override
    public CustomParameterOrBuilder getUrlCustomParametersOrBuilder(int index) {
        return this.urlCustomParameters_.get(index);
    }

    @Override
    public boolean hasCampaign() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public String getCampaign() {
        Object ref = this.campaign_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.campaign_ = s;
        return s;
    }

    @Override
    public ByteString getCampaignBytes() {
        Object ref = this.campaign_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.campaign_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasCpcBidMicros() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public long getCpcBidMicros() {
        return this.cpcBidMicros_;
    }

    @Override
    public boolean hasEffectiveCpcBidMicros() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public long getEffectiveCpcBidMicros() {
        return this.effectiveCpcBidMicros_;
    }

    @Override
    public boolean hasCpmBidMicros() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public long getCpmBidMicros() {
        return this.cpmBidMicros_;
    }

    @Override
    public boolean hasTargetCpaMicros() {
        return (this.bitField0_ & 0x100) != 0;
    }

    @Override
    public long getTargetCpaMicros() {
        return this.targetCpaMicros_;
    }

    @Override
    public boolean hasCpvBidMicros() {
        return (this.bitField0_ & 0x200) != 0;
    }

    @Override
    public long getCpvBidMicros() {
        return this.cpvBidMicros_;
    }

    @Override
    public boolean hasTargetCpmMicros() {
        return (this.bitField0_ & 0x400) != 0;
    }

    @Override
    public long getTargetCpmMicros() {
        return this.targetCpmMicros_;
    }

    @Override
    public boolean hasTargetRoas() {
        return (this.bitField0_ & 0x800) != 0;
    }

    @Override
    public double getTargetRoas() {
        return this.targetRoas_;
    }

    @Override
    public boolean hasPercentCpcBidMicros() {
        return (this.bitField0_ & 0x1000) != 0;
    }

    @Override
    public long getPercentCpcBidMicros() {
        return this.percentCpcBidMicros_;
    }

    @Override
    public boolean getOptimizedTargetingEnabled() {
        return this.optimizedTargetingEnabled_;
    }

    @Override
    public int getDisplayCustomBidDimensionValue() {
        return this.displayCustomBidDimension_;
    }

    @Override
    public TargetingDimensionEnum.TargetingDimension getDisplayCustomBidDimension() {
        TargetingDimensionEnum.TargetingDimension result = TargetingDimensionEnum.TargetingDimension.forNumber(this.displayCustomBidDimension_);
        return result == null ? TargetingDimensionEnum.TargetingDimension.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasFinalUrlSuffix() {
        return (this.bitField0_ & 0x2000) != 0;
    }

    @Override
    public String getFinalUrlSuffix() {
        Object ref = this.finalUrlSuffix_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.finalUrlSuffix_ = s;
        return s;
    }

    @Override
    public ByteString getFinalUrlSuffixBytes() {
        Object ref = this.finalUrlSuffix_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.finalUrlSuffix_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasTargetingSetting() {
        return (this.bitField0_ & 0x4000) != 0;
    }

    @Override
    public TargetingSetting getTargetingSetting() {
        return this.targetingSetting_ == null ? TargetingSetting.getDefaultInstance() : this.targetingSetting_;
    }

    @Override
    public TargetingSettingOrBuilder getTargetingSettingOrBuilder() {
        return this.targetingSetting_ == null ? TargetingSetting.getDefaultInstance() : this.targetingSetting_;
    }

    @Override
    public boolean hasAudienceSetting() {
        return (this.bitField0_ & 0x8000) != 0;
    }

    @Override
    public AudienceSetting getAudienceSetting() {
        return this.audienceSetting_ == null ? AudienceSetting.getDefaultInstance() : this.audienceSetting_;
    }

    @Override
    public AudienceSettingOrBuilder getAudienceSettingOrBuilder() {
        return this.audienceSetting_ == null ? AudienceSetting.getDefaultInstance() : this.audienceSetting_;
    }

    @Override
    public boolean hasEffectiveTargetCpaMicros() {
        return (this.bitField0_ & 0x10000) != 0;
    }

    @Override
    public long getEffectiveTargetCpaMicros() {
        return this.effectiveTargetCpaMicros_;
    }

    @Override
    public int getEffectiveTargetCpaSourceValue() {
        return this.effectiveTargetCpaSource_;
    }

    @Override
    public BiddingSourceEnum.BiddingSource getEffectiveTargetCpaSource() {
        BiddingSourceEnum.BiddingSource result = BiddingSourceEnum.BiddingSource.forNumber(this.effectiveTargetCpaSource_);
        return result == null ? BiddingSourceEnum.BiddingSource.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasEffectiveTargetRoas() {
        return (this.bitField0_ & 0x20000) != 0;
    }

    @Override
    public double getEffectiveTargetRoas() {
        return this.effectiveTargetRoas_;
    }

    @Override
    public int getEffectiveTargetRoasSourceValue() {
        return this.effectiveTargetRoasSource_;
    }

    @Override
    public BiddingSourceEnum.BiddingSource getEffectiveTargetRoasSource() {
        BiddingSourceEnum.BiddingSource result = BiddingSourceEnum.BiddingSource.forNumber(this.effectiveTargetRoasSource_);
        return result == null ? BiddingSourceEnum.BiddingSource.UNRECOGNIZED : result;
    }

    public ProtocolStringList getLabelsList() {
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.labels_.size();
    }

    @Override
    public String getLabels(int index) {
        return this.labels_.get(index);
    }

    @Override
    public ByteString getLabelsBytes(int index) {
        return this.labels_.getByteString(index);
    }

    @Override
    public List<AssetFieldTypeEnum.AssetFieldType> getExcludedParentAssetFieldTypesList() {
        return new Internal.ListAdapter(this.excludedParentAssetFieldTypes_, excludedParentAssetFieldTypes_converter_);
    }

    @Override
    public int getExcludedParentAssetFieldTypesCount() {
        return this.excludedParentAssetFieldTypes_.size();
    }

    @Override
    public AssetFieldTypeEnum.AssetFieldType getExcludedParentAssetFieldTypes(int index) {
        return (AssetFieldTypeEnum.AssetFieldType)((Object)excludedParentAssetFieldTypes_converter_.convert((Object)this.excludedParentAssetFieldTypes_.get(index)));
    }

    @Override
    public List<Integer> getExcludedParentAssetFieldTypesValueList() {
        return this.excludedParentAssetFieldTypes_;
    }

    @Override
    public int getExcludedParentAssetFieldTypesValue(int index) {
        return this.excludedParentAssetFieldTypes_.get(index);
    }

    @Override
    public List<AssetSetTypeEnum.AssetSetType> getExcludedParentAssetSetTypesList() {
        return new Internal.ListAdapter(this.excludedParentAssetSetTypes_, excludedParentAssetSetTypes_converter_);
    }

    @Override
    public int getExcludedParentAssetSetTypesCount() {
        return this.excludedParentAssetSetTypes_.size();
    }

    @Override
    public AssetSetTypeEnum.AssetSetType getExcludedParentAssetSetTypes(int index) {
        return (AssetSetTypeEnum.AssetSetType)((Object)excludedParentAssetSetTypes_converter_.convert((Object)this.excludedParentAssetSetTypes_.get(index)));
    }

    @Override
    public List<Integer> getExcludedParentAssetSetTypesValueList() {
        return this.excludedParentAssetSetTypes_;
    }

    @Override
    public int getExcludedParentAssetSetTypesValue(int index) {
        return this.excludedParentAssetSetTypes_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (this.status_ != AdGroupStatusEnum.AdGroupStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.status_);
        }
        for (i = 0; i < this.urlCustomParameters_.size(); ++i) {
            output.writeMessage(6, (MessageLite)this.urlCustomParameters_.get(i));
        }
        if (this.type_ != AdGroupTypeEnum.AdGroupType.UNSPECIFIED.getNumber()) {
            output.writeEnum(12, this.type_);
        }
        if (this.adRotationMode_ != AdGroupAdRotationModeEnum.AdGroupAdRotationMode.UNSPECIFIED.getNumber()) {
            output.writeEnum(22, this.adRotationMode_);
        }
        if (this.displayCustomBidDimension_ != TargetingDimensionEnum.TargetingDimension.UNSPECIFIED.getNumber()) {
            output.writeEnum(23, this.displayCustomBidDimension_);
        }
        if ((this.bitField0_ & 0x4000) != 0) {
            output.writeMessage(25, (MessageLite)this.getTargetingSetting());
        }
        if (this.effectiveTargetCpaSource_ != BiddingSourceEnum.BiddingSource.UNSPECIFIED.getNumber()) {
            output.writeEnum(29, this.effectiveTargetCpaSource_);
        }
        if (this.effectiveTargetRoasSource_ != BiddingSourceEnum.BiddingSource.UNSPECIFIED.getNumber()) {
            output.writeEnum(32, this.effectiveTargetRoasSource_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeInt64(34, this.id_);
        }
        if ((this.bitField0_ & 2) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)35, (Object)this.name_);
        }
        if ((this.bitField0_ & 4) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)36, (Object)this.baseAdGroup_);
        }
        if ((this.bitField0_ & 8) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)37, (Object)this.trackingUrlTemplate_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)38, (Object)this.campaign_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeInt64(39, this.cpcBidMicros_);
        }
        if ((this.bitField0_ & 0x80) != 0) {
            output.writeInt64(40, this.cpmBidMicros_);
        }
        if ((this.bitField0_ & 0x100) != 0) {
            output.writeInt64(41, this.targetCpaMicros_);
        }
        if ((this.bitField0_ & 0x200) != 0) {
            output.writeInt64(42, this.cpvBidMicros_);
        }
        if ((this.bitField0_ & 0x400) != 0) {
            output.writeInt64(43, this.targetCpmMicros_);
        }
        if ((this.bitField0_ & 0x800) != 0) {
            output.writeDouble(44, this.targetRoas_);
        }
        if ((this.bitField0_ & 0x1000) != 0) {
            output.writeInt64(45, this.percentCpcBidMicros_);
        }
        if ((this.bitField0_ & 0x2000) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)46, (Object)this.finalUrlSuffix_);
        }
        if ((this.bitField0_ & 0x10000) != 0) {
            output.writeInt64(47, this.effectiveTargetCpaMicros_);
        }
        if ((this.bitField0_ & 0x20000) != 0) {
            output.writeDouble(48, this.effectiveTargetRoas_);
        }
        for (i = 0; i < this.labels_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)49, (Object)this.labels_.getRaw(i));
        }
        if (this.getExcludedParentAssetFieldTypesList().size() > 0) {
            output.writeUInt32NoTag(434);
            output.writeUInt32NoTag(this.excludedParentAssetFieldTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.excludedParentAssetFieldTypes_.size(); ++i) {
            output.writeEnumNoTag(this.excludedParentAssetFieldTypes_.get(i).intValue());
        }
        if ((this.bitField0_ & 0x8000) != 0) {
            output.writeMessage(56, (MessageLite)this.getAudienceSetting());
        }
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeInt64(57, this.effectiveCpcBidMicros_);
        }
        if (this.getExcludedParentAssetSetTypesList().size() > 0) {
            output.writeUInt32NoTag(466);
            output.writeUInt32NoTag(this.excludedParentAssetSetTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.excludedParentAssetSetTypes_.size(); ++i) {
            output.writeEnumNoTag(this.excludedParentAssetSetTypes_.get(i).intValue());
        }
        if (this.optimizedTargetingEnabled_) {
            output.writeBool(59, this.optimizedTargetingEnabled_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (this.status_ != AdGroupStatusEnum.AdGroupStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.status_);
        }
        for (int i2 = 0; i2 < this.urlCustomParameters_.size(); ++i2) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((MessageLite)this.urlCustomParameters_.get(i2)));
        }
        if (this.type_ != AdGroupTypeEnum.AdGroupType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)12, (int)this.type_);
        }
        if (this.adRotationMode_ != AdGroupAdRotationModeEnum.AdGroupAdRotationMode.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)22, (int)this.adRotationMode_);
        }
        if (this.displayCustomBidDimension_ != TargetingDimensionEnum.TargetingDimension.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)23, (int)this.displayCustomBidDimension_);
        }
        if ((this.bitField0_ & 0x4000) != 0) {
            size += CodedOutputStream.computeMessageSize((int)25, (MessageLite)this.getTargetingSetting());
        }
        if (this.effectiveTargetCpaSource_ != BiddingSourceEnum.BiddingSource.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)29, (int)this.effectiveTargetCpaSource_);
        }
        if (this.effectiveTargetRoasSource_ != BiddingSourceEnum.BiddingSource.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)32, (int)this.effectiveTargetRoasSource_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeInt64Size((int)34, (long)this.id_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)35, (Object)this.name_);
        }
        if ((this.bitField0_ & 4) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)36, (Object)this.baseAdGroup_);
        }
        if ((this.bitField0_ & 8) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)37, (Object)this.trackingUrlTemplate_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)38, (Object)this.campaign_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeInt64Size((int)39, (long)this.cpcBidMicros_);
        }
        if ((this.bitField0_ & 0x80) != 0) {
            size += CodedOutputStream.computeInt64Size((int)40, (long)this.cpmBidMicros_);
        }
        if ((this.bitField0_ & 0x100) != 0) {
            size += CodedOutputStream.computeInt64Size((int)41, (long)this.targetCpaMicros_);
        }
        if ((this.bitField0_ & 0x200) != 0) {
            size += CodedOutputStream.computeInt64Size((int)42, (long)this.cpvBidMicros_);
        }
        if ((this.bitField0_ & 0x400) != 0) {
            size += CodedOutputStream.computeInt64Size((int)43, (long)this.targetCpmMicros_);
        }
        if ((this.bitField0_ & 0x800) != 0) {
            size += CodedOutputStream.computeDoubleSize((int)44, (double)this.targetRoas_);
        }
        if ((this.bitField0_ & 0x1000) != 0) {
            size += CodedOutputStream.computeInt64Size((int)45, (long)this.percentCpcBidMicros_);
        }
        if ((this.bitField0_ & 0x2000) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)46, (Object)this.finalUrlSuffix_);
        }
        if ((this.bitField0_ & 0x10000) != 0) {
            size += CodedOutputStream.computeInt64Size((int)47, (long)this.effectiveTargetCpaMicros_);
        }
        if ((this.bitField0_ & 0x20000) != 0) {
            size += CodedOutputStream.computeDoubleSize((int)48, (double)this.effectiveTargetRoas_);
        }
        int dataSize = 0;
        for (i = 0; i < this.labels_.size(); ++i) {
            dataSize += AdGroup.computeStringSizeNoTag((Object)this.labels_.getRaw(i));
        }
        size += dataSize;
        size += 2 * this.getLabelsList().size();
        dataSize = 0;
        for (i = 0; i < this.excludedParentAssetFieldTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.excludedParentAssetFieldTypes_.get(i));
        }
        size += dataSize;
        if (!this.getExcludedParentAssetFieldTypesList().isEmpty()) {
            size += 2;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.excludedParentAssetFieldTypesMemoizedSerializedSize = dataSize;
        if ((this.bitField0_ & 0x8000) != 0) {
            size += CodedOutputStream.computeMessageSize((int)56, (MessageLite)this.getAudienceSetting());
        }
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeInt64Size((int)57, (long)this.effectiveCpcBidMicros_);
        }
        dataSize = 0;
        for (i = 0; i < this.excludedParentAssetSetTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.excludedParentAssetSetTypes_.get(i));
        }
        size += dataSize;
        if (!this.getExcludedParentAssetSetTypesList().isEmpty()) {
            size += 2;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.excludedParentAssetSetTypesMemoizedSerializedSize = dataSize;
        if (this.optimizedTargetingEnabled_) {
            size += CodedOutputStream.computeBoolSize((int)59, (boolean)this.optimizedTargetingEnabled_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdGroup)) {
            return super.equals(obj);
        }
        AdGroup other = (AdGroup)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.hasId() != other.hasId()) {
            return false;
        }
        if (this.hasId() && this.getId() != other.getId()) {
            return false;
        }
        if (this.hasName() != other.hasName()) {
            return false;
        }
        if (this.hasName() && !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        if (this.adRotationMode_ != other.adRotationMode_) {
            return false;
        }
        if (this.hasBaseAdGroup() != other.hasBaseAdGroup()) {
            return false;
        }
        if (this.hasBaseAdGroup() && !this.getBaseAdGroup().equals(other.getBaseAdGroup())) {
            return false;
        }
        if (this.hasTrackingUrlTemplate() != other.hasTrackingUrlTemplate()) {
            return false;
        }
        if (this.hasTrackingUrlTemplate() && !this.getTrackingUrlTemplate().equals(other.getTrackingUrlTemplate())) {
            return false;
        }
        if (!this.getUrlCustomParametersList().equals(other.getUrlCustomParametersList())) {
            return false;
        }
        if (this.hasCampaign() != other.hasCampaign()) {
            return false;
        }
        if (this.hasCampaign() && !this.getCampaign().equals(other.getCampaign())) {
            return false;
        }
        if (this.hasCpcBidMicros() != other.hasCpcBidMicros()) {
            return false;
        }
        if (this.hasCpcBidMicros() && this.getCpcBidMicros() != other.getCpcBidMicros()) {
            return false;
        }
        if (this.hasEffectiveCpcBidMicros() != other.hasEffectiveCpcBidMicros()) {
            return false;
        }
        if (this.hasEffectiveCpcBidMicros() && this.getEffectiveCpcBidMicros() != other.getEffectiveCpcBidMicros()) {
            return false;
        }
        if (this.hasCpmBidMicros() != other.hasCpmBidMicros()) {
            return false;
        }
        if (this.hasCpmBidMicros() && this.getCpmBidMicros() != other.getCpmBidMicros()) {
            return false;
        }
        if (this.hasTargetCpaMicros() != other.hasTargetCpaMicros()) {
            return false;
        }
        if (this.hasTargetCpaMicros() && this.getTargetCpaMicros() != other.getTargetCpaMicros()) {
            return false;
        }
        if (this.hasCpvBidMicros() != other.hasCpvBidMicros()) {
            return false;
        }
        if (this.hasCpvBidMicros() && this.getCpvBidMicros() != other.getCpvBidMicros()) {
            return false;
        }
        if (this.hasTargetCpmMicros() != other.hasTargetCpmMicros()) {
            return false;
        }
        if (this.hasTargetCpmMicros() && this.getTargetCpmMicros() != other.getTargetCpmMicros()) {
            return false;
        }
        if (this.hasTargetRoas() != other.hasTargetRoas()) {
            return false;
        }
        if (this.hasTargetRoas() && Double.doubleToLongBits(this.getTargetRoas()) != Double.doubleToLongBits(other.getTargetRoas())) {
            return false;
        }
        if (this.hasPercentCpcBidMicros() != other.hasPercentCpcBidMicros()) {
            return false;
        }
        if (this.hasPercentCpcBidMicros() && this.getPercentCpcBidMicros() != other.getPercentCpcBidMicros()) {
            return false;
        }
        if (this.getOptimizedTargetingEnabled() != other.getOptimizedTargetingEnabled()) {
            return false;
        }
        if (this.displayCustomBidDimension_ != other.displayCustomBidDimension_) {
            return false;
        }
        if (this.hasFinalUrlSuffix() != other.hasFinalUrlSuffix()) {
            return false;
        }
        if (this.hasFinalUrlSuffix() && !this.getFinalUrlSuffix().equals(other.getFinalUrlSuffix())) {
            return false;
        }
        if (this.hasTargetingSetting() != other.hasTargetingSetting()) {
            return false;
        }
        if (this.hasTargetingSetting() && !this.getTargetingSetting().equals(other.getTargetingSetting())) {
            return false;
        }
        if (this.hasAudienceSetting() != other.hasAudienceSetting()) {
            return false;
        }
        if (this.hasAudienceSetting() && !this.getAudienceSetting().equals(other.getAudienceSetting())) {
            return false;
        }
        if (this.hasEffectiveTargetCpaMicros() != other.hasEffectiveTargetCpaMicros()) {
            return false;
        }
        if (this.hasEffectiveTargetCpaMicros() && this.getEffectiveTargetCpaMicros() != other.getEffectiveTargetCpaMicros()) {
            return false;
        }
        if (this.effectiveTargetCpaSource_ != other.effectiveTargetCpaSource_) {
            return false;
        }
        if (this.hasEffectiveTargetRoas() != other.hasEffectiveTargetRoas()) {
            return false;
        }
        if (this.hasEffectiveTargetRoas() && Double.doubleToLongBits(this.getEffectiveTargetRoas()) != Double.doubleToLongBits(other.getEffectiveTargetRoas())) {
            return false;
        }
        if (this.effectiveTargetRoasSource_ != other.effectiveTargetRoasSource_) {
            return false;
        }
        if (!this.getLabelsList().equals(other.getLabelsList())) {
            return false;
        }
        if (!this.excludedParentAssetFieldTypes_.equals(other.excludedParentAssetFieldTypes_)) {
            return false;
        }
        if (!this.excludedParentAssetSetTypes_.equals(other.excludedParentAssetSetTypes_)) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + AdGroup.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        if (this.hasId()) {
            hash = 37 * hash + 34;
            hash = 53 * hash + Internal.hashLong((long)this.getId());
        }
        if (this.hasName()) {
            hash = 37 * hash + 35;
            hash = 53 * hash + this.getName().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.status_;
        hash = 37 * hash + 12;
        hash = 53 * hash + this.type_;
        hash = 37 * hash + 22;
        hash = 53 * hash + this.adRotationMode_;
        if (this.hasBaseAdGroup()) {
            hash = 37 * hash + 36;
            hash = 53 * hash + this.getBaseAdGroup().hashCode();
        }
        if (this.hasTrackingUrlTemplate()) {
            hash = 37 * hash + 37;
            hash = 53 * hash + this.getTrackingUrlTemplate().hashCode();
        }
        if (this.getUrlCustomParametersCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getUrlCustomParametersList().hashCode();
        }
        if (this.hasCampaign()) {
            hash = 37 * hash + 38;
            hash = 53 * hash + this.getCampaign().hashCode();
        }
        if (this.hasCpcBidMicros()) {
            hash = 37 * hash + 39;
            hash = 53 * hash + Internal.hashLong((long)this.getCpcBidMicros());
        }
        if (this.hasEffectiveCpcBidMicros()) {
            hash = 37 * hash + 57;
            hash = 53 * hash + Internal.hashLong((long)this.getEffectiveCpcBidMicros());
        }
        if (this.hasCpmBidMicros()) {
            hash = 37 * hash + 40;
            hash = 53 * hash + Internal.hashLong((long)this.getCpmBidMicros());
        }
        if (this.hasTargetCpaMicros()) {
            hash = 37 * hash + 41;
            hash = 53 * hash + Internal.hashLong((long)this.getTargetCpaMicros());
        }
        if (this.hasCpvBidMicros()) {
            hash = 37 * hash + 42;
            hash = 53 * hash + Internal.hashLong((long)this.getCpvBidMicros());
        }
        if (this.hasTargetCpmMicros()) {
            hash = 37 * hash + 43;
            hash = 53 * hash + Internal.hashLong((long)this.getTargetCpmMicros());
        }
        if (this.hasTargetRoas()) {
            hash = 37 * hash + 44;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getTargetRoas()));
        }
        if (this.hasPercentCpcBidMicros()) {
            hash = 37 * hash + 45;
            hash = 53 * hash + Internal.hashLong((long)this.getPercentCpcBidMicros());
        }
        hash = 37 * hash + 59;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getOptimizedTargetingEnabled());
        hash = 37 * hash + 23;
        hash = 53 * hash + this.displayCustomBidDimension_;
        if (this.hasFinalUrlSuffix()) {
            hash = 37 * hash + 46;
            hash = 53 * hash + this.getFinalUrlSuffix().hashCode();
        }
        if (this.hasTargetingSetting()) {
            hash = 37 * hash + 25;
            hash = 53 * hash + this.getTargetingSetting().hashCode();
        }
        if (this.hasAudienceSetting()) {
            hash = 37 * hash + 56;
            hash = 53 * hash + this.getAudienceSetting().hashCode();
        }
        if (this.hasEffectiveTargetCpaMicros()) {
            hash = 37 * hash + 47;
            hash = 53 * hash + Internal.hashLong((long)this.getEffectiveTargetCpaMicros());
        }
        hash = 37 * hash + 29;
        hash = 53 * hash + this.effectiveTargetCpaSource_;
        if (this.hasEffectiveTargetRoas()) {
            hash = 37 * hash + 48;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getEffectiveTargetRoas()));
        }
        hash = 37 * hash + 32;
        hash = 53 * hash + this.effectiveTargetRoasSource_;
        if (this.getLabelsCount() > 0) {
            hash = 37 * hash + 49;
            hash = 53 * hash + this.getLabelsList().hashCode();
        }
        if (this.getExcludedParentAssetFieldTypesCount() > 0) {
            hash = 37 * hash + 54;
            hash = 53 * hash + this.excludedParentAssetFieldTypes_.hashCode();
        }
        if (this.getExcludedParentAssetSetTypesCount() > 0) {
            hash = 37 * hash + 58;
            hash = 53 * hash + this.excludedParentAssetSetTypes_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static AdGroup parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (AdGroup)PARSER.parseFrom(data);
    }

    public static AdGroup parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AdGroup)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AdGroup parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (AdGroup)PARSER.parseFrom(data);
    }

    public static AdGroup parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AdGroup)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AdGroup parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (AdGroup)PARSER.parseFrom(data);
    }

    public static AdGroup parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AdGroup)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AdGroup parseFrom(InputStream input) throws IOException {
        return (AdGroup)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static AdGroup parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AdGroup)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AdGroup parseDelimitedFrom(InputStream input) throws IOException {
        return (AdGroup)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static AdGroup parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AdGroup)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AdGroup parseFrom(CodedInputStream input) throws IOException {
        return (AdGroup)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static AdGroup parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AdGroup)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return AdGroup.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AdGroup prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static AdGroup getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<AdGroup> parser() {
        return PARSER;
    }

    public Parser<AdGroup> getParserForType() {
        return PARSER;
    }

    public AdGroup getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AdGroupOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private long id_;
        private Object name_ = "";
        private int status_ = 0;
        private int type_ = 0;
        private int adRotationMode_ = 0;
        private Object baseAdGroup_ = "";
        private Object trackingUrlTemplate_ = "";
        private List<CustomParameter> urlCustomParameters_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<CustomParameter, CustomParameter.Builder, CustomParameterOrBuilder> urlCustomParametersBuilder_;
        private Object campaign_ = "";
        private long cpcBidMicros_;
        private long effectiveCpcBidMicros_;
        private long cpmBidMicros_;
        private long targetCpaMicros_;
        private long cpvBidMicros_;
        private long targetCpmMicros_;
        private double targetRoas_;
        private long percentCpcBidMicros_;
        private boolean optimizedTargetingEnabled_;
        private int displayCustomBidDimension_ = 0;
        private Object finalUrlSuffix_ = "";
        private TargetingSetting targetingSetting_;
        private SingleFieldBuilderV3<TargetingSetting, TargetingSetting.Builder, TargetingSettingOrBuilder> targetingSettingBuilder_;
        private AudienceSetting audienceSetting_;
        private SingleFieldBuilderV3<AudienceSetting, AudienceSetting.Builder, AudienceSettingOrBuilder> audienceSettingBuilder_;
        private long effectiveTargetCpaMicros_;
        private int effectiveTargetCpaSource_ = 0;
        private double effectiveTargetRoas_;
        private int effectiveTargetRoasSource_ = 0;
        private LazyStringArrayList labels_ = LazyStringArrayList.emptyList();
        private List<Integer> excludedParentAssetFieldTypes_ = Collections.emptyList();
        private List<Integer> excludedParentAssetSetTypes_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return AdGroupProto.internal_static_google_ads_googleads_v14_resources_AdGroup_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AdGroupProto.internal_static_google_ads_googleads_v14_resources_AdGroup_fieldAccessorTable.ensureFieldAccessorsInitialized(AdGroup.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getUrlCustomParametersFieldBuilder();
                this.getTargetingSettingFieldBuilder();
                this.getAudienceSettingFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.id_ = 0L;
            this.name_ = "";
            this.status_ = 0;
            this.type_ = 0;
            this.adRotationMode_ = 0;
            this.baseAdGroup_ = "";
            this.trackingUrlTemplate_ = "";
            if (this.urlCustomParametersBuilder_ == null) {
                this.urlCustomParameters_ = Collections.emptyList();
            } else {
                this.urlCustomParameters_ = null;
                this.urlCustomParametersBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFEFF;
            this.campaign_ = "";
            this.cpcBidMicros_ = 0L;
            this.effectiveCpcBidMicros_ = 0L;
            this.cpmBidMicros_ = 0L;
            this.targetCpaMicros_ = 0L;
            this.cpvBidMicros_ = 0L;
            this.targetCpmMicros_ = 0L;
            this.targetRoas_ = 0.0;
            this.percentCpcBidMicros_ = 0L;
            this.optimizedTargetingEnabled_ = false;
            this.displayCustomBidDimension_ = 0;
            this.finalUrlSuffix_ = "";
            this.targetingSetting_ = null;
            if (this.targetingSettingBuilder_ != null) {
                this.targetingSettingBuilder_.dispose();
                this.targetingSettingBuilder_ = null;
            }
            this.audienceSetting_ = null;
            if (this.audienceSettingBuilder_ != null) {
                this.audienceSettingBuilder_.dispose();
                this.audienceSettingBuilder_ = null;
            }
            this.effectiveTargetCpaMicros_ = 0L;
            this.effectiveTargetCpaSource_ = 0;
            this.effectiveTargetRoas_ = 0.0;
            this.effectiveTargetRoasSource_ = 0;
            this.labels_ = LazyStringArrayList.emptyList();
            this.excludedParentAssetFieldTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xEFFFFFFF;
            this.excludedParentAssetSetTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xDFFFFFFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AdGroupProto.internal_static_google_ads_googleads_v14_resources_AdGroup_descriptor;
        }

        public AdGroup getDefaultInstanceForType() {
            return AdGroup.getDefaultInstance();
        }

        public AdGroup build() {
            AdGroup result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public AdGroup buildPartial() {
            AdGroup result = new AdGroup(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(AdGroup result) {
            if (this.urlCustomParametersBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0) {
                    this.urlCustomParameters_ = Collections.unmodifiableList(this.urlCustomParameters_);
                    this.bitField0_ &= 0xFFFFFEFF;
                }
                result.urlCustomParameters_ = this.urlCustomParameters_;
            } else {
                result.urlCustomParameters_ = this.urlCustomParametersBuilder_.build();
            }
            if ((this.bitField0_ & 0x10000000) != 0) {
                this.excludedParentAssetFieldTypes_ = Collections.unmodifiableList(this.excludedParentAssetFieldTypes_);
                this.bitField0_ &= 0xEFFFFFFF;
            }
            result.excludedParentAssetFieldTypes_ = this.excludedParentAssetFieldTypes_;
            if ((this.bitField0_ & 0x20000000) != 0) {
                this.excludedParentAssetSetTypes_ = Collections.unmodifiableList(this.excludedParentAssetSetTypes_);
                this.bitField0_ &= 0xDFFFFFFF;
            }
            result.excludedParentAssetSetTypes_ = this.excludedParentAssetSetTypes_;
        }

        private void buildPartial0(AdGroup result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.id_ = this.id_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.name_ = this.name_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.status_ = this.status_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.type_ = this.type_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.adRotationMode_ = this.adRotationMode_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.baseAdGroup_ = this.baseAdGroup_;
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.trackingUrlTemplate_ = this.trackingUrlTemplate_;
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.campaign_ = this.campaign_;
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.cpcBidMicros_ = this.cpcBidMicros_;
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.effectiveCpcBidMicros_ = this.effectiveCpcBidMicros_;
                to_bitField0_ |= 0x40;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.cpmBidMicros_ = this.cpmBidMicros_;
                to_bitField0_ |= 0x80;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.targetCpaMicros_ = this.targetCpaMicros_;
                to_bitField0_ |= 0x100;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.cpvBidMicros_ = this.cpvBidMicros_;
                to_bitField0_ |= 0x200;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.targetCpmMicros_ = this.targetCpmMicros_;
                to_bitField0_ |= 0x400;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.targetRoas_ = this.targetRoas_;
                to_bitField0_ |= 0x800;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.percentCpcBidMicros_ = this.percentCpcBidMicros_;
                to_bitField0_ |= 0x1000;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.optimizedTargetingEnabled_ = this.optimizedTargetingEnabled_;
            }
            if ((from_bitField0_ & 0x80000) != 0) {
                result.displayCustomBidDimension_ = this.displayCustomBidDimension_;
            }
            if ((from_bitField0_ & 0x100000) != 0) {
                result.finalUrlSuffix_ = this.finalUrlSuffix_;
                to_bitField0_ |= 0x2000;
            }
            if ((from_bitField0_ & 0x200000) != 0) {
                result.targetingSetting_ = this.targetingSettingBuilder_ == null ? this.targetingSetting_ : (TargetingSetting)this.targetingSettingBuilder_.build();
                to_bitField0_ |= 0x4000;
            }
            if ((from_bitField0_ & 0x400000) != 0) {
                result.audienceSetting_ = this.audienceSettingBuilder_ == null ? this.audienceSetting_ : (AudienceSetting)this.audienceSettingBuilder_.build();
                to_bitField0_ |= 0x8000;
            }
            if ((from_bitField0_ & 0x800000) != 0) {
                result.effectiveTargetCpaMicros_ = this.effectiveTargetCpaMicros_;
                to_bitField0_ |= 0x10000;
            }
            if ((from_bitField0_ & 0x1000000) != 0) {
                result.effectiveTargetCpaSource_ = this.effectiveTargetCpaSource_;
            }
            if ((from_bitField0_ & 0x2000000) != 0) {
                result.effectiveTargetRoas_ = this.effectiveTargetRoas_;
                to_bitField0_ |= 0x20000;
            }
            if ((from_bitField0_ & 0x4000000) != 0) {
                result.effectiveTargetRoasSource_ = this.effectiveTargetRoasSource_;
            }
            if ((from_bitField0_ & 0x8000000) != 0) {
                this.labels_.makeImmutable();
                result.labels_ = this.labels_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof AdGroup) {
                return this.mergeFrom((AdGroup)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(AdGroup other) {
            if (other == AdGroup.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasId()) {
                this.setId(other.getId());
            }
            if (other.hasName()) {
                this.name_ = other.name_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (other.type_ != 0) {
                this.setTypeValue(other.getTypeValue());
            }
            if (other.adRotationMode_ != 0) {
                this.setAdRotationModeValue(other.getAdRotationModeValue());
            }
            if (other.hasBaseAdGroup()) {
                this.baseAdGroup_ = other.baseAdGroup_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (other.hasTrackingUrlTemplate()) {
                this.trackingUrlTemplate_ = other.trackingUrlTemplate_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (this.urlCustomParametersBuilder_ == null) {
                if (!other.urlCustomParameters_.isEmpty()) {
                    if (this.urlCustomParameters_.isEmpty()) {
                        this.urlCustomParameters_ = other.urlCustomParameters_;
                        this.bitField0_ &= 0xFFFFFEFF;
                    } else {
                        this.ensureUrlCustomParametersIsMutable();
                        this.urlCustomParameters_.addAll(other.urlCustomParameters_);
                    }
                    this.onChanged();
                }
            } else if (!other.urlCustomParameters_.isEmpty()) {
                if (this.urlCustomParametersBuilder_.isEmpty()) {
                    this.urlCustomParametersBuilder_.dispose();
                    this.urlCustomParametersBuilder_ = null;
                    this.urlCustomParameters_ = other.urlCustomParameters_;
                    this.bitField0_ &= 0xFFFFFEFF;
                    this.urlCustomParametersBuilder_ = alwaysUseFieldBuilders ? this.getUrlCustomParametersFieldBuilder() : null;
                } else {
                    this.urlCustomParametersBuilder_.addAllMessages((Iterable)other.urlCustomParameters_);
                }
            }
            if (other.hasCampaign()) {
                this.campaign_ = other.campaign_;
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            if (other.hasCpcBidMicros()) {
                this.setCpcBidMicros(other.getCpcBidMicros());
            }
            if (other.hasEffectiveCpcBidMicros()) {
                this.setEffectiveCpcBidMicros(other.getEffectiveCpcBidMicros());
            }
            if (other.hasCpmBidMicros()) {
                this.setCpmBidMicros(other.getCpmBidMicros());
            }
            if (other.hasTargetCpaMicros()) {
                this.setTargetCpaMicros(other.getTargetCpaMicros());
            }
            if (other.hasCpvBidMicros()) {
                this.setCpvBidMicros(other.getCpvBidMicros());
            }
            if (other.hasTargetCpmMicros()) {
                this.setTargetCpmMicros(other.getTargetCpmMicros());
            }
            if (other.hasTargetRoas()) {
                this.setTargetRoas(other.getTargetRoas());
            }
            if (other.hasPercentCpcBidMicros()) {
                this.setPercentCpcBidMicros(other.getPercentCpcBidMicros());
            }
            if (other.getOptimizedTargetingEnabled()) {
                this.setOptimizedTargetingEnabled(other.getOptimizedTargetingEnabled());
            }
            if (other.displayCustomBidDimension_ != 0) {
                this.setDisplayCustomBidDimensionValue(other.getDisplayCustomBidDimensionValue());
            }
            if (other.hasFinalUrlSuffix()) {
                this.finalUrlSuffix_ = other.finalUrlSuffix_;
                this.bitField0_ |= 0x100000;
                this.onChanged();
            }
            if (other.hasTargetingSetting()) {
                this.mergeTargetingSetting(other.getTargetingSetting());
            }
            if (other.hasAudienceSetting()) {
                this.mergeAudienceSetting(other.getAudienceSetting());
            }
            if (other.hasEffectiveTargetCpaMicros()) {
                this.setEffectiveTargetCpaMicros(other.getEffectiveTargetCpaMicros());
            }
            if (other.effectiveTargetCpaSource_ != 0) {
                this.setEffectiveTargetCpaSourceValue(other.getEffectiveTargetCpaSourceValue());
            }
            if (other.hasEffectiveTargetRoas()) {
                this.setEffectiveTargetRoas(other.getEffectiveTargetRoas());
            }
            if (other.effectiveTargetRoasSource_ != 0) {
                this.setEffectiveTargetRoasSourceValue(other.getEffectiveTargetRoasSourceValue());
            }
            if (!other.labels_.isEmpty()) {
                if (this.labels_.isEmpty()) {
                    this.labels_ = other.labels_;
                    this.bitField0_ |= 0x8000000;
                } else {
                    this.ensureLabelsIsMutable();
                    this.labels_.addAll((Collection)other.labels_);
                }
                this.onChanged();
            }
            if (!other.excludedParentAssetFieldTypes_.isEmpty()) {
                if (this.excludedParentAssetFieldTypes_.isEmpty()) {
                    this.excludedParentAssetFieldTypes_ = other.excludedParentAssetFieldTypes_;
                    this.bitField0_ &= 0xEFFFFFFF;
                } else {
                    this.ensureExcludedParentAssetFieldTypesIsMutable();
                    this.excludedParentAssetFieldTypes_.addAll(other.excludedParentAssetFieldTypes_);
                }
                this.onChanged();
            }
            if (!other.excludedParentAssetSetTypes_.isEmpty()) {
                if (this.excludedParentAssetSetTypes_.isEmpty()) {
                    this.excludedParentAssetSetTypes_ = other.excludedParentAssetSetTypes_;
                    this.bitField0_ &= 0xDFFFFFFF;
                } else {
                    this.ensureExcludedParentAssetSetTypesIsMutable();
                    this.excludedParentAssetSetTypes_.addAll(other.excludedParentAssetSetTypes_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block40: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block40;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block40;
                        }
                        case 40: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block40;
                        }
                        case 50: {
                            CustomParameter m = (CustomParameter)input.readMessage(CustomParameter.parser(), extensionRegistry);
                            if (this.urlCustomParametersBuilder_ == null) {
                                this.ensureUrlCustomParametersIsMutable();
                                this.urlCustomParameters_.add(m);
                                continue block40;
                            }
                            this.urlCustomParametersBuilder_.addMessage((AbstractMessage)m);
                            continue block40;
                        }
                        case 96: {
                            this.type_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block40;
                        }
                        case 176: {
                            this.adRotationMode_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block40;
                        }
                        case 184: {
                            this.displayCustomBidDimension_ = input.readEnum();
                            this.bitField0_ |= 0x80000;
                            continue block40;
                        }
                        case 202: {
                            input.readMessage((MessageLite.Builder)this.getTargetingSettingFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200000;
                            continue block40;
                        }
                        case 232: {
                            this.effectiveTargetCpaSource_ = input.readEnum();
                            this.bitField0_ |= 0x1000000;
                            continue block40;
                        }
                        case 256: {
                            this.effectiveTargetRoasSource_ = input.readEnum();
                            this.bitField0_ |= 0x4000000;
                            continue block40;
                        }
                        case 272: {
                            this.id_ = input.readInt64();
                            this.bitField0_ |= 2;
                            continue block40;
                        }
                        case 282: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block40;
                        }
                        case 290: {
                            this.baseAdGroup_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block40;
                        }
                        case 298: {
                            this.trackingUrlTemplate_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block40;
                        }
                        case 306: {
                            this.campaign_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x200;
                            continue block40;
                        }
                        case 312: {
                            this.cpcBidMicros_ = input.readInt64();
                            this.bitField0_ |= 0x400;
                            continue block40;
                        }
                        case 320: {
                            this.cpmBidMicros_ = input.readInt64();
                            this.bitField0_ |= 0x1000;
                            continue block40;
                        }
                        case 328: {
                            this.targetCpaMicros_ = input.readInt64();
                            this.bitField0_ |= 0x2000;
                            continue block40;
                        }
                        case 336: {
                            this.cpvBidMicros_ = input.readInt64();
                            this.bitField0_ |= 0x4000;
                            continue block40;
                        }
                        case 344: {
                            this.targetCpmMicros_ = input.readInt64();
                            this.bitField0_ |= 0x8000;
                            continue block40;
                        }
                        case 353: {
                            this.targetRoas_ = input.readDouble();
                            this.bitField0_ |= 0x10000;
                            continue block40;
                        }
                        case 360: {
                            this.percentCpcBidMicros_ = input.readInt64();
                            this.bitField0_ |= 0x20000;
                            continue block40;
                        }
                        case 370: {
                            this.finalUrlSuffix_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x100000;
                            continue block40;
                        }
                        case 376: {
                            this.effectiveTargetCpaMicros_ = input.readInt64();
                            this.bitField0_ |= 0x800000;
                            continue block40;
                        }
                        case 385: {
                            this.effectiveTargetRoas_ = input.readDouble();
                            this.bitField0_ |= 0x2000000;
                            continue block40;
                        }
                        case 394: {
                            String s = input.readStringRequireUtf8();
                            this.ensureLabelsIsMutable();
                            this.labels_.add((Object)s);
                            continue block40;
                        }
                        case 432: {
                            int tmpRaw = input.readEnum();
                            this.ensureExcludedParentAssetFieldTypesIsMutable();
                            this.excludedParentAssetFieldTypes_.add(tmpRaw);
                            continue block40;
                        }
                        case 434: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureExcludedParentAssetFieldTypesIsMutable();
                                this.excludedParentAssetFieldTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block40;
                        }
                        case 450: {
                            input.readMessage((MessageLite.Builder)this.getAudienceSettingFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400000;
                            continue block40;
                        }
                        case 456: {
                            this.effectiveCpcBidMicros_ = input.readInt64();
                            this.bitField0_ |= 0x800;
                            continue block40;
                        }
                        case 464: {
                            int tmpRaw = input.readEnum();
                            this.ensureExcludedParentAssetSetTypesIsMutable();
                            this.excludedParentAssetSetTypes_.add(tmpRaw);
                            continue block40;
                        }
                        case 466: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureExcludedParentAssetSetTypesIsMutable();
                                this.excludedParentAssetSetTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block40;
                        }
                        case 472: {
                            this.optimizedTargetingEnabled_ = input.readBool();
                            this.bitField0_ |= 0x40000;
                            continue block40;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = AdGroup.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroup.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasId() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public long getId() {
            return this.id_;
        }

        public Builder setId(long value) {
            this.id_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.id_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasName() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = AdGroup.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroup.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public AdGroupStatusEnum.AdGroupStatus getStatus() {
            AdGroupStatusEnum.AdGroupStatus result = AdGroupStatusEnum.AdGroupStatus.forNumber(this.status_);
            return result == null ? AdGroupStatusEnum.AdGroupStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(AdGroupStatusEnum.AdGroupStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        public Builder setTypeValue(int value) {
            this.type_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public AdGroupTypeEnum.AdGroupType getType() {
            AdGroupTypeEnum.AdGroupType result = AdGroupTypeEnum.AdGroupType.forNumber(this.type_);
            return result == null ? AdGroupTypeEnum.AdGroupType.UNRECOGNIZED : result;
        }

        public Builder setType(AdGroupTypeEnum.AdGroupType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.type_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.type_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getAdRotationModeValue() {
            return this.adRotationMode_;
        }

        public Builder setAdRotationModeValue(int value) {
            this.adRotationMode_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public AdGroupAdRotationModeEnum.AdGroupAdRotationMode getAdRotationMode() {
            AdGroupAdRotationModeEnum.AdGroupAdRotationMode result = AdGroupAdRotationModeEnum.AdGroupAdRotationMode.forNumber(this.adRotationMode_);
            return result == null ? AdGroupAdRotationModeEnum.AdGroupAdRotationMode.UNRECOGNIZED : result;
        }

        public Builder setAdRotationMode(AdGroupAdRotationModeEnum.AdGroupAdRotationMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.adRotationMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAdRotationMode() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.adRotationMode_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasBaseAdGroup() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public String getBaseAdGroup() {
            Object ref = this.baseAdGroup_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.baseAdGroup_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getBaseAdGroupBytes() {
            Object ref = this.baseAdGroup_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.baseAdGroup_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setBaseAdGroup(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.baseAdGroup_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearBaseAdGroup() {
            this.baseAdGroup_ = AdGroup.getDefaultInstance().getBaseAdGroup();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setBaseAdGroupBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroup.checkByteStringIsUtf8((ByteString)value);
            this.baseAdGroup_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTrackingUrlTemplate() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public String getTrackingUrlTemplate() {
            Object ref = this.trackingUrlTemplate_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.trackingUrlTemplate_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTrackingUrlTemplateBytes() {
            Object ref = this.trackingUrlTemplate_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.trackingUrlTemplate_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTrackingUrlTemplate(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.trackingUrlTemplate_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearTrackingUrlTemplate() {
            this.trackingUrlTemplate_ = AdGroup.getDefaultInstance().getTrackingUrlTemplate();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setTrackingUrlTemplateBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroup.checkByteStringIsUtf8((ByteString)value);
            this.trackingUrlTemplate_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        private void ensureUrlCustomParametersIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.urlCustomParameters_ = new ArrayList<CustomParameter>(this.urlCustomParameters_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<CustomParameter> getUrlCustomParametersList() {
            if (this.urlCustomParametersBuilder_ == null) {
                return Collections.unmodifiableList(this.urlCustomParameters_);
            }
            return this.urlCustomParametersBuilder_.getMessageList();
        }

        @Override
        public int getUrlCustomParametersCount() {
            if (this.urlCustomParametersBuilder_ == null) {
                return this.urlCustomParameters_.size();
            }
            return this.urlCustomParametersBuilder_.getCount();
        }

        @Override
        public CustomParameter getUrlCustomParameters(int index) {
            if (this.urlCustomParametersBuilder_ == null) {
                return this.urlCustomParameters_.get(index);
            }
            return (CustomParameter)this.urlCustomParametersBuilder_.getMessage(index);
        }

        public Builder setUrlCustomParameters(int index, CustomParameter value) {
            if (this.urlCustomParametersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureUrlCustomParametersIsMutable();
                this.urlCustomParameters_.set(index, value);
                this.onChanged();
            } else {
                this.urlCustomParametersBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setUrlCustomParameters(int index, CustomParameter.Builder builderForValue) {
            if (this.urlCustomParametersBuilder_ == null) {
                this.ensureUrlCustomParametersIsMutable();
                this.urlCustomParameters_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.urlCustomParametersBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addUrlCustomParameters(CustomParameter value) {
            if (this.urlCustomParametersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureUrlCustomParametersIsMutable();
                this.urlCustomParameters_.add(value);
                this.onChanged();
            } else {
                this.urlCustomParametersBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addUrlCustomParameters(int index, CustomParameter value) {
            if (this.urlCustomParametersBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureUrlCustomParametersIsMutable();
                this.urlCustomParameters_.add(index, value);
                this.onChanged();
            } else {
                this.urlCustomParametersBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addUrlCustomParameters(CustomParameter.Builder builderForValue) {
            if (this.urlCustomParametersBuilder_ == null) {
                this.ensureUrlCustomParametersIsMutable();
                this.urlCustomParameters_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.urlCustomParametersBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addUrlCustomParameters(int index, CustomParameter.Builder builderForValue) {
            if (this.urlCustomParametersBuilder_ == null) {
                this.ensureUrlCustomParametersIsMutable();
                this.urlCustomParameters_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.urlCustomParametersBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllUrlCustomParameters(Iterable<? extends CustomParameter> values) {
            if (this.urlCustomParametersBuilder_ == null) {
                this.ensureUrlCustomParametersIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.urlCustomParameters_);
                this.onChanged();
            } else {
                this.urlCustomParametersBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearUrlCustomParameters() {
            if (this.urlCustomParametersBuilder_ == null) {
                this.urlCustomParameters_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFEFF;
                this.onChanged();
            } else {
                this.urlCustomParametersBuilder_.clear();
            }
            return this;
        }

        public Builder removeUrlCustomParameters(int index) {
            if (this.urlCustomParametersBuilder_ == null) {
                this.ensureUrlCustomParametersIsMutable();
                this.urlCustomParameters_.remove(index);
                this.onChanged();
            } else {
                this.urlCustomParametersBuilder_.remove(index);
            }
            return this;
        }

        public CustomParameter.Builder getUrlCustomParametersBuilder(int index) {
            return (CustomParameter.Builder)this.getUrlCustomParametersFieldBuilder().getBuilder(index);
        }

        @Override
        public CustomParameterOrBuilder getUrlCustomParametersOrBuilder(int index) {
            if (this.urlCustomParametersBuilder_ == null) {
                return this.urlCustomParameters_.get(index);
            }
            return (CustomParameterOrBuilder)this.urlCustomParametersBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends CustomParameterOrBuilder> getUrlCustomParametersOrBuilderList() {
            if (this.urlCustomParametersBuilder_ != null) {
                return this.urlCustomParametersBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.urlCustomParameters_);
        }

        public CustomParameter.Builder addUrlCustomParametersBuilder() {
            return (CustomParameter.Builder)this.getUrlCustomParametersFieldBuilder().addBuilder((AbstractMessage)CustomParameter.getDefaultInstance());
        }

        public CustomParameter.Builder addUrlCustomParametersBuilder(int index) {
            return (CustomParameter.Builder)this.getUrlCustomParametersFieldBuilder().addBuilder(index, (AbstractMessage)CustomParameter.getDefaultInstance());
        }

        public List<CustomParameter.Builder> getUrlCustomParametersBuilderList() {
            return this.getUrlCustomParametersFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<CustomParameter, CustomParameter.Builder, CustomParameterOrBuilder> getUrlCustomParametersFieldBuilder() {
            if (this.urlCustomParametersBuilder_ == null) {
                this.urlCustomParametersBuilder_ = new RepeatedFieldBuilderV3(this.urlCustomParameters_, (this.bitField0_ & 0x100) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.urlCustomParameters_ = null;
            }
            return this.urlCustomParametersBuilder_;
        }

        @Override
        public boolean hasCampaign() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public String getCampaign() {
            Object ref = this.campaign_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.campaign_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCampaignBytes() {
            Object ref = this.campaign_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.campaign_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCampaign(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.campaign_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearCampaign() {
            this.campaign_ = AdGroup.getDefaultInstance().getCampaign();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder setCampaignBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroup.checkByteStringIsUtf8((ByteString)value);
            this.campaign_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCpcBidMicros() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public long getCpcBidMicros() {
            return this.cpcBidMicros_;
        }

        public Builder setCpcBidMicros(long value) {
            this.cpcBidMicros_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearCpcBidMicros() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.cpcBidMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasEffectiveCpcBidMicros() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public long getEffectiveCpcBidMicros() {
            return this.effectiveCpcBidMicros_;
        }

        public Builder setEffectiveCpcBidMicros(long value) {
            this.effectiveCpcBidMicros_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearEffectiveCpcBidMicros() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.effectiveCpcBidMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCpmBidMicros() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public long getCpmBidMicros() {
            return this.cpmBidMicros_;
        }

        public Builder setCpmBidMicros(long value) {
            this.cpmBidMicros_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearCpmBidMicros() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.cpmBidMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTargetCpaMicros() {
            return (this.bitField0_ & 0x2000) != 0;
        }

        @Override
        public long getTargetCpaMicros() {
            return this.targetCpaMicros_;
        }

        public Builder setTargetCpaMicros(long value) {
            this.targetCpaMicros_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearTargetCpaMicros() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.targetCpaMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCpvBidMicros() {
            return (this.bitField0_ & 0x4000) != 0;
        }

        @Override
        public long getCpvBidMicros() {
            return this.cpvBidMicros_;
        }

        public Builder setCpvBidMicros(long value) {
            this.cpvBidMicros_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearCpvBidMicros() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.cpvBidMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTargetCpmMicros() {
            return (this.bitField0_ & 0x8000) != 0;
        }

        @Override
        public long getTargetCpmMicros() {
            return this.targetCpmMicros_;
        }

        public Builder setTargetCpmMicros(long value) {
            this.targetCpmMicros_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearTargetCpmMicros() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.targetCpmMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTargetRoas() {
            return (this.bitField0_ & 0x10000) != 0;
        }

        @Override
        public double getTargetRoas() {
            return this.targetRoas_;
        }

        public Builder setTargetRoas(double value) {
            this.targetRoas_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearTargetRoas() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.targetRoas_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPercentCpcBidMicros() {
            return (this.bitField0_ & 0x20000) != 0;
        }

        @Override
        public long getPercentCpcBidMicros() {
            return this.percentCpcBidMicros_;
        }

        public Builder setPercentCpcBidMicros(long value) {
            this.percentCpcBidMicros_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder clearPercentCpcBidMicros() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.percentCpcBidMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getOptimizedTargetingEnabled() {
            return this.optimizedTargetingEnabled_;
        }

        public Builder setOptimizedTargetingEnabled(boolean value) {
            this.optimizedTargetingEnabled_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        public Builder clearOptimizedTargetingEnabled() {
            this.bitField0_ &= 0xFFFBFFFF;
            this.optimizedTargetingEnabled_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getDisplayCustomBidDimensionValue() {
            return this.displayCustomBidDimension_;
        }

        public Builder setDisplayCustomBidDimensionValue(int value) {
            this.displayCustomBidDimension_ = value;
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return this;
        }

        @Override
        public TargetingDimensionEnum.TargetingDimension getDisplayCustomBidDimension() {
            TargetingDimensionEnum.TargetingDimension result = TargetingDimensionEnum.TargetingDimension.forNumber(this.displayCustomBidDimension_);
            return result == null ? TargetingDimensionEnum.TargetingDimension.UNRECOGNIZED : result;
        }

        public Builder setDisplayCustomBidDimension(TargetingDimensionEnum.TargetingDimension value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x80000;
            this.displayCustomBidDimension_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearDisplayCustomBidDimension() {
            this.bitField0_ &= 0xFFF7FFFF;
            this.displayCustomBidDimension_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasFinalUrlSuffix() {
            return (this.bitField0_ & 0x100000) != 0;
        }

        @Override
        public String getFinalUrlSuffix() {
            Object ref = this.finalUrlSuffix_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.finalUrlSuffix_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFinalUrlSuffixBytes() {
            Object ref = this.finalUrlSuffix_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.finalUrlSuffix_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFinalUrlSuffix(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.finalUrlSuffix_ = value;
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return this;
        }

        public Builder clearFinalUrlSuffix() {
            this.finalUrlSuffix_ = AdGroup.getDefaultInstance().getFinalUrlSuffix();
            this.bitField0_ &= 0xFFEFFFFF;
            this.onChanged();
            return this;
        }

        public Builder setFinalUrlSuffixBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroup.checkByteStringIsUtf8((ByteString)value);
            this.finalUrlSuffix_ = value;
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTargetingSetting() {
            return (this.bitField0_ & 0x200000) != 0;
        }

        @Override
        public TargetingSetting getTargetingSetting() {
            if (this.targetingSettingBuilder_ == null) {
                return this.targetingSetting_ == null ? TargetingSetting.getDefaultInstance() : this.targetingSetting_;
            }
            return (TargetingSetting)this.targetingSettingBuilder_.getMessage();
        }

        public Builder setTargetingSetting(TargetingSetting value) {
            if (this.targetingSettingBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.targetingSetting_ = value;
            } else {
                this.targetingSettingBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return this;
        }

        public Builder setTargetingSetting(TargetingSetting.Builder builderForValue) {
            if (this.targetingSettingBuilder_ == null) {
                this.targetingSetting_ = builderForValue.build();
            } else {
                this.targetingSettingBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return this;
        }

        public Builder mergeTargetingSetting(TargetingSetting value) {
            if (this.targetingSettingBuilder_ == null) {
                if ((this.bitField0_ & 0x200000) != 0 && this.targetingSetting_ != null && this.targetingSetting_ != TargetingSetting.getDefaultInstance()) {
                    this.getTargetingSettingBuilder().mergeFrom(value);
                } else {
                    this.targetingSetting_ = value;
                }
            } else {
                this.targetingSettingBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.targetingSetting_ != null) {
                this.bitField0_ |= 0x200000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearTargetingSetting() {
            this.bitField0_ &= 0xFFDFFFFF;
            this.targetingSetting_ = null;
            if (this.targetingSettingBuilder_ != null) {
                this.targetingSettingBuilder_.dispose();
                this.targetingSettingBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public TargetingSetting.Builder getTargetingSettingBuilder() {
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return (TargetingSetting.Builder)this.getTargetingSettingFieldBuilder().getBuilder();
        }

        @Override
        public TargetingSettingOrBuilder getTargetingSettingOrBuilder() {
            if (this.targetingSettingBuilder_ != null) {
                return (TargetingSettingOrBuilder)this.targetingSettingBuilder_.getMessageOrBuilder();
            }
            return this.targetingSetting_ == null ? TargetingSetting.getDefaultInstance() : this.targetingSetting_;
        }

        private SingleFieldBuilderV3<TargetingSetting, TargetingSetting.Builder, TargetingSettingOrBuilder> getTargetingSettingFieldBuilder() {
            if (this.targetingSettingBuilder_ == null) {
                this.targetingSettingBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTargetingSetting(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.targetingSetting_ = null;
            }
            return this.targetingSettingBuilder_;
        }

        @Override
        public boolean hasAudienceSetting() {
            return (this.bitField0_ & 0x400000) != 0;
        }

        @Override
        public AudienceSetting getAudienceSetting() {
            if (this.audienceSettingBuilder_ == null) {
                return this.audienceSetting_ == null ? AudienceSetting.getDefaultInstance() : this.audienceSetting_;
            }
            return (AudienceSetting)this.audienceSettingBuilder_.getMessage();
        }

        public Builder setAudienceSetting(AudienceSetting value) {
            if (this.audienceSettingBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.audienceSetting_ = value;
            } else {
                this.audienceSettingBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return this;
        }

        public Builder setAudienceSetting(AudienceSetting.Builder builderForValue) {
            if (this.audienceSettingBuilder_ == null) {
                this.audienceSetting_ = builderForValue.build();
            } else {
                this.audienceSettingBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return this;
        }

        public Builder mergeAudienceSetting(AudienceSetting value) {
            if (this.audienceSettingBuilder_ == null) {
                if ((this.bitField0_ & 0x400000) != 0 && this.audienceSetting_ != null && this.audienceSetting_ != AudienceSetting.getDefaultInstance()) {
                    this.getAudienceSettingBuilder().mergeFrom(value);
                } else {
                    this.audienceSetting_ = value;
                }
            } else {
                this.audienceSettingBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.audienceSetting_ != null) {
                this.bitField0_ |= 0x400000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearAudienceSetting() {
            this.bitField0_ &= 0xFFBFFFFF;
            this.audienceSetting_ = null;
            if (this.audienceSettingBuilder_ != null) {
                this.audienceSettingBuilder_.dispose();
                this.audienceSettingBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public AudienceSetting.Builder getAudienceSettingBuilder() {
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return (AudienceSetting.Builder)this.getAudienceSettingFieldBuilder().getBuilder();
        }

        @Override
        public AudienceSettingOrBuilder getAudienceSettingOrBuilder() {
            if (this.audienceSettingBuilder_ != null) {
                return (AudienceSettingOrBuilder)this.audienceSettingBuilder_.getMessageOrBuilder();
            }
            return this.audienceSetting_ == null ? AudienceSetting.getDefaultInstance() : this.audienceSetting_;
        }

        private SingleFieldBuilderV3<AudienceSetting, AudienceSetting.Builder, AudienceSettingOrBuilder> getAudienceSettingFieldBuilder() {
            if (this.audienceSettingBuilder_ == null) {
                this.audienceSettingBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAudienceSetting(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.audienceSetting_ = null;
            }
            return this.audienceSettingBuilder_;
        }

        @Override
        public boolean hasEffectiveTargetCpaMicros() {
            return (this.bitField0_ & 0x800000) != 0;
        }

        @Override
        public long getEffectiveTargetCpaMicros() {
            return this.effectiveTargetCpaMicros_;
        }

        public Builder setEffectiveTargetCpaMicros(long value) {
            this.effectiveTargetCpaMicros_ = value;
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        public Builder clearEffectiveTargetCpaMicros() {
            this.bitField0_ &= 0xFF7FFFFF;
            this.effectiveTargetCpaMicros_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getEffectiveTargetCpaSourceValue() {
            return this.effectiveTargetCpaSource_;
        }

        public Builder setEffectiveTargetCpaSourceValue(int value) {
            this.effectiveTargetCpaSource_ = value;
            this.bitField0_ |= 0x1000000;
            this.onChanged();
            return this;
        }

        @Override
        public BiddingSourceEnum.BiddingSource getEffectiveTargetCpaSource() {
            BiddingSourceEnum.BiddingSource result = BiddingSourceEnum.BiddingSource.forNumber(this.effectiveTargetCpaSource_);
            return result == null ? BiddingSourceEnum.BiddingSource.UNRECOGNIZED : result;
        }

        public Builder setEffectiveTargetCpaSource(BiddingSourceEnum.BiddingSource value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x1000000;
            this.effectiveTargetCpaSource_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearEffectiveTargetCpaSource() {
            this.bitField0_ &= 0xFEFFFFFF;
            this.effectiveTargetCpaSource_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasEffectiveTargetRoas() {
            return (this.bitField0_ & 0x2000000) != 0;
        }

        @Override
        public double getEffectiveTargetRoas() {
            return this.effectiveTargetRoas_;
        }

        public Builder setEffectiveTargetRoas(double value) {
            this.effectiveTargetRoas_ = value;
            this.bitField0_ |= 0x2000000;
            this.onChanged();
            return this;
        }

        public Builder clearEffectiveTargetRoas() {
            this.bitField0_ &= 0xFDFFFFFF;
            this.effectiveTargetRoas_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public int getEffectiveTargetRoasSourceValue() {
            return this.effectiveTargetRoasSource_;
        }

        public Builder setEffectiveTargetRoasSourceValue(int value) {
            this.effectiveTargetRoasSource_ = value;
            this.bitField0_ |= 0x4000000;
            this.onChanged();
            return this;
        }

        @Override
        public BiddingSourceEnum.BiddingSource getEffectiveTargetRoasSource() {
            BiddingSourceEnum.BiddingSource result = BiddingSourceEnum.BiddingSource.forNumber(this.effectiveTargetRoasSource_);
            return result == null ? BiddingSourceEnum.BiddingSource.UNRECOGNIZED : result;
        }

        public Builder setEffectiveTargetRoasSource(BiddingSourceEnum.BiddingSource value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x4000000;
            this.effectiveTargetRoasSource_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearEffectiveTargetRoasSource() {
            this.bitField0_ &= 0xFBFFFFFF;
            this.effectiveTargetRoasSource_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureLabelsIsMutable() {
            if (!this.labels_.isModifiable()) {
                this.labels_ = new LazyStringArrayList((LazyStringList)this.labels_);
            }
            this.bitField0_ |= 0x8000000;
        }

        public ProtocolStringList getLabelsList() {
            this.labels_.makeImmutable();
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.labels_.size();
        }

        @Override
        public String getLabels(int index) {
            return this.labels_.get(index);
        }

        @Override
        public ByteString getLabelsBytes(int index) {
            return this.labels_.getByteString(index);
        }

        public Builder setLabels(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureLabelsIsMutable();
            this.labels_.set(index, value);
            this.bitField0_ |= 0x8000000;
            this.onChanged();
            return this;
        }

        public Builder addLabels(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureLabelsIsMutable();
            this.labels_.add((Object)value);
            this.bitField0_ |= 0x8000000;
            this.onChanged();
            return this;
        }

        public Builder addAllLabels(Iterable<String> values) {
            this.ensureLabelsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.labels_);
            this.bitField0_ |= 0x8000000;
            this.onChanged();
            return this;
        }

        public Builder clearLabels() {
            this.labels_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xF7FFFFFF;
            this.onChanged();
            return this;
        }

        public Builder addLabelsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroup.checkByteStringIsUtf8((ByteString)value);
            this.ensureLabelsIsMutable();
            this.labels_.add(value);
            this.bitField0_ |= 0x8000000;
            this.onChanged();
            return this;
        }

        private void ensureExcludedParentAssetFieldTypesIsMutable() {
            if ((this.bitField0_ & 0x10000000) == 0) {
                this.excludedParentAssetFieldTypes_ = new ArrayList<Integer>(this.excludedParentAssetFieldTypes_);
                this.bitField0_ |= 0x10000000;
            }
        }

        @Override
        public List<AssetFieldTypeEnum.AssetFieldType> getExcludedParentAssetFieldTypesList() {
            return new Internal.ListAdapter(this.excludedParentAssetFieldTypes_, excludedParentAssetFieldTypes_converter_);
        }

        @Override
        public int getExcludedParentAssetFieldTypesCount() {
            return this.excludedParentAssetFieldTypes_.size();
        }

        @Override
        public AssetFieldTypeEnum.AssetFieldType getExcludedParentAssetFieldTypes(int index) {
            return (AssetFieldTypeEnum.AssetFieldType)((Object)excludedParentAssetFieldTypes_converter_.convert((Object)this.excludedParentAssetFieldTypes_.get(index)));
        }

        public Builder setExcludedParentAssetFieldTypes(int index, AssetFieldTypeEnum.AssetFieldType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExcludedParentAssetFieldTypesIsMutable();
            this.excludedParentAssetFieldTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addExcludedParentAssetFieldTypes(AssetFieldTypeEnum.AssetFieldType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExcludedParentAssetFieldTypesIsMutable();
            this.excludedParentAssetFieldTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllExcludedParentAssetFieldTypes(Iterable<? extends AssetFieldTypeEnum.AssetFieldType> values) {
            this.ensureExcludedParentAssetFieldTypesIsMutable();
            for (AssetFieldTypeEnum.AssetFieldType assetFieldType : values) {
                this.excludedParentAssetFieldTypes_.add(assetFieldType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearExcludedParentAssetFieldTypes() {
            this.excludedParentAssetFieldTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xEFFFFFFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getExcludedParentAssetFieldTypesValueList() {
            return Collections.unmodifiableList(this.excludedParentAssetFieldTypes_);
        }

        @Override
        public int getExcludedParentAssetFieldTypesValue(int index) {
            return this.excludedParentAssetFieldTypes_.get(index);
        }

        public Builder setExcludedParentAssetFieldTypesValue(int index, int value) {
            this.ensureExcludedParentAssetFieldTypesIsMutable();
            this.excludedParentAssetFieldTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addExcludedParentAssetFieldTypesValue(int value) {
            this.ensureExcludedParentAssetFieldTypesIsMutable();
            this.excludedParentAssetFieldTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllExcludedParentAssetFieldTypesValue(Iterable<Integer> values) {
            this.ensureExcludedParentAssetFieldTypesIsMutable();
            for (int value : values) {
                this.excludedParentAssetFieldTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureExcludedParentAssetSetTypesIsMutable() {
            if ((this.bitField0_ & 0x20000000) == 0) {
                this.excludedParentAssetSetTypes_ = new ArrayList<Integer>(this.excludedParentAssetSetTypes_);
                this.bitField0_ |= 0x20000000;
            }
        }

        @Override
        public List<AssetSetTypeEnum.AssetSetType> getExcludedParentAssetSetTypesList() {
            return new Internal.ListAdapter(this.excludedParentAssetSetTypes_, excludedParentAssetSetTypes_converter_);
        }

        @Override
        public int getExcludedParentAssetSetTypesCount() {
            return this.excludedParentAssetSetTypes_.size();
        }

        @Override
        public AssetSetTypeEnum.AssetSetType getExcludedParentAssetSetTypes(int index) {
            return (AssetSetTypeEnum.AssetSetType)((Object)excludedParentAssetSetTypes_converter_.convert((Object)this.excludedParentAssetSetTypes_.get(index)));
        }

        public Builder setExcludedParentAssetSetTypes(int index, AssetSetTypeEnum.AssetSetType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExcludedParentAssetSetTypesIsMutable();
            this.excludedParentAssetSetTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addExcludedParentAssetSetTypes(AssetSetTypeEnum.AssetSetType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureExcludedParentAssetSetTypesIsMutable();
            this.excludedParentAssetSetTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllExcludedParentAssetSetTypes(Iterable<? extends AssetSetTypeEnum.AssetSetType> values) {
            this.ensureExcludedParentAssetSetTypesIsMutable();
            for (AssetSetTypeEnum.AssetSetType assetSetType : values) {
                this.excludedParentAssetSetTypes_.add(assetSetType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearExcludedParentAssetSetTypes() {
            this.excludedParentAssetSetTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xDFFFFFFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getExcludedParentAssetSetTypesValueList() {
            return Collections.unmodifiableList(this.excludedParentAssetSetTypes_);
        }

        @Override
        public int getExcludedParentAssetSetTypesValue(int index) {
            return this.excludedParentAssetSetTypes_.get(index);
        }

        public Builder setExcludedParentAssetSetTypesValue(int index, int value) {
            this.ensureExcludedParentAssetSetTypesIsMutable();
            this.excludedParentAssetSetTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addExcludedParentAssetSetTypesValue(int value) {
            this.ensureExcludedParentAssetSetTypesIsMutable();
            this.excludedParentAssetSetTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllExcludedParentAssetSetTypesValue(Iterable<Integer> values) {
            this.ensureExcludedParentAssetSetTypesIsMutable();
            for (int value : values) {
                this.excludedParentAssetSetTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class AudienceSetting
    extends GeneratedMessageV3
    implements AudienceSettingOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int USE_AUDIENCE_GROUPED_FIELD_NUMBER = 1;
        private boolean useAudienceGrouped_ = false;
        private byte memoizedIsInitialized = (byte)-1;
        private static final AudienceSetting DEFAULT_INSTANCE = new AudienceSetting();
        private static final Parser<AudienceSetting> PARSER = new AbstractParser<AudienceSetting>(){

            public AudienceSetting parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = AudienceSetting.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private AudienceSetting(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private AudienceSetting() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new AudienceSetting();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return AdGroupProto.internal_static_google_ads_googleads_v14_resources_AdGroup_AudienceSetting_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AdGroupProto.internal_static_google_ads_googleads_v14_resources_AdGroup_AudienceSetting_fieldAccessorTable.ensureFieldAccessorsInitialized(AudienceSetting.class, Builder.class);
        }

        @Override
        public boolean getUseAudienceGrouped() {
            return this.useAudienceGrouped_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.useAudienceGrouped_) {
                output.writeBool(1, this.useAudienceGrouped_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.useAudienceGrouped_) {
                size += CodedOutputStream.computeBoolSize((int)1, (boolean)this.useAudienceGrouped_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AudienceSetting)) {
                return super.equals(obj);
            }
            AudienceSetting other = (AudienceSetting)obj;
            if (this.getUseAudienceGrouped() != other.getUseAudienceGrouped()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + AudienceSetting.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + Internal.hashBoolean((boolean)this.getUseAudienceGrouped());
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static AudienceSetting parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (AudienceSetting)PARSER.parseFrom(data);
        }

        public static AudienceSetting parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AudienceSetting)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AudienceSetting parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (AudienceSetting)PARSER.parseFrom(data);
        }

        public static AudienceSetting parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AudienceSetting)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AudienceSetting parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (AudienceSetting)PARSER.parseFrom(data);
        }

        public static AudienceSetting parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AudienceSetting)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AudienceSetting parseFrom(InputStream input) throws IOException {
            return (AudienceSetting)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static AudienceSetting parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AudienceSetting)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AudienceSetting parseDelimitedFrom(InputStream input) throws IOException {
            return (AudienceSetting)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static AudienceSetting parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AudienceSetting)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AudienceSetting parseFrom(CodedInputStream input) throws IOException {
            return (AudienceSetting)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static AudienceSetting parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AudienceSetting)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return AudienceSetting.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(AudienceSetting prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static AudienceSetting getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<AudienceSetting> parser() {
            return PARSER;
        }

        public Parser<AudienceSetting> getParserForType() {
            return PARSER;
        }

        public AudienceSetting getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AudienceSettingOrBuilder {
            private int bitField0_;
            private boolean useAudienceGrouped_;

            public static final Descriptors.Descriptor getDescriptor() {
                return AdGroupProto.internal_static_google_ads_googleads_v14_resources_AdGroup_AudienceSetting_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return AdGroupProto.internal_static_google_ads_googleads_v14_resources_AdGroup_AudienceSetting_fieldAccessorTable.ensureFieldAccessorsInitialized(AudienceSetting.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.useAudienceGrouped_ = false;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return AdGroupProto.internal_static_google_ads_googleads_v14_resources_AdGroup_AudienceSetting_descriptor;
            }

            public AudienceSetting getDefaultInstanceForType() {
                return AudienceSetting.getDefaultInstance();
            }

            public AudienceSetting build() {
                AudienceSetting result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public AudienceSetting buildPartial() {
                AudienceSetting result = new AudienceSetting(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(AudienceSetting result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.useAudienceGrouped_ = this.useAudienceGrouped_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof AudienceSetting) {
                    return this.mergeFrom((AudienceSetting)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(AudienceSetting other) {
                if (other == AudienceSetting.getDefaultInstance()) {
                    return this;
                }
                if (other.getUseAudienceGrouped()) {
                    this.setUseAudienceGrouped(other.getUseAudienceGrouped());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 8: {
                                this.useAudienceGrouped_ = input.readBool();
                                this.bitField0_ |= 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean getUseAudienceGrouped() {
                return this.useAudienceGrouped_;
            }

            public Builder setUseAudienceGrouped(boolean value) {
                this.useAudienceGrouped_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearUseAudienceGrouped() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.useAudienceGrouped_ = false;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface AudienceSettingOrBuilder
    extends MessageOrBuilder {
        public boolean getUseAudienceGrouped();
    }
}

