/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupCustomizerName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_CUSTOMIZER_ATTRIBUTE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroupCustomizers/{ad_group_id}~{customizer_attribute_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String customizerAttributeId;

    @Deprecated
    protected AdGroupCustomizerName() {
        this.customerId = null;
        this.adGroupId = null;
        this.customizerAttributeId = null;
    }

    private AdGroupCustomizerName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.customizerAttributeId = (String)Preconditions.checkNotNull((Object)builder.getCustomizerAttributeId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getCustomizerAttributeId() {
        return this.customizerAttributeId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupCustomizerName of(String customerId, String adGroupId, String customizerAttributeId) {
        return AdGroupCustomizerName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setCustomizerAttributeId(customizerAttributeId).build();
    }

    public static String format(String customerId, String adGroupId, String customizerAttributeId) {
        return AdGroupCustomizerName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setCustomizerAttributeId(customizerAttributeId).build().toString();
    }

    public static AdGroupCustomizerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_CUSTOMIZER_ATTRIBUTE_ID.validatedMatch(formattedString, "AdGroupCustomizerName.parse: formattedString not in valid format");
        return AdGroupCustomizerName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("customizer_attribute_id"));
    }

    public static List<AdGroupCustomizerName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupCustomizerName> list = new ArrayList<AdGroupCustomizerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupCustomizerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupCustomizerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupCustomizerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_CUSTOMIZER_ATTRIBUTE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupCustomizerName adGroupCustomizerName = this;
            synchronized (adGroupCustomizerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.customizerAttributeId != null) {
                        fieldMapBuilder.put((Object)"customizer_attribute_id", (Object)this.customizerAttributeId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_CUSTOMIZER_ATTRIBUTE_ID.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "customizer_attribute_id", this.customizerAttributeId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AdGroupCustomizerName that = (AdGroupCustomizerName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.customizerAttributeId, that.customizerAttributeId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customizerAttributeId);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String customizerAttributeId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getCustomizerAttributeId() {
            return this.customizerAttributeId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setCustomizerAttributeId(String customizerAttributeId) {
            this.customizerAttributeId = customizerAttributeId;
            return this;
        }

        private Builder(AdGroupCustomizerName adGroupCustomizerName) {
            this.customerId = adGroupCustomizerName.customerId;
            this.adGroupId = adGroupCustomizerName.adGroupId;
            this.customizerAttributeId = adGroupCustomizerName.customizerAttributeId;
        }

        public AdGroupCustomizerName build() {
            return new AdGroupCustomizerName(this);
        }
    }
}

