/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.ads.googleads.v14.common.MatchingFunction;
import com.google.ads.googleads.v14.common.MatchingFunctionOrBuilder;
import com.google.ads.googleads.v14.enums.FeedLinkStatusEnum;
import com.google.ads.googleads.v14.enums.PlaceholderTypeEnum;
import com.google.ads.googleads.v14.resources.AdGroupFeedOrBuilder;
import com.google.ads.googleads.v14.resources.AdGroupFeedProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AdGroupFeed
extends GeneratedMessageV3
implements AdGroupFeedOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int FEED_FIELD_NUMBER = 7;
    private volatile Object feed_ = "";
    public static final int AD_GROUP_FIELD_NUMBER = 8;
    private volatile Object adGroup_ = "";
    public static final int PLACEHOLDER_TYPES_FIELD_NUMBER = 4;
    private List<Integer> placeholderTypes_;
    private static final Internal.ListAdapter.Converter<Integer, PlaceholderTypeEnum.PlaceholderType> placeholderTypes_converter_ = new Internal.ListAdapter.Converter<Integer, PlaceholderTypeEnum.PlaceholderType>(){

        public PlaceholderTypeEnum.PlaceholderType convert(Integer from) {
            PlaceholderTypeEnum.PlaceholderType result = PlaceholderTypeEnum.PlaceholderType.forNumber(from);
            return result == null ? PlaceholderTypeEnum.PlaceholderType.UNRECOGNIZED : result;
        }
    };
    private int placeholderTypesMemoizedSerializedSize;
    public static final int MATCHING_FUNCTION_FIELD_NUMBER = 5;
    private MatchingFunction matchingFunction_;
    public static final int STATUS_FIELD_NUMBER = 6;
    private int status_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final AdGroupFeed DEFAULT_INSTANCE = new AdGroupFeed();
    private static final Parser<AdGroupFeed> PARSER = new AbstractParser<AdGroupFeed>(){

        public AdGroupFeed parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = AdGroupFeed.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private AdGroupFeed(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private AdGroupFeed() {
        this.resourceName_ = "";
        this.feed_ = "";
        this.adGroup_ = "";
        this.placeholderTypes_ = Collections.emptyList();
        this.status_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new AdGroupFeed();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return AdGroupFeedProto.internal_static_google_ads_googleads_v14_resources_AdGroupFeed_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return AdGroupFeedProto.internal_static_google_ads_googleads_v14_resources_AdGroupFeed_fieldAccessorTable.ensureFieldAccessorsInitialized(AdGroupFeed.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasFeed() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getFeed() {
        Object ref = this.feed_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.feed_ = s;
        return s;
    }

    @Override
    public ByteString getFeedBytes() {
        Object ref = this.feed_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.feed_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasAdGroup() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public String getAdGroup() {
        Object ref = this.adGroup_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.adGroup_ = s;
        return s;
    }

    @Override
    public ByteString getAdGroupBytes() {
        Object ref = this.adGroup_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.adGroup_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<PlaceholderTypeEnum.PlaceholderType> getPlaceholderTypesList() {
        return new Internal.ListAdapter(this.placeholderTypes_, placeholderTypes_converter_);
    }

    @Override
    public int getPlaceholderTypesCount() {
        return this.placeholderTypes_.size();
    }

    @Override
    public PlaceholderTypeEnum.PlaceholderType getPlaceholderTypes(int index) {
        return (PlaceholderTypeEnum.PlaceholderType)((Object)placeholderTypes_converter_.convert((Object)this.placeholderTypes_.get(index)));
    }

    @Override
    public List<Integer> getPlaceholderTypesValueList() {
        return this.placeholderTypes_;
    }

    @Override
    public int getPlaceholderTypesValue(int index) {
        return this.placeholderTypes_.get(index);
    }

    @Override
    public boolean hasMatchingFunction() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public MatchingFunction getMatchingFunction() {
        return this.matchingFunction_ == null ? MatchingFunction.getDefaultInstance() : this.matchingFunction_;
    }

    @Override
    public MatchingFunctionOrBuilder getMatchingFunctionOrBuilder() {
        return this.matchingFunction_ == null ? MatchingFunction.getDefaultInstance() : this.matchingFunction_;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public FeedLinkStatusEnum.FeedLinkStatus getStatus() {
        FeedLinkStatusEnum.FeedLinkStatus result = FeedLinkStatusEnum.FeedLinkStatus.forNumber(this.status_);
        return result == null ? FeedLinkStatusEnum.FeedLinkStatus.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (this.getPlaceholderTypesList().size() > 0) {
            output.writeUInt32NoTag(34);
            output.writeUInt32NoTag(this.placeholderTypesMemoizedSerializedSize);
        }
        for (int i = 0; i < this.placeholderTypes_.size(); ++i) {
            output.writeEnumNoTag(this.placeholderTypes_.get(i).intValue());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(5, (MessageLite)this.getMatchingFunction());
        }
        if (this.status_ != FeedLinkStatusEnum.FeedLinkStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.status_);
        }
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.feed_);
        }
        if ((this.bitField0_ & 2) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.adGroup_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.placeholderTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.placeholderTypes_.get(i));
        }
        size += dataSize;
        if (!this.getPlaceholderTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.placeholderTypesMemoizedSerializedSize = dataSize;
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getMatchingFunction());
        }
        if (this.status_ != FeedLinkStatusEnum.FeedLinkStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.status_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.feed_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)8, (Object)this.adGroup_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdGroupFeed)) {
            return super.equals(obj);
        }
        AdGroupFeed other = (AdGroupFeed)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.hasFeed() != other.hasFeed()) {
            return false;
        }
        if (this.hasFeed() && !this.getFeed().equals(other.getFeed())) {
            return false;
        }
        if (this.hasAdGroup() != other.hasAdGroup()) {
            return false;
        }
        if (this.hasAdGroup() && !this.getAdGroup().equals(other.getAdGroup())) {
            return false;
        }
        if (!this.placeholderTypes_.equals(other.placeholderTypes_)) {
            return false;
        }
        if (this.hasMatchingFunction() != other.hasMatchingFunction()) {
            return false;
        }
        if (this.hasMatchingFunction() && !this.getMatchingFunction().equals(other.getMatchingFunction())) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + AdGroupFeed.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        if (this.hasFeed()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getFeed().hashCode();
        }
        if (this.hasAdGroup()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getAdGroup().hashCode();
        }
        if (this.getPlaceholderTypesCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.placeholderTypes_.hashCode();
        }
        if (this.hasMatchingFunction()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getMatchingFunction().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.status_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static AdGroupFeed parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (AdGroupFeed)PARSER.parseFrom(data);
    }

    public static AdGroupFeed parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AdGroupFeed)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AdGroupFeed parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (AdGroupFeed)PARSER.parseFrom(data);
    }

    public static AdGroupFeed parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AdGroupFeed)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AdGroupFeed parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (AdGroupFeed)PARSER.parseFrom(data);
    }

    public static AdGroupFeed parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AdGroupFeed)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AdGroupFeed parseFrom(InputStream input) throws IOException {
        return (AdGroupFeed)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static AdGroupFeed parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AdGroupFeed)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AdGroupFeed parseDelimitedFrom(InputStream input) throws IOException {
        return (AdGroupFeed)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static AdGroupFeed parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AdGroupFeed)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AdGroupFeed parseFrom(CodedInputStream input) throws IOException {
        return (AdGroupFeed)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static AdGroupFeed parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AdGroupFeed)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return AdGroupFeed.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AdGroupFeed prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static AdGroupFeed getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<AdGroupFeed> parser() {
        return PARSER;
    }

    public Parser<AdGroupFeed> getParserForType() {
        return PARSER;
    }

    public AdGroupFeed getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AdGroupFeedOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private Object feed_ = "";
        private Object adGroup_ = "";
        private List<Integer> placeholderTypes_ = Collections.emptyList();
        private MatchingFunction matchingFunction_;
        private SingleFieldBuilderV3<MatchingFunction, MatchingFunction.Builder, MatchingFunctionOrBuilder> matchingFunctionBuilder_;
        private int status_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return AdGroupFeedProto.internal_static_google_ads_googleads_v14_resources_AdGroupFeed_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return AdGroupFeedProto.internal_static_google_ads_googleads_v14_resources_AdGroupFeed_fieldAccessorTable.ensureFieldAccessorsInitialized(AdGroupFeed.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getMatchingFunctionFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.feed_ = "";
            this.adGroup_ = "";
            this.placeholderTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.matchingFunction_ = null;
            if (this.matchingFunctionBuilder_ != null) {
                this.matchingFunctionBuilder_.dispose();
                this.matchingFunctionBuilder_ = null;
            }
            this.status_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return AdGroupFeedProto.internal_static_google_ads_googleads_v14_resources_AdGroupFeed_descriptor;
        }

        public AdGroupFeed getDefaultInstanceForType() {
            return AdGroupFeed.getDefaultInstance();
        }

        public AdGroupFeed build() {
            AdGroupFeed result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public AdGroupFeed buildPartial() {
            AdGroupFeed result = new AdGroupFeed(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(AdGroupFeed result) {
            if ((this.bitField0_ & 8) != 0) {
                this.placeholderTypes_ = Collections.unmodifiableList(this.placeholderTypes_);
                this.bitField0_ &= 0xFFFFFFF7;
            }
            result.placeholderTypes_ = this.placeholderTypes_;
        }

        private void buildPartial0(AdGroupFeed result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.feed_ = this.feed_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.adGroup_ = this.adGroup_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.matchingFunction_ = this.matchingFunctionBuilder_ == null ? this.matchingFunction_ : (MatchingFunction)this.matchingFunctionBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.status_ = this.status_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof AdGroupFeed) {
                return this.mergeFrom((AdGroupFeed)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(AdGroupFeed other) {
            if (other == AdGroupFeed.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasFeed()) {
                this.feed_ = other.feed_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.hasAdGroup()) {
                this.adGroup_ = other.adGroup_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.placeholderTypes_.isEmpty()) {
                if (this.placeholderTypes_.isEmpty()) {
                    this.placeholderTypes_ = other.placeholderTypes_;
                    this.bitField0_ &= 0xFFFFFFF7;
                } else {
                    this.ensurePlaceholderTypesIsMutable();
                    this.placeholderTypes_.addAll(other.placeholderTypes_);
                }
                this.onChanged();
            }
            if (other.hasMatchingFunction()) {
                this.mergeMatchingFunction(other.getMatchingFunction());
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block15: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block15;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block15;
                        }
                        case 32: {
                            int tmpRaw = input.readEnum();
                            this.ensurePlaceholderTypesIsMutable();
                            this.placeholderTypes_.add(tmpRaw);
                            continue block15;
                        }
                        case 34: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensurePlaceholderTypesIsMutable();
                                this.placeholderTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block15;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getMatchingFunctionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block15;
                        }
                        case 48: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block15;
                        }
                        case 58: {
                            this.feed_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block15;
                        }
                        case 66: {
                            this.adGroup_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block15;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = AdGroupFeed.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroupFeed.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasFeed() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public String getFeed() {
            Object ref = this.feed_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.feed_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFeedBytes() {
            Object ref = this.feed_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.feed_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFeed(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.feed_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearFeed() {
            this.feed_ = AdGroupFeed.getDefaultInstance().getFeed();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setFeedBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroupFeed.checkByteStringIsUtf8((ByteString)value);
            this.feed_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAdGroup() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public String getAdGroup() {
            Object ref = this.adGroup_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.adGroup_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAdGroupBytes() {
            Object ref = this.adGroup_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.adGroup_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAdGroup(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.adGroup_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearAdGroup() {
            this.adGroup_ = AdGroupFeed.getDefaultInstance().getAdGroup();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setAdGroupBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            AdGroupFeed.checkByteStringIsUtf8((ByteString)value);
            this.adGroup_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        private void ensurePlaceholderTypesIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.placeholderTypes_ = new ArrayList<Integer>(this.placeholderTypes_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<PlaceholderTypeEnum.PlaceholderType> getPlaceholderTypesList() {
            return new Internal.ListAdapter(this.placeholderTypes_, placeholderTypes_converter_);
        }

        @Override
        public int getPlaceholderTypesCount() {
            return this.placeholderTypes_.size();
        }

        @Override
        public PlaceholderTypeEnum.PlaceholderType getPlaceholderTypes(int index) {
            return (PlaceholderTypeEnum.PlaceholderType)((Object)placeholderTypes_converter_.convert((Object)this.placeholderTypes_.get(index)));
        }

        public Builder setPlaceholderTypes(int index, PlaceholderTypeEnum.PlaceholderType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePlaceholderTypesIsMutable();
            this.placeholderTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addPlaceholderTypes(PlaceholderTypeEnum.PlaceholderType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePlaceholderTypesIsMutable();
            this.placeholderTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllPlaceholderTypes(Iterable<? extends PlaceholderTypeEnum.PlaceholderType> values) {
            this.ensurePlaceholderTypesIsMutable();
            for (PlaceholderTypeEnum.PlaceholderType placeholderType : values) {
                this.placeholderTypes_.add(placeholderType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearPlaceholderTypes() {
            this.placeholderTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getPlaceholderTypesValueList() {
            return Collections.unmodifiableList(this.placeholderTypes_);
        }

        @Override
        public int getPlaceholderTypesValue(int index) {
            return this.placeholderTypes_.get(index);
        }

        public Builder setPlaceholderTypesValue(int index, int value) {
            this.ensurePlaceholderTypesIsMutable();
            this.placeholderTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addPlaceholderTypesValue(int value) {
            this.ensurePlaceholderTypesIsMutable();
            this.placeholderTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllPlaceholderTypesValue(Iterable<Integer> values) {
            this.ensurePlaceholderTypesIsMutable();
            for (int value : values) {
                this.placeholderTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMatchingFunction() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public MatchingFunction getMatchingFunction() {
            if (this.matchingFunctionBuilder_ == null) {
                return this.matchingFunction_ == null ? MatchingFunction.getDefaultInstance() : this.matchingFunction_;
            }
            return (MatchingFunction)this.matchingFunctionBuilder_.getMessage();
        }

        public Builder setMatchingFunction(MatchingFunction value) {
            if (this.matchingFunctionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.matchingFunction_ = value;
            } else {
                this.matchingFunctionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setMatchingFunction(MatchingFunction.Builder builderForValue) {
            if (this.matchingFunctionBuilder_ == null) {
                this.matchingFunction_ = builderForValue.build();
            } else {
                this.matchingFunctionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeMatchingFunction(MatchingFunction value) {
            if (this.matchingFunctionBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.matchingFunction_ != null && this.matchingFunction_ != MatchingFunction.getDefaultInstance()) {
                    this.getMatchingFunctionBuilder().mergeFrom(value);
                } else {
                    this.matchingFunction_ = value;
                }
            } else {
                this.matchingFunctionBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.matchingFunction_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearMatchingFunction() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.matchingFunction_ = null;
            if (this.matchingFunctionBuilder_ != null) {
                this.matchingFunctionBuilder_.dispose();
                this.matchingFunctionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MatchingFunction.Builder getMatchingFunctionBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (MatchingFunction.Builder)this.getMatchingFunctionFieldBuilder().getBuilder();
        }

        @Override
        public MatchingFunctionOrBuilder getMatchingFunctionOrBuilder() {
            if (this.matchingFunctionBuilder_ != null) {
                return (MatchingFunctionOrBuilder)this.matchingFunctionBuilder_.getMessageOrBuilder();
            }
            return this.matchingFunction_ == null ? MatchingFunction.getDefaultInstance() : this.matchingFunction_;
        }

        private SingleFieldBuilderV3<MatchingFunction, MatchingFunction.Builder, MatchingFunctionOrBuilder> getMatchingFunctionFieldBuilder() {
            if (this.matchingFunctionBuilder_ == null) {
                this.matchingFunctionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMatchingFunction(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.matchingFunction_ = null;
            }
            return this.matchingFunctionBuilder_;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public FeedLinkStatusEnum.FeedLinkStatus getStatus() {
            FeedLinkStatusEnum.FeedLinkStatus result = FeedLinkStatusEnum.FeedLinkStatus.forNumber(this.status_);
            return result == null ? FeedLinkStatusEnum.FeedLinkStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(FeedLinkStatusEnum.FeedLinkStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

