/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetGroupName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ASSET_GROUP_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/assetGroups/{asset_group_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String assetGroupId;

    @Deprecated
    protected AssetGroupName() {
        this.customerId = null;
        this.assetGroupId = null;
    }

    private AssetGroupName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.assetGroupId = (String)Preconditions.checkNotNull((Object)builder.getAssetGroupId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAssetGroupId() {
        return this.assetGroupId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetGroupName of(String customerId, String assetGroupId) {
        return AssetGroupName.newBuilder().setCustomerId(customerId).setAssetGroupId(assetGroupId).build();
    }

    public static String format(String customerId, String assetGroupId) {
        return AssetGroupName.newBuilder().setCustomerId(customerId).setAssetGroupId(assetGroupId).build().toString();
    }

    public static AssetGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ASSET_GROUP_ID.validatedMatch(formattedString, "AssetGroupName.parse: formattedString not in valid format");
        return AssetGroupName.of((String)matchMap.get("customer_id"), (String)matchMap.get("asset_group_id"));
    }

    public static List<AssetGroupName> parseList(List<String> formattedStrings) {
        ArrayList<AssetGroupName> list = new ArrayList<AssetGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ASSET_GROUP_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetGroupName assetGroupName = this;
            synchronized (assetGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.assetGroupId != null) {
                        fieldMapBuilder.put((Object)"asset_group_id", (Object)this.assetGroupId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ASSET_GROUP_ID.instantiate(new String[]{"customer_id", this.customerId, "asset_group_id", this.assetGroupId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AssetGroupName that = (AssetGroupName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.assetGroupId, that.assetGroupId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assetGroupId);
    }

    public static class Builder {
        private String customerId;
        private String assetGroupId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAssetGroupId() {
            return this.assetGroupId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAssetGroupId(String assetGroupId) {
            this.assetGroupId = assetGroupId;
            return this;
        }

        private Builder(AssetGroupName assetGroupName) {
            this.customerId = assetGroupName.customerId;
            this.assetGroupId = assetGroupName.assetGroupId;
        }

        public AssetGroupName build() {
            return new AssetGroupName(this);
        }
    }
}

