/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignExtensionSettingName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_EXTENSION_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignExtensionSettings/{campaign_id}~{extension_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String extensionType;

    @Deprecated
    protected CampaignExtensionSettingName() {
        this.customerId = null;
        this.campaignId = null;
        this.extensionType = null;
    }

    private CampaignExtensionSettingName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.extensionType = (String)Preconditions.checkNotNull((Object)builder.getExtensionType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getExtensionType() {
        return this.extensionType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignExtensionSettingName of(String customerId, String campaignId, String extensionType) {
        return CampaignExtensionSettingName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setExtensionType(extensionType).build();
    }

    public static String format(String customerId, String campaignId, String extensionType) {
        return CampaignExtensionSettingName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setExtensionType(extensionType).build().toString();
    }

    public static CampaignExtensionSettingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_EXTENSION_TYPE.validatedMatch(formattedString, "CampaignExtensionSettingName.parse: formattedString not in valid format");
        return CampaignExtensionSettingName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("extension_type"));
    }

    public static List<CampaignExtensionSettingName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignExtensionSettingName> list = new ArrayList<CampaignExtensionSettingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignExtensionSettingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignExtensionSettingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignExtensionSettingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_EXTENSION_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignExtensionSettingName campaignExtensionSettingName = this;
            synchronized (campaignExtensionSettingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.extensionType != null) {
                        fieldMapBuilder.put((Object)"extension_type", (Object)this.extensionType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_EXTENSION_TYPE.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "extension_type", this.extensionType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CampaignExtensionSettingName that = (CampaignExtensionSettingName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.extensionType, that.extensionType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.extensionType);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String extensionType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getExtensionType() {
            return this.extensionType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setExtensionType(String extensionType) {
            this.extensionType = extensionType;
            return this;
        }

        private Builder(CampaignExtensionSettingName campaignExtensionSettingName) {
            this.customerId = campaignExtensionSettingName.customerId;
            this.campaignId = campaignExtensionSettingName.campaignId;
            this.extensionType = campaignExtensionSettingName.extensionType;
        }

        public CampaignExtensionSettingName build() {
            return new CampaignExtensionSettingName(this);
        }
    }
}

