/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignSearchTermInsightName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_CLUSTER_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignSearchTermInsights/{campaign_id}~{cluster_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String clusterId;

    @Deprecated
    protected CampaignSearchTermInsightName() {
        this.customerId = null;
        this.campaignId = null;
        this.clusterId = null;
    }

    private CampaignSearchTermInsightName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.clusterId = (String)Preconditions.checkNotNull((Object)builder.getClusterId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignSearchTermInsightName of(String customerId, String campaignId, String clusterId) {
        return CampaignSearchTermInsightName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setClusterId(clusterId).build();
    }

    public static String format(String customerId, String campaignId, String clusterId) {
        return CampaignSearchTermInsightName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setClusterId(clusterId).build().toString();
    }

    public static CampaignSearchTermInsightName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_CLUSTER_ID.validatedMatch(formattedString, "CampaignSearchTermInsightName.parse: formattedString not in valid format");
        return CampaignSearchTermInsightName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("cluster_id"));
    }

    public static List<CampaignSearchTermInsightName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignSearchTermInsightName> list = new ArrayList<CampaignSearchTermInsightName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignSearchTermInsightName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignSearchTermInsightName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignSearchTermInsightName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_CLUSTER_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignSearchTermInsightName campaignSearchTermInsightName = this;
            synchronized (campaignSearchTermInsightName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.clusterId != null) {
                        fieldMapBuilder.put((Object)"cluster_id", (Object)this.clusterId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_CLUSTER_ID.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "cluster_id", this.clusterId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CampaignSearchTermInsightName that = (CampaignSearchTermInsightName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.clusterId, that.clusterId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.clusterId);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String clusterId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        private Builder(CampaignSearchTermInsightName campaignSearchTermInsightName) {
            this.customerId = campaignSearchTermInsightName.customerId;
            this.campaignId = campaignSearchTermInsightName.campaignId;
            this.clusterId = campaignSearchTermInsightName.clusterId;
        }

        public CampaignSearchTermInsightName build() {
            return new CampaignSearchTermInsightName(this);
        }
    }
}

