/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.ads.googleads.v14.enums.ConversionActionCategoryEnum;
import com.google.ads.googleads.v14.enums.ConversionValueRuleSetStatusEnum;
import com.google.ads.googleads.v14.enums.ValueRuleSetAttachmentTypeEnum;
import com.google.ads.googleads.v14.enums.ValueRuleSetDimensionEnum;
import com.google.ads.googleads.v14.resources.ConversionValueRuleSetOrBuilder;
import com.google.ads.googleads.v14.resources.ConversionValueRuleSetProto;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ConversionValueRuleSet
extends GeneratedMessageV3
implements ConversionValueRuleSetOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_ = "";
    public static final int ID_FIELD_NUMBER = 2;
    private long id_ = 0L;
    public static final int CONVERSION_VALUE_RULES_FIELD_NUMBER = 3;
    private LazyStringArrayList conversionValueRules_ = LazyStringArrayList.emptyList();
    public static final int DIMENSIONS_FIELD_NUMBER = 4;
    private List<Integer> dimensions_;
    private static final Internal.ListAdapter.Converter<Integer, ValueRuleSetDimensionEnum.ValueRuleSetDimension> dimensions_converter_ = new Internal.ListAdapter.Converter<Integer, ValueRuleSetDimensionEnum.ValueRuleSetDimension>(){

        public ValueRuleSetDimensionEnum.ValueRuleSetDimension convert(Integer from) {
            ValueRuleSetDimensionEnum.ValueRuleSetDimension result = ValueRuleSetDimensionEnum.ValueRuleSetDimension.forNumber(from);
            return result == null ? ValueRuleSetDimensionEnum.ValueRuleSetDimension.UNRECOGNIZED : result;
        }
    };
    private int dimensionsMemoizedSerializedSize;
    public static final int OWNER_CUSTOMER_FIELD_NUMBER = 5;
    private volatile Object ownerCustomer_ = "";
    public static final int ATTACHMENT_TYPE_FIELD_NUMBER = 6;
    private int attachmentType_ = 0;
    public static final int CAMPAIGN_FIELD_NUMBER = 7;
    private volatile Object campaign_ = "";
    public static final int STATUS_FIELD_NUMBER = 8;
    private int status_ = 0;
    public static final int CONVERSION_ACTION_CATEGORIES_FIELD_NUMBER = 9;
    private List<Integer> conversionActionCategories_;
    private static final Internal.ListAdapter.Converter<Integer, ConversionActionCategoryEnum.ConversionActionCategory> conversionActionCategories_converter_ = new Internal.ListAdapter.Converter<Integer, ConversionActionCategoryEnum.ConversionActionCategory>(){

        public ConversionActionCategoryEnum.ConversionActionCategory convert(Integer from) {
            ConversionActionCategoryEnum.ConversionActionCategory result = ConversionActionCategoryEnum.ConversionActionCategory.forNumber(from);
            return result == null ? ConversionActionCategoryEnum.ConversionActionCategory.UNRECOGNIZED : result;
        }
    };
    private int conversionActionCategoriesMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ConversionValueRuleSet DEFAULT_INSTANCE = new ConversionValueRuleSet();
    private static final Parser<ConversionValueRuleSet> PARSER = new AbstractParser<ConversionValueRuleSet>(){

        public ConversionValueRuleSet parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ConversionValueRuleSet.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ConversionValueRuleSet(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ConversionValueRuleSet() {
        this.resourceName_ = "";
        this.conversionValueRules_ = LazyStringArrayList.emptyList();
        this.dimensions_ = Collections.emptyList();
        this.ownerCustomer_ = "";
        this.attachmentType_ = 0;
        this.campaign_ = "";
        this.status_ = 0;
        this.conversionActionCategories_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ConversionValueRuleSet();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ConversionValueRuleSetProto.internal_static_google_ads_googleads_v14_resources_ConversionValueRuleSet_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ConversionValueRuleSetProto.internal_static_google_ads_googleads_v14_resources_ConversionValueRuleSet_fieldAccessorTable.ensureFieldAccessorsInitialized(ConversionValueRuleSet.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public long getId() {
        return this.id_;
    }

    public ProtocolStringList getConversionValueRulesList() {
        return this.conversionValueRules_;
    }

    @Override
    public int getConversionValueRulesCount() {
        return this.conversionValueRules_.size();
    }

    @Override
    public String getConversionValueRules(int index) {
        return this.conversionValueRules_.get(index);
    }

    @Override
    public ByteString getConversionValueRulesBytes(int index) {
        return this.conversionValueRules_.getByteString(index);
    }

    @Override
    public List<ValueRuleSetDimensionEnum.ValueRuleSetDimension> getDimensionsList() {
        return new Internal.ListAdapter(this.dimensions_, dimensions_converter_);
    }

    @Override
    public int getDimensionsCount() {
        return this.dimensions_.size();
    }

    @Override
    public ValueRuleSetDimensionEnum.ValueRuleSetDimension getDimensions(int index) {
        return (ValueRuleSetDimensionEnum.ValueRuleSetDimension)((Object)dimensions_converter_.convert((Object)this.dimensions_.get(index)));
    }

    @Override
    public List<Integer> getDimensionsValueList() {
        return this.dimensions_;
    }

    @Override
    public int getDimensionsValue(int index) {
        return this.dimensions_.get(index);
    }

    @Override
    public String getOwnerCustomer() {
        Object ref = this.ownerCustomer_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.ownerCustomer_ = s;
        return s;
    }

    @Override
    public ByteString getOwnerCustomerBytes() {
        Object ref = this.ownerCustomer_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.ownerCustomer_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getAttachmentTypeValue() {
        return this.attachmentType_;
    }

    @Override
    public ValueRuleSetAttachmentTypeEnum.ValueRuleSetAttachmentType getAttachmentType() {
        ValueRuleSetAttachmentTypeEnum.ValueRuleSetAttachmentType result = ValueRuleSetAttachmentTypeEnum.ValueRuleSetAttachmentType.forNumber(this.attachmentType_);
        return result == null ? ValueRuleSetAttachmentTypeEnum.ValueRuleSetAttachmentType.UNRECOGNIZED : result;
    }

    @Override
    public String getCampaign() {
        Object ref = this.campaign_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.campaign_ = s;
        return s;
    }

    @Override
    public ByteString getCampaignBytes() {
        Object ref = this.campaign_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.campaign_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public ConversionValueRuleSetStatusEnum.ConversionValueRuleSetStatus getStatus() {
        ConversionValueRuleSetStatusEnum.ConversionValueRuleSetStatus result = ConversionValueRuleSetStatusEnum.ConversionValueRuleSetStatus.forNumber(this.status_);
        return result == null ? ConversionValueRuleSetStatusEnum.ConversionValueRuleSetStatus.UNRECOGNIZED : result;
    }

    @Override
    public List<ConversionActionCategoryEnum.ConversionActionCategory> getConversionActionCategoriesList() {
        return new Internal.ListAdapter(this.conversionActionCategories_, conversionActionCategories_converter_);
    }

    @Override
    public int getConversionActionCategoriesCount() {
        return this.conversionActionCategories_.size();
    }

    @Override
    public ConversionActionCategoryEnum.ConversionActionCategory getConversionActionCategories(int index) {
        return (ConversionActionCategoryEnum.ConversionActionCategory)((Object)conversionActionCategories_converter_.convert((Object)this.conversionActionCategories_.get(index)));
    }

    @Override
    public List<Integer> getConversionActionCategoriesValueList() {
        return this.conversionActionCategories_;
    }

    @Override
    public int getConversionActionCategoriesValue(int index) {
        return this.conversionActionCategories_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (this.id_ != 0L) {
            output.writeInt64(2, this.id_);
        }
        for (i = 0; i < this.conversionValueRules_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.conversionValueRules_.getRaw(i));
        }
        if (this.getDimensionsList().size() > 0) {
            output.writeUInt32NoTag(34);
            output.writeUInt32NoTag(this.dimensionsMemoizedSerializedSize);
        }
        for (i = 0; i < this.dimensions_.size(); ++i) {
            output.writeEnumNoTag(this.dimensions_.get(i).intValue());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.ownerCustomer_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.ownerCustomer_);
        }
        if (this.attachmentType_ != ValueRuleSetAttachmentTypeEnum.ValueRuleSetAttachmentType.UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.attachmentType_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.campaign_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.campaign_);
        }
        if (this.status_ != ConversionValueRuleSetStatusEnum.ConversionValueRuleSetStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(8, this.status_);
        }
        if (this.getConversionActionCategoriesList().size() > 0) {
            output.writeUInt32NoTag(74);
            output.writeUInt32NoTag(this.conversionActionCategoriesMemoizedSerializedSize);
        }
        for (i = 0; i < this.conversionActionCategories_.size(); ++i) {
            output.writeEnumNoTag(this.conversionActionCategories_.get(i).intValue());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (this.id_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)2, (long)this.id_);
        }
        int dataSize = 0;
        for (i = 0; i < this.conversionValueRules_.size(); ++i) {
            dataSize += ConversionValueRuleSet.computeStringSizeNoTag((Object)this.conversionValueRules_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getConversionValueRulesList().size();
        dataSize = 0;
        for (i = 0; i < this.dimensions_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.dimensions_.get(i));
        }
        size += dataSize;
        if (!this.getDimensionsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.dimensionsMemoizedSerializedSize = dataSize;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.ownerCustomer_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.ownerCustomer_);
        }
        if (this.attachmentType_ != ValueRuleSetAttachmentTypeEnum.ValueRuleSetAttachmentType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.attachmentType_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.campaign_)) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.campaign_);
        }
        if (this.status_ != ConversionValueRuleSetStatusEnum.ConversionValueRuleSetStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)8, (int)this.status_);
        }
        dataSize = 0;
        for (i = 0; i < this.conversionActionCategories_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.conversionActionCategories_.get(i));
        }
        size += dataSize;
        if (!this.getConversionActionCategoriesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.conversionActionCategoriesMemoizedSerializedSize = dataSize;
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConversionValueRuleSet)) {
            return super.equals(obj);
        }
        ConversionValueRuleSet other = (ConversionValueRuleSet)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (!this.getConversionValueRulesList().equals(other.getConversionValueRulesList())) {
            return false;
        }
        if (!this.dimensions_.equals(other.dimensions_)) {
            return false;
        }
        if (!this.getOwnerCustomer().equals(other.getOwnerCustomer())) {
            return false;
        }
        if (this.attachmentType_ != other.attachmentType_) {
            return false;
        }
        if (!this.getCampaign().equals(other.getCampaign())) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (!this.conversionActionCategories_.equals(other.conversionActionCategories_)) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ConversionValueRuleSet.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + Internal.hashLong((long)this.getId());
        if (this.getConversionValueRulesCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getConversionValueRulesList().hashCode();
        }
        if (this.getDimensionsCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.dimensions_.hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getOwnerCustomer().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + this.attachmentType_;
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getCampaign().hashCode();
        hash = 37 * hash + 8;
        hash = 53 * hash + this.status_;
        if (this.getConversionActionCategoriesCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.conversionActionCategories_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ConversionValueRuleSet parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ConversionValueRuleSet)PARSER.parseFrom(data);
    }

    public static ConversionValueRuleSet parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ConversionValueRuleSet)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ConversionValueRuleSet parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ConversionValueRuleSet)PARSER.parseFrom(data);
    }

    public static ConversionValueRuleSet parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ConversionValueRuleSet)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ConversionValueRuleSet parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ConversionValueRuleSet)PARSER.parseFrom(data);
    }

    public static ConversionValueRuleSet parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ConversionValueRuleSet)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ConversionValueRuleSet parseFrom(InputStream input) throws IOException {
        return (ConversionValueRuleSet)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ConversionValueRuleSet parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ConversionValueRuleSet)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ConversionValueRuleSet parseDelimitedFrom(InputStream input) throws IOException {
        return (ConversionValueRuleSet)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ConversionValueRuleSet parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ConversionValueRuleSet)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ConversionValueRuleSet parseFrom(CodedInputStream input) throws IOException {
        return (ConversionValueRuleSet)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ConversionValueRuleSet parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ConversionValueRuleSet)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ConversionValueRuleSet.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ConversionValueRuleSet prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ConversionValueRuleSet getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ConversionValueRuleSet> parser() {
        return PARSER;
    }

    public Parser<ConversionValueRuleSet> getParserForType() {
        return PARSER;
    }

    public ConversionValueRuleSet getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ConversionValueRuleSetOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private long id_;
        private LazyStringArrayList conversionValueRules_ = LazyStringArrayList.emptyList();
        private List<Integer> dimensions_ = Collections.emptyList();
        private Object ownerCustomer_ = "";
        private int attachmentType_ = 0;
        private Object campaign_ = "";
        private int status_ = 0;
        private List<Integer> conversionActionCategories_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return ConversionValueRuleSetProto.internal_static_google_ads_googleads_v14_resources_ConversionValueRuleSet_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ConversionValueRuleSetProto.internal_static_google_ads_googleads_v14_resources_ConversionValueRuleSet_fieldAccessorTable.ensureFieldAccessorsInitialized(ConversionValueRuleSet.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.resourceName_ = "";
            this.id_ = 0L;
            this.conversionValueRules_ = LazyStringArrayList.emptyList();
            this.dimensions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.ownerCustomer_ = "";
            this.attachmentType_ = 0;
            this.campaign_ = "";
            this.status_ = 0;
            this.conversionActionCategories_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ConversionValueRuleSetProto.internal_static_google_ads_googleads_v14_resources_ConversionValueRuleSet_descriptor;
        }

        public ConversionValueRuleSet getDefaultInstanceForType() {
            return ConversionValueRuleSet.getDefaultInstance();
        }

        public ConversionValueRuleSet build() {
            ConversionValueRuleSet result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ConversionValueRuleSet buildPartial() {
            ConversionValueRuleSet result = new ConversionValueRuleSet(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(ConversionValueRuleSet result) {
            if ((this.bitField0_ & 8) != 0) {
                this.dimensions_ = Collections.unmodifiableList(this.dimensions_);
                this.bitField0_ &= 0xFFFFFFF7;
            }
            result.dimensions_ = this.dimensions_;
            if ((this.bitField0_ & 0x100) != 0) {
                this.conversionActionCategories_ = Collections.unmodifiableList(this.conversionActionCategories_);
                this.bitField0_ &= 0xFFFFFEFF;
            }
            result.conversionActionCategories_ = this.conversionActionCategories_;
        }

        private void buildPartial0(ConversionValueRuleSet result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.resourceName_ = this.resourceName_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.id_ = this.id_;
            }
            if ((from_bitField0_ & 4) != 0) {
                this.conversionValueRules_.makeImmutable();
                result.conversionValueRules_ = this.conversionValueRules_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.ownerCustomer_ = this.ownerCustomer_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.attachmentType_ = this.attachmentType_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.campaign_ = this.campaign_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.status_ = this.status_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ConversionValueRuleSet) {
                return this.mergeFrom((ConversionValueRuleSet)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ConversionValueRuleSet other) {
            if (other == ConversionValueRuleSet.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.getId() != 0L) {
                this.setId(other.getId());
            }
            if (!other.conversionValueRules_.isEmpty()) {
                if (this.conversionValueRules_.isEmpty()) {
                    this.conversionValueRules_ = other.conversionValueRules_;
                    this.bitField0_ |= 4;
                } else {
                    this.ensureConversionValueRulesIsMutable();
                    this.conversionValueRules_.addAll((Collection)other.conversionValueRules_);
                }
                this.onChanged();
            }
            if (!other.dimensions_.isEmpty()) {
                if (this.dimensions_.isEmpty()) {
                    this.dimensions_ = other.dimensions_;
                    this.bitField0_ &= 0xFFFFFFF7;
                } else {
                    this.ensureDimensionsIsMutable();
                    this.dimensions_.addAll(other.dimensions_);
                }
                this.onChanged();
            }
            if (!other.getOwnerCustomer().isEmpty()) {
                this.ownerCustomer_ = other.ownerCustomer_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.attachmentType_ != 0) {
                this.setAttachmentTypeValue(other.getAttachmentTypeValue());
            }
            if (!other.getCampaign().isEmpty()) {
                this.campaign_ = other.campaign_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (!other.conversionActionCategories_.isEmpty()) {
                if (this.conversionActionCategories_.isEmpty()) {
                    this.conversionActionCategories_ = other.conversionActionCategories_;
                    this.bitField0_ &= 0xFFFFFEFF;
                } else {
                    this.ensureConversionActionCategoriesIsMutable();
                    this.conversionActionCategories_.addAll(other.conversionActionCategories_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block19: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block19;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block19;
                        }
                        case 16: {
                            this.id_ = input.readInt64();
                            this.bitField0_ |= 2;
                            continue block19;
                        }
                        case 26: {
                            String s = input.readStringRequireUtf8();
                            this.ensureConversionValueRulesIsMutable();
                            this.conversionValueRules_.add((Object)s);
                            continue block19;
                        }
                        case 32: {
                            int tmpRaw = input.readEnum();
                            this.ensureDimensionsIsMutable();
                            this.dimensions_.add(tmpRaw);
                            continue block19;
                        }
                        case 34: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureDimensionsIsMutable();
                                this.dimensions_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block19;
                        }
                        case 42: {
                            this.ownerCustomer_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block19;
                        }
                        case 48: {
                            this.attachmentType_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block19;
                        }
                        case 58: {
                            this.campaign_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block19;
                        }
                        case 64: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 0x80;
                            continue block19;
                        }
                        case 72: {
                            int tmpRaw = input.readEnum();
                            this.ensureConversionActionCategoriesIsMutable();
                            this.conversionActionCategories_.add(tmpRaw);
                            continue block19;
                        }
                        case 74: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureConversionActionCategoriesIsMutable();
                                this.conversionActionCategories_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block19;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = ConversionValueRuleSet.getDefaultInstance().getResourceName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConversionValueRuleSet.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public long getId() {
            return this.id_;
        }

        public Builder setId(long value) {
            this.id_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.id_ = 0L;
            this.onChanged();
            return this;
        }

        private void ensureConversionValueRulesIsMutable() {
            if (!this.conversionValueRules_.isModifiable()) {
                this.conversionValueRules_ = new LazyStringArrayList((LazyStringList)this.conversionValueRules_);
            }
            this.bitField0_ |= 4;
        }

        public ProtocolStringList getConversionValueRulesList() {
            this.conversionValueRules_.makeImmutable();
            return this.conversionValueRules_;
        }

        @Override
        public int getConversionValueRulesCount() {
            return this.conversionValueRules_.size();
        }

        @Override
        public String getConversionValueRules(int index) {
            return this.conversionValueRules_.get(index);
        }

        @Override
        public ByteString getConversionValueRulesBytes(int index) {
            return this.conversionValueRules_.getByteString(index);
        }

        public Builder setConversionValueRules(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureConversionValueRulesIsMutable();
            this.conversionValueRules_.set(index, value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder addConversionValueRules(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureConversionValueRulesIsMutable();
            this.conversionValueRules_.add((Object)value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder addAllConversionValueRules(Iterable<String> values) {
            this.ensureConversionValueRulesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.conversionValueRules_);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearConversionValueRules() {
            this.conversionValueRules_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder addConversionValueRulesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConversionValueRuleSet.checkByteStringIsUtf8((ByteString)value);
            this.ensureConversionValueRulesIsMutable();
            this.conversionValueRules_.add(value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        private void ensureDimensionsIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.dimensions_ = new ArrayList<Integer>(this.dimensions_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<ValueRuleSetDimensionEnum.ValueRuleSetDimension> getDimensionsList() {
            return new Internal.ListAdapter(this.dimensions_, dimensions_converter_);
        }

        @Override
        public int getDimensionsCount() {
            return this.dimensions_.size();
        }

        @Override
        public ValueRuleSetDimensionEnum.ValueRuleSetDimension getDimensions(int index) {
            return (ValueRuleSetDimensionEnum.ValueRuleSetDimension)((Object)dimensions_converter_.convert((Object)this.dimensions_.get(index)));
        }

        public Builder setDimensions(int index, ValueRuleSetDimensionEnum.ValueRuleSetDimension value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDimensionsIsMutable();
            this.dimensions_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addDimensions(ValueRuleSetDimensionEnum.ValueRuleSetDimension value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDimensionsIsMutable();
            this.dimensions_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllDimensions(Iterable<? extends ValueRuleSetDimensionEnum.ValueRuleSetDimension> values) {
            this.ensureDimensionsIsMutable();
            for (ValueRuleSetDimensionEnum.ValueRuleSetDimension valueRuleSetDimension : values) {
                this.dimensions_.add(valueRuleSetDimension.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearDimensions() {
            this.dimensions_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getDimensionsValueList() {
            return Collections.unmodifiableList(this.dimensions_);
        }

        @Override
        public int getDimensionsValue(int index) {
            return this.dimensions_.get(index);
        }

        public Builder setDimensionsValue(int index, int value) {
            this.ensureDimensionsIsMutable();
            this.dimensions_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addDimensionsValue(int value) {
            this.ensureDimensionsIsMutable();
            this.dimensions_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllDimensionsValue(Iterable<Integer> values) {
            this.ensureDimensionsIsMutable();
            for (int value : values) {
                this.dimensions_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public String getOwnerCustomer() {
            Object ref = this.ownerCustomer_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.ownerCustomer_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getOwnerCustomerBytes() {
            Object ref = this.ownerCustomer_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.ownerCustomer_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setOwnerCustomer(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ownerCustomer_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearOwnerCustomer() {
            this.ownerCustomer_ = ConversionValueRuleSet.getDefaultInstance().getOwnerCustomer();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setOwnerCustomerBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConversionValueRuleSet.checkByteStringIsUtf8((ByteString)value);
            this.ownerCustomer_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public int getAttachmentTypeValue() {
            return this.attachmentType_;
        }

        public Builder setAttachmentTypeValue(int value) {
            this.attachmentType_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public ValueRuleSetAttachmentTypeEnum.ValueRuleSetAttachmentType getAttachmentType() {
            ValueRuleSetAttachmentTypeEnum.ValueRuleSetAttachmentType result = ValueRuleSetAttachmentTypeEnum.ValueRuleSetAttachmentType.forNumber(this.attachmentType_);
            return result == null ? ValueRuleSetAttachmentTypeEnum.ValueRuleSetAttachmentType.UNRECOGNIZED : result;
        }

        public Builder setAttachmentType(ValueRuleSetAttachmentTypeEnum.ValueRuleSetAttachmentType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.attachmentType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAttachmentType() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.attachmentType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getCampaign() {
            Object ref = this.campaign_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.campaign_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCampaignBytes() {
            Object ref = this.campaign_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.campaign_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCampaign(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.campaign_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearCampaign() {
            this.campaign_ = ConversionValueRuleSet.getDefaultInstance().getCampaign();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setCampaignBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            ConversionValueRuleSet.checkByteStringIsUtf8((ByteString)value);
            this.campaign_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public ConversionValueRuleSetStatusEnum.ConversionValueRuleSetStatus getStatus() {
            ConversionValueRuleSetStatusEnum.ConversionValueRuleSetStatus result = ConversionValueRuleSetStatusEnum.ConversionValueRuleSetStatus.forNumber(this.status_);
            return result == null ? ConversionValueRuleSetStatusEnum.ConversionValueRuleSetStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(ConversionValueRuleSetStatusEnum.ConversionValueRuleSetStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x80;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureConversionActionCategoriesIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.conversionActionCategories_ = new ArrayList<Integer>(this.conversionActionCategories_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<ConversionActionCategoryEnum.ConversionActionCategory> getConversionActionCategoriesList() {
            return new Internal.ListAdapter(this.conversionActionCategories_, conversionActionCategories_converter_);
        }

        @Override
        public int getConversionActionCategoriesCount() {
            return this.conversionActionCategories_.size();
        }

        @Override
        public ConversionActionCategoryEnum.ConversionActionCategory getConversionActionCategories(int index) {
            return (ConversionActionCategoryEnum.ConversionActionCategory)((Object)conversionActionCategories_converter_.convert((Object)this.conversionActionCategories_.get(index)));
        }

        public Builder setConversionActionCategories(int index, ConversionActionCategoryEnum.ConversionActionCategory value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureConversionActionCategoriesIsMutable();
            this.conversionActionCategories_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addConversionActionCategories(ConversionActionCategoryEnum.ConversionActionCategory value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureConversionActionCategoriesIsMutable();
            this.conversionActionCategories_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllConversionActionCategories(Iterable<? extends ConversionActionCategoryEnum.ConversionActionCategory> values) {
            this.ensureConversionActionCategoriesIsMutable();
            for (ConversionActionCategoryEnum.ConversionActionCategory conversionActionCategory : values) {
                this.conversionActionCategories_.add(conversionActionCategory.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearConversionActionCategories() {
            this.conversionActionCategories_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getConversionActionCategoriesValueList() {
            return Collections.unmodifiableList(this.conversionActionCategories_);
        }

        @Override
        public int getConversionActionCategoriesValue(int index) {
            return this.conversionActionCategories_.get(index);
        }

        public Builder setConversionActionCategoriesValue(int index, int value) {
            this.ensureConversionActionCategoriesIsMutable();
            this.conversionActionCategories_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addConversionActionCategoriesValue(int value) {
            this.ensureConversionActionCategoriesIsMutable();
            this.conversionActionCategories_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllConversionActionCategoriesValue(Iterable<Integer> values) {
            this.ensureConversionActionCategoriesIsMutable();
            for (int value : values) {
                this.conversionActionCategories_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

