/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExpandedLandingPageViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_EXPANDED_FINAL_URL_FINGERPRINT = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/expandedLandingPageViews/{expanded_final_url_fingerprint}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String expandedFinalUrlFingerprint;

    @Deprecated
    protected ExpandedLandingPageViewName() {
        this.customerId = null;
        this.expandedFinalUrlFingerprint = null;
    }

    private ExpandedLandingPageViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.expandedFinalUrlFingerprint = (String)Preconditions.checkNotNull((Object)builder.getExpandedFinalUrlFingerprint());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getExpandedFinalUrlFingerprint() {
        return this.expandedFinalUrlFingerprint;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExpandedLandingPageViewName of(String customerId, String expandedFinalUrlFingerprint) {
        return ExpandedLandingPageViewName.newBuilder().setCustomerId(customerId).setExpandedFinalUrlFingerprint(expandedFinalUrlFingerprint).build();
    }

    public static String format(String customerId, String expandedFinalUrlFingerprint) {
        return ExpandedLandingPageViewName.newBuilder().setCustomerId(customerId).setExpandedFinalUrlFingerprint(expandedFinalUrlFingerprint).build().toString();
    }

    public static ExpandedLandingPageViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_EXPANDED_FINAL_URL_FINGERPRINT.validatedMatch(formattedString, "ExpandedLandingPageViewName.parse: formattedString not in valid format");
        return ExpandedLandingPageViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("expanded_final_url_fingerprint"));
    }

    public static List<ExpandedLandingPageViewName> parseList(List<String> formattedStrings) {
        ArrayList<ExpandedLandingPageViewName> list = new ArrayList<ExpandedLandingPageViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExpandedLandingPageViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExpandedLandingPageViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExpandedLandingPageViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_EXPANDED_FINAL_URL_FINGERPRINT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExpandedLandingPageViewName expandedLandingPageViewName = this;
            synchronized (expandedLandingPageViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.expandedFinalUrlFingerprint != null) {
                        fieldMapBuilder.put((Object)"expanded_final_url_fingerprint", (Object)this.expandedFinalUrlFingerprint);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_EXPANDED_FINAL_URL_FINGERPRINT.instantiate(new String[]{"customer_id", this.customerId, "expanded_final_url_fingerprint", this.expandedFinalUrlFingerprint});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ExpandedLandingPageViewName that = (ExpandedLandingPageViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.expandedFinalUrlFingerprint, that.expandedFinalUrlFingerprint);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.expandedFinalUrlFingerprint);
    }

    public static class Builder {
        private String customerId;
        private String expandedFinalUrlFingerprint;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getExpandedFinalUrlFingerprint() {
            return this.expandedFinalUrlFingerprint;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setExpandedFinalUrlFingerprint(String expandedFinalUrlFingerprint) {
            this.expandedFinalUrlFingerprint = expandedFinalUrlFingerprint;
            return this;
        }

        private Builder(ExpandedLandingPageViewName expandedLandingPageViewName) {
            this.customerId = expandedLandingPageViewName.customerId;
            this.expandedFinalUrlFingerprint = expandedLandingPageViewName.expandedFinalUrlFingerprint;
        }

        public ExpandedLandingPageViewName build() {
            return new ExpandedLandingPageViewName(this);
        }
    }
}

