/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeywordThemeConstantName
implements ResourceName {
    private static final PathTemplate EXPRESS_CATEGORY_ID_EXPRESS_SUB_CATEGORY_ID = PathTemplate.createWithoutUrlEncoding((String)"keywordThemeConstants/{express_category_id}~{express_sub_category_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String expressCategoryId;
    private final String expressSubCategoryId;

    @Deprecated
    protected KeywordThemeConstantName() {
        this.expressCategoryId = null;
        this.expressSubCategoryId = null;
    }

    private KeywordThemeConstantName(Builder builder) {
        this.expressCategoryId = (String)Preconditions.checkNotNull((Object)builder.getExpressCategoryId());
        this.expressSubCategoryId = (String)Preconditions.checkNotNull((Object)builder.getExpressSubCategoryId());
    }

    public String getExpressCategoryId() {
        return this.expressCategoryId;
    }

    public String getExpressSubCategoryId() {
        return this.expressSubCategoryId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static KeywordThemeConstantName of(String expressCategoryId, String expressSubCategoryId) {
        return KeywordThemeConstantName.newBuilder().setExpressCategoryId(expressCategoryId).setExpressSubCategoryId(expressSubCategoryId).build();
    }

    public static String format(String expressCategoryId, String expressSubCategoryId) {
        return KeywordThemeConstantName.newBuilder().setExpressCategoryId(expressCategoryId).setExpressSubCategoryId(expressSubCategoryId).build().toString();
    }

    public static KeywordThemeConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = EXPRESS_CATEGORY_ID_EXPRESS_SUB_CATEGORY_ID.validatedMatch(formattedString, "KeywordThemeConstantName.parse: formattedString not in valid format");
        return KeywordThemeConstantName.of((String)matchMap.get("express_category_id"), (String)matchMap.get("express_sub_category_id"));
    }

    public static List<KeywordThemeConstantName> parseList(List<String> formattedStrings) {
        ArrayList<KeywordThemeConstantName> list = new ArrayList<KeywordThemeConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeywordThemeConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeywordThemeConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeywordThemeConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return EXPRESS_CATEGORY_ID_EXPRESS_SUB_CATEGORY_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeywordThemeConstantName keywordThemeConstantName = this;
            synchronized (keywordThemeConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.expressCategoryId != null) {
                        fieldMapBuilder.put((Object)"express_category_id", (Object)this.expressCategoryId);
                    }
                    if (this.expressSubCategoryId != null) {
                        fieldMapBuilder.put((Object)"express_sub_category_id", (Object)this.expressSubCategoryId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return EXPRESS_CATEGORY_ID_EXPRESS_SUB_CATEGORY_ID.instantiate(new String[]{"express_category_id", this.expressCategoryId, "express_sub_category_id", this.expressSubCategoryId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            KeywordThemeConstantName that = (KeywordThemeConstantName)o;
            return Objects.equals(this.expressCategoryId, that.expressCategoryId) && Objects.equals(this.expressSubCategoryId, that.expressSubCategoryId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.expressCategoryId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.expressSubCategoryId);
    }

    public static class Builder {
        private String expressCategoryId;
        private String expressSubCategoryId;

        protected Builder() {
        }

        public String getExpressCategoryId() {
            return this.expressCategoryId;
        }

        public String getExpressSubCategoryId() {
            return this.expressSubCategoryId;
        }

        public Builder setExpressCategoryId(String expressCategoryId) {
            this.expressCategoryId = expressCategoryId;
            return this;
        }

        public Builder setExpressSubCategoryId(String expressSubCategoryId) {
            this.expressSubCategoryId = expressSubCategoryId;
            return this;
        }

        private Builder(KeywordThemeConstantName keywordThemeConstantName) {
            this.expressCategoryId = keywordThemeConstantName.expressCategoryId;
            this.expressSubCategoryId = keywordThemeConstantName.expressSubCategoryId;
        }

        public KeywordThemeConstantName build() {
            return new KeywordThemeConstantName(this);
        }
    }
}

