/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.ads.googleads.v14.enums.OfflineConversionDiagnosticStatusEnum;
import com.google.ads.googleads.v14.enums.OfflineEventUploadClientEnum;
import com.google.ads.googleads.v14.resources.CustomerProto;
import com.google.ads.googleads.v14.resources.OfflineConversionClientSummaryOrBuilder;
import com.google.ads.googleads.v14.resources.OfflineConversionUploadAlert;
import com.google.ads.googleads.v14.resources.OfflineConversionUploadAlertOrBuilder;
import com.google.ads.googleads.v14.resources.OfflineConversionUploadSummary;
import com.google.ads.googleads.v14.resources.OfflineConversionUploadSummaryOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OfflineConversionClientSummary
extends GeneratedMessageV3
implements OfflineConversionClientSummaryOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int CLIENT_FIELD_NUMBER = 1;
    private int client_ = 0;
    public static final int STATUS_FIELD_NUMBER = 2;
    private int status_ = 0;
    public static final int TOTAL_EVENT_COUNT_FIELD_NUMBER = 3;
    private long totalEventCount_ = 0L;
    public static final int SUCCESSFUL_EVENT_COUNT_FIELD_NUMBER = 4;
    private long successfulEventCount_ = 0L;
    public static final int SUCCESS_RATE_FIELD_NUMBER = 5;
    private double successRate_ = 0.0;
    public static final int LAST_UPLOAD_DATE_TIME_FIELD_NUMBER = 6;
    private volatile Object lastUploadDateTime_ = "";
    public static final int DAILY_SUMMARIES_FIELD_NUMBER = 7;
    private List<OfflineConversionUploadSummary> dailySummaries_;
    public static final int JOB_SUMMARIES_FIELD_NUMBER = 8;
    private List<OfflineConversionUploadSummary> jobSummaries_;
    public static final int ALERTS_FIELD_NUMBER = 9;
    private List<OfflineConversionUploadAlert> alerts_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final OfflineConversionClientSummary DEFAULT_INSTANCE = new OfflineConversionClientSummary();
    private static final Parser<OfflineConversionClientSummary> PARSER = new AbstractParser<OfflineConversionClientSummary>(){

        public OfflineConversionClientSummary parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = OfflineConversionClientSummary.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private OfflineConversionClientSummary(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private OfflineConversionClientSummary() {
        this.client_ = 0;
        this.status_ = 0;
        this.lastUploadDateTime_ = "";
        this.dailySummaries_ = Collections.emptyList();
        this.jobSummaries_ = Collections.emptyList();
        this.alerts_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new OfflineConversionClientSummary();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CustomerProto.internal_static_google_ads_googleads_v14_resources_OfflineConversionClientSummary_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CustomerProto.internal_static_google_ads_googleads_v14_resources_OfflineConversionClientSummary_fieldAccessorTable.ensureFieldAccessorsInitialized(OfflineConversionClientSummary.class, Builder.class);
    }

    @Override
    public int getClientValue() {
        return this.client_;
    }

    @Override
    public OfflineEventUploadClientEnum.OfflineEventUploadClient getClient() {
        OfflineEventUploadClientEnum.OfflineEventUploadClient result = OfflineEventUploadClientEnum.OfflineEventUploadClient.forNumber(this.client_);
        return result == null ? OfflineEventUploadClientEnum.OfflineEventUploadClient.UNRECOGNIZED : result;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus getStatus() {
        OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus result = OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus.forNumber(this.status_);
        return result == null ? OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus.UNRECOGNIZED : result;
    }

    @Override
    public long getTotalEventCount() {
        return this.totalEventCount_;
    }

    @Override
    public long getSuccessfulEventCount() {
        return this.successfulEventCount_;
    }

    @Override
    public double getSuccessRate() {
        return this.successRate_;
    }

    @Override
    public String getLastUploadDateTime() {
        Object ref = this.lastUploadDateTime_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.lastUploadDateTime_ = s;
        return s;
    }

    @Override
    public ByteString getLastUploadDateTimeBytes() {
        Object ref = this.lastUploadDateTime_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.lastUploadDateTime_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<OfflineConversionUploadSummary> getDailySummariesList() {
        return this.dailySummaries_;
    }

    @Override
    public List<? extends OfflineConversionUploadSummaryOrBuilder> getDailySummariesOrBuilderList() {
        return this.dailySummaries_;
    }

    @Override
    public int getDailySummariesCount() {
        return this.dailySummaries_.size();
    }

    @Override
    public OfflineConversionUploadSummary getDailySummaries(int index) {
        return this.dailySummaries_.get(index);
    }

    @Override
    public OfflineConversionUploadSummaryOrBuilder getDailySummariesOrBuilder(int index) {
        return this.dailySummaries_.get(index);
    }

    @Override
    public List<OfflineConversionUploadSummary> getJobSummariesList() {
        return this.jobSummaries_;
    }

    @Override
    public List<? extends OfflineConversionUploadSummaryOrBuilder> getJobSummariesOrBuilderList() {
        return this.jobSummaries_;
    }

    @Override
    public int getJobSummariesCount() {
        return this.jobSummaries_.size();
    }

    @Override
    public OfflineConversionUploadSummary getJobSummaries(int index) {
        return this.jobSummaries_.get(index);
    }

    @Override
    public OfflineConversionUploadSummaryOrBuilder getJobSummariesOrBuilder(int index) {
        return this.jobSummaries_.get(index);
    }

    @Override
    public List<OfflineConversionUploadAlert> getAlertsList() {
        return this.alerts_;
    }

    @Override
    public List<? extends OfflineConversionUploadAlertOrBuilder> getAlertsOrBuilderList() {
        return this.alerts_;
    }

    @Override
    public int getAlertsCount() {
        return this.alerts_.size();
    }

    @Override
    public OfflineConversionUploadAlert getAlerts(int index) {
        return this.alerts_.get(index);
    }

    @Override
    public OfflineConversionUploadAlertOrBuilder getAlertsOrBuilder(int index) {
        return this.alerts_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (this.client_ != OfflineEventUploadClientEnum.OfflineEventUploadClient.UNSPECIFIED.getNumber()) {
            output.writeEnum(1, this.client_);
        }
        if (this.status_ != OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.status_);
        }
        if (this.totalEventCount_ != 0L) {
            output.writeInt64(3, this.totalEventCount_);
        }
        if (this.successfulEventCount_ != 0L) {
            output.writeInt64(4, this.successfulEventCount_);
        }
        if (Double.doubleToRawLongBits(this.successRate_) != 0L) {
            output.writeDouble(5, this.successRate_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.lastUploadDateTime_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.lastUploadDateTime_);
        }
        for (i = 0; i < this.dailySummaries_.size(); ++i) {
            output.writeMessage(7, (MessageLite)this.dailySummaries_.get(i));
        }
        for (i = 0; i < this.jobSummaries_.size(); ++i) {
            output.writeMessage(8, (MessageLite)this.jobSummaries_.get(i));
        }
        for (i = 0; i < this.alerts_.size(); ++i) {
            output.writeMessage(9, (MessageLite)this.alerts_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.client_ != OfflineEventUploadClientEnum.OfflineEventUploadClient.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)1, (int)this.client_);
        }
        if (this.status_ != OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.status_);
        }
        if (this.totalEventCount_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)3, (long)this.totalEventCount_);
        }
        if (this.successfulEventCount_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)4, (long)this.successfulEventCount_);
        }
        if (Double.doubleToRawLongBits(this.successRate_) != 0L) {
            size += CodedOutputStream.computeDoubleSize((int)5, (double)this.successRate_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.lastUploadDateTime_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.lastUploadDateTime_);
        }
        for (i = 0; i < this.dailySummaries_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)((MessageLite)this.dailySummaries_.get(i)));
        }
        for (i = 0; i < this.jobSummaries_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)((MessageLite)this.jobSummaries_.get(i)));
        }
        for (i = 0; i < this.alerts_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)((MessageLite)this.alerts_.get(i)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OfflineConversionClientSummary)) {
            return super.equals(obj);
        }
        OfflineConversionClientSummary other = (OfflineConversionClientSummary)obj;
        if (this.client_ != other.client_) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (this.getTotalEventCount() != other.getTotalEventCount()) {
            return false;
        }
        if (this.getSuccessfulEventCount() != other.getSuccessfulEventCount()) {
            return false;
        }
        if (Double.doubleToLongBits(this.getSuccessRate()) != Double.doubleToLongBits(other.getSuccessRate())) {
            return false;
        }
        if (!this.getLastUploadDateTime().equals(other.getLastUploadDateTime())) {
            return false;
        }
        if (!this.getDailySummariesList().equals(other.getDailySummariesList())) {
            return false;
        }
        if (!this.getJobSummariesList().equals(other.getJobSummariesList())) {
            return false;
        }
        if (!this.getAlertsList().equals(other.getAlertsList())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + OfflineConversionClientSummary.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.client_;
        hash = 37 * hash + 2;
        hash = 53 * hash + this.status_;
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashLong((long)this.getTotalEventCount());
        hash = 37 * hash + 4;
        hash = 53 * hash + Internal.hashLong((long)this.getSuccessfulEventCount());
        hash = 37 * hash + 5;
        hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getSuccessRate()));
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getLastUploadDateTime().hashCode();
        if (this.getDailySummariesCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getDailySummariesList().hashCode();
        }
        if (this.getJobSummariesCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getJobSummariesList().hashCode();
        }
        if (this.getAlertsCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getAlertsList().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static OfflineConversionClientSummary parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (OfflineConversionClientSummary)PARSER.parseFrom(data);
    }

    public static OfflineConversionClientSummary parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OfflineConversionClientSummary)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OfflineConversionClientSummary parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (OfflineConversionClientSummary)PARSER.parseFrom(data);
    }

    public static OfflineConversionClientSummary parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OfflineConversionClientSummary)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OfflineConversionClientSummary parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (OfflineConversionClientSummary)PARSER.parseFrom(data);
    }

    public static OfflineConversionClientSummary parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OfflineConversionClientSummary)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OfflineConversionClientSummary parseFrom(InputStream input) throws IOException {
        return (OfflineConversionClientSummary)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static OfflineConversionClientSummary parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OfflineConversionClientSummary)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OfflineConversionClientSummary parseDelimitedFrom(InputStream input) throws IOException {
        return (OfflineConversionClientSummary)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static OfflineConversionClientSummary parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OfflineConversionClientSummary)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OfflineConversionClientSummary parseFrom(CodedInputStream input) throws IOException {
        return (OfflineConversionClientSummary)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static OfflineConversionClientSummary parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OfflineConversionClientSummary)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return OfflineConversionClientSummary.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(OfflineConversionClientSummary prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static OfflineConversionClientSummary getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<OfflineConversionClientSummary> parser() {
        return PARSER;
    }

    public Parser<OfflineConversionClientSummary> getParserForType() {
        return PARSER;
    }

    public OfflineConversionClientSummary getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements OfflineConversionClientSummaryOrBuilder {
        private int bitField0_;
        private int client_ = 0;
        private int status_ = 0;
        private long totalEventCount_;
        private long successfulEventCount_;
        private double successRate_;
        private Object lastUploadDateTime_ = "";
        private List<OfflineConversionUploadSummary> dailySummaries_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<OfflineConversionUploadSummary, OfflineConversionUploadSummary.Builder, OfflineConversionUploadSummaryOrBuilder> dailySummariesBuilder_;
        private List<OfflineConversionUploadSummary> jobSummaries_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<OfflineConversionUploadSummary, OfflineConversionUploadSummary.Builder, OfflineConversionUploadSummaryOrBuilder> jobSummariesBuilder_;
        private List<OfflineConversionUploadAlert> alerts_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<OfflineConversionUploadAlert, OfflineConversionUploadAlert.Builder, OfflineConversionUploadAlertOrBuilder> alertsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return CustomerProto.internal_static_google_ads_googleads_v14_resources_OfflineConversionClientSummary_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CustomerProto.internal_static_google_ads_googleads_v14_resources_OfflineConversionClientSummary_fieldAccessorTable.ensureFieldAccessorsInitialized(OfflineConversionClientSummary.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.client_ = 0;
            this.status_ = 0;
            this.totalEventCount_ = 0L;
            this.successfulEventCount_ = 0L;
            this.successRate_ = 0.0;
            this.lastUploadDateTime_ = "";
            if (this.dailySummariesBuilder_ == null) {
                this.dailySummaries_ = Collections.emptyList();
            } else {
                this.dailySummaries_ = null;
                this.dailySummariesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFBF;
            if (this.jobSummariesBuilder_ == null) {
                this.jobSummaries_ = Collections.emptyList();
            } else {
                this.jobSummaries_ = null;
                this.jobSummariesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFF7F;
            if (this.alertsBuilder_ == null) {
                this.alerts_ = Collections.emptyList();
            } else {
                this.alerts_ = null;
                this.alertsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFEFF;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CustomerProto.internal_static_google_ads_googleads_v14_resources_OfflineConversionClientSummary_descriptor;
        }

        public OfflineConversionClientSummary getDefaultInstanceForType() {
            return OfflineConversionClientSummary.getDefaultInstance();
        }

        public OfflineConversionClientSummary build() {
            OfflineConversionClientSummary result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public OfflineConversionClientSummary buildPartial() {
            OfflineConversionClientSummary result = new OfflineConversionClientSummary(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(OfflineConversionClientSummary result) {
            if (this.dailySummariesBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0) {
                    this.dailySummaries_ = Collections.unmodifiableList(this.dailySummaries_);
                    this.bitField0_ &= 0xFFFFFFBF;
                }
                result.dailySummaries_ = this.dailySummaries_;
            } else {
                result.dailySummaries_ = this.dailySummariesBuilder_.build();
            }
            if (this.jobSummariesBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0) {
                    this.jobSummaries_ = Collections.unmodifiableList(this.jobSummaries_);
                    this.bitField0_ &= 0xFFFFFF7F;
                }
                result.jobSummaries_ = this.jobSummaries_;
            } else {
                result.jobSummaries_ = this.jobSummariesBuilder_.build();
            }
            if (this.alertsBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0) {
                    this.alerts_ = Collections.unmodifiableList(this.alerts_);
                    this.bitField0_ &= 0xFFFFFEFF;
                }
                result.alerts_ = this.alerts_;
            } else {
                result.alerts_ = this.alertsBuilder_.build();
            }
        }

        private void buildPartial0(OfflineConversionClientSummary result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.client_ = this.client_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.status_ = this.status_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.totalEventCount_ = this.totalEventCount_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.successfulEventCount_ = this.successfulEventCount_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.successRate_ = this.successRate_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.lastUploadDateTime_ = this.lastUploadDateTime_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof OfflineConversionClientSummary) {
                return this.mergeFrom((OfflineConversionClientSummary)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(OfflineConversionClientSummary other) {
            if (other == OfflineConversionClientSummary.getDefaultInstance()) {
                return this;
            }
            if (other.client_ != 0) {
                this.setClientValue(other.getClientValue());
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (other.getTotalEventCount() != 0L) {
                this.setTotalEventCount(other.getTotalEventCount());
            }
            if (other.getSuccessfulEventCount() != 0L) {
                this.setSuccessfulEventCount(other.getSuccessfulEventCount());
            }
            if (other.getSuccessRate() != 0.0) {
                this.setSuccessRate(other.getSuccessRate());
            }
            if (!other.getLastUploadDateTime().isEmpty()) {
                this.lastUploadDateTime_ = other.lastUploadDateTime_;
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            if (this.dailySummariesBuilder_ == null) {
                if (!other.dailySummaries_.isEmpty()) {
                    if (this.dailySummaries_.isEmpty()) {
                        this.dailySummaries_ = other.dailySummaries_;
                        this.bitField0_ &= 0xFFFFFFBF;
                    } else {
                        this.ensureDailySummariesIsMutable();
                        this.dailySummaries_.addAll(other.dailySummaries_);
                    }
                    this.onChanged();
                }
            } else if (!other.dailySummaries_.isEmpty()) {
                if (this.dailySummariesBuilder_.isEmpty()) {
                    this.dailySummariesBuilder_.dispose();
                    this.dailySummariesBuilder_ = null;
                    this.dailySummaries_ = other.dailySummaries_;
                    this.bitField0_ &= 0xFFFFFFBF;
                    this.dailySummariesBuilder_ = alwaysUseFieldBuilders ? this.getDailySummariesFieldBuilder() : null;
                } else {
                    this.dailySummariesBuilder_.addAllMessages((Iterable)other.dailySummaries_);
                }
            }
            if (this.jobSummariesBuilder_ == null) {
                if (!other.jobSummaries_.isEmpty()) {
                    if (this.jobSummaries_.isEmpty()) {
                        this.jobSummaries_ = other.jobSummaries_;
                        this.bitField0_ &= 0xFFFFFF7F;
                    } else {
                        this.ensureJobSummariesIsMutable();
                        this.jobSummaries_.addAll(other.jobSummaries_);
                    }
                    this.onChanged();
                }
            } else if (!other.jobSummaries_.isEmpty()) {
                if (this.jobSummariesBuilder_.isEmpty()) {
                    this.jobSummariesBuilder_.dispose();
                    this.jobSummariesBuilder_ = null;
                    this.jobSummaries_ = other.jobSummaries_;
                    this.bitField0_ &= 0xFFFFFF7F;
                    this.jobSummariesBuilder_ = alwaysUseFieldBuilders ? this.getJobSummariesFieldBuilder() : null;
                } else {
                    this.jobSummariesBuilder_.addAllMessages((Iterable)other.jobSummaries_);
                }
            }
            if (this.alertsBuilder_ == null) {
                if (!other.alerts_.isEmpty()) {
                    if (this.alerts_.isEmpty()) {
                        this.alerts_ = other.alerts_;
                        this.bitField0_ &= 0xFFFFFEFF;
                    } else {
                        this.ensureAlertsIsMutable();
                        this.alerts_.addAll(other.alerts_);
                    }
                    this.onChanged();
                }
            } else if (!other.alerts_.isEmpty()) {
                if (this.alertsBuilder_.isEmpty()) {
                    this.alertsBuilder_.dispose();
                    this.alertsBuilder_ = null;
                    this.alerts_ = other.alerts_;
                    this.bitField0_ &= 0xFFFFFEFF;
                    this.alertsBuilder_ = alwaysUseFieldBuilders ? this.getAlertsFieldBuilder() : null;
                } else {
                    this.alertsBuilder_.addAllMessages((Iterable)other.alerts_);
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block17: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block17;
                        }
                        case 8: {
                            this.client_ = input.readEnum();
                            this.bitField0_ |= 1;
                            continue block17;
                        }
                        case 16: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block17;
                        }
                        case 24: {
                            this.totalEventCount_ = input.readInt64();
                            this.bitField0_ |= 4;
                            continue block17;
                        }
                        case 32: {
                            this.successfulEventCount_ = input.readInt64();
                            this.bitField0_ |= 8;
                            continue block17;
                        }
                        case 41: {
                            this.successRate_ = input.readDouble();
                            this.bitField0_ |= 0x10;
                            continue block17;
                        }
                        case 50: {
                            this.lastUploadDateTime_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20;
                            continue block17;
                        }
                        case 58: {
                            GeneratedMessageV3 m = (OfflineConversionUploadSummary)input.readMessage(OfflineConversionUploadSummary.parser(), extensionRegistry);
                            if (this.dailySummariesBuilder_ == null) {
                                this.ensureDailySummariesIsMutable();
                                this.dailySummaries_.add((OfflineConversionUploadSummary)m);
                                continue block17;
                            }
                            this.dailySummariesBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                        case 66: {
                            GeneratedMessageV3 m = (OfflineConversionUploadSummary)input.readMessage(OfflineConversionUploadSummary.parser(), extensionRegistry);
                            if (this.jobSummariesBuilder_ == null) {
                                this.ensureJobSummariesIsMutable();
                                this.jobSummaries_.add((OfflineConversionUploadSummary)m);
                                continue block17;
                            }
                            this.jobSummariesBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                        case 74: {
                            GeneratedMessageV3 m = (OfflineConversionUploadAlert)input.readMessage(OfflineConversionUploadAlert.parser(), extensionRegistry);
                            if (this.alertsBuilder_ == null) {
                                this.ensureAlertsIsMutable();
                                this.alerts_.add((OfflineConversionUploadAlert)m);
                                continue block17;
                            }
                            this.alertsBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public int getClientValue() {
            return this.client_;
        }

        public Builder setClientValue(int value) {
            this.client_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public OfflineEventUploadClientEnum.OfflineEventUploadClient getClient() {
            OfflineEventUploadClientEnum.OfflineEventUploadClient result = OfflineEventUploadClientEnum.OfflineEventUploadClient.forNumber(this.client_);
            return result == null ? OfflineEventUploadClientEnum.OfflineEventUploadClient.UNRECOGNIZED : result;
        }

        public Builder setClient(OfflineEventUploadClientEnum.OfflineEventUploadClient value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 1;
            this.client_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearClient() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.client_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus getStatus() {
            OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus result = OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus.forNumber(this.status_);
            return result == null ? OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(OfflineConversionDiagnosticStatusEnum.OfflineConversionDiagnosticStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public long getTotalEventCount() {
            return this.totalEventCount_;
        }

        public Builder setTotalEventCount(long value) {
            this.totalEventCount_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearTotalEventCount() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.totalEventCount_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getSuccessfulEventCount() {
            return this.successfulEventCount_;
        }

        public Builder setSuccessfulEventCount(long value) {
            this.successfulEventCount_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearSuccessfulEventCount() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.successfulEventCount_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public double getSuccessRate() {
            return this.successRate_;
        }

        public Builder setSuccessRate(double value) {
            this.successRate_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearSuccessRate() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.successRate_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public String getLastUploadDateTime() {
            Object ref = this.lastUploadDateTime_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.lastUploadDateTime_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLastUploadDateTimeBytes() {
            Object ref = this.lastUploadDateTime_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.lastUploadDateTime_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLastUploadDateTime(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.lastUploadDateTime_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearLastUploadDateTime() {
            this.lastUploadDateTime_ = OfflineConversionClientSummary.getDefaultInstance().getLastUploadDateTime();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder setLastUploadDateTimeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OfflineConversionClientSummary.checkByteStringIsUtf8((ByteString)value);
            this.lastUploadDateTime_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        private void ensureDailySummariesIsMutable() {
            if ((this.bitField0_ & 0x40) == 0) {
                this.dailySummaries_ = new ArrayList<OfflineConversionUploadSummary>(this.dailySummaries_);
                this.bitField0_ |= 0x40;
            }
        }

        @Override
        public List<OfflineConversionUploadSummary> getDailySummariesList() {
            if (this.dailySummariesBuilder_ == null) {
                return Collections.unmodifiableList(this.dailySummaries_);
            }
            return this.dailySummariesBuilder_.getMessageList();
        }

        @Override
        public int getDailySummariesCount() {
            if (this.dailySummariesBuilder_ == null) {
                return this.dailySummaries_.size();
            }
            return this.dailySummariesBuilder_.getCount();
        }

        @Override
        public OfflineConversionUploadSummary getDailySummaries(int index) {
            if (this.dailySummariesBuilder_ == null) {
                return this.dailySummaries_.get(index);
            }
            return (OfflineConversionUploadSummary)this.dailySummariesBuilder_.getMessage(index);
        }

        public Builder setDailySummaries(int index, OfflineConversionUploadSummary value) {
            if (this.dailySummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.set(index, value);
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setDailySummaries(int index, OfflineConversionUploadSummary.Builder builderForValue) {
            if (this.dailySummariesBuilder_ == null) {
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDailySummaries(OfflineConversionUploadSummary value) {
            if (this.dailySummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.add(value);
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addDailySummaries(int index, OfflineConversionUploadSummary value) {
            if (this.dailySummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.add(index, value);
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addDailySummaries(OfflineConversionUploadSummary.Builder builderForValue) {
            if (this.dailySummariesBuilder_ == null) {
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addDailySummaries(int index, OfflineConversionUploadSummary.Builder builderForValue) {
            if (this.dailySummariesBuilder_ == null) {
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllDailySummaries(Iterable<? extends OfflineConversionUploadSummary> values) {
            if (this.dailySummariesBuilder_ == null) {
                this.ensureDailySummariesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.dailySummaries_);
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearDailySummaries() {
            if (this.dailySummariesBuilder_ == null) {
                this.dailySummaries_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFBF;
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.clear();
            }
            return this;
        }

        public Builder removeDailySummaries(int index) {
            if (this.dailySummariesBuilder_ == null) {
                this.ensureDailySummariesIsMutable();
                this.dailySummaries_.remove(index);
                this.onChanged();
            } else {
                this.dailySummariesBuilder_.remove(index);
            }
            return this;
        }

        public OfflineConversionUploadSummary.Builder getDailySummariesBuilder(int index) {
            return (OfflineConversionUploadSummary.Builder)this.getDailySummariesFieldBuilder().getBuilder(index);
        }

        @Override
        public OfflineConversionUploadSummaryOrBuilder getDailySummariesOrBuilder(int index) {
            if (this.dailySummariesBuilder_ == null) {
                return this.dailySummaries_.get(index);
            }
            return (OfflineConversionUploadSummaryOrBuilder)this.dailySummariesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends OfflineConversionUploadSummaryOrBuilder> getDailySummariesOrBuilderList() {
            if (this.dailySummariesBuilder_ != null) {
                return this.dailySummariesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.dailySummaries_);
        }

        public OfflineConversionUploadSummary.Builder addDailySummariesBuilder() {
            return (OfflineConversionUploadSummary.Builder)this.getDailySummariesFieldBuilder().addBuilder((AbstractMessage)OfflineConversionUploadSummary.getDefaultInstance());
        }

        public OfflineConversionUploadSummary.Builder addDailySummariesBuilder(int index) {
            return (OfflineConversionUploadSummary.Builder)this.getDailySummariesFieldBuilder().addBuilder(index, (AbstractMessage)OfflineConversionUploadSummary.getDefaultInstance());
        }

        public List<OfflineConversionUploadSummary.Builder> getDailySummariesBuilderList() {
            return this.getDailySummariesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<OfflineConversionUploadSummary, OfflineConversionUploadSummary.Builder, OfflineConversionUploadSummaryOrBuilder> getDailySummariesFieldBuilder() {
            if (this.dailySummariesBuilder_ == null) {
                this.dailySummariesBuilder_ = new RepeatedFieldBuilderV3(this.dailySummaries_, (this.bitField0_ & 0x40) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.dailySummaries_ = null;
            }
            return this.dailySummariesBuilder_;
        }

        private void ensureJobSummariesIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.jobSummaries_ = new ArrayList<OfflineConversionUploadSummary>(this.jobSummaries_);
                this.bitField0_ |= 0x80;
            }
        }

        @Override
        public List<OfflineConversionUploadSummary> getJobSummariesList() {
            if (this.jobSummariesBuilder_ == null) {
                return Collections.unmodifiableList(this.jobSummaries_);
            }
            return this.jobSummariesBuilder_.getMessageList();
        }

        @Override
        public int getJobSummariesCount() {
            if (this.jobSummariesBuilder_ == null) {
                return this.jobSummaries_.size();
            }
            return this.jobSummariesBuilder_.getCount();
        }

        @Override
        public OfflineConversionUploadSummary getJobSummaries(int index) {
            if (this.jobSummariesBuilder_ == null) {
                return this.jobSummaries_.get(index);
            }
            return (OfflineConversionUploadSummary)this.jobSummariesBuilder_.getMessage(index);
        }

        public Builder setJobSummaries(int index, OfflineConversionUploadSummary value) {
            if (this.jobSummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.set(index, value);
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setJobSummaries(int index, OfflineConversionUploadSummary.Builder builderForValue) {
            if (this.jobSummariesBuilder_ == null) {
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addJobSummaries(OfflineConversionUploadSummary value) {
            if (this.jobSummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.add(value);
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addJobSummaries(int index, OfflineConversionUploadSummary value) {
            if (this.jobSummariesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.add(index, value);
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addJobSummaries(OfflineConversionUploadSummary.Builder builderForValue) {
            if (this.jobSummariesBuilder_ == null) {
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addJobSummaries(int index, OfflineConversionUploadSummary.Builder builderForValue) {
            if (this.jobSummariesBuilder_ == null) {
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllJobSummaries(Iterable<? extends OfflineConversionUploadSummary> values) {
            if (this.jobSummariesBuilder_ == null) {
                this.ensureJobSummariesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.jobSummaries_);
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearJobSummaries() {
            if (this.jobSummariesBuilder_ == null) {
                this.jobSummaries_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFF7F;
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.clear();
            }
            return this;
        }

        public Builder removeJobSummaries(int index) {
            if (this.jobSummariesBuilder_ == null) {
                this.ensureJobSummariesIsMutable();
                this.jobSummaries_.remove(index);
                this.onChanged();
            } else {
                this.jobSummariesBuilder_.remove(index);
            }
            return this;
        }

        public OfflineConversionUploadSummary.Builder getJobSummariesBuilder(int index) {
            return (OfflineConversionUploadSummary.Builder)this.getJobSummariesFieldBuilder().getBuilder(index);
        }

        @Override
        public OfflineConversionUploadSummaryOrBuilder getJobSummariesOrBuilder(int index) {
            if (this.jobSummariesBuilder_ == null) {
                return this.jobSummaries_.get(index);
            }
            return (OfflineConversionUploadSummaryOrBuilder)this.jobSummariesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends OfflineConversionUploadSummaryOrBuilder> getJobSummariesOrBuilderList() {
            if (this.jobSummariesBuilder_ != null) {
                return this.jobSummariesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.jobSummaries_);
        }

        public OfflineConversionUploadSummary.Builder addJobSummariesBuilder() {
            return (OfflineConversionUploadSummary.Builder)this.getJobSummariesFieldBuilder().addBuilder((AbstractMessage)OfflineConversionUploadSummary.getDefaultInstance());
        }

        public OfflineConversionUploadSummary.Builder addJobSummariesBuilder(int index) {
            return (OfflineConversionUploadSummary.Builder)this.getJobSummariesFieldBuilder().addBuilder(index, (AbstractMessage)OfflineConversionUploadSummary.getDefaultInstance());
        }

        public List<OfflineConversionUploadSummary.Builder> getJobSummariesBuilderList() {
            return this.getJobSummariesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<OfflineConversionUploadSummary, OfflineConversionUploadSummary.Builder, OfflineConversionUploadSummaryOrBuilder> getJobSummariesFieldBuilder() {
            if (this.jobSummariesBuilder_ == null) {
                this.jobSummariesBuilder_ = new RepeatedFieldBuilderV3(this.jobSummaries_, (this.bitField0_ & 0x80) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.jobSummaries_ = null;
            }
            return this.jobSummariesBuilder_;
        }

        private void ensureAlertsIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.alerts_ = new ArrayList<OfflineConversionUploadAlert>(this.alerts_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<OfflineConversionUploadAlert> getAlertsList() {
            if (this.alertsBuilder_ == null) {
                return Collections.unmodifiableList(this.alerts_);
            }
            return this.alertsBuilder_.getMessageList();
        }

        @Override
        public int getAlertsCount() {
            if (this.alertsBuilder_ == null) {
                return this.alerts_.size();
            }
            return this.alertsBuilder_.getCount();
        }

        @Override
        public OfflineConversionUploadAlert getAlerts(int index) {
            if (this.alertsBuilder_ == null) {
                return this.alerts_.get(index);
            }
            return (OfflineConversionUploadAlert)this.alertsBuilder_.getMessage(index);
        }

        public Builder setAlerts(int index, OfflineConversionUploadAlert value) {
            if (this.alertsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAlertsIsMutable();
                this.alerts_.set(index, value);
                this.onChanged();
            } else {
                this.alertsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAlerts(int index, OfflineConversionUploadAlert.Builder builderForValue) {
            if (this.alertsBuilder_ == null) {
                this.ensureAlertsIsMutable();
                this.alerts_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.alertsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAlerts(OfflineConversionUploadAlert value) {
            if (this.alertsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAlertsIsMutable();
                this.alerts_.add(value);
                this.onChanged();
            } else {
                this.alertsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAlerts(int index, OfflineConversionUploadAlert value) {
            if (this.alertsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAlertsIsMutable();
                this.alerts_.add(index, value);
                this.onChanged();
            } else {
                this.alertsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAlerts(OfflineConversionUploadAlert.Builder builderForValue) {
            if (this.alertsBuilder_ == null) {
                this.ensureAlertsIsMutable();
                this.alerts_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.alertsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAlerts(int index, OfflineConversionUploadAlert.Builder builderForValue) {
            if (this.alertsBuilder_ == null) {
                this.ensureAlertsIsMutable();
                this.alerts_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.alertsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAlerts(Iterable<? extends OfflineConversionUploadAlert> values) {
            if (this.alertsBuilder_ == null) {
                this.ensureAlertsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.alerts_);
                this.onChanged();
            } else {
                this.alertsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAlerts() {
            if (this.alertsBuilder_ == null) {
                this.alerts_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFEFF;
                this.onChanged();
            } else {
                this.alertsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAlerts(int index) {
            if (this.alertsBuilder_ == null) {
                this.ensureAlertsIsMutable();
                this.alerts_.remove(index);
                this.onChanged();
            } else {
                this.alertsBuilder_.remove(index);
            }
            return this;
        }

        public OfflineConversionUploadAlert.Builder getAlertsBuilder(int index) {
            return (OfflineConversionUploadAlert.Builder)this.getAlertsFieldBuilder().getBuilder(index);
        }

        @Override
        public OfflineConversionUploadAlertOrBuilder getAlertsOrBuilder(int index) {
            if (this.alertsBuilder_ == null) {
                return this.alerts_.get(index);
            }
            return (OfflineConversionUploadAlertOrBuilder)this.alertsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends OfflineConversionUploadAlertOrBuilder> getAlertsOrBuilderList() {
            if (this.alertsBuilder_ != null) {
                return this.alertsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.alerts_);
        }

        public OfflineConversionUploadAlert.Builder addAlertsBuilder() {
            return (OfflineConversionUploadAlert.Builder)this.getAlertsFieldBuilder().addBuilder((AbstractMessage)OfflineConversionUploadAlert.getDefaultInstance());
        }

        public OfflineConversionUploadAlert.Builder addAlertsBuilder(int index) {
            return (OfflineConversionUploadAlert.Builder)this.getAlertsFieldBuilder().addBuilder(index, (AbstractMessage)OfflineConversionUploadAlert.getDefaultInstance());
        }

        public List<OfflineConversionUploadAlert.Builder> getAlertsBuilderList() {
            return this.getAlertsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<OfflineConversionUploadAlert, OfflineConversionUploadAlert.Builder, OfflineConversionUploadAlertOrBuilder> getAlertsFieldBuilder() {
            if (this.alertsBuilder_ == null) {
                this.alertsBuilder_ = new RepeatedFieldBuilderV3(this.alerts_, (this.bitField0_ & 0x100) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.alerts_ = null;
            }
            return this.alertsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

