/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ThirdPartyAppAnalyticsLinkName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CUSTOMER_LINK_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/thirdPartyAppAnalyticsLinks/{customer_link_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String customerLinkId;

    @Deprecated
    protected ThirdPartyAppAnalyticsLinkName() {
        this.customerId = null;
        this.customerLinkId = null;
    }

    private ThirdPartyAppAnalyticsLinkName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.customerLinkId = (String)Preconditions.checkNotNull((Object)builder.getCustomerLinkId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCustomerLinkId() {
        return this.customerLinkId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ThirdPartyAppAnalyticsLinkName of(String customerId, String customerLinkId) {
        return ThirdPartyAppAnalyticsLinkName.newBuilder().setCustomerId(customerId).setCustomerLinkId(customerLinkId).build();
    }

    public static String format(String customerId, String customerLinkId) {
        return ThirdPartyAppAnalyticsLinkName.newBuilder().setCustomerId(customerId).setCustomerLinkId(customerLinkId).build().toString();
    }

    public static ThirdPartyAppAnalyticsLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CUSTOMER_LINK_ID.validatedMatch(formattedString, "ThirdPartyAppAnalyticsLinkName.parse: formattedString not in valid format");
        return ThirdPartyAppAnalyticsLinkName.of((String)matchMap.get("customer_id"), (String)matchMap.get("customer_link_id"));
    }

    public static List<ThirdPartyAppAnalyticsLinkName> parseList(List<String> formattedStrings) {
        ArrayList<ThirdPartyAppAnalyticsLinkName> list = new ArrayList<ThirdPartyAppAnalyticsLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ThirdPartyAppAnalyticsLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ThirdPartyAppAnalyticsLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ThirdPartyAppAnalyticsLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CUSTOMER_LINK_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ThirdPartyAppAnalyticsLinkName thirdPartyAppAnalyticsLinkName = this;
            synchronized (thirdPartyAppAnalyticsLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.customerLinkId != null) {
                        fieldMapBuilder.put((Object)"customer_link_id", (Object)this.customerLinkId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CUSTOMER_LINK_ID.instantiate(new String[]{"customer_id", this.customerId, "customer_link_id", this.customerLinkId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ThirdPartyAppAnalyticsLinkName that = (ThirdPartyAppAnalyticsLinkName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.customerLinkId, that.customerLinkId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customerLinkId);
    }

    public static class Builder {
        private String customerId;
        private String customerLinkId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCustomerLinkId() {
            return this.customerLinkId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCustomerLinkId(String customerLinkId) {
            this.customerLinkId = customerLinkId;
            return this;
        }

        private Builder(ThirdPartyAppAnalyticsLinkName thirdPartyAppAnalyticsLinkName) {
            this.customerId = thirdPartyAppAnalyticsLinkName.customerId;
            this.customerLinkId = thirdPartyAppAnalyticsLinkName.customerLinkId;
        }

        public ThirdPartyAppAnalyticsLinkName build() {
            return new ThirdPartyAppAnalyticsLinkName(this);
        }
    }
}

