/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.services;

import com.google.ads.googleads.v14.enums.AccessRoleEnum;
import com.google.ads.googleads.v14.resources.Customer;
import com.google.ads.googleads.v14.resources.CustomerOrBuilder;
import com.google.ads.googleads.v14.services.CreateCustomerClientRequestOrBuilder;
import com.google.ads.googleads.v14.services.CustomerServiceProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class CreateCustomerClientRequest
extends GeneratedMessageV3
implements CreateCustomerClientRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int CUSTOMER_ID_FIELD_NUMBER = 1;
    private volatile Object customerId_ = "";
    public static final int CUSTOMER_CLIENT_FIELD_NUMBER = 2;
    private Customer customerClient_;
    public static final int EMAIL_ADDRESS_FIELD_NUMBER = 5;
    private volatile Object emailAddress_ = "";
    public static final int ACCESS_ROLE_FIELD_NUMBER = 4;
    private int accessRole_ = 0;
    public static final int VALIDATE_ONLY_FIELD_NUMBER = 6;
    private boolean validateOnly_ = false;
    private byte memoizedIsInitialized = (byte)-1;
    private static final CreateCustomerClientRequest DEFAULT_INSTANCE = new CreateCustomerClientRequest();
    private static final Parser<CreateCustomerClientRequest> PARSER = new AbstractParser<CreateCustomerClientRequest>(){

        public CreateCustomerClientRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = CreateCustomerClientRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private CreateCustomerClientRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private CreateCustomerClientRequest() {
        this.customerId_ = "";
        this.emailAddress_ = "";
        this.accessRole_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new CreateCustomerClientRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CustomerServiceProto.internal_static_google_ads_googleads_v14_services_CreateCustomerClientRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CustomerServiceProto.internal_static_google_ads_googleads_v14_services_CreateCustomerClientRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(CreateCustomerClientRequest.class, Builder.class);
    }

    @Override
    public String getCustomerId() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.customerId_ = s;
        return s;
    }

    @Override
    public ByteString getCustomerIdBytes() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.customerId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasCustomerClient() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Customer getCustomerClient() {
        return this.customerClient_ == null ? Customer.getDefaultInstance() : this.customerClient_;
    }

    @Override
    public CustomerOrBuilder getCustomerClientOrBuilder() {
        return this.customerClient_ == null ? Customer.getDefaultInstance() : this.customerClient_;
    }

    @Override
    public boolean hasEmailAddress() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public String getEmailAddress() {
        Object ref = this.emailAddress_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.emailAddress_ = s;
        return s;
    }

    @Override
    public ByteString getEmailAddressBytes() {
        Object ref = this.emailAddress_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.emailAddress_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getAccessRoleValue() {
        return this.accessRole_;
    }

    @Override
    public AccessRoleEnum.AccessRole getAccessRole() {
        AccessRoleEnum.AccessRole result = AccessRoleEnum.AccessRole.forNumber(this.accessRole_);
        return result == null ? AccessRoleEnum.AccessRole.UNRECOGNIZED : result;
    }

    @Override
    public boolean getValidateOnly() {
        return this.validateOnly_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.customerId_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(2, (MessageLite)this.getCustomerClient());
        }
        if (this.accessRole_ != AccessRoleEnum.AccessRole.UNSPECIFIED.getNumber()) {
            output.writeEnum(4, this.accessRole_);
        }
        if ((this.bitField0_ & 2) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.emailAddress_);
        }
        if (this.validateOnly_) {
            output.writeBool(6, this.validateOnly_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.customerId_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getCustomerClient());
        }
        if (this.accessRole_ != AccessRoleEnum.AccessRole.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.accessRole_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.emailAddress_);
        }
        if (this.validateOnly_) {
            size += CodedOutputStream.computeBoolSize((int)6, (boolean)this.validateOnly_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateCustomerClientRequest)) {
            return super.equals(obj);
        }
        CreateCustomerClientRequest other = (CreateCustomerClientRequest)obj;
        if (!this.getCustomerId().equals(other.getCustomerId())) {
            return false;
        }
        if (this.hasCustomerClient() != other.hasCustomerClient()) {
            return false;
        }
        if (this.hasCustomerClient() && !this.getCustomerClient().equals(other.getCustomerClient())) {
            return false;
        }
        if (this.hasEmailAddress() != other.hasEmailAddress()) {
            return false;
        }
        if (this.hasEmailAddress() && !this.getEmailAddress().equals(other.getEmailAddress())) {
            return false;
        }
        if (this.accessRole_ != other.accessRole_) {
            return false;
        }
        if (this.getValidateOnly() != other.getValidateOnly()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + CreateCustomerClientRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCustomerId().hashCode();
        if (this.hasCustomerClient()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getCustomerClient().hashCode();
        }
        if (this.hasEmailAddress()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getEmailAddress().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + this.accessRole_;
        hash = 37 * hash + 6;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getValidateOnly());
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static CreateCustomerClientRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (CreateCustomerClientRequest)PARSER.parseFrom(data);
    }

    public static CreateCustomerClientRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CreateCustomerClientRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CreateCustomerClientRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (CreateCustomerClientRequest)PARSER.parseFrom(data);
    }

    public static CreateCustomerClientRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CreateCustomerClientRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CreateCustomerClientRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (CreateCustomerClientRequest)PARSER.parseFrom(data);
    }

    public static CreateCustomerClientRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CreateCustomerClientRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CreateCustomerClientRequest parseFrom(InputStream input) throws IOException {
        return (CreateCustomerClientRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static CreateCustomerClientRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CreateCustomerClientRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CreateCustomerClientRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (CreateCustomerClientRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static CreateCustomerClientRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CreateCustomerClientRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CreateCustomerClientRequest parseFrom(CodedInputStream input) throws IOException {
        return (CreateCustomerClientRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static CreateCustomerClientRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CreateCustomerClientRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return CreateCustomerClientRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CreateCustomerClientRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static CreateCustomerClientRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<CreateCustomerClientRequest> parser() {
        return PARSER;
    }

    public Parser<CreateCustomerClientRequest> getParserForType() {
        return PARSER;
    }

    public CreateCustomerClientRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements CreateCustomerClientRequestOrBuilder {
        private int bitField0_;
        private Object customerId_ = "";
        private Customer customerClient_;
        private SingleFieldBuilderV3<Customer, Customer.Builder, CustomerOrBuilder> customerClientBuilder_;
        private Object emailAddress_ = "";
        private int accessRole_ = 0;
        private boolean validateOnly_;

        public static final Descriptors.Descriptor getDescriptor() {
            return CustomerServiceProto.internal_static_google_ads_googleads_v14_services_CreateCustomerClientRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CustomerServiceProto.internal_static_google_ads_googleads_v14_services_CreateCustomerClientRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(CreateCustomerClientRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getCustomerClientFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.customerId_ = "";
            this.customerClient_ = null;
            if (this.customerClientBuilder_ != null) {
                this.customerClientBuilder_.dispose();
                this.customerClientBuilder_ = null;
            }
            this.emailAddress_ = "";
            this.accessRole_ = 0;
            this.validateOnly_ = false;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CustomerServiceProto.internal_static_google_ads_googleads_v14_services_CreateCustomerClientRequest_descriptor;
        }

        public CreateCustomerClientRequest getDefaultInstanceForType() {
            return CreateCustomerClientRequest.getDefaultInstance();
        }

        public CreateCustomerClientRequest build() {
            CreateCustomerClientRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public CreateCustomerClientRequest buildPartial() {
            CreateCustomerClientRequest result = new CreateCustomerClientRequest(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(CreateCustomerClientRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.customerId_ = this.customerId_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.customerClient_ = this.customerClientBuilder_ == null ? this.customerClient_ : (Customer)this.customerClientBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.emailAddress_ = this.emailAddress_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.accessRole_ = this.accessRole_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.validateOnly_ = this.validateOnly_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof CreateCustomerClientRequest) {
                return this.mergeFrom((CreateCustomerClientRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(CreateCustomerClientRequest other) {
            if (other == CreateCustomerClientRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getCustomerId().isEmpty()) {
                this.customerId_ = other.customerId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasCustomerClient()) {
                this.mergeCustomerClient(other.getCustomerClient());
            }
            if (other.hasEmailAddress()) {
                this.emailAddress_ = other.emailAddress_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (other.accessRole_ != 0) {
                this.setAccessRoleValue(other.getAccessRoleValue());
            }
            if (other.getValidateOnly()) {
                this.setValidateOnly(other.getValidateOnly());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block13: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block13;
                        }
                        case 10: {
                            this.customerId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block13;
                        }
                        case 18: {
                            input.readMessage((MessageLite.Builder)this.getCustomerClientFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block13;
                        }
                        case 32: {
                            this.accessRole_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block13;
                        }
                        case 42: {
                            this.emailAddress_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block13;
                        }
                        case 48: {
                            this.validateOnly_ = input.readBool();
                            this.bitField0_ |= 0x10;
                            continue block13;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getCustomerId() {
            Object ref = this.customerId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.customerId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCustomerIdBytes() {
            Object ref = this.customerId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customerId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCustomerId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearCustomerId() {
            this.customerId_ = CreateCustomerClientRequest.getDefaultInstance().getCustomerId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setCustomerIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CreateCustomerClientRequest.checkByteStringIsUtf8((ByteString)value);
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCustomerClient() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public Customer getCustomerClient() {
            if (this.customerClientBuilder_ == null) {
                return this.customerClient_ == null ? Customer.getDefaultInstance() : this.customerClient_;
            }
            return (Customer)this.customerClientBuilder_.getMessage();
        }

        public Builder setCustomerClient(Customer value) {
            if (this.customerClientBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.customerClient_ = value;
            } else {
                this.customerClientBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setCustomerClient(Customer.Builder builderForValue) {
            if (this.customerClientBuilder_ == null) {
                this.customerClient_ = builderForValue.build();
            } else {
                this.customerClientBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeCustomerClient(Customer value) {
            if (this.customerClientBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.customerClient_ != null && this.customerClient_ != Customer.getDefaultInstance()) {
                    this.getCustomerClientBuilder().mergeFrom(value);
                } else {
                    this.customerClient_ = value;
                }
            } else {
                this.customerClientBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.customerClient_ != null) {
                this.bitField0_ |= 2;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCustomerClient() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.customerClient_ = null;
            if (this.customerClientBuilder_ != null) {
                this.customerClientBuilder_.dispose();
                this.customerClientBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Customer.Builder getCustomerClientBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (Customer.Builder)this.getCustomerClientFieldBuilder().getBuilder();
        }

        @Override
        public CustomerOrBuilder getCustomerClientOrBuilder() {
            if (this.customerClientBuilder_ != null) {
                return (CustomerOrBuilder)this.customerClientBuilder_.getMessageOrBuilder();
            }
            return this.customerClient_ == null ? Customer.getDefaultInstance() : this.customerClient_;
        }

        private SingleFieldBuilderV3<Customer, Customer.Builder, CustomerOrBuilder> getCustomerClientFieldBuilder() {
            if (this.customerClientBuilder_ == null) {
                this.customerClientBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCustomerClient(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.customerClient_ = null;
            }
            return this.customerClientBuilder_;
        }

        @Override
        public boolean hasEmailAddress() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public String getEmailAddress() {
            Object ref = this.emailAddress_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.emailAddress_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEmailAddressBytes() {
            Object ref = this.emailAddress_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.emailAddress_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEmailAddress(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.emailAddress_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearEmailAddress() {
            this.emailAddress_ = CreateCustomerClientRequest.getDefaultInstance().getEmailAddress();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setEmailAddressBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CreateCustomerClientRequest.checkByteStringIsUtf8((ByteString)value);
            this.emailAddress_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public int getAccessRoleValue() {
            return this.accessRole_;
        }

        public Builder setAccessRoleValue(int value) {
            this.accessRole_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public AccessRoleEnum.AccessRole getAccessRole() {
            AccessRoleEnum.AccessRole result = AccessRoleEnum.AccessRole.forNumber(this.accessRole_);
            return result == null ? AccessRoleEnum.AccessRole.UNRECOGNIZED : result;
        }

        public Builder setAccessRole(AccessRoleEnum.AccessRole value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.accessRole_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAccessRole() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.accessRole_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getValidateOnly() {
            return this.validateOnly_;
        }

        public Builder setValidateOnly(boolean value) {
            this.validateOnly_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearValidateOnly() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.validateOnly_ = false;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

