/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.services;

import com.google.ads.googleads.v14.common.HistoricalMetricsOptions;
import com.google.ads.googleads.v14.common.HistoricalMetricsOptionsOrBuilder;
import com.google.ads.googleads.v14.common.KeywordPlanAggregateMetrics;
import com.google.ads.googleads.v14.common.KeywordPlanAggregateMetricsOrBuilder;
import com.google.ads.googleads.v14.enums.KeywordPlanKeywordAnnotationEnum;
import com.google.ads.googleads.v14.enums.KeywordPlanNetworkEnum;
import com.google.ads.googleads.v14.services.GenerateKeywordIdeasRequestOrBuilder;
import com.google.ads.googleads.v14.services.KeywordAndUrlSeed;
import com.google.ads.googleads.v14.services.KeywordAndUrlSeedOrBuilder;
import com.google.ads.googleads.v14.services.KeywordPlanIdeaServiceProto;
import com.google.ads.googleads.v14.services.KeywordSeed;
import com.google.ads.googleads.v14.services.KeywordSeedOrBuilder;
import com.google.ads.googleads.v14.services.SiteSeed;
import com.google.ads.googleads.v14.services.SiteSeedOrBuilder;
import com.google.ads.googleads.v14.services.UrlSeed;
import com.google.ads.googleads.v14.services.UrlSeedOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class GenerateKeywordIdeasRequest
extends GeneratedMessageV3
implements GenerateKeywordIdeasRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    private int seedCase_ = 0;
    private Object seed_;
    public static final int CUSTOMER_ID_FIELD_NUMBER = 1;
    private volatile Object customerId_ = "";
    public static final int LANGUAGE_FIELD_NUMBER = 14;
    private volatile Object language_ = "";
    public static final int GEO_TARGET_CONSTANTS_FIELD_NUMBER = 15;
    private LazyStringArrayList geoTargetConstants_ = LazyStringArrayList.emptyList();
    public static final int INCLUDE_ADULT_KEYWORDS_FIELD_NUMBER = 10;
    private boolean includeAdultKeywords_ = false;
    public static final int PAGE_TOKEN_FIELD_NUMBER = 12;
    private volatile Object pageToken_ = "";
    public static final int PAGE_SIZE_FIELD_NUMBER = 13;
    private int pageSize_ = 0;
    public static final int KEYWORD_PLAN_NETWORK_FIELD_NUMBER = 9;
    private int keywordPlanNetwork_ = 0;
    public static final int KEYWORD_ANNOTATION_FIELD_NUMBER = 17;
    private List<Integer> keywordAnnotation_;
    private static final Internal.ListAdapter.Converter<Integer, KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation> keywordAnnotation_converter_ = new Internal.ListAdapter.Converter<Integer, KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation>(){

        public KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation convert(Integer from) {
            KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation result = KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation.forNumber(from);
            return result == null ? KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation.UNRECOGNIZED : result;
        }
    };
    private int keywordAnnotationMemoizedSerializedSize;
    public static final int AGGREGATE_METRICS_FIELD_NUMBER = 16;
    private KeywordPlanAggregateMetrics aggregateMetrics_;
    public static final int HISTORICAL_METRICS_OPTIONS_FIELD_NUMBER = 18;
    private HistoricalMetricsOptions historicalMetricsOptions_;
    public static final int KEYWORD_AND_URL_SEED_FIELD_NUMBER = 2;
    public static final int KEYWORD_SEED_FIELD_NUMBER = 3;
    public static final int URL_SEED_FIELD_NUMBER = 5;
    public static final int SITE_SEED_FIELD_NUMBER = 11;
    private byte memoizedIsInitialized = (byte)-1;
    private static final GenerateKeywordIdeasRequest DEFAULT_INSTANCE = new GenerateKeywordIdeasRequest();
    private static final Parser<GenerateKeywordIdeasRequest> PARSER = new AbstractParser<GenerateKeywordIdeasRequest>(){

        public GenerateKeywordIdeasRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = GenerateKeywordIdeasRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private GenerateKeywordIdeasRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private GenerateKeywordIdeasRequest() {
        this.customerId_ = "";
        this.language_ = "";
        this.geoTargetConstants_ = LazyStringArrayList.emptyList();
        this.pageToken_ = "";
        this.keywordPlanNetwork_ = 0;
        this.keywordAnnotation_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new GenerateKeywordIdeasRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return KeywordPlanIdeaServiceProto.internal_static_google_ads_googleads_v14_services_GenerateKeywordIdeasRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return KeywordPlanIdeaServiceProto.internal_static_google_ads_googleads_v14_services_GenerateKeywordIdeasRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateKeywordIdeasRequest.class, Builder.class);
    }

    @Override
    public SeedCase getSeedCase() {
        return SeedCase.forNumber(this.seedCase_);
    }

    @Override
    public String getCustomerId() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.customerId_ = s;
        return s;
    }

    @Override
    public ByteString getCustomerIdBytes() {
        Object ref = this.customerId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.customerId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasLanguage() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public String getLanguage() {
        Object ref = this.language_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.language_ = s;
        return s;
    }

    @Override
    public ByteString getLanguageBytes() {
        Object ref = this.language_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.language_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getGeoTargetConstantsList() {
        return this.geoTargetConstants_;
    }

    @Override
    public int getGeoTargetConstantsCount() {
        return this.geoTargetConstants_.size();
    }

    @Override
    public String getGeoTargetConstants(int index) {
        return this.geoTargetConstants_.get(index);
    }

    @Override
    public ByteString getGeoTargetConstantsBytes(int index) {
        return this.geoTargetConstants_.getByteString(index);
    }

    @Override
    public boolean getIncludeAdultKeywords() {
        return this.includeAdultKeywords_;
    }

    @Override
    public String getPageToken() {
        Object ref = this.pageToken_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.pageToken_ = s;
        return s;
    }

    @Override
    public ByteString getPageTokenBytes() {
        Object ref = this.pageToken_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.pageToken_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getPageSize() {
        return this.pageSize_;
    }

    @Override
    public int getKeywordPlanNetworkValue() {
        return this.keywordPlanNetwork_;
    }

    @Override
    public KeywordPlanNetworkEnum.KeywordPlanNetwork getKeywordPlanNetwork() {
        KeywordPlanNetworkEnum.KeywordPlanNetwork result = KeywordPlanNetworkEnum.KeywordPlanNetwork.forNumber(this.keywordPlanNetwork_);
        return result == null ? KeywordPlanNetworkEnum.KeywordPlanNetwork.UNRECOGNIZED : result;
    }

    @Override
    public List<KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation> getKeywordAnnotationList() {
        return new Internal.ListAdapter(this.keywordAnnotation_, keywordAnnotation_converter_);
    }

    @Override
    public int getKeywordAnnotationCount() {
        return this.keywordAnnotation_.size();
    }

    @Override
    public KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation getKeywordAnnotation(int index) {
        return (KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation)((Object)keywordAnnotation_converter_.convert((Object)this.keywordAnnotation_.get(index)));
    }

    @Override
    public List<Integer> getKeywordAnnotationValueList() {
        return this.keywordAnnotation_;
    }

    @Override
    public int getKeywordAnnotationValue(int index) {
        return this.keywordAnnotation_.get(index);
    }

    @Override
    public boolean hasAggregateMetrics() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public KeywordPlanAggregateMetrics getAggregateMetrics() {
        return this.aggregateMetrics_ == null ? KeywordPlanAggregateMetrics.getDefaultInstance() : this.aggregateMetrics_;
    }

    @Override
    public KeywordPlanAggregateMetricsOrBuilder getAggregateMetricsOrBuilder() {
        return this.aggregateMetrics_ == null ? KeywordPlanAggregateMetrics.getDefaultInstance() : this.aggregateMetrics_;
    }

    @Override
    public boolean hasHistoricalMetricsOptions() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public HistoricalMetricsOptions getHistoricalMetricsOptions() {
        return this.historicalMetricsOptions_ == null ? HistoricalMetricsOptions.getDefaultInstance() : this.historicalMetricsOptions_;
    }

    @Override
    public HistoricalMetricsOptionsOrBuilder getHistoricalMetricsOptionsOrBuilder() {
        return this.historicalMetricsOptions_ == null ? HistoricalMetricsOptions.getDefaultInstance() : this.historicalMetricsOptions_;
    }

    @Override
    public boolean hasKeywordAndUrlSeed() {
        return this.seedCase_ == 2;
    }

    @Override
    public KeywordAndUrlSeed getKeywordAndUrlSeed() {
        if (this.seedCase_ == 2) {
            return (KeywordAndUrlSeed)this.seed_;
        }
        return KeywordAndUrlSeed.getDefaultInstance();
    }

    @Override
    public KeywordAndUrlSeedOrBuilder getKeywordAndUrlSeedOrBuilder() {
        if (this.seedCase_ == 2) {
            return (KeywordAndUrlSeed)this.seed_;
        }
        return KeywordAndUrlSeed.getDefaultInstance();
    }

    @Override
    public boolean hasKeywordSeed() {
        return this.seedCase_ == 3;
    }

    @Override
    public KeywordSeed getKeywordSeed() {
        if (this.seedCase_ == 3) {
            return (KeywordSeed)this.seed_;
        }
        return KeywordSeed.getDefaultInstance();
    }

    @Override
    public KeywordSeedOrBuilder getKeywordSeedOrBuilder() {
        if (this.seedCase_ == 3) {
            return (KeywordSeed)this.seed_;
        }
        return KeywordSeed.getDefaultInstance();
    }

    @Override
    public boolean hasUrlSeed() {
        return this.seedCase_ == 5;
    }

    @Override
    public UrlSeed getUrlSeed() {
        if (this.seedCase_ == 5) {
            return (UrlSeed)this.seed_;
        }
        return UrlSeed.getDefaultInstance();
    }

    @Override
    public UrlSeedOrBuilder getUrlSeedOrBuilder() {
        if (this.seedCase_ == 5) {
            return (UrlSeed)this.seed_;
        }
        return UrlSeed.getDefaultInstance();
    }

    @Override
    public boolean hasSiteSeed() {
        return this.seedCase_ == 11;
    }

    @Override
    public SiteSeed getSiteSeed() {
        if (this.seedCase_ == 11) {
            return (SiteSeed)this.seed_;
        }
        return SiteSeed.getDefaultInstance();
    }

    @Override
    public SiteSeedOrBuilder getSiteSeedOrBuilder() {
        if (this.seedCase_ == 11) {
            return (SiteSeed)this.seed_;
        }
        return SiteSeed.getDefaultInstance();
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.customerId_);
        }
        if (this.seedCase_ == 2) {
            output.writeMessage(2, (MessageLite)((KeywordAndUrlSeed)this.seed_));
        }
        if (this.seedCase_ == 3) {
            output.writeMessage(3, (MessageLite)((KeywordSeed)this.seed_));
        }
        if (this.seedCase_ == 5) {
            output.writeMessage(5, (MessageLite)((UrlSeed)this.seed_));
        }
        if (this.keywordPlanNetwork_ != KeywordPlanNetworkEnum.KeywordPlanNetwork.UNSPECIFIED.getNumber()) {
            output.writeEnum(9, this.keywordPlanNetwork_);
        }
        if (this.includeAdultKeywords_) {
            output.writeBool(10, this.includeAdultKeywords_);
        }
        if (this.seedCase_ == 11) {
            output.writeMessage(11, (MessageLite)((SiteSeed)this.seed_));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.pageToken_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.pageToken_);
        }
        if (this.pageSize_ != 0) {
            output.writeInt32(13, this.pageSize_);
        }
        if ((this.bitField0_ & 1) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)14, (Object)this.language_);
        }
        for (i = 0; i < this.geoTargetConstants_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)15, (Object)this.geoTargetConstants_.getRaw(i));
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(16, (MessageLite)this.getAggregateMetrics());
        }
        if (this.getKeywordAnnotationList().size() > 0) {
            output.writeUInt32NoTag(138);
            output.writeUInt32NoTag(this.keywordAnnotationMemoizedSerializedSize);
        }
        for (i = 0; i < this.keywordAnnotation_.size(); ++i) {
            output.writeEnumNoTag(this.keywordAnnotation_.get(i).intValue());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(18, (MessageLite)this.getHistoricalMetricsOptions());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.customerId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.customerId_);
        }
        if (this.seedCase_ == 2) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((KeywordAndUrlSeed)this.seed_));
        }
        if (this.seedCase_ == 3) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((KeywordSeed)this.seed_));
        }
        if (this.seedCase_ == 5) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((UrlSeed)this.seed_));
        }
        if (this.keywordPlanNetwork_ != KeywordPlanNetworkEnum.KeywordPlanNetwork.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)9, (int)this.keywordPlanNetwork_);
        }
        if (this.includeAdultKeywords_) {
            size += CodedOutputStream.computeBoolSize((int)10, (boolean)this.includeAdultKeywords_);
        }
        if (this.seedCase_ == 11) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)((SiteSeed)this.seed_));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.pageToken_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.pageToken_);
        }
        if (this.pageSize_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)13, (int)this.pageSize_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)14, (Object)this.language_);
        }
        int dataSize = 0;
        for (i = 0; i < this.geoTargetConstants_.size(); ++i) {
            dataSize += GenerateKeywordIdeasRequest.computeStringSizeNoTag((Object)this.geoTargetConstants_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getGeoTargetConstantsList().size();
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)16, (MessageLite)this.getAggregateMetrics());
        }
        dataSize = 0;
        for (i = 0; i < this.keywordAnnotation_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.keywordAnnotation_.get(i));
        }
        size += dataSize;
        if (!this.getKeywordAnnotationList().isEmpty()) {
            size += 2;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.keywordAnnotationMemoizedSerializedSize = dataSize;
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)18, (MessageLite)this.getHistoricalMetricsOptions());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GenerateKeywordIdeasRequest)) {
            return super.equals(obj);
        }
        GenerateKeywordIdeasRequest other = (GenerateKeywordIdeasRequest)obj;
        if (!this.getCustomerId().equals(other.getCustomerId())) {
            return false;
        }
        if (this.hasLanguage() != other.hasLanguage()) {
            return false;
        }
        if (this.hasLanguage() && !this.getLanguage().equals(other.getLanguage())) {
            return false;
        }
        if (!this.getGeoTargetConstantsList().equals(other.getGeoTargetConstantsList())) {
            return false;
        }
        if (this.getIncludeAdultKeywords() != other.getIncludeAdultKeywords()) {
            return false;
        }
        if (!this.getPageToken().equals(other.getPageToken())) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.keywordPlanNetwork_ != other.keywordPlanNetwork_) {
            return false;
        }
        if (!this.keywordAnnotation_.equals(other.keywordAnnotation_)) {
            return false;
        }
        if (this.hasAggregateMetrics() != other.hasAggregateMetrics()) {
            return false;
        }
        if (this.hasAggregateMetrics() && !this.getAggregateMetrics().equals(other.getAggregateMetrics())) {
            return false;
        }
        if (this.hasHistoricalMetricsOptions() != other.hasHistoricalMetricsOptions()) {
            return false;
        }
        if (this.hasHistoricalMetricsOptions() && !this.getHistoricalMetricsOptions().equals(other.getHistoricalMetricsOptions())) {
            return false;
        }
        if (!this.getSeedCase().equals((Object)other.getSeedCase())) {
            return false;
        }
        switch (this.seedCase_) {
            case 2: {
                if (this.getKeywordAndUrlSeed().equals(other.getKeywordAndUrlSeed())) break;
                return false;
            }
            case 3: {
                if (this.getKeywordSeed().equals(other.getKeywordSeed())) break;
                return false;
            }
            case 5: {
                if (this.getUrlSeed().equals(other.getUrlSeed())) break;
                return false;
            }
            case 11: {
                if (this.getSiteSeed().equals(other.getSiteSeed())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + GenerateKeywordIdeasRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getCustomerId().hashCode();
        if (this.hasLanguage()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getLanguage().hashCode();
        }
        if (this.getGeoTargetConstantsCount() > 0) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getGeoTargetConstantsList().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIncludeAdultKeywords());
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getPageToken().hashCode();
        hash = 37 * hash + 13;
        hash = 53 * hash + this.getPageSize();
        hash = 37 * hash + 9;
        hash = 53 * hash + this.keywordPlanNetwork_;
        if (this.getKeywordAnnotationCount() > 0) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.keywordAnnotation_.hashCode();
        }
        if (this.hasAggregateMetrics()) {
            hash = 37 * hash + 16;
            hash = 53 * hash + this.getAggregateMetrics().hashCode();
        }
        if (this.hasHistoricalMetricsOptions()) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.getHistoricalMetricsOptions().hashCode();
        }
        switch (this.seedCase_) {
            case 2: {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getKeywordAndUrlSeed().hashCode();
                break;
            }
            case 3: {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getKeywordSeed().hashCode();
                break;
            }
            case 5: {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getUrlSeed().hashCode();
                break;
            }
            case 11: {
                hash = 37 * hash + 11;
                hash = 53 * hash + this.getSiteSeed().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static GenerateKeywordIdeasRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (GenerateKeywordIdeasRequest)PARSER.parseFrom(data);
    }

    public static GenerateKeywordIdeasRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateKeywordIdeasRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateKeywordIdeasRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (GenerateKeywordIdeasRequest)PARSER.parseFrom(data);
    }

    public static GenerateKeywordIdeasRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateKeywordIdeasRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateKeywordIdeasRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (GenerateKeywordIdeasRequest)PARSER.parseFrom(data);
    }

    public static GenerateKeywordIdeasRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateKeywordIdeasRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateKeywordIdeasRequest parseFrom(InputStream input) throws IOException {
        return (GenerateKeywordIdeasRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateKeywordIdeasRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateKeywordIdeasRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateKeywordIdeasRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (GenerateKeywordIdeasRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateKeywordIdeasRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateKeywordIdeasRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateKeywordIdeasRequest parseFrom(CodedInputStream input) throws IOException {
        return (GenerateKeywordIdeasRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static GenerateKeywordIdeasRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateKeywordIdeasRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return GenerateKeywordIdeasRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GenerateKeywordIdeasRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static GenerateKeywordIdeasRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<GenerateKeywordIdeasRequest> parser() {
        return PARSER;
    }

    public Parser<GenerateKeywordIdeasRequest> getParserForType() {
        return PARSER;
    }

    public GenerateKeywordIdeasRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements GenerateKeywordIdeasRequestOrBuilder {
        private int seedCase_ = 0;
        private Object seed_;
        private int bitField0_;
        private Object customerId_ = "";
        private Object language_ = "";
        private LazyStringArrayList geoTargetConstants_ = LazyStringArrayList.emptyList();
        private boolean includeAdultKeywords_;
        private Object pageToken_ = "";
        private int pageSize_;
        private int keywordPlanNetwork_ = 0;
        private List<Integer> keywordAnnotation_ = Collections.emptyList();
        private KeywordPlanAggregateMetrics aggregateMetrics_;
        private SingleFieldBuilderV3<KeywordPlanAggregateMetrics, KeywordPlanAggregateMetrics.Builder, KeywordPlanAggregateMetricsOrBuilder> aggregateMetricsBuilder_;
        private HistoricalMetricsOptions historicalMetricsOptions_;
        private SingleFieldBuilderV3<HistoricalMetricsOptions, HistoricalMetricsOptions.Builder, HistoricalMetricsOptionsOrBuilder> historicalMetricsOptionsBuilder_;
        private SingleFieldBuilderV3<KeywordAndUrlSeed, KeywordAndUrlSeed.Builder, KeywordAndUrlSeedOrBuilder> keywordAndUrlSeedBuilder_;
        private SingleFieldBuilderV3<KeywordSeed, KeywordSeed.Builder, KeywordSeedOrBuilder> keywordSeedBuilder_;
        private SingleFieldBuilderV3<UrlSeed, UrlSeed.Builder, UrlSeedOrBuilder> urlSeedBuilder_;
        private SingleFieldBuilderV3<SiteSeed, SiteSeed.Builder, SiteSeedOrBuilder> siteSeedBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return KeywordPlanIdeaServiceProto.internal_static_google_ads_googleads_v14_services_GenerateKeywordIdeasRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return KeywordPlanIdeaServiceProto.internal_static_google_ads_googleads_v14_services_GenerateKeywordIdeasRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateKeywordIdeasRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getAggregateMetricsFieldBuilder();
                this.getHistoricalMetricsOptionsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.customerId_ = "";
            this.language_ = "";
            this.geoTargetConstants_ = LazyStringArrayList.emptyList();
            this.includeAdultKeywords_ = false;
            this.pageToken_ = "";
            this.pageSize_ = 0;
            this.keywordPlanNetwork_ = 0;
            this.keywordAnnotation_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.aggregateMetrics_ = null;
            if (this.aggregateMetricsBuilder_ != null) {
                this.aggregateMetricsBuilder_.dispose();
                this.aggregateMetricsBuilder_ = null;
            }
            this.historicalMetricsOptions_ = null;
            if (this.historicalMetricsOptionsBuilder_ != null) {
                this.historicalMetricsOptionsBuilder_.dispose();
                this.historicalMetricsOptionsBuilder_ = null;
            }
            if (this.keywordAndUrlSeedBuilder_ != null) {
                this.keywordAndUrlSeedBuilder_.clear();
            }
            if (this.keywordSeedBuilder_ != null) {
                this.keywordSeedBuilder_.clear();
            }
            if (this.urlSeedBuilder_ != null) {
                this.urlSeedBuilder_.clear();
            }
            if (this.siteSeedBuilder_ != null) {
                this.siteSeedBuilder_.clear();
            }
            this.seedCase_ = 0;
            this.seed_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return KeywordPlanIdeaServiceProto.internal_static_google_ads_googleads_v14_services_GenerateKeywordIdeasRequest_descriptor;
        }

        public GenerateKeywordIdeasRequest getDefaultInstanceForType() {
            return GenerateKeywordIdeasRequest.getDefaultInstance();
        }

        public GenerateKeywordIdeasRequest build() {
            GenerateKeywordIdeasRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public GenerateKeywordIdeasRequest buildPartial() {
            GenerateKeywordIdeasRequest result = new GenerateKeywordIdeasRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.buildPartialOneofs(result);
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(GenerateKeywordIdeasRequest result) {
            if ((this.bitField0_ & 0x80) != 0) {
                this.keywordAnnotation_ = Collections.unmodifiableList(this.keywordAnnotation_);
                this.bitField0_ &= 0xFFFFFF7F;
            }
            result.keywordAnnotation_ = this.keywordAnnotation_;
        }

        private void buildPartial0(GenerateKeywordIdeasRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.customerId_ = this.customerId_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 2) != 0) {
                result.language_ = this.language_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 4) != 0) {
                this.geoTargetConstants_.makeImmutable();
                result.geoTargetConstants_ = this.geoTargetConstants_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.includeAdultKeywords_ = this.includeAdultKeywords_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.pageToken_ = this.pageToken_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.pageSize_ = this.pageSize_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.keywordPlanNetwork_ = this.keywordPlanNetwork_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.aggregateMetrics_ = this.aggregateMetricsBuilder_ == null ? this.aggregateMetrics_ : (KeywordPlanAggregateMetrics)this.aggregateMetricsBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.historicalMetricsOptions_ = this.historicalMetricsOptionsBuilder_ == null ? this.historicalMetricsOptions_ : (HistoricalMetricsOptions)this.historicalMetricsOptionsBuilder_.build();
                to_bitField0_ |= 4;
            }
            result.bitField0_ |= to_bitField0_;
        }

        private void buildPartialOneofs(GenerateKeywordIdeasRequest result) {
            result.seedCase_ = this.seedCase_;
            result.seed_ = this.seed_;
            if (this.seedCase_ == 2 && this.keywordAndUrlSeedBuilder_ != null) {
                result.seed_ = this.keywordAndUrlSeedBuilder_.build();
            }
            if (this.seedCase_ == 3 && this.keywordSeedBuilder_ != null) {
                result.seed_ = this.keywordSeedBuilder_.build();
            }
            if (this.seedCase_ == 5 && this.urlSeedBuilder_ != null) {
                result.seed_ = this.urlSeedBuilder_.build();
            }
            if (this.seedCase_ == 11 && this.siteSeedBuilder_ != null) {
                result.seed_ = this.siteSeedBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof GenerateKeywordIdeasRequest) {
                return this.mergeFrom((GenerateKeywordIdeasRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(GenerateKeywordIdeasRequest other) {
            if (other == GenerateKeywordIdeasRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getCustomerId().isEmpty()) {
                this.customerId_ = other.customerId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasLanguage()) {
                this.language_ = other.language_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.geoTargetConstants_.isEmpty()) {
                if (this.geoTargetConstants_.isEmpty()) {
                    this.geoTargetConstants_ = other.geoTargetConstants_;
                    this.bitField0_ |= 4;
                } else {
                    this.ensureGeoTargetConstantsIsMutable();
                    this.geoTargetConstants_.addAll((Collection)other.geoTargetConstants_);
                }
                this.onChanged();
            }
            if (other.getIncludeAdultKeywords()) {
                this.setIncludeAdultKeywords(other.getIncludeAdultKeywords());
            }
            if (!other.getPageToken().isEmpty()) {
                this.pageToken_ = other.pageToken_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (other.getPageSize() != 0) {
                this.setPageSize(other.getPageSize());
            }
            if (other.keywordPlanNetwork_ != 0) {
                this.setKeywordPlanNetworkValue(other.getKeywordPlanNetworkValue());
            }
            if (!other.keywordAnnotation_.isEmpty()) {
                if (this.keywordAnnotation_.isEmpty()) {
                    this.keywordAnnotation_ = other.keywordAnnotation_;
                    this.bitField0_ &= 0xFFFFFF7F;
                } else {
                    this.ensureKeywordAnnotationIsMutable();
                    this.keywordAnnotation_.addAll(other.keywordAnnotation_);
                }
                this.onChanged();
            }
            if (other.hasAggregateMetrics()) {
                this.mergeAggregateMetrics(other.getAggregateMetrics());
            }
            if (other.hasHistoricalMetricsOptions()) {
                this.mergeHistoricalMetricsOptions(other.getHistoricalMetricsOptions());
            }
            switch (other.getSeedCase()) {
                case KEYWORD_AND_URL_SEED: {
                    this.mergeKeywordAndUrlSeed(other.getKeywordAndUrlSeed());
                    break;
                }
                case KEYWORD_SEED: {
                    this.mergeKeywordSeed(other.getKeywordSeed());
                    break;
                }
                case URL_SEED: {
                    this.mergeUrlSeed(other.getUrlSeed());
                    break;
                }
                case SITE_SEED: {
                    this.mergeSiteSeed(other.getSiteSeed());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block23: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block23;
                        }
                        case 10: {
                            this.customerId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block23;
                        }
                        case 18: {
                            input.readMessage((MessageLite.Builder)this.getKeywordAndUrlSeedFieldBuilder().getBuilder(), extensionRegistry);
                            this.seedCase_ = 2;
                            continue block23;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getKeywordSeedFieldBuilder().getBuilder(), extensionRegistry);
                            this.seedCase_ = 3;
                            continue block23;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getUrlSeedFieldBuilder().getBuilder(), extensionRegistry);
                            this.seedCase_ = 5;
                            continue block23;
                        }
                        case 72: {
                            this.keywordPlanNetwork_ = input.readEnum();
                            this.bitField0_ |= 0x40;
                            continue block23;
                        }
                        case 80: {
                            this.includeAdultKeywords_ = input.readBool();
                            this.bitField0_ |= 8;
                            continue block23;
                        }
                        case 90: {
                            input.readMessage((MessageLite.Builder)this.getSiteSeedFieldBuilder().getBuilder(), extensionRegistry);
                            this.seedCase_ = 11;
                            continue block23;
                        }
                        case 98: {
                            this.pageToken_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block23;
                        }
                        case 104: {
                            this.pageSize_ = input.readInt32();
                            this.bitField0_ |= 0x20;
                            continue block23;
                        }
                        case 114: {
                            this.language_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block23;
                        }
                        case 122: {
                            String s = input.readStringRequireUtf8();
                            this.ensureGeoTargetConstantsIsMutable();
                            this.geoTargetConstants_.add((Object)s);
                            continue block23;
                        }
                        case 130: {
                            input.readMessage((MessageLite.Builder)this.getAggregateMetricsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block23;
                        }
                        case 136: {
                            int tmpRaw = input.readEnum();
                            this.ensureKeywordAnnotationIsMutable();
                            this.keywordAnnotation_.add(tmpRaw);
                            continue block23;
                        }
                        case 138: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureKeywordAnnotationIsMutable();
                                this.keywordAnnotation_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block23;
                        }
                        case 146: {
                            input.readMessage((MessageLite.Builder)this.getHistoricalMetricsOptionsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200;
                            continue block23;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public SeedCase getSeedCase() {
            return SeedCase.forNumber(this.seedCase_);
        }

        public Builder clearSeed() {
            this.seedCase_ = 0;
            this.seed_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public String getCustomerId() {
            Object ref = this.customerId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.customerId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCustomerIdBytes() {
            Object ref = this.customerId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.customerId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCustomerId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearCustomerId() {
            this.customerId_ = GenerateKeywordIdeasRequest.getDefaultInstance().getCustomerId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setCustomerIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateKeywordIdeasRequest.checkByteStringIsUtf8((ByteString)value);
            this.customerId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLanguage() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public String getLanguage() {
            Object ref = this.language_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.language_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLanguageBytes() {
            Object ref = this.language_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.language_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLanguage(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.language_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearLanguage() {
            this.language_ = GenerateKeywordIdeasRequest.getDefaultInstance().getLanguage();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setLanguageBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateKeywordIdeasRequest.checkByteStringIsUtf8((ByteString)value);
            this.language_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        private void ensureGeoTargetConstantsIsMutable() {
            if (!this.geoTargetConstants_.isModifiable()) {
                this.geoTargetConstants_ = new LazyStringArrayList((LazyStringList)this.geoTargetConstants_);
            }
            this.bitField0_ |= 4;
        }

        public ProtocolStringList getGeoTargetConstantsList() {
            this.geoTargetConstants_.makeImmutable();
            return this.geoTargetConstants_;
        }

        @Override
        public int getGeoTargetConstantsCount() {
            return this.geoTargetConstants_.size();
        }

        @Override
        public String getGeoTargetConstants(int index) {
            return this.geoTargetConstants_.get(index);
        }

        @Override
        public ByteString getGeoTargetConstantsBytes(int index) {
            return this.geoTargetConstants_.getByteString(index);
        }

        public Builder setGeoTargetConstants(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureGeoTargetConstantsIsMutable();
            this.geoTargetConstants_.set(index, value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder addGeoTargetConstants(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureGeoTargetConstantsIsMutable();
            this.geoTargetConstants_.add((Object)value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder addAllGeoTargetConstants(Iterable<String> values) {
            this.ensureGeoTargetConstantsIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.geoTargetConstants_);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearGeoTargetConstants() {
            this.geoTargetConstants_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder addGeoTargetConstantsBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateKeywordIdeasRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensureGeoTargetConstantsIsMutable();
            this.geoTargetConstants_.add(value);
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getIncludeAdultKeywords() {
            return this.includeAdultKeywords_;
        }

        public Builder setIncludeAdultKeywords(boolean value) {
            this.includeAdultKeywords_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearIncludeAdultKeywords() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.includeAdultKeywords_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public String getPageToken() {
            Object ref = this.pageToken_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.pageToken_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPageTokenBytes() {
            Object ref = this.pageToken_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.pageToken_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPageToken(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.pageToken_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearPageToken() {
            this.pageToken_ = GenerateKeywordIdeasRequest.getDefaultInstance().getPageToken();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setPageTokenBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateKeywordIdeasRequest.checkByteStringIsUtf8((ByteString)value);
            this.pageToken_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public int getPageSize() {
            return this.pageSize_;
        }

        public Builder setPageSize(int value) {
            this.pageSize_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearPageSize() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.pageSize_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getKeywordPlanNetworkValue() {
            return this.keywordPlanNetwork_;
        }

        public Builder setKeywordPlanNetworkValue(int value) {
            this.keywordPlanNetwork_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public KeywordPlanNetworkEnum.KeywordPlanNetwork getKeywordPlanNetwork() {
            KeywordPlanNetworkEnum.KeywordPlanNetwork result = KeywordPlanNetworkEnum.KeywordPlanNetwork.forNumber(this.keywordPlanNetwork_);
            return result == null ? KeywordPlanNetworkEnum.KeywordPlanNetwork.UNRECOGNIZED : result;
        }

        public Builder setKeywordPlanNetwork(KeywordPlanNetworkEnum.KeywordPlanNetwork value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x40;
            this.keywordPlanNetwork_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearKeywordPlanNetwork() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.keywordPlanNetwork_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureKeywordAnnotationIsMutable() {
            if ((this.bitField0_ & 0x80) == 0) {
                this.keywordAnnotation_ = new ArrayList<Integer>(this.keywordAnnotation_);
                this.bitField0_ |= 0x80;
            }
        }

        @Override
        public List<KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation> getKeywordAnnotationList() {
            return new Internal.ListAdapter(this.keywordAnnotation_, keywordAnnotation_converter_);
        }

        @Override
        public int getKeywordAnnotationCount() {
            return this.keywordAnnotation_.size();
        }

        @Override
        public KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation getKeywordAnnotation(int index) {
            return (KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation)((Object)keywordAnnotation_converter_.convert((Object)this.keywordAnnotation_.get(index)));
        }

        public Builder setKeywordAnnotation(int index, KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureKeywordAnnotationIsMutable();
            this.keywordAnnotation_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addKeywordAnnotation(KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureKeywordAnnotationIsMutable();
            this.keywordAnnotation_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllKeywordAnnotation(Iterable<? extends KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation> values) {
            this.ensureKeywordAnnotationIsMutable();
            for (KeywordPlanKeywordAnnotationEnum.KeywordPlanKeywordAnnotation keywordPlanKeywordAnnotation : values) {
                this.keywordAnnotation_.add(keywordPlanKeywordAnnotation.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearKeywordAnnotation() {
            this.keywordAnnotation_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getKeywordAnnotationValueList() {
            return Collections.unmodifiableList(this.keywordAnnotation_);
        }

        @Override
        public int getKeywordAnnotationValue(int index) {
            return this.keywordAnnotation_.get(index);
        }

        public Builder setKeywordAnnotationValue(int index, int value) {
            this.ensureKeywordAnnotationIsMutable();
            this.keywordAnnotation_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addKeywordAnnotationValue(int value) {
            this.ensureKeywordAnnotationIsMutable();
            this.keywordAnnotation_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllKeywordAnnotationValue(Iterable<Integer> values) {
            this.ensureKeywordAnnotationIsMutable();
            for (int value : values) {
                this.keywordAnnotation_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasAggregateMetrics() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public KeywordPlanAggregateMetrics getAggregateMetrics() {
            if (this.aggregateMetricsBuilder_ == null) {
                return this.aggregateMetrics_ == null ? KeywordPlanAggregateMetrics.getDefaultInstance() : this.aggregateMetrics_;
            }
            return (KeywordPlanAggregateMetrics)this.aggregateMetricsBuilder_.getMessage();
        }

        public Builder setAggregateMetrics(KeywordPlanAggregateMetrics value) {
            if (this.aggregateMetricsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.aggregateMetrics_ = value;
            } else {
                this.aggregateMetricsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setAggregateMetrics(KeywordPlanAggregateMetrics.Builder builderForValue) {
            if (this.aggregateMetricsBuilder_ == null) {
                this.aggregateMetrics_ = builderForValue.build();
            } else {
                this.aggregateMetricsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeAggregateMetrics(KeywordPlanAggregateMetrics value) {
            if (this.aggregateMetricsBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.aggregateMetrics_ != null && this.aggregateMetrics_ != KeywordPlanAggregateMetrics.getDefaultInstance()) {
                    this.getAggregateMetricsBuilder().mergeFrom(value);
                } else {
                    this.aggregateMetrics_ = value;
                }
            } else {
                this.aggregateMetricsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.aggregateMetrics_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearAggregateMetrics() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.aggregateMetrics_ = null;
            if (this.aggregateMetricsBuilder_ != null) {
                this.aggregateMetricsBuilder_.dispose();
                this.aggregateMetricsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public KeywordPlanAggregateMetrics.Builder getAggregateMetricsBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (KeywordPlanAggregateMetrics.Builder)this.getAggregateMetricsFieldBuilder().getBuilder();
        }

        @Override
        public KeywordPlanAggregateMetricsOrBuilder getAggregateMetricsOrBuilder() {
            if (this.aggregateMetricsBuilder_ != null) {
                return (KeywordPlanAggregateMetricsOrBuilder)this.aggregateMetricsBuilder_.getMessageOrBuilder();
            }
            return this.aggregateMetrics_ == null ? KeywordPlanAggregateMetrics.getDefaultInstance() : this.aggregateMetrics_;
        }

        private SingleFieldBuilderV3<KeywordPlanAggregateMetrics, KeywordPlanAggregateMetrics.Builder, KeywordPlanAggregateMetricsOrBuilder> getAggregateMetricsFieldBuilder() {
            if (this.aggregateMetricsBuilder_ == null) {
                this.aggregateMetricsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAggregateMetrics(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.aggregateMetrics_ = null;
            }
            return this.aggregateMetricsBuilder_;
        }

        @Override
        public boolean hasHistoricalMetricsOptions() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public HistoricalMetricsOptions getHistoricalMetricsOptions() {
            if (this.historicalMetricsOptionsBuilder_ == null) {
                return this.historicalMetricsOptions_ == null ? HistoricalMetricsOptions.getDefaultInstance() : this.historicalMetricsOptions_;
            }
            return (HistoricalMetricsOptions)this.historicalMetricsOptionsBuilder_.getMessage();
        }

        public Builder setHistoricalMetricsOptions(HistoricalMetricsOptions value) {
            if (this.historicalMetricsOptionsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.historicalMetricsOptions_ = value;
            } else {
                this.historicalMetricsOptionsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder setHistoricalMetricsOptions(HistoricalMetricsOptions.Builder builderForValue) {
            if (this.historicalMetricsOptionsBuilder_ == null) {
                this.historicalMetricsOptions_ = builderForValue.build();
            } else {
                this.historicalMetricsOptionsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder mergeHistoricalMetricsOptions(HistoricalMetricsOptions value) {
            if (this.historicalMetricsOptionsBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0 && this.historicalMetricsOptions_ != null && this.historicalMetricsOptions_ != HistoricalMetricsOptions.getDefaultInstance()) {
                    this.getHistoricalMetricsOptionsBuilder().mergeFrom(value);
                } else {
                    this.historicalMetricsOptions_ = value;
                }
            } else {
                this.historicalMetricsOptionsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.historicalMetricsOptions_ != null) {
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            return this;
        }

        public Builder clearHistoricalMetricsOptions() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.historicalMetricsOptions_ = null;
            if (this.historicalMetricsOptionsBuilder_ != null) {
                this.historicalMetricsOptionsBuilder_.dispose();
                this.historicalMetricsOptionsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public HistoricalMetricsOptions.Builder getHistoricalMetricsOptionsBuilder() {
            this.bitField0_ |= 0x200;
            this.onChanged();
            return (HistoricalMetricsOptions.Builder)this.getHistoricalMetricsOptionsFieldBuilder().getBuilder();
        }

        @Override
        public HistoricalMetricsOptionsOrBuilder getHistoricalMetricsOptionsOrBuilder() {
            if (this.historicalMetricsOptionsBuilder_ != null) {
                return (HistoricalMetricsOptionsOrBuilder)this.historicalMetricsOptionsBuilder_.getMessageOrBuilder();
            }
            return this.historicalMetricsOptions_ == null ? HistoricalMetricsOptions.getDefaultInstance() : this.historicalMetricsOptions_;
        }

        private SingleFieldBuilderV3<HistoricalMetricsOptions, HistoricalMetricsOptions.Builder, HistoricalMetricsOptionsOrBuilder> getHistoricalMetricsOptionsFieldBuilder() {
            if (this.historicalMetricsOptionsBuilder_ == null) {
                this.historicalMetricsOptionsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getHistoricalMetricsOptions(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.historicalMetricsOptions_ = null;
            }
            return this.historicalMetricsOptionsBuilder_;
        }

        @Override
        public boolean hasKeywordAndUrlSeed() {
            return this.seedCase_ == 2;
        }

        @Override
        public KeywordAndUrlSeed getKeywordAndUrlSeed() {
            if (this.keywordAndUrlSeedBuilder_ == null) {
                if (this.seedCase_ == 2) {
                    return (KeywordAndUrlSeed)this.seed_;
                }
                return KeywordAndUrlSeed.getDefaultInstance();
            }
            if (this.seedCase_ == 2) {
                return (KeywordAndUrlSeed)this.keywordAndUrlSeedBuilder_.getMessage();
            }
            return KeywordAndUrlSeed.getDefaultInstance();
        }

        public Builder setKeywordAndUrlSeed(KeywordAndUrlSeed value) {
            if (this.keywordAndUrlSeedBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.seed_ = value;
                this.onChanged();
            } else {
                this.keywordAndUrlSeedBuilder_.setMessage((AbstractMessage)value);
            }
            this.seedCase_ = 2;
            return this;
        }

        public Builder setKeywordAndUrlSeed(KeywordAndUrlSeed.Builder builderForValue) {
            if (this.keywordAndUrlSeedBuilder_ == null) {
                this.seed_ = builderForValue.build();
                this.onChanged();
            } else {
                this.keywordAndUrlSeedBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.seedCase_ = 2;
            return this;
        }

        public Builder mergeKeywordAndUrlSeed(KeywordAndUrlSeed value) {
            if (this.keywordAndUrlSeedBuilder_ == null) {
                this.seed_ = this.seedCase_ == 2 && this.seed_ != KeywordAndUrlSeed.getDefaultInstance() ? KeywordAndUrlSeed.newBuilder((KeywordAndUrlSeed)this.seed_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.seedCase_ == 2) {
                this.keywordAndUrlSeedBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.keywordAndUrlSeedBuilder_.setMessage((AbstractMessage)value);
            }
            this.seedCase_ = 2;
            return this;
        }

        public Builder clearKeywordAndUrlSeed() {
            if (this.keywordAndUrlSeedBuilder_ == null) {
                if (this.seedCase_ == 2) {
                    this.seedCase_ = 0;
                    this.seed_ = null;
                    this.onChanged();
                }
            } else {
                if (this.seedCase_ == 2) {
                    this.seedCase_ = 0;
                    this.seed_ = null;
                }
                this.keywordAndUrlSeedBuilder_.clear();
            }
            return this;
        }

        public KeywordAndUrlSeed.Builder getKeywordAndUrlSeedBuilder() {
            return (KeywordAndUrlSeed.Builder)this.getKeywordAndUrlSeedFieldBuilder().getBuilder();
        }

        @Override
        public KeywordAndUrlSeedOrBuilder getKeywordAndUrlSeedOrBuilder() {
            if (this.seedCase_ == 2 && this.keywordAndUrlSeedBuilder_ != null) {
                return (KeywordAndUrlSeedOrBuilder)this.keywordAndUrlSeedBuilder_.getMessageOrBuilder();
            }
            if (this.seedCase_ == 2) {
                return (KeywordAndUrlSeed)this.seed_;
            }
            return KeywordAndUrlSeed.getDefaultInstance();
        }

        private SingleFieldBuilderV3<KeywordAndUrlSeed, KeywordAndUrlSeed.Builder, KeywordAndUrlSeedOrBuilder> getKeywordAndUrlSeedFieldBuilder() {
            if (this.keywordAndUrlSeedBuilder_ == null) {
                if (this.seedCase_ != 2) {
                    this.seed_ = KeywordAndUrlSeed.getDefaultInstance();
                }
                this.keywordAndUrlSeedBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((KeywordAndUrlSeed)this.seed_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.seed_ = null;
            }
            this.seedCase_ = 2;
            this.onChanged();
            return this.keywordAndUrlSeedBuilder_;
        }

        @Override
        public boolean hasKeywordSeed() {
            return this.seedCase_ == 3;
        }

        @Override
        public KeywordSeed getKeywordSeed() {
            if (this.keywordSeedBuilder_ == null) {
                if (this.seedCase_ == 3) {
                    return (KeywordSeed)this.seed_;
                }
                return KeywordSeed.getDefaultInstance();
            }
            if (this.seedCase_ == 3) {
                return (KeywordSeed)this.keywordSeedBuilder_.getMessage();
            }
            return KeywordSeed.getDefaultInstance();
        }

        public Builder setKeywordSeed(KeywordSeed value) {
            if (this.keywordSeedBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.seed_ = value;
                this.onChanged();
            } else {
                this.keywordSeedBuilder_.setMessage((AbstractMessage)value);
            }
            this.seedCase_ = 3;
            return this;
        }

        public Builder setKeywordSeed(KeywordSeed.Builder builderForValue) {
            if (this.keywordSeedBuilder_ == null) {
                this.seed_ = builderForValue.build();
                this.onChanged();
            } else {
                this.keywordSeedBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.seedCase_ = 3;
            return this;
        }

        public Builder mergeKeywordSeed(KeywordSeed value) {
            if (this.keywordSeedBuilder_ == null) {
                this.seed_ = this.seedCase_ == 3 && this.seed_ != KeywordSeed.getDefaultInstance() ? KeywordSeed.newBuilder((KeywordSeed)this.seed_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.seedCase_ == 3) {
                this.keywordSeedBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.keywordSeedBuilder_.setMessage((AbstractMessage)value);
            }
            this.seedCase_ = 3;
            return this;
        }

        public Builder clearKeywordSeed() {
            if (this.keywordSeedBuilder_ == null) {
                if (this.seedCase_ == 3) {
                    this.seedCase_ = 0;
                    this.seed_ = null;
                    this.onChanged();
                }
            } else {
                if (this.seedCase_ == 3) {
                    this.seedCase_ = 0;
                    this.seed_ = null;
                }
                this.keywordSeedBuilder_.clear();
            }
            return this;
        }

        public KeywordSeed.Builder getKeywordSeedBuilder() {
            return (KeywordSeed.Builder)this.getKeywordSeedFieldBuilder().getBuilder();
        }

        @Override
        public KeywordSeedOrBuilder getKeywordSeedOrBuilder() {
            if (this.seedCase_ == 3 && this.keywordSeedBuilder_ != null) {
                return (KeywordSeedOrBuilder)this.keywordSeedBuilder_.getMessageOrBuilder();
            }
            if (this.seedCase_ == 3) {
                return (KeywordSeed)this.seed_;
            }
            return KeywordSeed.getDefaultInstance();
        }

        private SingleFieldBuilderV3<KeywordSeed, KeywordSeed.Builder, KeywordSeedOrBuilder> getKeywordSeedFieldBuilder() {
            if (this.keywordSeedBuilder_ == null) {
                if (this.seedCase_ != 3) {
                    this.seed_ = KeywordSeed.getDefaultInstance();
                }
                this.keywordSeedBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((KeywordSeed)this.seed_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.seed_ = null;
            }
            this.seedCase_ = 3;
            this.onChanged();
            return this.keywordSeedBuilder_;
        }

        @Override
        public boolean hasUrlSeed() {
            return this.seedCase_ == 5;
        }

        @Override
        public UrlSeed getUrlSeed() {
            if (this.urlSeedBuilder_ == null) {
                if (this.seedCase_ == 5) {
                    return (UrlSeed)this.seed_;
                }
                return UrlSeed.getDefaultInstance();
            }
            if (this.seedCase_ == 5) {
                return (UrlSeed)this.urlSeedBuilder_.getMessage();
            }
            return UrlSeed.getDefaultInstance();
        }

        public Builder setUrlSeed(UrlSeed value) {
            if (this.urlSeedBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.seed_ = value;
                this.onChanged();
            } else {
                this.urlSeedBuilder_.setMessage((AbstractMessage)value);
            }
            this.seedCase_ = 5;
            return this;
        }

        public Builder setUrlSeed(UrlSeed.Builder builderForValue) {
            if (this.urlSeedBuilder_ == null) {
                this.seed_ = builderForValue.build();
                this.onChanged();
            } else {
                this.urlSeedBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.seedCase_ = 5;
            return this;
        }

        public Builder mergeUrlSeed(UrlSeed value) {
            if (this.urlSeedBuilder_ == null) {
                this.seed_ = this.seedCase_ == 5 && this.seed_ != UrlSeed.getDefaultInstance() ? UrlSeed.newBuilder((UrlSeed)this.seed_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.seedCase_ == 5) {
                this.urlSeedBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.urlSeedBuilder_.setMessage((AbstractMessage)value);
            }
            this.seedCase_ = 5;
            return this;
        }

        public Builder clearUrlSeed() {
            if (this.urlSeedBuilder_ == null) {
                if (this.seedCase_ == 5) {
                    this.seedCase_ = 0;
                    this.seed_ = null;
                    this.onChanged();
                }
            } else {
                if (this.seedCase_ == 5) {
                    this.seedCase_ = 0;
                    this.seed_ = null;
                }
                this.urlSeedBuilder_.clear();
            }
            return this;
        }

        public UrlSeed.Builder getUrlSeedBuilder() {
            return (UrlSeed.Builder)this.getUrlSeedFieldBuilder().getBuilder();
        }

        @Override
        public UrlSeedOrBuilder getUrlSeedOrBuilder() {
            if (this.seedCase_ == 5 && this.urlSeedBuilder_ != null) {
                return (UrlSeedOrBuilder)this.urlSeedBuilder_.getMessageOrBuilder();
            }
            if (this.seedCase_ == 5) {
                return (UrlSeed)this.seed_;
            }
            return UrlSeed.getDefaultInstance();
        }

        private SingleFieldBuilderV3<UrlSeed, UrlSeed.Builder, UrlSeedOrBuilder> getUrlSeedFieldBuilder() {
            if (this.urlSeedBuilder_ == null) {
                if (this.seedCase_ != 5) {
                    this.seed_ = UrlSeed.getDefaultInstance();
                }
                this.urlSeedBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((UrlSeed)this.seed_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.seed_ = null;
            }
            this.seedCase_ = 5;
            this.onChanged();
            return this.urlSeedBuilder_;
        }

        @Override
        public boolean hasSiteSeed() {
            return this.seedCase_ == 11;
        }

        @Override
        public SiteSeed getSiteSeed() {
            if (this.siteSeedBuilder_ == null) {
                if (this.seedCase_ == 11) {
                    return (SiteSeed)this.seed_;
                }
                return SiteSeed.getDefaultInstance();
            }
            if (this.seedCase_ == 11) {
                return (SiteSeed)this.siteSeedBuilder_.getMessage();
            }
            return SiteSeed.getDefaultInstance();
        }

        public Builder setSiteSeed(SiteSeed value) {
            if (this.siteSeedBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.seed_ = value;
                this.onChanged();
            } else {
                this.siteSeedBuilder_.setMessage((AbstractMessage)value);
            }
            this.seedCase_ = 11;
            return this;
        }

        public Builder setSiteSeed(SiteSeed.Builder builderForValue) {
            if (this.siteSeedBuilder_ == null) {
                this.seed_ = builderForValue.build();
                this.onChanged();
            } else {
                this.siteSeedBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.seedCase_ = 11;
            return this;
        }

        public Builder mergeSiteSeed(SiteSeed value) {
            if (this.siteSeedBuilder_ == null) {
                this.seed_ = this.seedCase_ == 11 && this.seed_ != SiteSeed.getDefaultInstance() ? SiteSeed.newBuilder((SiteSeed)this.seed_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.seedCase_ == 11) {
                this.siteSeedBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.siteSeedBuilder_.setMessage((AbstractMessage)value);
            }
            this.seedCase_ = 11;
            return this;
        }

        public Builder clearSiteSeed() {
            if (this.siteSeedBuilder_ == null) {
                if (this.seedCase_ == 11) {
                    this.seedCase_ = 0;
                    this.seed_ = null;
                    this.onChanged();
                }
            } else {
                if (this.seedCase_ == 11) {
                    this.seedCase_ = 0;
                    this.seed_ = null;
                }
                this.siteSeedBuilder_.clear();
            }
            return this;
        }

        public SiteSeed.Builder getSiteSeedBuilder() {
            return (SiteSeed.Builder)this.getSiteSeedFieldBuilder().getBuilder();
        }

        @Override
        public SiteSeedOrBuilder getSiteSeedOrBuilder() {
            if (this.seedCase_ == 11 && this.siteSeedBuilder_ != null) {
                return (SiteSeedOrBuilder)this.siteSeedBuilder_.getMessageOrBuilder();
            }
            if (this.seedCase_ == 11) {
                return (SiteSeed)this.seed_;
            }
            return SiteSeed.getDefaultInstance();
        }

        private SingleFieldBuilderV3<SiteSeed, SiteSeed.Builder, SiteSeedOrBuilder> getSiteSeedFieldBuilder() {
            if (this.siteSeedBuilder_ == null) {
                if (this.seedCase_ != 11) {
                    this.seed_ = SiteSeed.getDefaultInstance();
                }
                this.siteSeedBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((SiteSeed)this.seed_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.seed_ = null;
            }
            this.seedCase_ = 11;
            this.onChanged();
            return this.siteSeedBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum SeedCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        KEYWORD_AND_URL_SEED(2),
        KEYWORD_SEED(3),
        URL_SEED(5),
        SITE_SEED(11),
        SEED_NOT_SET(0);

        private final int value;

        private SeedCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static SeedCase valueOf(int value) {
            return SeedCase.forNumber(value);
        }

        public static SeedCase forNumber(int value) {
            switch (value) {
                case 2: {
                    return KEYWORD_AND_URL_SEED;
                }
                case 3: {
                    return KEYWORD_SEED;
                }
                case 5: {
                    return URL_SEED;
                }
                case 11: {
                    return SITE_SEED;
                }
                case 0: {
                    return SEED_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }
}

