/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.services.stub;

import com.google.ads.googleads.v14.services.MutateLabelsRequest;
import com.google.ads.googleads.v14.services.MutateLabelsResponse;
import com.google.ads.googleads.v14.services.stub.GrpcLabelServiceCallableFactory;
import com.google.ads.googleads.v14.services.stub.LabelServiceStub;
import com.google.ads.googleads.v14.services.stub.LabelServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcLabelServiceStub
extends LabelServiceStub {
    private static final MethodDescriptor<MutateLabelsRequest, MutateLabelsResponse> mutateLabelsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v14.services.LabelService/MutateLabels").setRequestMarshaller(ProtoUtils.marshaller((Message)MutateLabelsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MutateLabelsResponse.getDefaultInstance())).build();
    private final UnaryCallable<MutateLabelsRequest, MutateLabelsResponse> mutateLabelsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcLabelServiceStub create(LabelServiceStubSettings settings) throws IOException {
        return new GrpcLabelServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcLabelServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcLabelServiceStub(LabelServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcLabelServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcLabelServiceStub(LabelServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcLabelServiceStub(LabelServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcLabelServiceCallableFactory());
    }

    protected GrpcLabelServiceStub(LabelServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings mutateLabelsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateLabelsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        this.mutateLabelsCallable = callableFactory.createUnaryCallable(mutateLabelsTransportSettings, settings.mutateLabelsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<MutateLabelsRequest, MutateLabelsResponse> mutateLabelsCallable() {
        return this.mutateLabelsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

