/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v14.services.stub;

import com.google.ads.googleads.v14.services.ApplyRecommendationRequest;
import com.google.ads.googleads.v14.services.ApplyRecommendationResponse;
import com.google.ads.googleads.v14.services.DismissRecommendationRequest;
import com.google.ads.googleads.v14.services.DismissRecommendationResponse;
import com.google.ads.googleads.v14.services.stub.GrpcRecommendationServiceCallableFactory;
import com.google.ads.googleads.v14.services.stub.RecommendationServiceStub;
import com.google.ads.googleads.v14.services.stub.RecommendationServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcRecommendationServiceStub
extends RecommendationServiceStub {
    private static final MethodDescriptor<ApplyRecommendationRequest, ApplyRecommendationResponse> applyRecommendationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v14.services.RecommendationService/ApplyRecommendation").setRequestMarshaller(ProtoUtils.marshaller((Message)ApplyRecommendationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ApplyRecommendationResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DismissRecommendationRequest, DismissRecommendationResponse> dismissRecommendationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.ads.googleads.v14.services.RecommendationService/DismissRecommendation").setRequestMarshaller(ProtoUtils.marshaller((Message)DismissRecommendationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DismissRecommendationResponse.getDefaultInstance())).build();
    private final UnaryCallable<ApplyRecommendationRequest, ApplyRecommendationResponse> applyRecommendationCallable;
    private final UnaryCallable<DismissRecommendationRequest, DismissRecommendationResponse> dismissRecommendationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcRecommendationServiceStub create(RecommendationServiceStubSettings settings) throws IOException {
        return new GrpcRecommendationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcRecommendationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcRecommendationServiceStub(RecommendationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcRecommendationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcRecommendationServiceStub(RecommendationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcRecommendationServiceStub(RecommendationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, (GrpcStubCallableFactory)new GrpcRecommendationServiceCallableFactory());
    }

    protected GrpcRecommendationServiceStub(RecommendationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings applyRecommendationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(applyRecommendationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        GrpcCallSettings dismissRecommendationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(dismissRecommendationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("customer_id", String.valueOf(request.getCustomerId()));
            return builder.build();
        }).build();
        this.applyRecommendationCallable = callableFactory.createUnaryCallable(applyRecommendationTransportSettings, settings.applyRecommendationSettings(), clientContext);
        this.dismissRecommendationCallable = callableFactory.createUnaryCallable(dismissRecommendationTransportSettings, settings.dismissRecommendationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ApplyRecommendationRequest, ApplyRecommendationResponse> applyRecommendationCallable() {
        return this.applyRecommendationCallable;
    }

    @Override
    public UnaryCallable<DismissRecommendationRequest, DismissRecommendationResponse> dismissRecommendationCallable() {
        return this.dismissRecommendationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

