/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupAdAssetCombinationViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_AD_ID_ASSET_COMBINATION_ID_LOW_ASSET_COMBINATION_ID_HIGH = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroupAdAssetCombinationViews/{ad_group_id}~{ad_id}~{asset_combination_id_low}~{asset_combination_id_high}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String adId;
    private final String assetCombinationIdLow;
    private final String assetCombinationIdHigh;

    @Deprecated
    protected AdGroupAdAssetCombinationViewName() {
        this.customerId = null;
        this.adGroupId = null;
        this.adId = null;
        this.assetCombinationIdLow = null;
        this.assetCombinationIdHigh = null;
    }

    private AdGroupAdAssetCombinationViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.adId = (String)Preconditions.checkNotNull((Object)builder.getAdId());
        this.assetCombinationIdLow = (String)Preconditions.checkNotNull((Object)builder.getAssetCombinationIdLow());
        this.assetCombinationIdHigh = (String)Preconditions.checkNotNull((Object)builder.getAssetCombinationIdHigh());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getAdId() {
        return this.adId;
    }

    public String getAssetCombinationIdLow() {
        return this.assetCombinationIdLow;
    }

    public String getAssetCombinationIdHigh() {
        return this.assetCombinationIdHigh;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupAdAssetCombinationViewName of(String customerId, String adGroupId, String adId, String assetCombinationIdLow, String assetCombinationIdHigh) {
        return AdGroupAdAssetCombinationViewName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setAdId(adId).setAssetCombinationIdLow(assetCombinationIdLow).setAssetCombinationIdHigh(assetCombinationIdHigh).build();
    }

    public static String format(String customerId, String adGroupId, String adId, String assetCombinationIdLow, String assetCombinationIdHigh) {
        return AdGroupAdAssetCombinationViewName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setAdId(adId).setAssetCombinationIdLow(assetCombinationIdLow).setAssetCombinationIdHigh(assetCombinationIdHigh).build().toString();
    }

    public static AdGroupAdAssetCombinationViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_AD_ID_ASSET_COMBINATION_ID_LOW_ASSET_COMBINATION_ID_HIGH.validatedMatch(formattedString, "AdGroupAdAssetCombinationViewName.parse: formattedString not in valid format");
        return AdGroupAdAssetCombinationViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("ad_id"), (String)matchMap.get("asset_combination_id_low"), (String)matchMap.get("asset_combination_id_high"));
    }

    public static List<AdGroupAdAssetCombinationViewName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupAdAssetCombinationViewName> list = new ArrayList<AdGroupAdAssetCombinationViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupAdAssetCombinationViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupAdAssetCombinationViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupAdAssetCombinationViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_AD_ID_ASSET_COMBINATION_ID_LOW_ASSET_COMBINATION_ID_HIGH.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupAdAssetCombinationViewName adGroupAdAssetCombinationViewName = this;
            synchronized (adGroupAdAssetCombinationViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.adId != null) {
                        fieldMapBuilder.put((Object)"ad_id", (Object)this.adId);
                    }
                    if (this.assetCombinationIdLow != null) {
                        fieldMapBuilder.put((Object)"asset_combination_id_low", (Object)this.assetCombinationIdLow);
                    }
                    if (this.assetCombinationIdHigh != null) {
                        fieldMapBuilder.put((Object)"asset_combination_id_high", (Object)this.assetCombinationIdHigh);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_AD_ID_ASSET_COMBINATION_ID_LOW_ASSET_COMBINATION_ID_HIGH.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "ad_id", this.adId, "asset_combination_id_low", this.assetCombinationIdLow, "asset_combination_id_high", this.assetCombinationIdHigh});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AdGroupAdAssetCombinationViewName that = (AdGroupAdAssetCombinationViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.adId, that.adId) && Objects.equals(this.assetCombinationIdLow, that.assetCombinationIdLow) && Objects.equals(this.assetCombinationIdHigh, that.assetCombinationIdHigh);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetCombinationIdLow);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assetCombinationIdHigh);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String adId;
        private String assetCombinationIdLow;
        private String assetCombinationIdHigh;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getAdId() {
            return this.adId;
        }

        public String getAssetCombinationIdLow() {
            return this.assetCombinationIdLow;
        }

        public String getAssetCombinationIdHigh() {
            return this.assetCombinationIdHigh;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setAdId(String adId) {
            this.adId = adId;
            return this;
        }

        public Builder setAssetCombinationIdLow(String assetCombinationIdLow) {
            this.assetCombinationIdLow = assetCombinationIdLow;
            return this;
        }

        public Builder setAssetCombinationIdHigh(String assetCombinationIdHigh) {
            this.assetCombinationIdHigh = assetCombinationIdHigh;
            return this;
        }

        private Builder(AdGroupAdAssetCombinationViewName adGroupAdAssetCombinationViewName) {
            this.customerId = adGroupAdAssetCombinationViewName.customerId;
            this.adGroupId = adGroupAdAssetCombinationViewName.adGroupId;
            this.adId = adGroupAdAssetCombinationViewName.adId;
            this.assetCombinationIdLow = adGroupAdAssetCombinationViewName.assetCombinationIdLow;
            this.assetCombinationIdHigh = adGroupAdAssetCombinationViewName.assetCombinationIdHigh;
        }

        public AdGroupAdAssetCombinationViewName build() {
            return new AdGroupAdAssetCombinationViewName(this);
        }
    }
}

