/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignSharedSetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_SHARED_SET_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignSharedSets/{campaign_id}~{shared_set_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String sharedSetId;

    @Deprecated
    protected CampaignSharedSetName() {
        this.customerId = null;
        this.campaignId = null;
        this.sharedSetId = null;
    }

    private CampaignSharedSetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.sharedSetId = (String)Preconditions.checkNotNull((Object)builder.getSharedSetId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getSharedSetId() {
        return this.sharedSetId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignSharedSetName of(String customerId, String campaignId, String sharedSetId) {
        return CampaignSharedSetName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setSharedSetId(sharedSetId).build();
    }

    public static String format(String customerId, String campaignId, String sharedSetId) {
        return CampaignSharedSetName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setSharedSetId(sharedSetId).build().toString();
    }

    public static CampaignSharedSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_SHARED_SET_ID.validatedMatch(formattedString, "CampaignSharedSetName.parse: formattedString not in valid format");
        return CampaignSharedSetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("shared_set_id"));
    }

    public static List<CampaignSharedSetName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignSharedSetName> list = new ArrayList<CampaignSharedSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignSharedSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignSharedSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignSharedSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_SHARED_SET_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignSharedSetName campaignSharedSetName = this;
            synchronized (campaignSharedSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.sharedSetId != null) {
                        fieldMapBuilder.put((Object)"shared_set_id", (Object)this.sharedSetId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_SHARED_SET_ID.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "shared_set_id", this.sharedSetId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CampaignSharedSetName that = (CampaignSharedSetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.sharedSetId, that.sharedSetId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.sharedSetId);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String sharedSetId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getSharedSetId() {
            return this.sharedSetId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setSharedSetId(String sharedSetId) {
            this.sharedSetId = sharedSetId;
            return this;
        }

        private Builder(CampaignSharedSetName campaignSharedSetName) {
            this.customerId = campaignSharedSetName.customerId;
            this.campaignId = campaignSharedSetName.campaignId;
            this.sharedSetId = campaignSharedSetName.sharedSetId;
        }

        public CampaignSharedSetName build() {
            return new CampaignSharedSetName(this);
        }
    }
}

