/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LocalServicesLeadName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_LOCAL_SERVICES_LEAD_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/localServicesLeads/{local_services_lead_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String localServicesLeadId;

    @Deprecated
    protected LocalServicesLeadName() {
        this.customerId = null;
        this.localServicesLeadId = null;
    }

    private LocalServicesLeadName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.localServicesLeadId = (String)Preconditions.checkNotNull((Object)builder.getLocalServicesLeadId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getLocalServicesLeadId() {
        return this.localServicesLeadId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LocalServicesLeadName of(String customerId, String localServicesLeadId) {
        return LocalServicesLeadName.newBuilder().setCustomerId(customerId).setLocalServicesLeadId(localServicesLeadId).build();
    }

    public static String format(String customerId, String localServicesLeadId) {
        return LocalServicesLeadName.newBuilder().setCustomerId(customerId).setLocalServicesLeadId(localServicesLeadId).build().toString();
    }

    public static LocalServicesLeadName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_LOCAL_SERVICES_LEAD_ID.validatedMatch(formattedString, "LocalServicesLeadName.parse: formattedString not in valid format");
        return LocalServicesLeadName.of((String)matchMap.get("customer_id"), (String)matchMap.get("local_services_lead_id"));
    }

    public static List<LocalServicesLeadName> parseList(List<String> formattedStrings) {
        ArrayList<LocalServicesLeadName> list = new ArrayList<LocalServicesLeadName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LocalServicesLeadName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LocalServicesLeadName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LocalServicesLeadName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_LOCAL_SERVICES_LEAD_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LocalServicesLeadName localServicesLeadName = this;
            synchronized (localServicesLeadName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.localServicesLeadId != null) {
                        fieldMapBuilder.put((Object)"local_services_lead_id", (Object)this.localServicesLeadId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_LOCAL_SERVICES_LEAD_ID.instantiate(new String[]{"customer_id", this.customerId, "local_services_lead_id", this.localServicesLeadId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LocalServicesLeadName that = (LocalServicesLeadName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.localServicesLeadId, that.localServicesLeadId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.localServicesLeadId);
    }

    public static class Builder {
        private String customerId;
        private String localServicesLeadId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getLocalServicesLeadId() {
            return this.localServicesLeadId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setLocalServicesLeadId(String localServicesLeadId) {
            this.localServicesLeadId = localServicesLeadId;
            return this;
        }

        private Builder(LocalServicesLeadName localServicesLeadName) {
            this.customerId = localServicesLeadName.customerId;
            this.localServicesLeadId = localServicesLeadName.localServicesLeadId;
        }

        public LocalServicesLeadName build() {
            return new LocalServicesLeadName(this);
        }
    }
}

