/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RecommendationName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_RECOMMENDATION_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/recommendations/{recommendation_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String recommendationId;

    @Deprecated
    protected RecommendationName() {
        this.customerId = null;
        this.recommendationId = null;
    }

    private RecommendationName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.recommendationId = (String)Preconditions.checkNotNull((Object)builder.getRecommendationId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getRecommendationId() {
        return this.recommendationId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RecommendationName of(String customerId, String recommendationId) {
        return RecommendationName.newBuilder().setCustomerId(customerId).setRecommendationId(recommendationId).build();
    }

    public static String format(String customerId, String recommendationId) {
        return RecommendationName.newBuilder().setCustomerId(customerId).setRecommendationId(recommendationId).build().toString();
    }

    public static RecommendationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_RECOMMENDATION_ID.validatedMatch(formattedString, "RecommendationName.parse: formattedString not in valid format");
        return RecommendationName.of((String)matchMap.get("customer_id"), (String)matchMap.get("recommendation_id"));
    }

    public static List<RecommendationName> parseList(List<String> formattedStrings) {
        ArrayList<RecommendationName> list = new ArrayList<RecommendationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RecommendationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RecommendationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RecommendationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_RECOMMENDATION_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RecommendationName recommendationName = this;
            synchronized (recommendationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.recommendationId != null) {
                        fieldMapBuilder.put((Object)"recommendation_id", (Object)this.recommendationId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_RECOMMENDATION_ID.instantiate(new String[]{"customer_id", this.customerId, "recommendation_id", this.recommendationId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RecommendationName that = (RecommendationName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.recommendationId, that.recommendationId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.recommendationId);
    }

    public static class Builder {
        private String customerId;
        private String recommendationId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getRecommendationId() {
            return this.recommendationId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        private Builder(RecommendationName recommendationName) {
            this.customerId = recommendationName.customerId;
            this.recommendationId = recommendationName.recommendationId;
        }

        public RecommendationName build() {
            return new RecommendationName(this);
        }
    }
}

