/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VideoName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_VIDEO_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/videos/{video_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String videoId;

    @Deprecated
    protected VideoName() {
        this.customerId = null;
        this.videoId = null;
    }

    private VideoName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.videoId = (String)Preconditions.checkNotNull((Object)builder.getVideoId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getVideoId() {
        return this.videoId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VideoName of(String customerId, String videoId) {
        return VideoName.newBuilder().setCustomerId(customerId).setVideoId(videoId).build();
    }

    public static String format(String customerId, String videoId) {
        return VideoName.newBuilder().setCustomerId(customerId).setVideoId(videoId).build().toString();
    }

    public static VideoName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_VIDEO_ID.validatedMatch(formattedString, "VideoName.parse: formattedString not in valid format");
        return VideoName.of((String)matchMap.get("customer_id"), (String)matchMap.get("video_id"));
    }

    public static List<VideoName> parseList(List<String> formattedStrings) {
        ArrayList<VideoName> list = new ArrayList<VideoName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VideoName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VideoName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VideoName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_VIDEO_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VideoName videoName = this;
            synchronized (videoName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.videoId != null) {
                        fieldMapBuilder.put((Object)"video_id", (Object)this.videoId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_VIDEO_ID.instantiate(new String[]{"customer_id", this.customerId, "video_id", this.videoId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            VideoName that = (VideoName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.videoId, that.videoId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.videoId);
    }

    public static class Builder {
        private String customerId;
        private String videoId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getVideoId() {
            return this.videoId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setVideoId(String videoId) {
            this.videoId = videoId;
            return this;
        }

        private Builder(VideoName videoName) {
            this.customerId = videoName.customerId;
            this.videoId = videoName.videoId;
        }

        public VideoName build() {
            return new VideoName(this);
        }
    }
}

