/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v15.services;

import com.google.ads.googleads.v15.services.AdGroupCustomizerOperation;
import com.google.ads.googleads.v15.services.AdGroupCustomizerServiceSettings;
import com.google.ads.googleads.v15.services.MutateAdGroupCustomizersRequest;
import com.google.ads.googleads.v15.services.MutateAdGroupCustomizersResponse;
import com.google.ads.googleads.v15.services.stub.AdGroupCustomizerServiceStub;
import com.google.ads.googleads.v15.services.stub.AdGroupCustomizerServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdGroupCustomizerServiceClient
implements BackgroundResource {
    private final AdGroupCustomizerServiceSettings settings;
    private final AdGroupCustomizerServiceStub stub;

    public static final AdGroupCustomizerServiceClient create() throws IOException {
        return AdGroupCustomizerServiceClient.create(AdGroupCustomizerServiceSettings.newBuilder().build());
    }

    public static final AdGroupCustomizerServiceClient create(AdGroupCustomizerServiceSettings settings) throws IOException {
        return new AdGroupCustomizerServiceClient(settings);
    }

    public static final AdGroupCustomizerServiceClient create(AdGroupCustomizerServiceStub stub) {
        return new AdGroupCustomizerServiceClient(stub);
    }

    protected AdGroupCustomizerServiceClient(AdGroupCustomizerServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupCustomizerServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdGroupCustomizerServiceClient(AdGroupCustomizerServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupCustomizerServiceSettings getSettings() {
        return this.settings;
    }

    public AdGroupCustomizerServiceStub getStub() {
        return this.stub;
    }

    public final MutateAdGroupCustomizersResponse mutateAdGroupCustomizers(String customerId, List<AdGroupCustomizerOperation> operations) {
        MutateAdGroupCustomizersRequest request = MutateAdGroupCustomizersRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroupCustomizers(request);
    }

    public final MutateAdGroupCustomizersResponse mutateAdGroupCustomizers(MutateAdGroupCustomizersRequest request) {
        return (MutateAdGroupCustomizersResponse)this.mutateAdGroupCustomizersCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupCustomizersRequest, MutateAdGroupCustomizersResponse> mutateAdGroupCustomizersCallable() {
        return this.stub.mutateAdGroupCustomizersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

